/**
 * \file lib_setup.js
 * \author Mihai OPREA <mihai.oprea@axigen.com>
 * \date 28-07-2006
 *
 * Copyright &copy; 2006 GeCAD Technologies SRL. All Rights Reserved.
 * \brief SCRIPT - Setup library
 *
 */

/*******************************************************************************
 * Event setup
 */

getEventManager().registerCallback(EVENT_NEW_MESSAGE, getManager().openComposer);
getEventManager().registerCallback(EVENT_NEW_CONTACT, getManager().openNewContact);

getEventManager().registerCallback(EVENT_REPLY, getManager().openComposer);
getEventManager().registerCallback(EVENT_REPLY_ALL, getManager().openComposer);

getEventManager().registerCallback(EVENT_FORWARD, getManager().openComposer);
getEventManager().registerCallback(EVENT_FORWARD_ATT, getManager().openComposer);

getEventManager().registerCallback(EVENT_SELECT, getManager().select);
getEventManager().registerCallback(EVENT_SELECT_ALL, getManager().selectAll);
getEventManager().registerCallback(EVENT_SELECT_INVERT, getManager().selectInvert);
getEventManager().registerCallback(EVENT_SELECT_NONE, getManager().selectNone);

getEventManager().registerCallback(EVENT_COPY, getManager().openTree);
getEventManager().registerCallback(EVENT_MOVE, getManager().openTree);

getEventManager().registerCallback(EVENT_DELETE, getManager().deleteMails);

/*******************************************************************************
 * UI setup
 */

function setup()
{
    setupTree();
//    setupMailList();
}

function setupTree()
{
    if (getObject("tree") &&
        getObject("tree").tree.firstChild.htmlContainer &&
        getObject("tree").tree.firstChild.htmlContainer.lastChild &&
        getObject("tree").tree.firstChild.htmlContainer.lastChild.onclick)
    {
        getObject("tree").tree.firstChild.htmlContainer.lastChild.onclick();
    } else {
        window.setTimeout("setupTree()", 1000);
    }
}

function setupMailList()
{
    if (getObject("mailList") &&
        getObject("mailList").mails)
    {
        var idx = 0;
        var mail = mails[0];
        var mails = getObject("mailList").mails;

        for (var i = 1; i < mails.length; ++i) {
            if (!mails[i].data.seen) {
                mail = mails[i];
                idx = i;
                break;
            }
        }

        getObject("mailList").container.childNodes[idx + 1].onclick();

        getManager().openMail(mail);
    } else {
        window.setTimeout("setupMailList()", 1000);
    }
}
