/**
 * \file lib_tree_panel.js
 * \author Mihai OPREA <mihai.oprea@axigen.com>
 * \date 29-08-2006
 *
 * Copyright &copy; 2006 GeCAD Technologies SRL. All Rights Reserved.
 * \brief SCRIPT - Tree Panel
 *
 */

/*******************************************************************************
 * TreePanel validation functions
 */

function validateTreeOperation(form_name, form_op)
{  
    var form = eval("document.forms." + form_name);
    
    if (form.name && form.name.value == "") {
        alert(getObject("dictionary").getAlert("empty_folder_msg"));

        return false;
    }

    if (!tree.selectedFolder) {
        alert(getObject("dictionary").getAlert("no_folder_msg"));
        
        return false;
    }

    var webmailData = getObject("mailList").webmailData;
    if (webmailData.confirmFolderEmpty == "yes" && form.empty_folder &&
        !confirm(getObject("dictionary").getAlert("tree_empty_confirm")))
    {
        return false;
    }

    var selectedFolderPath = tree.selectedFolder.data.path;
    var field = document.createElement("input");
    field.type = "hidden";
    field.value = selectedFolderPath;
    field.name = "selectedFolderPath";
    
    form.appendChild(field);

    return true;
}

/*******************************************************************************
 * Mail operation validation function
 */

function validateMailOperation(form_name, form_op)
{
    var form = eval("document.forms." + form_name);
    
    if (!tree.selectedFolder) {
        alert("No folder selected!");
        
        return false;
    }

    var oldFid = getObject("mailList").fid;
    var newFid = tree.selectedFolder.data.fid;

    var field = document.createElement("input");
    field.type = "hidden";
    field.name = "newFid";
    field.value = newFid;
    
    form.appendChild(field);

    var field = document.createElement("input");
    field.type = "hidden";
    field.name = "fid";
    field.value = oldFid;
    
    form.appendChild(field);

    var selectedMails = getObject("mailList").selectedMails;
    for (var i = 0; i < selectedMails.length; ++i) {
        if (selectedMails[i]) {
            var mail = getObject("mailList").mails[i];

            var field = document.createElement("input");
            field.type = "hidden";
            field.name = "mails[]";
            field.value = mail.mid;
            
            form.appendChild(field);       
        }
    }

    return true;
}

/*******************************************************************************
 * TreePanel class
 */

function TreePanel(type)
{
    registerObject(this, "treePanel");

    this.started = false;
    
    this.type = type;
}

TreePanel.prototype.start = function()
{
    if (this.started) { return false; }

    this.started = true;
}

TreePanel.prototype.draw = function()
{
    var body = document.getElementsByTagName("body").item(0);
    
    if (!body) { return false; }
}
