<?php
/*
    Pagetool
    Copyright 2001,2002 Pagetool Development Team
    pagetool-user@lists.sourceforge.net http://www.pagetool.org/
    $Id: pt_admin.inc,v 1.13 2004/07/20 01:10:34 daveguerin Exp $

    myphpPagetool
    http://sourceforge.net/projects/myphppagetool
    (C) 2000 by Sebastian Bunka <Sebastian.Bunka@vu-wien.ac.at>

    This file is part of Pagetool. Pagetool is a modification
    of myphpPagetool.

    Pagetool is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version
    2 of the License, or (at your option) any later version.
*/

/* Check if they clicked on a download link
If they did, skip the header, otherwise, draw the header. */

if (!isset($pt_action))
{
	$pt_action="";
}

if ( $pt_action != "download" )
{
    include($ptconf["src"] . "admin/pt_auth.inc");
    include($ptconf["src"] . "admin/pt_begin_admin.inc");
    echo pt_html_from(__FILE__, __LINE__);
    echo "<div class=\"body\">";
}
elseif( $pt_section <> 'oldversions' )
{
    /* Thanks to the phpMyAdmin team, http://phpwizard.net/phpMyAdmin/ 
    and http://phpmyadmin.sourceforge.net/ for this next bit,
    and contributers to the support forum at
    http://www.phpbuilder.com/forum/read.php3?num=2&id=143721&thread=104514 */
    if (strstr($HTTP_USER_AGENT, "MSIE"))
    {
        $attachment = "";
        $content_type = "application/x-ms-download";
    }
    else
    {
        $attachment = " attachment;";
        $content_type = "application/octet-stream";
    }
    header("Content-Type: " . $content_type);
    header("Content-Disposition:" . $attachment . " filename=pagetool.sql");
    header("Pragma: no-cache");
    header("Expires: 0");
    header("Content-Transfer-Encoding: binary");
}

// Depending on which menu they choose, include the appropriate file.
switch($menu) {
    case "www": /* view, edit, add www pages */
        if ($ptallow_www == "Y")
        {
            include($ptconf["src"] . "admin/pt_www.inc");
        }
        break;
    case "media":   /* view, edit, add media */
        if ($ptallow_media == "Y")
        {
            include($ptconf["src"] . "admin/pt_media.inc");
        }
        break;
    case "news":    /* view, edit, add  news */
        if ($ptallow_news == "Y")
        {
            include($ptconf["src"] . "admin/pt_news.inc");
        }
        break;
    case "prefs":   /* view, edit, add preferences */
        if ($ptallow_profile == "Y" || $ptallow_user == "Y")
        {
            include($ptconf["src"] . "admin/pt_prefs.inc");
        }
        break;
    case "db":
        if (strtolower($PHP_AUTH_USER) == "admin")
        {
            include($ptconf["src"] . "admin/pt_db.inc");
        }
        break;
    case "oldversions":
        if (strtolower($PHP_AUTH_USER) == "admin")
        {
            include($ptconf["src"] . "admin/pt_oldversions.inc");
        }
        break;
    case "plugins":
        if (strtolower($PHP_AUTH_USER) == "admin") {
            include($ptconf["src"] . "admin/pt_plugins.inc");
        }
        break;
    case "plugins_run":
        if (strtolower($PHP_AUTH_USER) == "admin") 
		{
        	include($ptconf["src"] . "admin/pt_plugins_run.inc");
		}
        break;
    case "help":
        include($ptconf["src"] . "admin/pt_help.inc");
        break;
    default:    /* view, edit, add nothing */

}

// Actions
switch($pt_action) {
    case "add":
        include($ptconf["src"] . "admin/pt_add.inc");
        break;
    case "edit":
        switch($pt_section) {
            case "user":
                if ($id=="") {
                    echo "<span class=\"message\">" . $str_no_record_selected . $str_user . ".</span>";
                    include($ptconf["src"] . "admin/pt_prefs.inc");
                    break;
                }
                include($ptconf["src"] . "admin/pt_user_edit.inc");
                break;
            case "www":
                if ($id=="") {
                    echo "<span class=\"message\">" . $str_no_record_selected . $str_page . ".</span>";
                    include($ptconf["src"] . "admin/pt_www.inc");
                    break;
                }
                // Check permissions
                $result=pt_query("select groups from pt_core_wwwpages where www_id=$id");
                $row = mysql_fetch_object($result);
                if (pt_checkgroupaccess($pt_core_groups, $row->groups) <> 1) {
                    echo "<span class=\"message\">" . $str_no_permission . "</span><br><br>";
                    include($ptconf["src"] . "admin/pt_www.inc");
                    break;
                }
                include($ptconf["src"] . "admin/pt_www_edit.inc");
                break;
            case "news":
                if ($id=="") {
                    echo "<span class=\"message\">" . $str_no_record_selected . $str_news_item . ".</span>";
                    include($ptconf["src"] . "admin/pt_news.inc");
                    break;
                }
                // Check permissions
                $query = "select groups,headline from pt_core_news where news_id=$id";
                $result=pt_query($query);
                $row = mysql_fetch_object($result);
                if (pt_checkgroupaccess($pt_core_groups, $row->groups) <> 1) {
                    echo "<span class=\"message\">" . $str_no_permission . "</span><br><br>";
                    include($ptconf["src"] . "admin/pt_news.inc");
                    break;
                }
                include($ptconf["src"] . "admin/pt_news_edit.inc");
                break;
            case "media":
                if ($id=="") {
                    echo "<span class=\"message\">" . $str_no_record_selected . $str_file . ".</span>";
                    include($ptconf["src"] . "admin/pt_media.inc");
                    break;
                }
                // Check permissions
                $query = "select groups from pt_core_media where media_id=$id";
                $result=pt_query($query);
                $row = mysql_fetch_object($result);
                if (pt_checkgroupaccess($pt_core_groups, $row->groups) <> 1) {
                    echo "<span class=\"message\">" . $str_no_permission . "</span><br><br>";
                    include($ptconf["src"] . "admin/pt_media.inc");
                    break;
                }
                include($ptconf["src"] . "admin/pt_media_edit.inc");
                break;
            case "prefs":
                if ($id=="") {
                    echo "<span class=\"message\">" . $str_no_record_selected . $str_profile_name . ".</span>";
                    include($ptconf["src"] . "admin/pt_prefs.inc");
                    break;
                }
                include($ptconf["src"] . "admin/pt_prefs_edit.inc");
                break;
            case "oldversions":
                include($ptconf["src"] . "admin/pt_oldversions_edit.inc");
                break;
        }
        break;
    case "update":
        include($ptconf["src"] . "admin/pt_update.inc");
        break;

    case "delete":
        switch($pt_section) {
            case "user":
                // Make sure a user was selected
                if ($id=="") {
                    echo "<span class=\"message\">" . $str_no_record_selected . $str_user . ".</span>";
                    include($ptconf["src"] . "admin/pt_prefs.inc");
                    break;
                }
                // Check permissions
                if ($ptallow_user<>"Y") {
                    echo "<span class=\"message\">" . $str_no_permission . "</span><br><br>";
                    include($ptconf["src"] . "admin/pt_prefs.inc");
                    break;
                }
                $query="select username from pt_core_users WHERE user_id=$id";
                $result=pt_query($query);
                $row = mysql_fetch_object($result);
                $delname = $row->username;
                pt_deleterow($delname,$pt_section,'pt_core_users','user_id',$id,$force);
                echo "<br><br>";
                include($ptconf["src"] . "admin/pt_prefs.inc");
                break;
            case "groups":
                // Make sure a group was selected
                if ($id=="") {
                    echo "<span class=\"message\">" . $str_no_record_selected. $str_group . ".</span>";
                    include($ptconf["src"] . "admin/pt_prefs.inc");
                    break;
                }
                // Check permissions
                if ($ptallow_user<>"Y") {
                    echo "<span class=\"message\">" . $str_no_permission . "</span><br><br>";
                    include($ptconf["src"] . "admin/pt_prefs.inc");
                    break;
                }
                $query="select group_name from pt_core_groups WHERE group_id=$id";
                $result=pt_query($query);
                $row = mysql_fetch_object($result);
                $delname = $row->group_name;
                pt_deleterow($delname,$pt_section,'pt_core_groups','group_id',$id,$force);
                echo "<br><br>";
                include($ptconf["src"] . "admin/pt_prefs.inc");
                break;
            case "www":
                // Make sure a page was selected
                if ($id=="") {
                    echo "<span class=\"message\">" . $str_no_record_selected. $str_page . ".</span>";
                    include($ptconf["src"] . "admin/pt_www.inc");
                    break;
                }
                // Check permissions
                $result=pt_query("select groups,name from pt_core_wwwpages where www_id=$id");
                $row = mysql_fetch_object($result);
                if (pt_checkgroupaccess($pt_core_groups, $row->groups) <> 1) {
                    echo "<span class=\"message\">" . $str_no_permission . "</span><br><br>";
                    include($ptconf["src"] . "admin/pt_www.inc");
                    break;
                }

                // first write the data to pt_core_wwwbackup, then delete
                if ( $force == 1 ) /* only backup if delete is confirmed */ {
                    $www_result = pt_query("select * from pt_core_wwwpages where www_id='$id'");
                    if (mysql_num_rows($www_result) == 1) {
                        $row = mysql_fetch_object($www_result);
                        $sql_friendly_category = addslashes($row->category);
                        $sql_friendly_title = addslashes($row->title);
                        $sql_friendly_keywords = addslashes($row->keywords);
                        $sql_friendly_html = addslashes($row->html);
                        $backup_query = "insert into pt_core_wwwbackup (version, name, category, title, keywords, html, changelog, tstamp,page_header, page_sidebar, page_footer, username, auto_html) ";
                        $backup_query .= "values('$row->version','$row->name','$sql_friendly_category','$sql_friendly_title','$sql_friendly_keywords','$sql_friendly_html','$row->changelog',now(),'$row->page_header','$row->page_sidebar','$row->page_footer','$row->username','$row->auto_html')";
                        pt_query($backup_query);
                        pt_errcheck($str_backup_was_successful);
                        echo "<br>";
                        mysql_free_result($www_result);
                    }
                }
                pt_deleterow($row->name,$pt_section,'pt_core_wwwpages','www_id',$id,$force);
                echo "<br><br>";
                include($ptconf["src"] . "admin/pt_www.inc");
                break;
            case "news":
                // Make sure an article was selected
                if ($id=="") {
                    echo "<span class=\"message\">" . $str_no_record_selected . $str_news_item . ".</span>";
                    include($ptconf["src"] . "admin/pt_news.inc");
                    break;
                }

                // Check permissions
                $query = "select groups,headline from pt_core_news where news_id=$id";
                $result=pt_query($query);
                $row = mysql_fetch_object($result);
                if (pt_checkgroupaccess($pt_core_groups, $row->groups) <> 1) {
                    echo "<span class=\"message\">" . $str_no_permission . "</span><br><br>";
                    include($ptconf["src"] . "admin/pt_news.inc");
                    break;
                }
                $delname = $row->headline;
                pt_deleterow($delname,$pt_section,'pt_core_news','news_id',$id,$force);
                echo "<br><br>";
                include($ptconf["src"] . "admin/pt_news.inc");
                break;
            case "media":
                // Make sure a item was selected
                if ($id=="") {
                    echo "<span class=\"message\">" . $str_no_record_selected . $str_file . ".</span>";
                    include($ptconf["src"] . "admin/pt_media.inc");
                    break;
                }
                // Check permissions
                $query = "select groups,name from pt_core_media where media_id=$id";
                $result=pt_query($query);
                $row = mysql_fetch_object($result);
                if (pt_checkgroupaccess($pt_core_groups, $row->groups) <> 1) {
                    echo "<span class=\"message\">" . $str_no_permission . "</span><br><br>";
                    include($ptconf["src"] . "admin/pt_media.inc");
                    break;
                }
                $delname = $row->name;
                pt_delete_media($delname,$pt_section,'pt_core_media','media_id',$id,$force);
                echo "<br><br>";
                include($ptconf["src"] . "admin/pt_media.inc");
                break;

            case "prefs":
                // Make sure a profile was selected
                if ($id=="") {
                    echo "<span class=\"message\">" . $str_no_record_selected . $str_profile . ".</span>";
                    include($ptconf["src"] . "admin/pt_prefs.inc");
                    break;
                }
                $query="select profile_name from pt_core_profiles WHERE profile_id=$id";
                $result=pt_query($query);
                $row = mysql_fetch_object($result);
                $delname = $row->profile_name;
                pt_deleterow($delname,$pt_section,'pt_core_profiles','profile_id',$id,$force);
                echo "<br><br>";
                include($ptconf["src"] . "admin/pt_prefs.inc");
                break;

            case "db":
                echo pt_html_from(__FILE__, __LINE__);
                if ( $what == "wwwbackup" )
                {
                    if ( $force !=1 )
                    {
                        echo $str_delete_all_wwwbackup ."<br><br>\n";
                        echo "<a href=\"" . $admp . "\">" . $str_no_cap . "</a>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
                        echo "<a href=\"" . $admp . "&pt_action=delete&pt_section=db&what=wwwbackup&force=1\">" . $str_yes_cap . "</a>";
                    }
                    else
                    {
                        pt_query("delete from pt_core_wwwbackup");
                        if ( mysql_errno() == 0 )
                        {
                            echo "<span class=\"message\">" . $str_wwwbackup_deleted . "</span>";
                        }
                        else
                        {
                            echo "<span class=\"message\">" . $str_there_was_an_error;
                            echo "<br>Error code: " . mysql_errno() . " " . mysql_error() . "</span><br>\n";
                        }
                   }
                }
            break;

            case "oldversions":
                pt_deleterow($delname,$pt_section,'pt_core_wwwbackup','www_id',$id,$force);
                break;
        }
        break;
    case "download":
          switch($pt_section)
          {
            case "www":
                $www_download = pt_query("select html from pt_core_wwwpages where www_id='$id'");
                if ($www_download) {
                    $row = mysql_fetch_object($www_download);
                    echo $row->html;
                    mysql_free_result($www_download);
                } else {
                    printf("<h3>No pages found</h3>");
                        }
                        break;
            case "oldversions":
                $www_download = pt_query("select html from pt_core_wwwbackup where www_id='$id'");
                        if ($www_download) {
                                $row = mysql_fetch_object($www_download);
                                echo $row->html;
                                mysql_free_result($www_download);
                        } else {
                                 profile_idntf("<h3>No pages found</h3>");
                        }
                        break;
            case "db":
                if (!is_file($ptconf["mysqldump"]))
                {
                    echo $str_no_mysqldump; 
                    exit;
                }
                if ($what) {
                    if ( $what == "full" ) $xparm = "-c --add-drop-table";
                    if ( $what == "insert" ) $xparm = "-c -t";
                    if ( $what == "create" ) $xparm = "-c -d --add-drop-table";
                    $mysqldump = $ptconf["mysqldump"];
                    $user = $ptconf["dbuser"];
                    $pass = $ptconf["dbpass"];
                    $dbname = $ptconf["dbname"];
                    if ( $what == "pt_core_wwwbackup" ) {
                        $dbname .= " pt_core_wwwbackup";
                        $xparm = "-c --add-drop-table";
                    }
                    $myresult = system("$mysqldump -u $user $xparm --password=$pass $dbname");
                }
                break;
         }
         break;

    case "new":
        switch($pt_section) {
            case "www":
                include($ptconf["src"] . "admin/pt_www_new.inc");
                break;
            case "news":
                include($ptconf["src"] . "admin/pt_news_new.inc");
                break;
            case "prefs":
                include($ptconf["src"] . "admin/pt_prefs_new.inc");
                break;
            case "user":
                include($ptconf["src"] . "admin/pt_user_new.inc");
                break;
            case "media":
                include($ptconf["src"] . "admin/pt_media_new.inc");
                break;
        }
        break;
        exit;
    case "generator":
        include($ptconf["src"] . "admin/pt_generator.inc");
        break;
    case "dupe":
        switch($pt_section) {
            case "www":
                if ($id=="") {
                    echo "<span class=\"message\">" . $str_no_record_selected . $str_page . ".</span>";
                    include($ptconf["src"] . "admin/pt_www.inc");
                    break;
                }
                $sql = "select * from pt_core_wwwpages where www_id=$id";
                $result = pt_query($sql);
                $row = mysql_fetch_array($result);
                $copy_name = $row["name"] . "_copy";

                /* Add slashes to fields that may have apostrophes or other
                problem characters. Do not use the defined pt_addslashes
                function because that function first checks whether or not
                magic quotes is turned on before it adds the slashes. In this
                case, however, magic quotes will not add the slashes (since they
                are not being passed by a form) so slashes should be added no
                matter what.*/

                $sql_friendly_category = addslashes($row["category"]);
                $sql_friendly_title = addslashes($row["title"]);
                $sql_friendly_keywords = addslashes($row["keywords"]);
                $sql_friendly_html = addslashes($row["html"]);
                $dupe_page_header = $row["page_header"];
                $dupe_page_sidebar = $row["page_sidebar"];
                $dupe_page_footer = $row["page_footer"];
                $dupe_auto_html = $row["auto_html"];
                $dupe_code_type = $row["code_type"];
                $dupe_security = $row["security"];

                /* Use the current user's groups, so that a user can
                duplicate and then access a page they don't have
                access to (pt_core_groups is defined in pt_auth.inc).*/
                $dupe_page_groups = $pt_core_groups;

                $dupe_query = "insert into pt_core_wwwpages (version, name,";
                $dupe_query .= "category, title, keywords, html, changelog,";
                $dupe_query .= "tstamp, page_header, page_sidebar, page_footer,";
                $dupe_query .= "username, groups, auto_html, code_type, security) values ";
                $dupe_query .= "('1.0','$copy_name',";
                $dupe_query .= "'$sql_friendly_category','$sql_friendly_title',";
                $dupe_query .= "'$sql_friendly_keywords','$sql_friendly_html',";
                $dupe_query .= "'initial version',now(),'$dupe_page_header',";
                $dupe_query .= "'$dupe_page_sidebar','$dupe_page_footer',";
                $dupe_query .= "'$PHP_AUTH_USER','$dupe_page_groups',";
                $dupe_query .= "'$dupe_auto_html','$dupe_code_type','$dupe_security')";

                pt_query($dupe_query);
                pt_errcheck($copy_name . " added!");
                include($ptconf["src"] . "admin/pt_www.inc");
                break;
        }   break;
    case "password":
		if(isset($ptconf['demo']) and TRUE == $ptconf['demo'])
		{
			// This feature is disabled in demo mode
			echo "<span class=\"message\">" . $str_disabled_in_demo . "</span><br><br>";
		}
		else
		{
        	include($ptconf["src"] . "admin/pt_password.inc");
		}
        break;

} /* end of pt_action */

if ( $pt_action != "download" )
{
    echo pt_html_from(__FILE__, __LINE__);
    echo "</div>";
    echo "</body></html>";
}
?>
