<?php
/*
    Pagetool
    Copyright 2001,2002 Pagetool Development Team
    pagetool-user@lists.sourceforge.net http://www.pagetool.org/
    $Id: pt_auth.inc,v 1.8 2004/07/18 05:43:32 jamiemcclelland Exp $

    myphpPagetool
    http://sourceforge.net/projects/myphppagetool
    (C) 2000 by Sebastian Bunka <Sebastian.Bunka@vu-wien.ac.at>

    This file is part of Pagetool. Pagetool is a modification
    of myphpPagetool.

    Pagetool is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version
    2 of the License, or (at your option) any later version.
*/

/* If $ptconf['auth'] is not set it means they are using an old pt_config.inc
   file - which is fine. In this case, set $ptconf['auth'] to the default 'http'.
   Just make sure any value hasn't come from anywhere _but_ the pt_config.inc file.
  */

if(!isset($ptconf['auth']) OR isset($HTTP_GET_VARS['ptconf']['auth']) OR isset($HTTP_POST_VARS['ptconf']['auth']) OR isset($HTTP_COOKIE_VARS['ptconf']['auth']) )
{
	$ptconf['auth'] = 'http';
}


if($ptconf['auth'] == 'http')
{
	if (!isset($PHP_AUTH_USER) || ($relogin == "y" && strcmp($oldauth, $PHP_AUTH_USER)==0) )
	{
		Header( "WWW-authenticate: Basic realm=\"Pagetool\"");
		Header( "HTTP/1.0 401 Unauthorized");
		$title= "Login Instructions";
		echo $str_auth_denied;
		exit;
	}
	else
	{
		pt_admpconnect();
		$user_id=strtolower(addslashes($PHP_AUTH_USER));
		$password=$PHP_AUTH_PW;
		$query = pt_query("SELECT * FROM pt_core_users WHERE username='$user_id'");
		if ($query)
		{
			$row = mysql_fetch_array($query);
			$salt = substr($row["passwd"],0,2);
			if ( crypt($password,$salt) == $row["passwd"] && $row["active"] == "Y" )
			{
				// Auth OK
				$pt_core_groups = $row["groups"];
				$user_id = $row["user_id"];
				$ptallow_www = $row["allow_www"];
				$ptallow_media = $row["allow_media"];
				$ptallow_news = $row["allow_news"];
				$ptallow_user = $row["allow_user"];
				$ptallow_profile = $row["allow_profile"];
				$logoff=0;
			}
			else
			{
				// Not authorized
				Header( "WWW-authenticate: Basic realm=\"Pagetool\"");
				Header( "HTTP/1.0 401 Unauthorized");
				$title= "Login Instructions";
				echo $str_auth_denied;
				exit;
			}
		}
	}
}
elseif($ptconf['auth'] == 'cookies')
{
	
	// Start the cookies authentication process

	// For security reasons, unset the just logged in variable
	unset($pt_just_logged_in);

	// If they are re-logging in - unset their cookies
	if(isset($relogin))
	{
		setcookie('pt_username','',0,'/','',0);
		setcookie('pt_timestamp','',0,'/','',0);
		setcookie('pt_username_hash','',0,'/','',0);
	}

	// If they just entered their username and password for the first time, check their password
	if(isset($pt_login_attempt))
	{
		pt_admpconnect();
		$user_id=strtolower(addslashes($pt_username));
		$password=$pt_password;
		$query = pt_query("SELECT * FROM pt_core_users WHERE username='$user_id'");
		if ($query)
		{
			$row = mysql_fetch_array($query);
			$salt = substr($row["passwd"],0,2);
			if ( crypt($password,$salt) == $row["passwd"] && $row["active"] == "Y" )
			{
				// Auth OK
				$pt_core_groups = $row["groups"];
				$user_id = $row["user_id"];
				$ptallow_www = $row["allow_www"];
				$ptallow_media = $row["allow_media"];
				$ptallow_news = $row["allow_news"];
				$ptallow_user = $row["allow_user"];
				$ptallow_profile = $row["allow_profile"];

				// set the cookie
				pt_set_cookies($pt_username,$ptconf['hash_var']);

				/* The cookies won't take effect until they load a page a again - so 
				set the just logged in variable which will bypass the regular login check. */
				$pt_just_logged_in = 1;
			}
		}
	}

	// If they are missing the inactivity time out parameter, set reasonable default
	if(!isset($ptconf['inactivity_timeout'])) $ptconf['inactivity_timeout'] = 120;

	// Otherwise - see if they have already logged in. If not, or if they are re-logging in - give them the login screen
	if((!pt_login_check($ptconf['hash_var'],$ptconf['inactivity_timeout']) && !isset($pt_just_logged_in)) || isset($relogin))
	{
		if(isset($_POST['pt_username']) && !isset($relogin))
		{
			$pt_message = $str_wrong_password;
		}
		else
		{
			$current_timestamp = time();
			if(isset($pt_timestamp) && ($current_timestamp - $pt_timestamp)/60 > $ptconf['inactivity_timeout'])
			{
				$pt_message = $str_session_timeout;
			}
			else
			{
				$pt_message = $str_please_enter_username;
			}
		}

		echo "	<html>
				<head>
					<title>$str_pagetool_auth</title>
					<link rel=\"stylesheet\" href=\"src/admin/style.php\">
				</head>
				<body>
					<span class=\"info\">$pt_message<br><br>
					$str_cookies_required</span><br><br>
					<form action=\"index.php?name=pagetool_admin\" method=\"post\">
					<table>
						<tr>
							<td class=\"label\">$str_username_cap</td>
							<td><input type=\"text\" name=\"pt_username\"></td>	
						</tr>
						<tr>
							<td class=\"label\">$str_password_cap</td>
							<td><input type=\"password\" name=\"pt_password\"></td>	
						</tr>
						<tr>
							<td><input type=\"hidden\" name=\"pt_login_attempt\" value=\"1\"></td>	
							<td colspan=\"2\"><input type=\"submit\" value=\"$str_enter\"></td>	
						</tr>
					</table>
					</form>
					</body>
					</html> ";
		exit;
	}
	elseif(!isset($pt_just_logged_in))
	{
		// If they have logged in already - set their variables
		pt_admpconnect();
		$user_id=strtolower(addslashes($pt_username));
		$password=$pt_password;
		$query = pt_query("SELECT * FROM pt_core_users WHERE username='$user_id'");
		if ($query)
		{
			$row = mysql_fetch_array($query);
			// Auth OK
			$pt_core_groups = $row["groups"];
			$user_id = $row["user_id"];
			$ptallow_www = $row["allow_www"];
			$ptallow_media = $row["allow_media"];
			$ptallow_news = $row["allow_news"];
			$ptallow_user = $row["allow_user"];
			$ptallow_profile = $row["allow_profile"];
		}
	}

	if(isset($pt_username))
	{
		// Set the $PHP_AUTH_USER variable so that the admin section will display the correct user
		$PHP_AUTH_USER = $pt_username;
	}
	
}
else
{
	die('You must set an authentication method in your pt_config.inc file');
}

?>
