<?php
/*
    Pagetool
    Copyright 2001,2002 Pagetool Development Team
    pagetool-user@lists.sourceforge.net http://www.pagetool.org/
    $Id: pt_thumb.php,v 1.2 2002/04/19 11:19:56 daveguerin Exp $

    myphpPagetool
    http://sourceforge.net/projects/myphppagetool
    (C) 2000 by Sebastian Bunka <Sebastian.Bunka@vu-wien.ac.at>

    This file is part of Pagetool. Pagetool is a modification
    of myphpPagetool.

    Pagetool is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version
    2 of the License, or (at your option) any later version.
*/
if (!$scale)
{
    $scale = 10;
}
$info = GetImageSize($image);
$w = $info[0];
$h = $info[1];
$type = $info[2];
$neww = round($w/$scale);
$newh = round($h/$scale);
if (!function_exists ("imagetypes"))
{
    // GD library not installed
    header("Location: " . $default);
    exit;
}

if ((1 == $type) && (imagetypes() & IMG_GIF) && $image)
{
    // GIF
    header ("Content-type: image/gif");
    header ("Cache-Control: must-revalidate, max-age=86400, s-max-age=86400");
    header ("Last-modified: ".gmdate("D, d M Y H:i:s", time())." GMT");
    header ("Expires: ".gmdate("D, d M Y H:i:s", time() + 86400)." GMT");
    $src = imagecreatefromgif("$image");
    $img = imagecreate($neww,$newh);
    imagecopyresized($img,$src,0,0,0,0,$neww,$newh,$w,$h);
    imagegif($img);
}
elseif ((2 == $type) && (imagetypes() & IMG_JPG) && $image)
{
    // JPG
    header ("Content-type: image/jpeg");
    header ("Cache-Control: must-revalidate, max-age=86400, s-max-age=86400");
    header ("Last-modified: ".gmdate("D, d M Y H:i:s", time())." GMT");
    header ("Expires: ".gmdate("D, d M Y H:i:s", time() + 86400)." GMT");
    $src = imagecreatefromjpeg("$image");
    $img = imagecreate($neww,$newh);
    imagecopyresized($img,$src,0,0,0,0,$neww,$newh,$w,$h);
    imagejpeg($img,'',100);
}
elseif ((3 == $type) && (imagetypes() & IMG_PNG) && $image)
{
    // PNG
    header ("Content-type: image/png");
    header ("Cache-Control: must-revalidate, max-age=86400, s-max-age=86400");
    header ("Last-modified: ".gmdate("D, d M Y H:i:s", time())." GMT");
    header ("Expires: ".gmdate("D, d M Y H:i:s", time() + 86400)." GMT");
    $src = imagecreatefrompng("$image");
    $img = imagecreate($neww,$newh);
    imagecopyresized($img,$src,0,0,0,0,$neww,$newh,$w,$h);
    imagepng($img);
}
else
{
    // Not able to create the thumbnail, so the Pagetool logo is shown
    header("Location: " . $default);
    exit;
}
imagedestroy($img);
?>