<?php
/*
    Pagetool
    Pagetool
    Copyright 2001,2002,2003,2004 Pagetool Development Team
    pagetool-user@lists.sourceforge.net http://www.pagetool.org/
    $Id: pt_upload.php,v 1.12 2004/07/17 05:13:37 jamiemcclelland Exp $

    myphpPagetool
    http://sourceforge.net/projects/myphppagetool
    (C) 2000 by Sebastian Bunka <Sebastian.Bunka@vu-wien.ac.at>

    This file is part of Pagetool. Pagetool is a modification
    of myphpPagetool.

    Pagetool is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version
    2 of the License, or (at your option) any later version.
*/

/*
If you're having problems uploading media files and you ask for support on the
pagetool-user@lists.sourceforge.net email list then for troubleshooting
purposes you might be asked to remove the leading # from the next line.
*/
#error_reporting(E_ALL);

/*
The next bits using the extract() function enables Pagetool to work with
register_globals = OFF which is the new PHP default. The GET variables aren't
extracted as they are not used in this file at all. POST is extracted first to
get the location of pt_config.inc.
*/
if (!empty($_POST))
{
	extract($_POST);
}
elseif (!empty($HTTP_POST_VARS))
{
	extract($HTTP_POST_VARS);
}

if (file_exists($config_file))
{
	include($config_file);
	if(isset($ptconf['upload_method']))
	{
		$upload_method = $ptconf['upload_method'];
	}
	else
	{
		// backward compatible w/ installs that don't have this
		// parameter in the config file.
		$upload_method = 'ftp';
	}
}
else
{
	die("Pagetool config file not found!");
}

/*
Now we can extract the rest of the variables from their arrays. $_SERVER
contains variables like PHP_AUTH_USER, PHP_AUTH_PW, HTTP_ACCEPT_LANGUAGE
*/

if (!empty($_SERVER))
{
	extract($_SERVER );
}
elseif (!empty($HTTP_SERVER_VARS))
{
	extract($HTTP_SERVER_VARS);
}

//The $_FILES array is not extracted - it is dealt with below
if(empty($_FILES) && !empty($HTTP_FILES_VARS))
{
	$_FILES = $HTTP_FILES_VARS;
}

/*
And finally extract _COOKIES, but only if the authentication type is set 
to cookies.
*/
if($ptconf['auth'] == 'cookies')
{
	if (!empty($_COOKIE))
	{
		extract($_COOKIE );
	}
	elseif (!empty($HTTP_COOKIE_VARS))
	{
		extract($HTTP_COOKIE_VARS);
	}
}
include($ptconf["src"] . "pagetool/pt_profile.inc");
include($ptconf["src"] . "pagetool/pt_functions.inc");

/*
   The default en language file is included to avoid blank language strings. 
   Then we use pt_accept_language() to check for the accepted languages and 
   include the first available language file.
*/
include($ptconf["src"] . "lang/pt_lang_en.inc");
include(pt_accept_language());

include($ptconf["src"] . "admin/pt_auth.inc");

/*
	Because $ptconf["version"] is set in pagetool.inc, and we haven't gone 
	anywhere near that file in this standalone pt_upload.php file, the pagetool 
	version number is unfortunately not available in the following 
	pt_begin_admin.inc include.
*/

include($ptconf["src"] . "admin/pt_begin_admin.inc");

function pt_upload_file($userfile,$name)
{
    global $ptconf, $str_ftp_con_failed, $str_ftp_mkdir_failed,$str_ftp_put_failed,$str_ftp_file_failed,$str_media_uploaded,$str_ftp_file_failed,$upload_method,$str_media_dir_not_writable;
    // Set full path of the destination file name
    $fullname =  $ptconf["ftppath"] . $ptconf["media_dir"] . $name;
	
	if($upload_method == 'www')
	{
		$uploaddir = $ptconf['wwwdir'] . $ptconf['media_dir'] . '/';
		$uploadfile = $uploaddir . $name;

		if(!is_writable($uploaddir)) {
            echo ("<span class=\"message\">" . $str_media_dir_not_writable ."</span><br>");
			return 0;
		}
			
		if (move_uploaded_file($userfile, $uploadfile)) {
            echo ("<span class=\"message\">" . $name . $str_media_uploaded ."</span><br>");
			return 1;
		} else {
            echo("<span class=\"message\">Upload error: " . $name . $str_media_upload_failed ."</span><br>");
			return 0;
		}
	}
    elseif (function_exists ("ftp_connect") && function_exists("ftp_login") && function_exists("ftp_put") && function_exists("ftp_quit") && function_exists("ftp_pwd") && function_exists("ftp_chdir") && function_exists("ftp_mkdir"))
    {   // FTP functions are available
        if(file_exists($userfile))
        {
            $conn_id = @ftp_connect($ptconf["ftpserver"]); // open a ftp connection
            $login_result = @ftp_login($conn_id,$ptconf["ftpuser"],$ptconf["ftppass"]); // login
            if ((!$conn_id) || (!$login_result)) // if the connection couldn't be made or the login failed
            {
                echo("<span class=\"message\">" . $str_ftp_con_failed ."</span><br>");
                @ftp_quit($conn_id);
                return 0;
            }
            $base_dir = ftp_pwd($conn_id); // Base FTP dir
            $media_dir = @ftp_chdir($conn_id, $ptconf["ftppath"] . $ptconf["media_dir"]); // check the media dir exists
            if (!$media_dir)
            {
                $dir = @ftp_mkdir($conn_id, $ptconf["ftppath"] . $ptconf["media_dir"]); // it doesn't exist, so create the media dir
                $media_dir = @ftp_chdir($conn_id, $ptconf["ftppath"] . $ptconf["media_dir"]); // check the media dir exists again
                if (!$media_dir) // creation of the media dir failed
                {
                    echo("<span class=\"message\">" . $str_ftp_mkdir_failed ."</span><br>"); 
                    @ftp_quit($conn_id);
                    return 0;
                }
                $dir=ftp_chdir($conn_id, $base_dir); // change back to the base dir
            }
            echo("<span class=\"message\">" . $str_ftp_mkdir_ok ."</span><br>"); 
            $upload = ftp_put($conn_id, $fullname,$userfile,FTP_BINARY);
            if (!$upload) // file upload failed
            {
                echo("<span class=\"message\">" . $str_ftp_put_failed ."</span><br>");
                @ftp_quit($conn_id);
                return 0;
            }
            else
            {
                echo ("<span class=\"message\">" . $name . $str_media_uploaded ."</span><br>");
                @ftp_quit($conn_id);
                return 1;
            }
        }
        else
        {
            echo("<span class=\"message\">" . $str_ftp_file_failed ."</span><br>");
            @ftp_quit($conn_id);
            return 0;
        }
    }
    else // No FTP functions so use fopen
    {
        // Open the source file for writing
        $sfile = fopen($userfile,"rb");
        if ( $sfile )
        {
            if( $dfile = fopen("ftp://" . urlencode($ptconf["ftpuser"]) . ":" . $ptconf["ftppass"] . "@" . $ptconf["ftpserver"] . $fullname, "wb"))
            {
                fwrite( $dfile, fread($sfile, filesize($userfile)));
                fclose( $dfile );
            }
            else
            {
                echo("<span class=\"message\">" . $str_open_ftp_failed . "</span>");
                return 0;
            }
            fclose( $sfile );
            echo("<span class=\"message\">" . $name . $str_media_uploaded . "</span>");
            return 1;
        }
        else
        {
            return 0;
        }
    }
}

echo pt_html_from(__FILE__, __LINE__);

echo ("<div class=\"body\">");
/* First, do the groups thing. You can only specify one set of groups
for each of the files uploaded.*/
$groups = pt_joingrouparray($_POST['new_groups']);

$files_array = $_FILES;
$i = 1;
foreach($files_array as $file)
{
	$name = $file['name'];
	if($name <> '')
	{
		// Make sure it has an extension
		if(!preg_match("/\./",$name))
		{
			echo ("<span class=\"message\">" . $str_missing_extension . "</span>");
        	include($ptconf["src"] . "admin/pt_media.inc");
        	echo pt_html_from(__FILE__,__LINE__);
        	echo ("</div></body></html>");
        	exit;
		}
		// Replace any blank spaces with underscores 
		$name = preg_replace ("/\s/","_",$name);
		$tmp_name = $file['tmp_name'];
		$description = $_POST[$description . $i];
		$size = $file['size'];
		if( $size > 10241440 )
		{
        	echo ("<span class=\"message\">" . $str_media_over_limit . "10 MB </span>");
        	include($ptconf["src"] . "admin/pt_media.inc");
        	echo pt_html_from(__FILE__,__LINE__);
        	echo ("</div></body></html>");
        	exit;
		}

		// Make sure no file with the same name exists
		$sql = "SELECT name FROM pt_core_media WHERE name='" . $name . "'";
		$result = pt_query($sql);
		if ( mysql_num_rows($result) > 0 )
		{
			echo "<span class=\"message\">" . $name . $str_media_name_exists . "</span>";
			echo "<br><br>";
			include($ptconf["src"] . "admin/pt_media.inc");
			echo pt_html_from(__FILE__,__LINE__);
			echo ("</div></body></html>");
			exit;
			/*
			We shouldn't really exit here as any other files we where trying to
			upload after this file won't now be uploaded. Mmmmm Pagetool 2........
			*/
		}
		if (pt_upload_file($tmp_name,$name)==1)
		{
			// If the file uploads, add an entry in the database
			pt_query("INSERT INTO pt_core_media (name, description, tstamp, username, groups ) VALUES('$name','$description',now(), '$PHP_AUTH_USER', '$groups')");
			$message = $name . $str_record_added;
			pt_errcheck($message);
			echo "<br>";
		}
		else
		{
			echo ("<span class=\"message\">" . $name . $str_media_upload_failed . "</span><br>");
			echo pt_html_from(__FILE__,__LINE__);
		}
	}
	$i++;
}
		
include($ptconf["src"] . "admin/pt_media.inc");
echo pt_html_from(__FILE__, __LINE__);
echo "</div>";
echo "</body></html>";

?>
