<?php
/*
    Pagetool
    http://www.mediajumpstart.org/index.php?name=pagetool
    Copyright 2001 Pagetool Development Team, info@pagetool.org
    $Id: style.php,v 1.3 2002/12/01 20:41:57 daveguerin Exp $

    myphpPagetool
    http://sourceforge.net/projects/myphppagetool
    (C) 2000 by Sebastian Bunka <Sebastian.Bunka@vu-wien.ac.at>

    This file is part of Pagetool. Pagetool is a modification
    of myphpPagetool.

    Pagetool is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version
    2 of the License, or (at your option) any later version.
*/
// The admin style sheet is not intended to be modified

/* This $dev variable, if set to 1, allows the style sheet to be viewed in the browser directly.
   So style.php?dev=1 will display as text/html. style.php or style.php?dev=0 will dispaly as text/css.
   If style.phh?dev=1 is called as a stylesheet, the browser will NOT be able to interpret the styles.
   $dev MUST be set to 0 therefore, for this file to act as a stylesheet.
*/

if ($dev)
{
    $br="<br>\n";
}
else
{
    $br="\n";
    // Send out headers to tell the browser this is a stylesheet, and that it should be cached
    header("Content-Type: text/css");
    header("Cache-Control: must-revalidate, max-age=86400, s-max-age=86400");
    header("Last-modified: ".gmdate("D, d M Y H:i:s", time())." GMT");
    header("Expires: ".gmdate("D, d M Y H:i:s", time() + 86400)." GMT");
}
// this function returns the font size and units required
function pt_font_size($size)
{
    global $font_base,$font_unit,$br;
    if ("px" == $font_unit)
    {
        $fsize = round($font_base * $size, 0);
    }
    elseif ("em" == $font_unit)
    {
        $fsize = round($font_base * $size, 1);
    }
    else
    {
         $fsize = round($font_base * $size, 1);
    }
    return("font-size:" . $fsize . $font_unit . ";" . $br);
}

/* include and initiate the class.
   phpSniff is by Roger Raymond, see http://sourceforge.net/projects/phpsniff/
   If the location of the class files is not the same directory as the stylesheet
   then the include statment will need to include the path */

include("../third_party/phpSniff.core.php");
include("../third_party/phpSniff.class.php");
$client = new phpSniff($ua,0);
$client->init();

// echo a style sheet header remark

echo "/* This is a dynamic stylesheet produced by Pagetool for";
echo " browser " . $client->property('browser');
echo " version " . $client->property('version');
echo " running on " . $client->property('platform');
echo " with os " . $client->property('os');
echo " */" . $br;

// set default values

$fontfamily = "font-family:Verdana,Geneva,Arial,Helvetica,sans-serif;" .$br; // the default font family string
$font_unit = "em"; // the default font unit
$font_base = 1; // the default font size (in the default font unit!)

// Now set various variables depending on platform and browser and browser version

// em is displayed as px on ie3 so reset the base size, and use px as the unit
if ("ie"==$client->property('browser') AND ($client->property('version')-3)<1)
{
    $font_unit = "px";
    $font_base = "12";
}
// make the base font size a bit bigger for the mac
if ("mac" == $client->property('platform'))
{
    $font_base = $font_base * 6/5;
}
// add in other browser specific stuff here

    echo "A{" . $br;
    echo "text-decoration:none;" . $br;
    echo "}" . $br;

    echo "A:HOVER{" . $br;
    echo "color:#0000FF;";
    echo "background-color:#FFFFFF;" . $br;
    echo "text-decoration:underline;" . $br;
    echo "}" . $br;
    
    echo "BODY{" . $br;
    echo "background:#FFFFFF;" . $br;
    echo $fontfamily;
    echo "}" . $br;

    echo ".head{" . $br;
    echo pt_font_size(.8);
    echo "}" . $br;

    echo ".menu{" . $br;
    echo pt_font_size(.8);
    echo "}" . $br;

    echo ".body{" . $br;
    echo pt_font_size(.8);
    echo "}" . $br;

    echo "TD{" . $br;
    echo "background:#FFFFFF;" . $br;
    echo $fontfamily;
    echo pt_font_size(.8);
    echo "}" . $br;

    echo ".header1{" . $br;
    echo pt_font_size(1.3);
    echo "font-weight:bold;" . $br;
    echo "}" . $br;

    echo ".header2{" . $br;
    echo pt_font_size(1);
    echo "}" . $br;
    
    echo ".info{" . $br;
    echo "font-style:italic;" . $br;
    echo "}" . $br;

    echo ".label{" . $br;
    echo "font-weight:bold;" . $br;
    echo "}" . $br;

    echo ".message{" . $br;
    echo "color:#FF0000;";
    echo "background-color:#FFFFFF;" . $br;
    echo "}" . $br;
?>