<?php
/*
    Pagetool
    Copyright 2001,2002,2003,2004 Pagetool Development Team
    pagetool-user@lists.sourceforge.net http://www.pagetool.org/
    $Id: pagetool.inc,v 1.39 2004/11/10 23:14:10 daveguerin Exp $

    myphpPagetool
    http://sourceforge.net/projects/myphppagetool
    (C) 2000 by Sebastian Bunka <Sebastian.Bunka@vu-wien.ac.at>

    This file is part of Pagetool. Pagetool is a modification
    of myphpPagetool.

    Pagetool is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version
    2 of the License, or (at your option) any later version.
*/

/*
The next bit enables Pagetool to work with register_globals = OFF which is the
new PHP default.
*/
if (!empty($_GET))
{
	extract($_GET);
}
elseif (!empty($HTTP_GET_VARS))
{
	extract($HTTP_GET_VARS);
}
if (!empty($_POST))
{
	extract($_POST);
}
elseif (!empty($HTTP_POST_VARS))
{
	extract($HTTP_POST_VARS);
}
// $_SERVER is variables like PHP_AUTH_USER, PHP_AUTH_PW, HTTP_ACCEPT_LANGUAGE
if (!empty($_SERVER))
{
	extract($_SERVER );
}
elseif (!empty($HTTP_SERVER_VARS))
{
	extract($HTTP_SERVER_VARS);
}

// Only extract cookies if they are using cookies for logging in
if($ptconf['auth'] == 'cookies')
{
	if (!empty($_COOKIE))
	{
		extract($_COOKIE);
	}
	elseif (!empty($HTTP_COOKIE_VARS))
	{
		extract($HTTP_COOKIE_VARS);
	}
}

include($ptconf["src"] . "pagetool/pt_functions.inc");

/*
   The default en language file is included to avoid blank language strings. 
   Then we use pt_accept_language() to check for the accepted languages and 
   include the first available language file.
*/
include($ptconf["src"] . "lang/pt_lang_en.inc");
include(pt_accept_language());

$ptconf["version"]  = "1.07";

pt_pconnect();

/*
    If no page was given to the script, select the homepage designated in the
    active profile.
*/

if ( $name == "" )
{
	$name = $ptconf["emptyname"];
}
// Start running through the master if/then statement

// If they are logging out ...

if ( $name == "pagetool_logout" )
{
	if(!isset($ptconf['auth']) OR isset($HTTP_GET_VARS['ptconf']['auth']) OR isset($HTTP_POST_VARS['ptconf']['auth']) OR isset($HTTP_COOKIE_VARS['ptconf']['auth']) )
	{
		$ptconf['auth'] = 'http';
	}

	if($ptconf['auth'] == 'cookies')
	{
		setcookie('pt_timestamp','',0,'/','',0);
		setcookie('pt_username','',0,'/','',0);
		setcookie('pt_username_hash','',0,'/','',0);
	}

	echo "<!doctype HTML PUBLIC \"-//W3C//DTD HTML 4.01 TRANSITIONAL//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">\n";
	echo "<html>\n<head>\n<title>";
	echo $str_log_out;
	echo "</title>\n";
	echo $ptconf["headcode"];
	echo "</head>\n<body>\n";
	echo "<span class=\"header1\">" . $str_log_out . "</span><br><br>";
	echo "<span class=\"text1\">" . $str_log_out_message . "</span>";
	echo "</body>\n</html>";
	exit;
}
elseif ( $name == "pagetool_news" ) // Show the selected news article ...
{
	if(!$news_id)
	{
		$news_id='all';
	}
	
	// Draw the begin html
	$my_title = $str_news_results;
	$my_header = $ptconf["header"];
	$my_sidebar = $ptconf["sidebar"];
	include($ptconf["src"] . "pagetool/pt_begin_html.inc");
	// Find the news to display
	if ($news_id == "all")
	{
		$newsquery = "SELECT headline,link,article,summary,UNIX_TIMESTAMP(tstamp) AS date ";
		$newsquery .= "FROM pt_core_news ";
		$newsquery .= "ORDER BY date DESC";
	}
	else
	{
		$newsquery = "SELECT headline,link,article,summary,UNIX_TIMESTAMP(tstamp) AS date ";
		$newsquery .= "FROM pt_core_news ";
		$newsquery .= "WHERE news_id=$news_id ";
		$newsquery .= "ORDER BY date DESC";
	}
	$my_result = pt_query($newsquery);
	// Display the news
	echo pt_html_from(__FILE__, __LINE__); // Begin body table data
	echo $ptconf["bodytd"] . "\n";
	echo "<span class=\"header1\">" . $str_news_cap . "</span><br><br>";
	include($ptconf["src"] . "pagetool/pt_news.inc");
	echo "</td>";
	// If there is news on the homepage, there will be a news bar, but with nothing in it, just to complete the table
	if ($ptconf["newsonhp"] == "Y")
	{
		echo pt_html_from(__FILE__, __LINE__); // News table data
		echo $ptconf["newstd"] . "&nbsp;</td></tr>\n\n";
	}
	// Draw end html
	$my_footer = $ptconf["footer"];
	include($ptconf["src"] . "pagetool/pt_end_html.inc");
}
elseif ( $name == "pagetool_admin" ) // Transfer to the admin section
{
	// If SSL is activated (see pt_config.inc) admin can only be done via SSL.
	if ( $ptconf["SSL"] == "Y" )
	{
		if ( $SERVER_PORT <> $ptconf["SSL_PORT"] )
		{
			$this_host = $_SERVER['HTTP_HOST'];
			$this_page = $_SERVER['PHP_SELF'];
			$query_string = $_SERVER['QUERY_STRING'];
			header('Location: https://' . $this_host . $this_page . '?' . $query_string);
			exit;
		}
	}
	include($ptconf["src"] . "admin/pt_admin.inc");
}
else // Finally, display the chosen page
{
	$my_query = "SELECT www_id,name,title,keywords,html,page_header,";
	$my_query .= "page_sidebar,page_footer,username,code_type,auto_html,";
	$my_query .= "unix_timestamp(tstamp) AS tstamp, security ";
	$my_query .= "FROM pt_core_wwwpages ";
	$my_query .= "WHERE name=\"$name\" ";
	$my_result = pt_query($my_query);
	// If there's a match for the page requested...
	if ( mysql_num_rows($my_result) == 1 )
	{
		$row = mysql_fetch_object($my_result);
		// Assign variables for the record
		$main_id = $row->www_id;
		$main_name = $row->name;
		$main_title = $row->title;
		$main_keywords = $row->keywords;
		$main_html = $row->html;
		$main_page_header = $row->page_header;
		$main_page_sidebar = $row->page_sidebar;
		$main_page_footer = $row->page_footer;
		$main_time = $row->tstamp;
		$main_username = $row->username;
		$main_code_type = $row->code_type;
		$main_auto_html = $row->auto_html;
		$main_security = $row->security;
		mysql_free_result($my_result);
		// Draw the beginning html
		$my_title = $main_title;
		$my_header = $main_page_header;
		$my_sidebar = $main_page_sidebar;
		include($ptconf["src"] . "pagetool/pt_begin_html.inc");
		// Draw the main page
		echo pt_html_from(__FILE__, __LINE__); //Begin Body tag
		echo $ptconf["bodytd"] . "\n";
		if ($main_code_type == 'php') // If it's php, evaluate, otherwise simply echo the code
		{
			eval($main_html);
		}
		else
		{
			/* If the page is Auto_HTML then place html between text1 tags in 
			   case the code contains no formatting instructions. This way, all 
			   pages will have the same text formatting.
			*/
			if ("Y" == $main_auto_html)
			{
				echo "<span class=\"text1\">";
			}
			echo $main_html;
			if ("Y" == $main_auto_html)
			{
				echo "</span>";
			}
		}

		echo "</td>\n";
		// If they are displaying news on the homepage, then start the the news td tag.
		if ($ptconf["newsonhp"] == "Y")
		{
			echo pt_html_from(__FILE__, __LINE__); // Begin news td
			echo $ptconf["newstd"] . "\n";

			// If this is the home page draw the news bar
			if ($name == $ptconf["emptyname"])
			{
				include($ptconf["src"] . "pagetool/pt_news_bar.inc");
			}
			else
			{
				echo "&nbsp;";
			}
			echo "</td>";
		}
		echo "</tr> \n";

		// Manually draw the html end so we can include the time stamp and modifed by
		echo pt_html_from(__FILE__, __LINE__); // Begin footer td
		echo "<tr>\n" . $ptconf["footertd"] . "\n";
		if ($main_page_footer <> "none")
		{
			retreive_html($main_page_footer);
		}
		else
		{
			echo "&nbsp;";
		}
		echo "</td></tr> \n";
		
		/*
		If they are displaying news on the homepage, then our table is 3 cells wide.
		If they are not displaying news on the homepage then it's only 2 cells wide.
		*/
		if ($ptconf["newsonhp"] == "Y")
		{
			$pt_colspan ='3';
		}
		else
		{
			$pt_colspan ='2';
		}
		
		if ($ptconf["lastmodified"]=="Y") // Last modified by ...
		{
			echo "<tr><td colspan=\"".$pt_colspan."\" class=\"text3\"><br><br>";
			echo $str_last_modified . pt_format_date($main_time);
			echo "<br>" . $str_by . $main_username;
			echo "</td></tr>\n";
		}
		if ($name == $ptconf["emptyname"])
		{
			echo "<tr><td colspan=\"".$pt_colspan."\" align=\"center\">\n";
			echo "\n\n\n<!--\n";
			echo "Please note that we request that the following copyright\n";
			echo "notice be displayed on the homepage of any Pagetool site.\n";
			echo "You may alter the font, colour etc. but we request that you\n";
			echo "do not remove it, nor change it so that it be, to all intents\n";
			echo "and purposes, invisible. You may add your own notice to it\n";
			echo "should you have altered the code but you should not replace it.\n";
			echo "We also request that the hyperlink should remain intact.\n\n";
			echo "The Pagetool Development Team 2001, 2002, 2003, 2004\n";
			echo "-->\n";
			echo "<span class=\"text3\">Powered by <a href=\"http://www.pagetool.org/\">Pagetool</a> Ver " . $ptconf["version"] . " &copy; 2001, 2002, 2003, 2004 Pagetool Development Team</span>\n\n\n";
			echo "</td></tr>\n";
		}
		echo "</table>\n</body>\n</html>\n";
	}
	else // If there is *no* match for the page, then generate the error
	{
		// Draw begin html
		$my_title = "404 Not Found";
		$my_header = $ptconf["header"];
		$my_sidebar = $ptconf["sidebar"];
		include($ptconf["src"] . "pagetool/pt_begin_html.inc");
		echo pt_html_from(__FILE__, __LINE__); //Begin body data
		echo $ptconf["bodytd"] . "\n";
		include($ptconf["src"] . "pagetool/pt_missing.inc");
		echo "</td>\n";
		echo pt_html_from(__FILE__, __LINE__); //News data
		echo $ptconf["newstd"] . " \n";
		echo "&nbsp;</td></tr>\n";
		// Draw end html
	   $my_footer = $ptconf["footer"];
	   include($ptconf["src"] . "pagetool/pt_end_html.inc");
	}
}
$name = "";
?>
