<?php
/*
    Pagetool
    Copyright 2001,2002 Pagetool Development Team
    pagetool-user@lists.sourceforge.net http://www.pagetool.org/
    $Id: pt_functions.inc,v 1.18 2004/07/18 05:43:32 jamiemcclelland Exp $

    myphpPagetool
    http://sourceforge.net/projects/myphppagetool
    (C) 2000 by Sebastian Bunka <Sebastian.Bunka@vu-wien.ac.at>

    This file is part of Pagetool. Pagetool is a modification
    of myphpPagetool.

    Pagetool is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version
    2 of the License, or (at your option) any later version.
*/

// If this file is already included, do not include it again.

if( !$included["pt_functions.inc"] ) {

///////////////////////////
// SQL related functions //
///////////////////////////

  /* pt_pconnect() establishes a persistant connection to the Pagetool database
  using the search user (the one without edit privileges). This is called every
  time a page is accessed, so you should not have to repeat it. */

  function pt_pconnect() {
	global $ptconf, $str_database_connection_failed;
	if (!mysql_pconnect($ptconf["dbhost"],$ptconf["dbuser"],$ptconf["dbpass"])) {
		echo "<span class=\"message\">" . $str_database_connection_failed . "</span>";
		exit;
	}
  }

  /* pt_admconnect() establishes a persistant connection to the Pagetool database
  using the admin user (which as write priveleges). */

  function pt_admpconnect() {
	global $ptconf, $str_database_connection_failed;
	if (!mysql_pconnect($ptconf["dbhost"],$ptconf["dbadmuser"],$ptconf["dbadmpass"])) {
		echo "<span class=\"message\">" . $str_database_connection_failed . "</span>";
	}
  }

  /* pt_query($sqlcommand) runs the mysql_db_query function using the Pagetool
  database. $sqlcommand should be a sql statement. This function returns the
  query result. */

  function pt_query($sqlcommand) {
        global $ptconf;
	$func_result = mysql_db_query($ptconf["dbname"], $sqlcommand);
	return $func_result;
  }

  /* pt_errcheck($message) checks to see if
  the last query was successful.  If so, it will display $message,
  otherwise it will return the mysql error number and error message.
  */

  function pt_errcheck($message) {
	global $ptconf, $str_sql_error;
    echo pt_html_from(__FILE__, __LINE__);
	if ( mysql_errno() == 0 ) {
		echo ("<span class=\"message\">" . $message . "</span>");
	} else {
		echo ("<span class=\"message\">" . $str_sql_error . "<br>" . mysql_errno() . ": "  . mysql_error() . "</span>");
	}
  }
////////////////////////////
// Miscelleneous functions//
////////////////////////////

  /* pt_format_date($unix_time_stamp) takes a unix timestamp and returns it
  in the date format specified in the active profile. To use this function,
  you must covert the mysql time stamp to a unix time stamp, i.e. : SELECT
  UNIX_TIMESTAMP(mysqltimestampfield) before passing it. */

  function pt_format_date($unix_time_stamp) {
  	global $ptconf;
  	if ($ptconf["dateformat"] == "dd-mm-yy") {
		return date("d-m-y",$unix_time_stamp);
  	} elseif ($ptconf["dateformat"] == "mm-dd-yy") {
		return date("m-d-y",$unix_time_stamp);
  	} else {
		return date("Y-m-d",$unix_time_stamp);
  	}
  }

  /* pt_html_to_special($html) will replace all textarea tags with !textarea
  and all & with !&. This function is used so that html will properly display
  within a textarea tag. */

  function pt_html_to_special($html) {
      if(preg_match_all("/&.?.?.?.?.?.?.?.?;/",$html,$match))
      {
          while(list($key,$value) = each($match[0]))
          {
              $new_value = ereg_replace("&","&!",$value);
              $html = ereg_replace($value,$new_value,$html);
          }
      }
      $html = eregi_replace("</textarea>","<!/textarea>",$html);
      return $html;
  }

  /* pt_special_to_html($html) reverses the pt_html_to_special($html) function
  by replacing the special characters with real html. */

  function pt_special_to_html($html) {
    $html1=eregi_replace("<!/textarea>","</textarea>",$html);
    $html2=eregi_replace("&!","&",$html1);
    return $html2;
  }

  /* pt_addslashes($text) is just like addslashes except that if first checks to see
  if magic quotes is enabled in the php.ini file. If so, it simply returns
  $text, if not then it addslashes and returns $text. */

  function pt_addslashes($text)  {
	if (get_magic_quotes_gpc()==1) {
		return $text;
      } else {
      	return AddSlashes($text);
      }
  }

  /* pt_br2nl($string) replaces all <br>'s \n's in the given string. */

  function pt_br2nl($string) {
	return eregi_replace('<br[[:space:]]*/?[[:space:]]*>', "\n", $string);
  }

  /* retreive_html($name) will return the html or php code for the
  pt_core_wwwpages entry with the name specified as the $name argument. */

  function retreive_html($name) 
  {
      $my_result = pt_query("select html,code_type from pt_core_wwwpages where name=\"$name\" ");
      $row = mysql_fetch_object($my_result);
      if ($row->code_type == "php")
      {
          eval($row->html);
      } 
      else
      {
          echo $row->html;
      }
  }

    /* outputs an HTML remark to show which file the HTML is from.
    but only if the $ptconf['html_from'] variable is set*/
function pt_html_from($file,$line)
{
    global $ptconf;
    if ($ptconf["html_from"])
    {
        return("\n\n\n\n<!-- HTML output from " . $file . " from line " . $line . " onwards -->\n\n\n\n");
    }
    else
    {
        return("");
    }
}

 /* used to replace all spaces with &nbsp; in a string to avoid 
    wordwrapping a line
 */
function pt_nbsp($string)
{
	$r = ereg_replace("[\r|\n|\t| ]","&nbsp;",$string);
	$r = ereg_replace("[-]","&minus;",$r);
	// I've used &minus; here as IE doesn't line break a minus but it does a 
	// &#45; which is a dash or -. Can you tell the difference?
	return($r);
}

/*
  Used to convert a string containing htmlentities back to purely text string
  Taken directly from the PHP documentation :-)
*/

function pt_unhtmlentities($string)
{
	$trans_tbl = get_html_translation_table(HTML_ENTITIES);
	$trans_tbl = array_flip($trans_tbl);
	return strtr($string, $trans_tbl);
}

/*
   Used to calculate the correct Pagetool language file to be included based on
   the languages accepted by the browser.
*/
function pt_accept_language()
{
	global $ptconf, $HTTP_ACCEPT_LANGUAGE;
	/*
	   $lang set to the default value of 'en'. If no other language is available 
	   this language file will be returned. In the main code this file should have
    already been included, so it's going to be included again if no other 
    accepted language is available. If we could GUARANTEE that the other 
    language files were complete then the additional first include of the 'en' 
    file could be avoided.

    This function needs further work, to do with dialects mainly, for example 
    how to deal with this lot of HTTP_ACCEPT_LANGUAGE values:

    IE6 SP1     Norwegian (Nynorsk) nn-no
                Norwegian (Bokml)  no
                Norwegian (Bokml)  nb-no

    Opera 6.01  Norwegian (Nynorsk) no-nyn
                Norwegian (Nynorsk) nn
                Norwegian (Bokml)  nb
                Norwegian (Bokml)  no-bok
                Norwegian           no

    Mozilla 1.0 Norwegian (Nynorsk) nn
                Norwegian           no
                Norwegian (Bokml)  nb
	*/
	$lang = 'en';
	if (isset($HTTP_ACCEPT_LANGUAGE))
	{
		if (file_exists($ptconf["src"] . "lang/pt_lang_". substr($HTTP_ACCEPT_LANGUAGE,0,2) . ".inc"))
		{
			$lang = substr($HTTP_ACCEPT_LANGUAGE,0,2);
		}
	}
	return($ptconf["src"] . "lang/pt_lang_". $lang . ".inc");
}

/////////////////////////
// Admin pages functions//
//////////////////////////

  /* pt_joingrouparray($grouparray) takes an array of group names and stores them in one
  database field. For example, an array consisting of joe, bar, and foo will be entered
  as :joe:bar:foo:. Use this function when creating or update group permissions
  for a wwwpage in the database. */

  function pt_joingrouparray($grouparray) {
	global $ptconf;

	if ( !is_array($grouparray) ) {
		$returnstring = ":$grouparray";
	} else {
		while ( list ($key, $value) = each ($grouparray) ) {
			$returnstring .= ":$value";
		}
	}
	$returnstring .= ":";
	return $returnstring;
  }

  /* pt_creategroupsel($select_name,$grouplist) creates the multiple select
  option that allows users to select which group should be given access to a
  particular wwwpage. It takes two variables: select_name is the array to
  put the selected items into and grouplist is a string of group names that
  should be pre-select. The string should be in the format: ":joe:foo:bar:" */

  function pt_creategroupsel($select_name,$grouplist) {
	global $ptconf;
	$allgroups = pt_query("select * from pt_core_groups");
	echo "<select multiple name=\"" . $select_name . "[]\">";
	if ( mysql_num_rows($allgroups) > 0 )
	{
		while ( $g_row = mysql_fetch_object($allgroups) )
		{
			echo "<option value=\"" . $g_row->group_name . "\"";
			if ( eregi ( $g_row->group_name, $grouplist ) )
				echo " selected";
			echo ">" . $g_row->group_name;
		}
		mysql_free_result($allgroups);
	}
	echo "</select>";
	return;
  }

  /* pt_checkgroupaccess($usergroups, $entrygroups) checks to see whether a
  particular users has the appropriate group rights to edit a wwwpage. $usergroups
  is an array containing all the groups the user belongs to while $entrygroups
  is an array containing all the groups who have access to the wwwpage. Returns
  1 is access should be granted and 0 is access should be denied. */

  function pt_checkgroupaccess($usergroups, $entrygroups) {
	global $ptconf;
	$groupaccess = 0;
	$singlegroups = explode(":", $usergroups);
	while ( list ($key, $value) = each ($singlegroups) ) {
		if ( $value != "" ) {
			if ( eregi (":" . $value . ":", $entrygroups) ) $groupaccess = 1;
			/* admin users are always allowed */
			if ( $value == "admin" ) $groupaccess = 1;
		}
	}
	return $groupaccess;
  }

  /* pt_explodegroup($grouplist) takes names from the string $grouplist (e.g. :foo:bar:)
  and puts them into a  single array, which is returned. */

  function pt_explodegroup($grouplist) {
	global $ptconf;
	$grouparray = explode(":", $grouplist);
	return($grouparray);
  }

  /* pt_deleterow($delname, $section, $table, $idname, $id, $force) deletes rows
  from the given table. */

  function pt_deleterow($delname, $section, $table, $idname, $id, $force) {
    global $ptconf;
    global $admp;
    global $str_wwwpage_in_use, $str_wwwpages_link_to, $str_delete_confirm, $str_yes_cap, $str_no_cap, $str_record_deleted;
    echo pt_html_from(__FILE__, __LINE__);
    if ( $force != 1 ) {
      if ($table=="pt_core_wwwpages") {
	$query = "SELECT homepage,header,sidebar,footer FROM pt_core_profiles WHERE profile_id=1";
	$result = pt_query($query);
	if ($row = mysql_fetch_object($result)) {
       	  if ($row->homepage == $delname || $row->footer == $delname || $row->header == $delname || $row->sidebar == $delname) {
	    echo "<span class=\"message\">" . $str_wwwpage_in_use . "</span>";
	    echo "<br><br>";
	    include($ptconf["src"] . "admin/pt_www.inc");
	    exit;
	  }
        }
	$query = "SELECT name FROM pt_core_wwwpages WHERE html LIKE '%index.php?name=$delname%'";
	$result = pt_query($query);
	$first=0;
	while ($row=mysql_fetch_object($result)) {
	  if ($first==0) echo "<span class=\"message\">" . $str_wwwpages_link_to . $delname . ":</span><br>";
	  echo $row->name . "<br>";
	  $first=1;
	}
      }
      if ($first=1) echo "<br>";
      echo "<span class=\"message\">" . $str_delete_confirm . $delname . "?</span>";
      echo "<br><br>";
      echo "<a href=\"" . $admp . "\">";
      echo $str_no_cap;
      echo "</a>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
      echo "<a href=\"" . $admp . "&amp;pt_action=delete&amp;pt_section=" . $section . "&amp;id=" . $id . "&amp;force=1&amp;delname=" . $delname ."\">";
      echo $str_yes_cap;
      echo "</a>";
    } else {
        pt_query("delete from $table where $idname='$id'");
	$message = $delname . $str_record_deleted;
	pt_errcheck($message);
	echo "<br>\n";
    }
  }

function pt_delete_media($delname, $section, $table, $idname, $id, $force) 
{
     global $ptconf, $str_media_deleted, $str_record_deleted, $str_media_not_deleted;
     global $admp, $str_delete_confirm, $str_no_cap, $str_yes_cap, $str_ftp_connection_failed;
     global $str_ftp_con_failed, $str_ftp_media_dir_error, $str_ftp_del_failed;
     echo pt_html_from(__FILE__, __LINE__);
     if ( $force != 1 ) 
     {
        echo "<span class=\"message\">" . $str_delete_confirm . $delname . "?</span>";
        echo "<br><br>";
        echo "<a href=\"" . $admp ."\">";
        echo $str_no_cap;
        echo "</a>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
        echo "<a href=\"" . $admp . "&pt_action=delete&pt_section=$section&id=$id&force=1&delname=$delname\">";
        echo $str_yes_cap . "</a>\n";
		return 1;
	} 
	else 
	{
	 	if($ptconf['upload_method'] == 'www')
		{
			$file = $ptconf['wwwdir'] . $ptconf['media_dir'] . '/' . $delname;
			if(unlink($file))
			{
				echo "<span class=\"message\">" . $delname . $str_media_deleted . "</span>";
	  			echo "<br>";
          		pt_query("DELETE FROM $table WHERE $idname='$id'");
	  			$message = $delname . $str_record_deleted;
	  			pt_errcheck($message);
       		} else {
	  			echo "<span class=\"message\">" . $str_media_not_deleted . "</span>";
       		}
		} else {
			//First delete the media file from the server
			if (function_exists ("ftp_connect") && function_exists("ftp_login") && function_exists("ftp_quit") && function_exists("ftp_pwd") && function_exists("ftp_chdir"))
			{
				// FTP functions are available
				$conn_id = @ftp_connect($ptconf["ftpserver"]); // open a ftp connection
				$login_result = @ftp_login($conn_id,$ptconf["ftpuser"],$ptconf["ftppass"]); // login
				if ((!$conn_id) || (!$login_result)) // if the connection couldn't be made or the login failed
				{
					echo("<span class=\"message\">" . $str_ftp_con_failed ."</span><br>");
					@ftp_quit($conn_id);
					return 0;
				}
				$base_dir = ftp_pwd($conn_id); // Base FTP dir
				$media_dir = @ftp_chdir($conn_id, $ptconf["ftppath"] . $ptconf["media_dir"]); // check the media dir exists
				if (!$media_dir)
				{
					echo("<span class=\"message\">" . $str_ftp_media_dir_error ."</span><br>");
					@ftp_quit($conn_id);
					return 0;
				}
				$delete = @ftp_delete($conn_id, $ptconf["ftppath"] . $ptconf["media_dir"] . $delname);
				if (!$delete) // file delete failed
				{
					echo("<span class=\"message\">" . $str_ftp_del_failed ."</span><br>");
					@ftp_quit($conn_id);
					return 0;
				}
				else
				{
					// the file has been deleted, so close the ftp connection
					@ftp_quit($conn_id);
				}
			}
			else
			{
				// No FTP functions, so we use fsockopen
				//Thanks to RedBehelit@Yahoo.com for some of the following code
				$tftp = fsockopen($ptconf["ftpserver"], 21, $errno, $errstr, 60);
				@socket_set_blocking($tftp, false);
				@fputs($tftp, "USER " . $ptconf["ftpuser"] . "\n");
				@fputs($tftp, "PASS " . $ptconf["ftppass"] . "\n");
				if (!$tftp)
				{
					/*
					we can't get any useful return from the USER or PASS commands so we don't 
					reference them at all
					*/
					echo "<span class=\"message\">" . $str_ftp_con_failed . "</span>";
					@fclose($tftp);
					return;
				}
				@fputs($tftp, "DELE " .$ptconf["ftppath"] . $ptconf["media_dir"]. $delname . "\n");
				// you have to give the connection time to execute the command.
				sleep(1);
				@fclose($tftp);
			}
			/*
			we can't actually get a return from the FTP server to confirm the file 
			delete, so we now check to see if the file exists still or not.
			*/
			if (file_exists($ptconf["media_dir"]. $delname))
			{
				echo "<span class=\"message\">" . $str_media_not_deleted . "</span>";
				return;
			}
			echo "<span class=\"message\">" . $delname . $str_media_deleted . "</span>";
			echo "<br>";
			pt_query("DELETE FROM $table WHERE $idname='$id'");
			$message = $delname . $str_record_deleted;
			pt_errcheck($message);
		}
	}
    return;
  }

  /* pt_createcategorysel($name,$selected_category) creates category lists.
  It is used on the new and edit wwwpages files to generate a list of all
  categories being used. $name is the name of the variable (e.g. new_category
  or edit_category). $selected_category is the category that should be selected
  (e.g. if this is an edit page, this should be the currently selected category,
  if this is a new page, then $selected_category should be set to "none." */

  function pt_createcategorysel($name,$selected_category) {

      global $ptconf;
	// Create the list of categories
	echo "<select name=\"" . $name . "\">\n";

	// If it's for a new form (as opposed to an edit form), create default choice
	if (substr($name,0,3) == "new") {
		echo "<option value=\"none\" selected>--choose one--</option>";
	}

	// Find all distinct category names and create option values for them.
	$result = pt_query("select distinct category from pt_core_wwwpages");
	if ( mysql_num_rows($result) > 0 ) {
		while ($c_row = mysql_fetch_object($result)) {
			echo "<option ";
			//If this category matches the one passed to the function
			//select it.
			if ($c_row->category == $selected_category ) {
				echo "selected ";
			}
			echo "value=\"" . $c_row->category . "\">" . $c_row->category . "</option>";
		}
	}

	/* If there isn't a system category (for homepage, header, sidebar, and
	and footer, create it. */
	$result = pt_query("select category from pt_core_wwwpages where category='system'");
	if (mysql_num_rows($result) == 0) {
		echo "<option value=\"system\">system</option>";
	}
	echo "</select>";

  }

  /* pt_system_names($name,$selected_name,$match="") will display a
  list of wwwpages names that are in the system category. */

  function pt_system_names ($name, $selected_name, $match="") {

  /* $name is the name of the select tag; $selected_name is the
  existing value of the field if this is for an edit form, and
  $match is the value of the ptconf default for this field (in other
  words, if this is a new form, the default value for header,
  footer, sidebar will be inserted). */

	echo "<select name=\"" . $name . "\"> \n";

	$result = pt_query("SELECT name FROM pt_core_wwwpages WHERE category='system' ORDER BY name ASC");
	if ( mysql_num_rows($result) > 0 ) {
		while ($g_row = mysql_fetch_object($result)) {
			echo "<option ";
			// First, is this a new or edit form?
			if (substr($name,0,3) == "new") {
				/* If it is a new form *and* this name matches the one
				chosen as the default header, sidebar or footer in the current
				profile, then select it as default. */
				if ($g_row->name == $match ) {
					echo "selected ";
				}
			// If it's not new, then it's edit, so select the existing value
			} else {
				if ($g_row->name == $selected_name ) {
					echo "selected ";
				}
			}
			echo "value=\"" . $g_row->name . "\">" . $g_row->name . "</option>";
		}
	}

	echo "<option value=\"none\"";
	/* If this page has the header, sidebar, etc set to none ,
	*or* if the selected name is not equal to none and the default
	name is set to none, then select this option. */
	if (($selected_name == "none") || ($selected_name != "none" and $match == "none") ) {
		echo " selected";
	}
	echo ">none</option>";
	echo "</select>";
  }

/* From http://www.linuxworld.com/site-stories/2001/0923.php.html
   Used to supply a 2 charater salt to the crypt() function
   this forces crypt() to use DES encryption.
*/
function pt_2_char_salt()
{
	srand((double)microtime()*1000000);
	$saltseeds =
	array(
	'0','1','2','3','4','5','6','7','8','9',
	'a','b','c','d','e','f','g','h','i','j','k','l','m','n','o','p','q','r','s','t','u','v','w','x','y','z',
	'A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T','U','V','W','X','Y','Z'
	);
	return $saltseeds[rand(0,63)] . $saltseeds[rand(0,63)];
}

/* pt_login_check($hash_var) will check to see if the current user is logged in or not, by comparing the 
user's hash variable with the hash derived from the system's $hash_var and the user's username. Returns
false if the user does not check out. */  

function pt_login_check($hash_var,$inactivity_timeout)
{
	// Thanks to Tim Perdue/PHPBuilder.com

	global $pt_username,$pt_username_hash, $pt_timestamp;
	
	//are all cookies present?
	if (isset($pt_username) && isset($pt_username_hash) && isset($pt_timestamp))
	{
		/*
			Create a hash of the user name and date time that was
			passed in from the cookie as well as the trusted hidden 
			variable

			If this hash matches the cookie hash, then all cookie 
			vars must be correct and thus trustable.

			When done, reset the timestamp and the hash.
		*/
		
		$current_timestamp = time();
		if(($current_timestamp - $pt_timestamp)/60 > $inactivity_timeout)
		{
			// Session has timed out
			return FALSE;
		}

		$pt_correct_hash=md5($pt_username.$pt_timestamp.$hash_var);
		if ($pt_correct_hash == $pt_username_hash)
		{
			// Set new cookies with a new time stamp so their hash will be
			// different
			pt_set_cookies($pt_username,$hash_var);
			return TRUE;
		}
		else
		{
			//hash didn't match - must be a hack attempt?
			return FALSE;
		}
	}
	else
	{
		return FALSE;
	}
}

/* pt_set_cookies($pt_username,$hash_var) will set the user's authentication cookies. This
function should be called after the user's username and password have been authenticated. */

function pt_set_cookies($pt_username,$hash_var)
{
	/*  Thanks to Tim Perdue/PHPBuilder.com
		call this once you have confirmed user name and password
		are correct in the database
	*/

	//create a hash of the two variables we know
	$new_timestamp = time();
	$pt_username_hash= md5($pt_username.$new_timestamp.$hash_var);

	//use session cookie (will be deleted when they close their browser)
	setcookie('pt_timestamp',$new_timestamp,0,'/','',0);
	setcookie('pt_username',$pt_username,0,'/','',0);
	setcookie('pt_username_hash',$pt_username_hash,0,'/','',0);

	return true;
}

/* add function ABOVE this line !! */

  $included["pt_functions.inc"] = 1;
}


?>
