<?php
/* 
    Pagetool
    Copyright 2001,2002 Pagetool Development Team
    pagetool-user@lists.sourceforge.net http://www.pagetool.org/
    $Id: setup_config.inc,v 1.2 2002/05/03 13:54:43 daveguerin Exp $

    myphpPagetool
    http://sourceforge.net/projects/myphppagetool
    (C) 2000 by Sebastian Bunka <Sebastian.Bunka@vu-wien.ac.at>

    This file is part of Pagetool. Pagetool is a modification
    of myphpPagetool.

    Pagetool is free software; you can redistribute it and/or 
    modify it under the terms of the GNU General Public License 
    as published by the Free Software Foundation; either version
    2 of the License, or (at your option) any later version.
*/

/* If they click step one to generate their files and there is no which_file
value, then draw the entry table for entering their configuration settings. 
which_file will be set if they have already entered their values and they
either hit the ftp button or they are using the manual installation method. */
	
pt_header();
echo "<br><br>" . $str_generate_files . "<br><br>";

// First, make educated guesses about file locations. 
$abs_dir = getcwd();
$abs_dir_len = strlen($abs_dir);

/* Get the absolute web directory length. We know they must be in the
/src/setup directory, so subtract 10.*/

$abs_web_dir_len = $abs_dir_len-10;
$abs_web_dir=substr($abs_dir,0,$abs_web_dir_len);

/* abs_web_dir will look something like this: "/home/www".
Next, isolate the web_dir itself by retrieving everything
in the abs_web_dir from the last "/" to the end.*/

$web_dir=strrchr($abs_web_dir,"/");

// Now remove the forward slash
// I don't know why I did this - it seems to be causing the extra slash in the unixconfig value
// $web_dir_noslash=substr($web_dir,1);

/* Now we have something like "/www". Next get the length
of this variable.*/

$web_dir_len=strlen($web_dir);

// Calculate the absolute home directory length
$home_dir_len=$abs_web_dir_len-$web_dir_len;

// And now get the home directory itself
$home_dir=substr($abs_dir,0,$home_dir_len);

/* Finally, get the relative web directory
First, check to see if this is fresh or upgrade. */

if ( $upgrade=="y" ) 
{
    $rel_wwwdir=substr($SCRIPT_NAME,0,-21);
} 
else 
{
    $rel_wwwdir=substr($SCRIPT_NAME,0,-27);
}

// Based on those ridiculously complicated calculations, set default values
if (!$dbhost) $dbhost="localhost";
if (!$dbname) $dbname="";
if (!$dbadmuser) $dbadmuser="";
if (!$wwwdir) $wwwdir=strtr($abs_web_dir,"\\","/") . "/"; // ststr added for Windows systems
if (!$ftppath) $ftppath= strtr($web_dir,"\\","/") . "/";
if (!$ftpserver) $ftpserver=getenv(HTTP_HOST);
if (!$unixconfig) $unixconfig=strtr($home_dir,"\\","/") . "/pt_config.inc";
if (!$ftpconfig) $ftpconfig="/pt_config.inc";
if (!$mysqldump && is_file("/usr/local/mysql/bin/mysqldump"))
{
    $mysqldump="/usr/local/mysql/bin/mysqldump";
}
elseif (!$mysqldump && is_file("c:/mysql/bin/mysqldump.exe")) // for Windows machines
{
     $mysqldump="c:/mysql/bin/mysqldump.exe";
}

// Add a hidden value for the relative web directory
echo "<input type=\"hidden\" name=\"rel_wwwdir\" value=\"$rel_wwwdir\">";

// Now draw the table
echo "<table width=\"700\" border=\"0\">
    <tr>
        <td><b>$str_database_settings</b></td>
        <td>&nbsp;</td>
    </tr>
    <tr>
        <td colspan=\"2\"><span class=\"info\"><i>$str_host_explain</i></span></td>
    </tr>
    <tr>
        <td>$str_name_of_host</td>
        <td><input type=\"text\" name=\"dbhost\" value=\"$dbhost\"></td>
    </tr>
    <tr>
        <td>$str_name_of_database</td>
        <td><input type=\"text\" name=\"dbname\" value=\"$dbname\"></td>
    </tr>
    <tr>
        <td><b><br><br>$str_user_settings</b></td>
        <td>&nbsp;</td>
    </tr>
    <tr>
        <td colspan=\"2\"><i><span class=\"info\">$str_mysql_user_pass_explain</span></i></td>
    </tr>
    <tr>
        <td>$str_database_username</td>
        <td><input type=\"text\" name=\"dbadmuser\" value=\"$dbadmuser\"></td>
    </tr>
    <tr>
        <td>$str_password</td>
        <td><input type=\"password\" name=\"dbadmpass\"></td>
    </tr>
    <tr>
        <td><b><br><br>$str_ftp_settings</b></td>
        <td>&nbsp;</td>
    </tr>
    <tr>
        <td colspan=\"2\"><i><span class=\"info\">$str_ftp_username_warning</span></i></td>
    </tr>
    <tr>
        <td>$str_ftp_username</td>
        <td><input type=\"text\" name=\"ftpuser\" value=\"$ftpuser\"></td>
    </tr>
    <tr>
        <td>$str_ftp_password</td>
        <td><input type=\"password\" name=\"ftppass\"></td>
    </tr>
    <tr>
        <td>$str_ftp_server_address</td>
        <td><input type=\"text\" name=\"ftpserver\" value=\"$ftpserver\"></td>
    </tr>
    <tr>
        <td><b><br><br>$str_paths</b></td>
        <td>&nbsp;</td>
    </tr>
    <tr>
        <td colspan=\"2\"><span class=\"info\"><i>$str_paths_explain</i></span></td>
    </tr>
    <tr>
        <td>$str_unix_path_web_dir<br></td>
        <td><input type=\"text\" size=\"50\" name=\"wwwdir\" value=\"$wwwdir\"></td>
    </tr>
    <tr>
        <td colspan=\"2\">&nbsp;</td>
    </tr>
    <tr>
        <td colspan=\"2\"><i><span class=\"info\">$str_ftp_path_explain</span></i></td>
    </tr>
    <tr>
        <td>$str_ftp_path</td>
        <td><input type=\"text\" size=\"50\" name=\"ftppath\" value=\"$ftppath\"></td>
    </tr>
    <tr>
        <td colspan=\"2\">&nbsp;</td>
    </tr>
    <tr>
        <td colspan=\"2\"><i><span class=\"info\">$str_pt_config_path_explain</span></i></td>
    </tr>
    <tr>
        <td>$str_unix_pt_config_path</td>
        <td><input type=\"text\" size=\"50\" name=\"unixconfig\" value=\"$unixconfig\"></td>
    </tr>
    <tr>
        <td>$str_ftp_pt_config_path</td>
        <td><input type=\"text\" size=\"50\" name=\"ftpconfig\" value=\"$ftpconfig\"></td>
    </tr>
    <tr>
        <td colspan=\"2\">&nbsp;</td>
    </tr>
    <tr>
        <td colspan=\"2\"><i><span class=\"info\">$str_mysqldump_explain</span></i></td>
    </tr>
    <tr>
        <td>$str_path_to_mysqldump</td>
        <td><input type=\"text\" size=\"50\" name=\"mysqldump\" value=\"$mysqldump\"></td>
    </tr>
    <tr>
        <td colspan=\"2\">&nbsp;</td>
    </tr>
    <tr>
        <td colspan=\"2\"><b><br>$str_next ...</b><br><br>
        $str_next_explain
        <input type=\"submit\" name=\"which_file\" value=\"pt_config.inc\">
        <input type=\"submit\" name=\"which_file\" value=\"index.php\">
        <input type=\"submit\" name=\"which_file\" value=\"test.php\">
        </td>
    </tr>
</table>";

?>
