<?php
/*
    Pagetool
    Copyright 2001,2002 Pagetool Development Team
    pagetool-user@lists.sourceforge.net http://www.pagetool.org/
    $Id: setup_upload.inc,v 1.2 2002/05/03 13:54:43 daveguerin Exp $

    myphpPagetool
    http://sourceforge.net/projects/myphppagetool
    (C) 2000 by Sebastian Bunka <Sebastian.Bunka@vu-wien.ac.at>

    This file is part of Pagetool. Pagetool is a modification
    of myphpPagetool.

    Pagetool is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version
    2 of the License, or (at your option) any later version.
*/

/* ftp function - determines whether to use built in ftp functions or
fopen, depending on how php was configured. */

function pt_upload_file($ftpuser,$ftppass,$ftpserver,$ftpconfig,$contents)
{
    // Set full path of the destination file name
    $fullname =  $ftpconfig;
    // Open the source file for writing
    if( $dfile = fopen("ftp://" . $ftpuser . ":" . $ftppass . "@" . $ftpserver . $fullname, "wb"))
    {
        fwrite( $dfile, $contents );
    }
    else
    {
        return 0;
    }
    // check the file now exists! It may not on a windows system that doesn't seem to work with fopen in ftp mode
    // hmmm... for some reason on my linux system, the is_file($dfile) is failing so I added an extra check
    if (is_file($dfile) || is_file($fullname))
    {
        fclose( $dfile );
        return 1;
	echo "yup, is a file";
    }
    echo "hitting the end of the function...";
    return 0;
}

/* If they are using the manual installation method and they hit
pt_config.inc or if they are using the ftp installation method...*/

if ($which_file == "pt_config.inc" || $which_file == "ftp")
{
    $filename = "sample/pt_config.inc.sample";
    $fd = fopen ($filename, "r");
    $contents = fread ($fd, filesize ($filename));
    fclose ($fd);

    $contents = ereg_replace("dbhost_value",$dbhost,$contents);
    $contents = ereg_replace("dbname_value",$dbname,$contents);
    $contents = ereg_replace("dbadmuser_value",$dbadmuser,$contents);
    $contents = ereg_replace("dbadmpass_value",$dbadmpass,$contents);
    $contents = ereg_replace("ftpserver_value",$ftpserver,$contents);
    $contents = ereg_replace("ftpuser_value",$ftpuser,$contents);
    $contents = ereg_replace("ftppass_value",$ftppass,$contents);
    $contents = ereg_replace("ftppath_value",$ftppath,$contents);
    $contents = ereg_replace("wwwdir_value",$wwwdir,$contents);
    $contents = ereg_replace("rel_webdir_value",$rel_wwwdir,$contents);
    $contents = ereg_replace("unixconfig_value",$unixconfig,$contents);
    $contents = ereg_replace("mysqldump_value",$mysqldump,$contents);

    if ($which_file<>"ftp")
    {
        echo "<html><head><title>$str_pt_config_source</title></head><body>";
        echo "<pre>\n&lt;?php\n";
        echo $contents;
        echo "?&gt;\n</pre></body></html>";
        exit;
    }
    else
    {
        pt_header();
        echo "<br><br>$str_if_no_errors_files<br><br> \n";

        $contents = "<?php\n" . $contents . "\n\n?" . ">";
        // split up the ending php tag so that my editor still colour codes correctly!

        if(pt_upload_file($ftpuser,$ftppass,$ftpserver,$ftpconfig,$contents))
        {
            echo "<span class=\"message\">$str_pt_config_uploaded</span><br>";
        }
        else
        {
            pt_ftp_error("pt_config.inc");
            pt_footer();
            exit;
        }
    }
}

if ($which_file == "index.php" || $which_file=="ftp") {

    $filename = "sample/index.php.sample";
    $fd = fopen ($filename, "r");
    $contents = fread ($fd, filesize ($filename));
    fclose ($fd);

    $contents = ereg_replace("pt_config.inc_value",$unixconfig,$contents);
    if ($which_file<>"ftp")
    {
        echo "<html><head><title>$str_index_source</title></head><body>";
        echo "<pre>&lt;?php\n";
        echo $contents;
        echo "\n?&gt;</pre></body></html>";
        exit;
    }
    else
    {
        $contents = "<?php \n" . $contents . "\n ?" . ">";

        if(pt_upload_file($ftpuser,$ftppass,$ftpserver,$ftppath . "index.php",$contents))
        {
            echo "<span class=\"message\">$str_index_uploaded</span><br>";
        }
        else
        {
            pt_ftp_error("index.php");
            pt_footer();
            exit;
        }
    }
}


if ($which_file == "test.php" || $which_file == "ftp") {

    $filename = "sample/test.php.sample";
    $fd = fopen ($filename, "r");
    $contents = fread ($fd, filesize ($filename));
    fclose ($fd);
    $contents = ereg_replace("pt_config.inc_value",$unixconfig,$contents);

    if ($which_file<>"ftp")
    {
        echo "<html><head><title>$str_test_source</title></head><body>";
        echo "<pre>&lt;?php\n";
        echo $contents;
        echo "\n?&gt; </pre></body></html>";
        exit;
    }
    else
    {
        $contents = "<?php \n" . $contents . "\n ?" . ">";

        if(pt_upload_file($ftpuser,$ftppass,$ftpserver,$ftppath . "test.php",$contents))
        {
            echo "<span class=\"message\">$str_test_uploaded</span><br>";
        }
        else
        {
            pt_ftp_error("test.php");
            pt_footer();
            exit;
        }
    }
}

// add the unixcongif locatin so that next step will execute properly
if ($unixconfig && is_file($unixconfig))
{
    echo "<input type=\"hidden\" name=\"unixconfig\" value=\"" . $unixconfig . "\">";
}

?>
