<?php
/*
    Pagetool
    http://www.mediajumpstart.org/index.php?name=pagetool
    Copyright 2001 Pagetool Development Team, info@pagetool.org
    $Id: style.php,v 1.3 2002/12/01 20:41:57 daveguerin Exp $

    myphpPagetool
    http://sourceforge.net/projects/myphppagetool
    (C) 2000 by Sebastian Bunka <Sebastian.Bunka@vu-wien.ac.at>

    This file is part of Pagetool. Pagetool is a modification
    of myphpPagetool.

    Pagetool is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version
    2 of the License, or (at your option) any later version.
*/

/*
    Please modify this file to fit your designs tastes. Don't be 
    intimidated by all the php code! You don't need to know any 
    php to change the style sheets.  

    Below is a description of the style declarations we have set 
    up by default. (We recommend that at a minimum you keep these 
    declarations. You can change their values and you can add new 
    declarations, but if delete these default ones, Pagetool 
    systems messages won't display consistantly.)

A:link      Style of any A (links) tags
A:visited   Style of any visited A (links) tags
BODY        Style of the BODY of the page
TD          Style of any TD on a page. Set as well as BODY because Netscape ignores the BODY style in a TD
.header1    The largest text on your site.
.header2    The second largest text on your site.
.header3    You get the picture...
.text1      Normal text.
.text2      Text with emphasis (we use a different color, but you could use italics, for example)
.text3      Small text.

    If you want to change the values of these declarations, scroll
    to the bottom of the page -- to where is says MODIFY STYLES HERE.


/* This $dev variable, if set to 1, allows the style sheet to be viewed in the browser directly.
   So style.php?dev=1 will display as text/html. style.php or style.php?dev=0 will dispaly as text/css.
   If style.phh?dev=1 is called as a stylesheet, the browser will NOT be able to interpret the styles.
   $dev MUST be set to 0 therefore, for this file to act as a stylesheet.
*/

if ($dev)
{
    $br="<br>\n";
}
else
{
    $br="\n";
    // Send out headers to tell the browser this is a stylesheet, and that it should be cached
    header("Content-Type: text/css");
    header("Cache-Control: must-revalidate, max-age=86400, s-max-age=86400");
    header("Last-modified: ".gmdate("D, d M Y H:i:s", time())." GMT");
    header("Expires: ".gmdate("D, d M Y H:i:s", time() + 86400)." GMT");
}
// this function returns the font size and units required
function pt_font_size($size)
{
    global $font_base,$font_unit,$br;
    if ("px" == $font_unit)
    {
        $fsize = round($font_base * $size, 0);
    }
    elseif ("em" == $font_unit)
    {
        $fsize = round($font_base * $size, 1);
    }
    else
    {
         $fsize = round($font_base * $size, 1);
    }
    return("font-size:" . $fsize . $font_unit . ";" . $br);
}

/* include and initiate the class.
   phpSniff is by Roger Raymond, see http://sourceforge.net/projects/phpsniff/
   If the location of the class files is not the same directory as the stylesheet
   then the include statment will need to include the path */

include("src/third_party/phpSniff.core.php");
include("src/third_party/phpSniff.class.php");
$client = new phpSniff($ua,0);
$client->init();

// echo a style sheet header remark

echo "/* This is a dynamic stylesheet produced by Pagetool for";
echo " browser " . $client->property('browser');
echo " version " . $client->property('version');
echo " running on " . $client->property('platform');
echo " with os " . $client->property('os');
echo " */" . $br;

// set variables for each style, if the variable is later set to 0 the style will not be echoed
$alink = 1;
$avisited = 1;
$body = 1;
$td = 1;
$header1 = 1;
$header2 = 1;
$header3 = 1;
$text1 = 1;
$text2 = 1;
$text3 = 1;
$font_unit = "em"; // the default font unit
$font_base = 1; // the default font size (in the default font unit!)

// Now set various variables depending on platform and browser and browser version

// em is displayed as px on ie3 so reset the base size, and use px as the unit

if ("ie"==$client->property('browser') AND ($client->property('version')-3)<1)
{
    $font_unit = "px";
    $font_base = "12";
}
// make the base font size a bit bigger for the mac
if ("mac" == $client->property('platform'))
{
    $font_base = $font_base * 6/5;
}

// add in other browser specific stuff here

/* 
*************************
*************************
 MAKE YOUR CHANGES BELOW
*************************
*************************

Below is where you can modify the style sheet to suit
you design tastes. If you are wondering, the $br's are 
simply line breaks, which makes the code eaiser to 
trouble shoot. They are optional.
*/

/* Change the font family. If you use a font with a space 
in it, be sure to add esacped quotes around it, for example:

\"Arial Black\"

...But who would want to use arial black? 
*/

$fontfamily = "font-family:Verdana,Geneva,Arial,Helvetica,sans-serif;" . $br; // the default font family string

/* Below you can change any of the color, background color, or size
values as you please. Size values are in decimals, with "1" set as the
default base size. Therefore, 1.5 would be very big and .5 would be 
very small. */ 

if ($alink)
{
    echo "A:link{" . $br;
    echo "color:#000066;" . $br;
    echo "background-color:#FFFFFF;" . $br;
    echo "}" . $br;
}
if ($avisited)
{
    echo "A:visited{" . $br;
    echo "color:#660000;" . $br;
    echo "background-color:#FFFFFF;" . $br;
    echo "}" . $br;
}
if ($body)
{
    echo "BODY{" . $br;
    echo "background:#FFFFFF;" . $br;
    echo $fontfamily;
    echo "}" . $br;
}
if ($td)
{
    echo "TD{" . $br;
    echo "background:#FFFFFF;" . $br;
    echo $fontfamily;
    echo "}" . $br;
}
if ($header1)
{
    echo ".header1{" . $br;
    echo "color:#000033;" . $br;
    echo "background-color:#FFFFFF;" . $br;
    echo pt_font_size(1.3);
    echo "font-weight:bold;" . $br;
    echo "}" . $br;
}
if ($header2)
{
    echo ".header2{" . $br;
    echo pt_font_size(1);
    echo "}" . $br;
}
if ($header3)
{
    echo ".header3{" . $br;
    echo pt_font_size(0.8);
    echo "}" . $br;
}
if ($text1)
{
    echo ".text1{" . $br;
    echo pt_font_size(0.8);
    echo "}" . $br;
}
if ($text2)
{
    echo ".text2{" . $br;
    echo "color:#000033;" . $br;
    echo "background-color:#FFFFFF;" . $br;
    echo pt_font_size(0.8);
    echo "font-weight:bold;" . $br;
    echo "}" . $br;
}
if ($text3)
{
    echo ".text3{" . $br;
    echo pt_font_size(0.6);
    echo "}" . $br;
}
?>