<?php
/**
 * $Id: controller.php 60 2014-07-09 11:54:26Z Szablac $
 * @Project		Saxum Picker Extension/Component
 * @author 		Laszlo Szabo
 * @package		Saxum Picker
 * @copyright	Copyright (C) 2010 Saxum 2003 Bt. All rights reserved.
 * @license 	http://www.gnu.org/licenses/old-licenses/gpl-3.0.html GNU/GPL version 3
*/
defined('_JEXEC') or die('Restricted access');

jimport('joomla.application.component.controller');

class SaxumpickerController extends JControllerLegacy
{
	function display($cachable = false, $urlparams = false) 
	{
		// set default view if not set
		JRequest::setVar('view', JRequest::getCmd('view', 'Saxumpicker'));
		// call parent behavior
		parent::display($cachable);
	}
	
	public static function quickIconButton( $link, $image, $text ) {
		
		$lang	= JFactory::getLanguage();
		$button = '';
		/*if ($lang->isRTL()) {
			$button .= '<div style="float:right;">';
		} else {
			$button .= '<div style="float:left;">';
		}*/
		$button .=	'<div class="thumbnails sax-icon">'
				   .'<a class="thumbnail sax-icon-inside" href="'.$link.'">'
				   .JHtml::_('image',  'administrator/components/com_saxumpicker/images/'.$image, $text )
				   .'<br /><span>'.$text.'</span></a>'
				   .'</div>';
		//$button .= '</div>';

		return $button;
	}
		
	public static function addSubmenu($submenu) 
	{
		//$canDo = SaxumpickerController::getActions();
		JHtmlSidebar::addEntry(JText::_('COM_SAXUMPICKER_CONTROLPANEL'), 'index.php?option=com_saxumpicker', $submenu == 'controlpanel');
		JHtmlSidebar::addEntry(JText::_('COM_SAXUMPICKER_SETS'), 'index.php?option=com_saxumpicker&view=sets', $submenu == 'sets');
		JHtmlSidebar::addEntry(JText::_('COM_SAXUMPICKER_ITEMS'), 'index.php?option=com_saxumpicker&view=items', $submenu == 'items');
		JHtmlSidebar::addEntry(JText::_('COM_SAXUMPICKER_TYPES'), 'index.php?option=com_saxumpicker&view=types', $submenu == 'types');
		JHtmlSidebar::addEntry(JText::_('COM_SAXUMPICKER_EVALUATIONS'), 'index.php?option=com_saxumpicker&view=evaluations', $submenu == 'evaluations');
		JHtmlSidebar::addEntry(JText::_('COM_SAXUMPICKER_SPREADS'), 'index.php?option=com_saxumpicker&view=spreads', $submenu == 'spreads');
		JHtmlSidebar::addEntry(JText::_('COM_SAXUMPICKER_ABOUT'), 'index.php?option=com_saxumpicker&view=about', $submenu == 'about');
	}
      			  
	function sendmail()
	{
	    JRequest::checkToken() or jexit( 'Invalid Token' );
		$app	= JFactory::getApplication();	
		$user	= JFactory::getUser();
		$mailer = JFactory::getMailer();
		$rawDataPost = JRequest::get('POST', 2);
		$rawDataGet = JRequest::get('GET', 2);
		$post = array_merge($rawDataGet, $rawDataPost);
		
		$config = JFactory::getConfig();
	    $sender_name =  $config->get( 'fromname' );
	    $sender = array(
		    $config->get( 'mailfrom' ),
		    $sender_name );
		 
		$mailer->setSender($sender);
		
	    $recipient = $post['email'];
	    $mailer->addRecipient($recipient);
	    
	    $body = JRequest::getVar( 'body', '', 'post', 'string', JREQUEST_ALLOWRAW);
	 	$body = base64_decode($body);
	
	 	jimport( 'joomla.mail.helper' );

	    $subject = $sender_name;
	
	    $subject = JMailHelper::cleanSubject($subject);
	    $body = JMailHelper::cleanBody($body);
	
		$mailer->isHTML(true);
		$mailer->Encoding = 'base64';
	    $mailer->setSubject($subject);
		$mailer->setBody($body);
		
		$send = $mailer->Send();
		if ( $send !== true ) {
	        JError::raiseNotice( 500, JText::_('COM_SAXUMPICKER_EMAIL_FAILED') );
	    }
	    else {
	    	JError::raiseNotice( 500, JText::_('COM_SAXUMPICKER_EMAIL_SENT') );
	    }
		
	    $this->display();
	}	
	
}
?>
