<?php
/**
 * $Id: evaluation.php 117 2015-06-17 07:40:53Z Szablac $
 * @Project		Saxum Picker Extension/Component
 * @author 		Laszlo Szabo
 * @package		Saxum Picker
 * @copyright	Copyright (C) 2010 Saxum 2003 Bt. All rights reserved.
 * @license 	http://www.gnu.org/licenses/old-licenses/gpl-3.0.html GNU/GPL version 3
*/

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die();
 
// import Joomla controllerform library
jimport('joomla.application.component.controllerform');
 
class SaxumpickerControllerEvaluation extends JControllerForm
{	
	function next(){
		$post		= JRequest::get('post');
		$id			= $post['jform']['id'];
		$type_id	= $post['jform']['typeid'];
		$app		= JFactory::getApplication();
		$lang		= JFactory::getLanguage();
		$model		= $this->getModel();
		$table		= $model->getTable();
		if (empty($key)) {
			$key = $table->getKeyName();
		}
		if ($id!=0){
			$data = $model->getItem($id);
			$data = get_object_vars($data);
			$orig_type=$model->getType($data['typeid']);
			$new_type=$model->getType($type_id);
			$data['typeid'] = $type_id;
			if (!($orig_type[0]->setid==$new_type[0]->setid) ||
				!($orig_type[0]->evaluation==1 && $new_type[0]->evaluation==1) ||
				($orig_type[0]->evaluation==0 && $new_type[0]->evaluation==0 && $orig_type[0]->pieces!=$new_type[0]->pieces)){
					$data['itemid'] = '';
					$data['spread'] = '';
			}
			$model->save($data);
			//$model->setTypeId($id,$type_id);
			$this->setMessage(JText::_(($lang->hasKey($this->text_prefix.($id==0 && $app->isSite() ? '_SUBMIT' : '').'_SAVE_SUCCESS') ? $this->text_prefix : 'JLIB_APPLICATION') . ($id==0 && $app->isSite() ? '_SUBMIT' : '') . '_SAVE_SUCCESS'));
			$this->setRedirect(JRoute::_('index.php?option='.$this->option.'&view='.$this->view_item.$this->getRedirectToItemAppend($id, $key), false));
		} else {
			parent::display();
		}
	}	
	
	function cancelcopy(){
		$post		= JRequest::get('post');
		$id			= $post['jform']['id'];
		$model		= $this->getModel();
		if ($id!=0){
			$model->cancelcopy($id);
		}
		parent::cancel();
	
	}
	
	function save($key = NULL, $urlVar = NULL){
		//$post	= JRequest::get('post');
		//$eval_id	= $post['jform']['id'];
				
		if (JRequest::getCmd( 'task' )=='save2copy'){
			// Check for request forgeries.
			JRequest::checkToken() or jexit(JText::_('JINVALID_TOKEN'));
	
			// Initialise variables.
			$app		= JFactory::getApplication();
			$lang		= JFactory::getLanguage();
			$model		= $this->getModel();
			$table		= $model->getTable();
			$data		= JRequest::getVar('jform', array(), 'post', 'array');
			$checkin	= property_exists($table, 'checked_out');
			$context	= "$this->option.edit.$this->context";
			$task		= $this->getTask();
	
			// Determine the name of the primary key for the data.
			if (empty($key)) {
				$key = $table->getKeyName();
			}
	
			// The urlVar may be different from the primary key to avoid data collisions.
			if (empty($urlVar)) {
				$urlVar = $key;
			}
	
			$recordId	= JRequest::getInt($urlVar);
	
			$session	= JFactory::getSession();
			$registry	= $session->get('registry');
	
			if (!$this->checkEditId($context, $recordId)) {
				// Somehow the person just went to the form and saved it - we don't allow that.
				$this->setError(JText::sprintf('JLIB_APPLICATION_ERROR_UNHELD_ID', $recordId));
				$this->setMessage($this->getError(), 'error');
				$this->setRedirect(JRoute::_('index.php?option='.$this->option.'&view='.$this->view_list.$this->getRedirectToListAppend(), false));
	
				return false;
			}
	
			// Check-in the original row.
			if ($checkin  && $model->checkin($data[$key]) === false) {
				// Check-in failed, go back to the item and display a notice.
				$this->setError(JText::sprintf('JLIB_APPLICATION_ERROR_CHECKIN_FAILED', $model->getError()));
				$this->setMessage($this->getError(), 'error');
				$this->setRedirect('index.php?option='.$this->option.'&view='.$this->view_item.$this->getRedirectToItemAppend($recordId, $urlVar));

				return false;
			}

			// Reset the ID and then treat the request as for Apply.
			$data[$key]	= 0;
			
			// Access check.
			if (!$this->allowSave($data)) {
				$this->setError(JText::_('JLIB_APPLICATION_ERROR_SAVE_NOT_PERMITTED'));
				$this->setMessage($this->getError(), 'error');
				$this->setRedirect(JRoute::_('index.php?option='.$this->option.'&view='.$this->view_list.$this->getRedirectToListAppend(), false));
	
				return false;
			}
	
			// Validate the posted data.
			// Sometimes the form needs some posted data, such as for plugins and modules.
			$form = $model->getForm($data, false);
	
			if (!$form) {
				$app->enqueueMessage($model->getError(), 'error');
	
				return false;
			}
	
			// Test if the data is valid.
			$validData = $model->validate($form, $data);
	
			// Check for validation errors.
			if ($validData === false) {
				// Get the validation messages.
				$errors	= $model->getErrors();
	
				// Push up to three validation messages out to the user.
				for ($i = 0, $n = count($errors); $i < $n && $i < 3; $i++)
				{
					if (JError::isError($errors[$i])) {
						$app->enqueueMessage($errors[$i]->getMessage(), 'warning');
					}
					else {
						$app->enqueueMessage($errors[$i], 'warning');
					}
				}
	
				// Save the data in the session.
				$app->setUserState($context.'.data', $data);
	
				// Redirect back to the edit screen.
				$this->setRedirect(JRoute::_('index.php?option='.$this->option.'&view='.$this->view_item.$this->getRedirectToItemAppend($recordId, $key), false));
	
				return false;
			}
	
			// Attempt to save the data.
			if (!$model->save($validData)) {
				// Save the data in the session.
				$app->setUserState($context.'.data', $validData);
	
				// Redirect back to the edit screen.
				$this->setError(JText::sprintf('JLIB_APPLICATION_ERROR_SAVE_FAILED', $model->getError()));
				$this->setMessage($this->getError(), 'error');
				$this->setRedirect(JRoute::_('index.php?option='.$this->option.'&view='.$this->view_item.$this->getRedirectToItemAppend($recordId, $key), false));
	
				return false;
			}
	
			// Save succeeded, check-in the record.
			if ($checkin && $model->checkin($validData[$key]) === false) {
				// Save the data in the session.
				$app->setUserState($context.'.data', $validData);
	
				// Check-in failed, go back to the record and display a notice.
				$this->setError(JText::sprintf('JLIB_APPLICATION_ERROR_CHECKIN_FAILED', $model->getError()));
				$this->setMessage($this->getError(), 'error');
				$this->setRedirect('index.php?option='.$this->option.'&view='.$this->view_item.$this->getRedirectToItemAppend($recordId, $key));
	
				return false;
			}
	
			//$this->setMessage(JText::_(($lang->hasKey($this->text_prefix.($recordId==0 && $app->isSite() ? '_SUBMIT' : '').'_SAVE_SUCCESS') ? $this->text_prefix : 'JLIB_APPLICATION') . ($recordId==0 && $app->isSite() ? '_SUBMIT' : '') . '_SAVE_SUCCESS'));
			$this->setMessage(JText::_('COM_SAXUMPICKER_CHOOSE_TYPE'));
			// Set the record data in the session.
			$recordId = $model->getState($this->context.'.id');
			$this->holdEditId($context, $recordId);
			$app->setUserState($context.'.data', null);
                                $model->checkout($recordId);

			// Redirect back to the edit screen.
			$this->setRedirect(JRoute::_('index.php?option='.$this->option.'&view='.$this->view_item.$this->getRedirectToItemAppend($recordId, $key).'&copy=1', false));
	
			// Invoke the postSave method to allow for the child class to access the model.
			$this->postSaveHook($model, $validData);
	
			return true;
		
		} else {
			parent::save();
		}
	}
}