<?php
/**
 * $Id: evaluation.php 117 2015-06-17 07:40:53Z Szablac $
 * @Project		Saxum Picker Extension/Component
 * @author 		Laszlo Szabo
 * @package		Saxum Picker
 * @copyright	Copyright (C) 2010 Saxum 2003 Bt. All rights reserved.
 * @license 	http://www.gnu.org/licenses/old-licenses/gpl-3.0.html GNU/GPL version 3
*/

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die();

jimport('joomla.application.component.modeladmin');

class SaxumpickerModelEvaluation extends JModelAdmin
{
	public function getTable($type = 'Evaluation', $prefix = 'SaxumpickerTable', $config = array()) 
	{
		return JTable::getInstance($type, $prefix, $config);
	}

	public function getForm($data = array(), $loadData = true) 
	{		
		$data = $this->getItem();	
		$isNew = ($data->id == 0);
		
		$copy = JRequest::getCmd( 'copy' );
		$jinput = JFactory::getApplication()->input;
		$jform = $jinput->post->get('jform', '0', null);
		if ($data->typeid==0 && !empty($jform)) $data->typeid=$jform['typeid'];
		
		if ($isNew && $data->typeid==0 || $copy==1) return self::getFormSelectType();

		$db		= JFactory::getDbo();
		$query	= $db->getQuery(true);
		
		$query->select('t.*');
		$query->from('#__saxumpicker_type AS t');
		$query->where('t.id = '.(int) $data->typeid);

		$db->setQuery($query);
		$type = $db->loadObjectList();
		
		// Get the form.
		$form = $this->loadForm('com_saxumpicker.evaluation', 'evaluation'.$type[0]->evaluation.$type[0]->order_counts,
		                        array('control' => 'jform', 'load_data' => $loadData));
		if (empty($form)) 
		{
			return false;
		}
		return $form;
	}  
	
	public function getFormSelectType($data = array(), $loadData = true) 
	{
		// Get the form.
		$form = $this->loadForm('com_saxumpicker.evaluation', 'selecttype',
		                        array('control' => 'jform', 'load_data' => $loadData));
		if (empty($form)) 
		{
			return false;
		}
		return $form;
	}  
	
	public function getScript() 
	{
		return 'administrator/components/com_saxumpicker/models/forms/spreadhelper.js';
	}

	protected function loadFormData()
	{
		// Check the session for previously entered form data.
		$data = JFactory::getApplication()->getUserState('com_saxumpicker.edit.evaluation.data', array());

		if (empty($data)) 
		{
			$post=JRequest::get( 'post' );
			$data = $this->getItem();	
			$isNew = ($data->id == 0);
			if ($isNew) $data->typeid= empty($post) ? 0 : $post['jform']['typeid'];
		}
		return $data;
	}

	public static function getType($id)
	{
		// Create a new query object.
		$db		= JFactory::getDbo();
		$query	= $db->getQuery(true);

		$query->select('t.*');
		$query->from('#__saxumpicker_type AS t');
		$query->where('t.id = '.(int) $id);

		$db->setQuery($query);
		$result = $db->loadObjectList();

		return $result;
	}

	public function setTypeId($id,$type_id)
	{
		// Create a new query object.
		$db		= JFactory::getDbo();
		$query	= $db->getQuery(true);

		$query->update('#__saxumpicker_evaluation');
		$query->set('typeid = '.(int) $type_id);
		$query->where('id = '.(int) $id);

		$db->setQuery($query);
		$result = $db->loadResult();

		return $result;
	}

	public function cancelcopy($id)
	{
		// Create a new query object.
		$db		= JFactory::getDbo();
		$query	= $db->getQuery(true);

		$query->delete();
		$query->from('#__saxumpicker_evaluation');
		$query->where('id = '.(int) $id);

		$db->setQuery($query);
		$result = $db->loadResult();

		return $result;
	}
}
?>
