<?php
/**
 * $Id: evaluations.php 7 2013-09-04 05:47:07Z Szablac $
 * @Project		Saxum Picker Extension/Component
 * @author 		Laszlo Szabo
 * @package		Saxum Picker
 * @copyright	Copyright (C) 2010 Saxum 2003 Bt. All rights reserved.
 * @license 	http://www.gnu.org/licenses/old-licenses/gpl-3.0.html GNU/GPL version 3
*/
// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die();

jimport('joomla.application.component.modellist');

class SaxumpickerModelEvaluations extends JModelList
{
	public function __construct($config = array())
	{
		if (empty($config['filter_fields'])) {
			$config['filter_fields'] = array(
				'id', 'a.id',
				'typeid', 'a.typeid' ,
				'typename', 't.name',
				'title', 'a.title' ,
				'picked', 'concat(ifnull(a.spread,\'\'),if(a.itemid=0,\'\',a.itemid))' ,
				'published', 'a.published'
			);
		}

		parent::__construct($config);
	}
	
	protected function getListQuery()
	{
		// Create a new query object.		
		$db = JFactory::getDBO();
		$query = $db->getQuery(true);
		// Select some fields
		$query->select(
			$this->getState(
				'list.select',
				'a.*,concat(ifnull(a.spread,\'\'),if(a.itemid=0,\'\',a.itemid)) as picked'
			)
		);
		$query->from('#__saxumpicker_evaluation a');
		
		$query->select('t.name AS typename');
		$query->join('INNER', '`#__saxumpicker_type` AS t ON a.typeid=t.id');
			
		// Filter by search in title.
		$search = $this->getState('filter.search');
		if (!empty($search))
		{
			if (stripos($search, 'id:') === 0)
			{
				$query->where('a.id = ' . (int) substr($search, 3));
			}
			elseif (stripos($search, 'type:') === 0)
			{
				$search = $db->quote('%' . $db->escape(substr($search, 5), true) . '%');
				$query->where('(t.name LIKE ' . $search . ')');
			}
			elseif (stripos($search, 'spread:') === 0)
			{
				$search = $db->quote('%' . $db->escape(substr($search, 7), true) . '%');
				$query->where('(concat(ifnull(a.spread,\'\'),if(a.itemid=0,\'\',a.itemid)) LIKE ' . $search . ')');
			}
			elseif (stripos($search, 'title:') === 0)
			{
				$search = $db->quote('%' . $db->escape(substr($search, 6), true) . '%');
				$query->where('(a.title LIKE ' . $search . ')');
			}
			else
			{
				$search = $db->quote('%' . $db->escape($search, true) . '%');
				$query->where('(a.title LIKE ' . $search . ')');
			}
		}
		
	// Filter by type
		$typeId = $this->getState('filter.typeid');
		if (is_numeric($typeId)) {
			$query->where('a.typeid = '.(int) $typeId);
		}
			
		// Filter by published state
		$published = $this->getState('filter.published');
		if (is_numeric($published)) {
			$query->where('a.published = '.(int) $published);
		} else if ($published === '') {
			$query->where('(a.published IN (0, 1))');
		}
		
		$orderCol	= $this->state->get('list.ordering');
		$orderDirn	= $this->state->get('list.direction');
		$query->order($db->escape($orderCol.' '.$orderDirn));
		
		return $query;
	}
	
	protected function populateState($ordering = null, $direction = null)
	{
		// Initialise variables.
		$app = JFactory::getApplication('administrator');

		$search = $this->getUserStateFromRequest($this->context . '.filter.search', 'filter_search');
		$this->setState('filter.search', $search);
		
		// Load the filter state.
		$typeId = $this->getUserStateFromRequest($this->context.'.filter.typeid', 'filter_typeid', '');
		$this->setState('filter.typeid', $typeId);
		
		$state = $this->getUserStateFromRequest($this->context.'.filter.published', 'filter_published', '', 'string');
		$this->setState('filter.published', $state);

		// List state information.
		parent::populateState('a.title', 'asc');
	}

	public function getTypes()
	{
		// Create a new query object.
		$db		= $this->getDbo();
		$query	= $db->getQuery(true);

		$query->select('t.id, t.name AS typename');
		$query->from('#__saxumpicker_type AS t');
		$query->order('t.name ASC');

		$db->setQuery($query);
		$result = $db->loadObjectList();

		return $result;
	}
}
  	
