<?php
/**
 * $Id: pickerlayout.php 7 2013-09-04 05:47:07Z Szablac $
 * @Project		Saxum Picker Extension/Component
 * @author 		Laszlo Szabo
 * @package		Saxum Picker
 * @copyright	Copyright (C) 2010 Saxum 2003 Bt. All rights reserved.
 * @license 	http://www.gnu.org/licenses/old-licenses/gpl-3.0.html GNU/GPL version 3
*/
defined('_JEXEC') or die('Restricted access');
jimport('joomla.form.formfield');

class JFormFieldPickerLayout extends JFormField
{
	protected $type = 'pickerlayout';

	public function getInput()
	{		
		// Initialize some field attributes.
		$attr = $this->element['class'] ? ' class="'.(string) $this->element['class'].'"' : '';
		$attr .= $this->element['size'] ? ' size="'.(string) $this->element['size'].'"' : '';
		
		$rows[]=JHTML::_('select.option', 'Default', JText::_('COM_SAXUMPICKER_DEFAULT'));
		
		// Get list of plugins
		$db     = JFactory::getDbo();
		$query  = $db->getQuery(true)
			->select('extension_id as id, element AS value, name AS text')
			->from('#__extensions')
			->where('folder = \'saxumpicker\'' )
			->where('enabled = 1')
			->order('ordering, name');
		$db->setQuery($query);

		$options = $db->loadObjectList();
		
		/*foreach ($options as $r){
			$rows[]=JHTML::_('select.option', $r['id'], $r['text']);
		}*/
		$rows=array_merge($rows,$options);

		return JHTML::_('select.genericlist',$rows, $this->name, $attr, 'value', 'text', $this->value);
	}
}