<?php
/**
 * $Id: pickerorderedspread.php 7 2013-09-04 05:47:07Z Szablac $
 * @Project		Saxum Picker Extension/Component
 * @author 		Laszlo Szabo
 * @package		Saxum Picker
 * @copyright	Copyright (C) 2010 Saxum 2003 Bt. All rights reserved.
 * @license 	http://www.gnu.org/licenses/old-licenses/gpl-3.0.html GNU/GPL version 3
*/
defined('JPATH_BASE') or die;
jimport('joomla.form.formfield');

class JFormFieldPickerOrderedSpread extends JFormField
{
	public $type = 'PickerOrderedSpread';

	protected function getInput()
	{		
		// Initialize some field attributes.
		$attr = $this->element['class'] ? ' class="'.(string) $this->element['class'].'"' : '';
		
		// Build the script.
		$script = array();
		$script[] = 'function itemSelected(id)';
		$script[] = '	{';
		$script[] = '		var s=\'spread\'+id;';
		$script[] = '		var i=\'item\'+id;';
		$script[] = '		var js = document.getElementById(s);';
		$script[] = '		var selObj = document.getElementById(i);';
		$script[] = '		js.setAttribute(\'value\',selObj.value);';
		$script[] = '	}';
		$script[] = 'function loopSpread(count)';
		$script[] = '	{';
  		$script[] = '		var spread = document.getElementById(\'jform_spread\');';
  		$script[] = '		spread.value = \'\';';
  		$script[] = '		for (k=1; k<=count; k++) {';
		$script[] = '			s=\'spread\'+k;';
		$script[] = '			helper = document.getElementById(s);';
		$script[] = '			h=helper.value;';
		$script[] = '			if(h==null || h=="") h=1;';
		$script[] = '			spread.value = spread.value+h+\',\';';
  		$script[] = '		}';
    	//$script[] = '		alert(spread.value);';
		$script[] = '	};';

		// Add the script to the document head.
		JFactory::getDocument()->addScriptDeclaration(implode("\n", $script));
		
		$db		= JFactory::getDbo();
		$query	= $db->getQuery(true);
			
		$query->select('t.*');
		$query->from('#__saxumpicker_type AS t');
		$query->where('t.id = '.(int) $this->form->getValue('typeid'));
		$db->setQuery($query);
		$type = $db->loadObjectList();
		
		$query	= $db->getQuery(true);
		// Query items for list.
		$query->select('i.id as value, concat(i.number,\' - \' ,i.name) as text');
		$query->from('#__saxumpicker_item AS i');
		$query->where('i.setid = '.(int) $type[0]->setid);
		$query->order('concat(i.number,\' - \' ,i.name)');

		$db->setQuery($query);
		$rows = $db->loadObjectList();
		
		$html = array();
		
		$html[] = '<div class="fltlft">';
		$spread=explode(",",$this->form->getValue('spread'));
	    if ($this->form->getValue('spread')==''){
	   		for ($i=1;$i<=$type[0]->pieces;$i++){
	    	   	$spread[$i-1]=1;
	    	}
	    } 
		$html[] = '<table>';
		for ($i=1;$i<=$type[0]->pieces;$i++){
			$itemlist=null;
	    	foreach( $rows as $obj )
			{
				$itemlist[] = JHTML::_('select.option',  $obj->value, $obj->text  );
			}
			$html[] = '<tr><td>'.$i.'</td><td>';
			$html[] = JHTML::_('select.genericlist',$itemlist,'item'.$i, $attr.' size="1" onChange="itemSelected('.$i.');loopSpread('.$type[0]->pieces.');"', 'value', 'text', $spread[$i-1] );
			$html[] = '</td>';
			$html[] = '<td><input type="hidden" name="spread'.$i.'" id="spread'.$i.'" value="'.$spread[$i-1].'"></td>';
			$html[] = '</tr>';
		}
		$html[] =  		'</table>';
		$html[] = '</div>';
		
		return implode("\n", $html);
	}
}