<?php
/**
 * $Id: pickerspread.php 7 2013-09-04 05:47:07Z Szablac $
 * @Project		Saxum Picker Extension/Component
 * @author 		Laszlo Szabo
 * @package		Saxum Picker
 * @copyright	Copyright (C) 2010 Saxum 2003 Bt. All rights reserved.
 * @license 	http://www.gnu.org/licenses/old-licenses/gpl-3.0.html GNU/GPL version 3
*/
defined('JPATH_BASE') or die;
jimport('joomla.form.formfield');

class JFormFieldPickerSpread extends JFormField
{
	public $type = 'PickerSpread';

	protected function getInput()
	{		
		// Initialize some field attributes.
		$attr = $this->element['class'] ? ' class="'.(string) $this->element['class'].'"' : '';
		$attr .= $this->element['size'] ? ' size="'.(int) $this->element['size'].'"' : '';
		$attr .= $this->element['multiple'] ? ' multiple="'.(string) $this->element['multiple'].'"' : '';
		$attr .= ' onclick="loopSelected();" onchange="loopSelected();"';
		
		// Build the script.
		$script = array();
		$script[] = '	function loopSelected() {';
  		$script[] = '		var spread = document.getElementById(\'jform_spread\');';
  		$script[] = '		var selectedArray = new Array();';
    	$script[] = '		var selObj = document.getElementById(\'jformspreadhelper\');';
    	$script[] = '		var i;';
    	$script[] = '		var count = 0;';
    	$script[] = '		for (i=0; i<selObj.options.length; i++) {';
  		$script[] = '		    if (selObj.options[i].selected) {';
  		$script[] = '		      selectedArray[count] = selObj.options[i].value;';
  		$script[] = '		      count++;';
  		$script[] = '		    }';
  		$script[] = '		  }';
    	$script[] = '		spread.value = selectedArray;';
    	//$script[] = '		alert(spread.value);';
		$script[] = '	};';

		// Add the script to the document head.
		JFactory::getDocument()->addScriptDeclaration(implode("\n", $script));
		
		$db		= JFactory::getDbo();
		$query	= $db->getQuery(true);
			
		$query->select('t.*');
		$query->from('#__saxumpicker_type AS t');
		$query->where('t.id = '.(int) $this->form->getValue('typeid'));
		$db->setQuery($query);
		$type = $db->loadObjectList();
		
		$query	= $db->getQuery(true);
		// Query items for list.
		$query->select('i.id as value, concat(i.number,\' - \' ,i.name) as text');
		$query->from('#__saxumpicker_item AS i');
		$query->where('i.setid = '.(int) $type[0]->setid);
		$query->order('concat(i.number,\' - \' ,i.name)');

		$db->setQuery($query);
		$rows = $db->loadObjectList();
		
		$spread=explode(",",$this->form->getValue('spread'));
	    if ($this->form->getValue('spread')==''){
	   		for ($i=1;$i<=$type[0]->pieces;$i++){
	    	   	$spread[$i-1]=1;
	    	}
	    } 
	    
		if($rows){
			return JHTML::_('select.genericlist',$rows, $this->name, $attr, 'value', 'text', $spread);
		}
	}
}