<?php
/**
 * $Id: saxumpayment.php 16 2013-12-09 23:13:51Z Szablac $
 * @Project		Saxum Picker Extension/Component
 * @author 		Laszlo Szabo
 * @package		Saxum Picker
 * @copyright	Copyright (C) 2010 Saxum 2003 Bt. All rights reserved.
 * @license 	http://www.gnu.org/licenses/old-licenses/gpl-3.0.html GNU/GPL version 3
*/
defined('_JEXEC') or die('Restricted access');
jimport('joomla.form.formfield');

class JFormFieldSaxumpayment extends JFormField
{
	protected $type = 'saxumpayment';

	public function getInput()
	{		
		// Initialize some field attributes.
		$attr = $this->element['class'] ? ' class="'.(string) $this->element['class'].'"' : '';
		$attr .= $this->element['size'] ? ' size="'.(string) $this->element['size'].'"' : '';
		
		$script[] = '(function($){';
		$script[] = '	$(document).ready(function() {';
		$script[] = '		var tab = $(\'<li id="pmtab" class=""><a href="#payment_options" data-toggle="tab">'.JText::_('COM_SAXUMPICKER_PAYMENT_OPTIONS').'</a></li>\');';
		$script[] = '		window.addEventListener("load", function(){ ';
    	$script[] = '			$( \'#myTabTabs li:last\' ).remove();';
		$script[] = '			if ($(\'select#jformpmtype\').val()!=\'free\') $(\'#myTabTabs\').append(tab);';
		$script[] = '		});';
		$script[] = '		$(\'select#jformpmtype\').on(\'change\',function() {';
		$script[] = '			if( this.value==\'free\' ){';
		$script[] = '				$(\'#pmtab\').remove();';
    	$script[] = '			} else {';
		//$script[] = '				alert(tab);';
		$script[] = '				$(\'#myTabTabs\').append(tab);';
    	$script[] = '			}';
		$script[] = '		});';
		$script[] = '	});';
		$script[] = '})(jQuery);';
		
		// Add the script to the document head.
		JFactory::getDocument()->addScriptDeclaration(implode("\n", $script));
		
		$rows[]=JHTML::_('select.option', 'free', JText::_('COM_SAXUMPICKER_FREE'));
		
		// Get list of plugins
		$db     = JFactory::getDbo();
		$query  = $db->getQuery(true)
			->select('extension_id as id, element AS value, name AS text')
			->from('#__extensions')
			->where('folder = \'saxumpayment\'' )
			->where('enabled = 1')
			->order('ordering, name');
		$db->setQuery($query);

		$options = $db->loadObjectList();
		
		/*foreach ($options as $r){
			$rows[]=JHTML::_('select.option', $r['id'], $r['text']);
		}*/
		$rows=array_merge($rows,$options);

		return JHTML::_('select.genericlist',$rows, $this->name, $attr, 'value', 'text', $this->value);
	}
}