<?php
/**
 * $Id: items.php 7 2013-09-04 05:47:07Z Szablac $
 * @Project		Saxum Picker Extension/Component
 * @author 		Laszlo Szabo
 * @package		Saxum Picker
 * @copyright	Copyright (C) 2010 Saxum 2003 Bt. All rights reserved.
 * @license 	http://www.gnu.org/licenses/old-licenses/gpl-3.0.html GNU/GPL version 3
*/
// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die();

jimport( 'joomla.application.component.modellist' );

class SaxumpickerModelItems extends JModelList
{	
	public function __construct($config = array())
	{
		if (empty($config['filter_fields'])) {
			$config['filter_fields'] = array(
				'id', 'a.id',
				'setid', 'a.setid' ,
				'setname', 's.name' ,
				'number', 'a.number' ,
				'name', 'a.name' ,
				'published', 'a.published'
			);
		}

		parent::__construct($config);
	}
	
	protected function getListQuery()
	{
		// Create a new query object.		
		$db = $this->getDBO();
		$query = $db->getQuery(true);
		// Select some fields
		$query->select(
			$this->getState(
				'list.select',
				'a.*'
				)
			);
		$query->from('#__saxumpicker_item as a');
		
		$query->select('s.name AS setname');
		$query->join('INNER', '`#__saxumpicker_set` AS s ON a.setid=s.id');
	
		// Filter by search in title.
		$search = $this->getState('filter.search');
		if (!empty($search))
		{
			if (stripos($search, 'id:') === 0)
			{
				$query->where('a.id = ' . (int) substr($search, 3));
			}
			elseif (stripos($search, 'set:') === 0)
			{
				$search = $db->quote('%' . $db->escape(substr($search, 4), true) . '%');
				$query->where('(s.name LIKE ' . $search . ')');
			}
			elseif (stripos($search, 'number:') === 0)
			{
				$search = $db->quote('%' . $db->escape(substr($search, 7), true) . '%');
				$query->where('(a.number LIKE ' . $search . ')');
			}
			elseif (stripos($search, 'name:') === 0)
			{
				$search = $db->quote('%' . $db->escape(substr($search, 5), true) . '%');
				$query->where('(a.name LIKE ' . $search . ')');
			}
			else
			{
				$search = $db->quote('%' . $db->escape($search, true) . '%');
				$query->where('(a.name LIKE ' . $search . ')');
			}
		}
		
		// Filter by set
		$setId = $this->getState('filter.setid');
		if (is_numeric($setId)) {
			$query->where('a.setid = '.(int) $setId);
		}
			
		// Filter by published state
		$published = $this->getState('filter.published');
		if (is_numeric($published)) {
			$query->where('a.published = '.(int) $published);
		} else if ($published === '') {
			$query->where('(a.published IN (0, 1))');
		}
		
		$orderCol	= $this->state->get('list.ordering');
		$orderDirn	= $this->state->get('list.direction');
		$query->order($db->escape($orderCol.' '.$orderDirn));
		
		return $query;
	}
	
	protected function populateState($ordering = null, $direction = null)
	{
		// Initialise variables.
		$app = JFactory::getApplication('administrator');

		$search = $this->getUserStateFromRequest($this->context . '.filter.search', 'filter_search');
		$this->setState('filter.search', $search);
		
		// Load the filter state.
		$setId = $this->getUserStateFromRequest($this->context.'.filter.setid', 'filter_setid', '');
		$this->setState('filter.setid', $setId);
		
		$state = $this->getUserStateFromRequest($this->context.'.filter.published', 'filter_published', '', 'string');
		$this->setState('filter.published', $state);

		// List state information.
		parent::populateState('a.name', 'asc');
	}

	public function getSets()
	{
		// Create a new query object.
		$db		= $this->getDbo();
		$query	= $db->getQuery(true);

		$query->select('s.id, s.name AS setname');
		$query->from('#__saxumpicker_set AS s');
		$query->order('s.name ASC');

		$db->setQuery($query);
		$result = $db->loadObjectList();

		return $result;
	}
}
  	
