<?php
/**
 * $Id: spreads.php 16 2013-12-09 23:13:51Z Szablac $
 * @Project		Saxum Picker Extension/Component
 * @author 		Laszlo Szabo
 * @package		Saxum Picker
 * @copyright	Copyright (C) 2010 Saxum 2003 Bt. All rights reserved.
 * @license 	http://www.gnu.org/licenses/old-licenses/gpl-3.0.html GNU/GPL version 3
*/
// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die();

jimport('joomla.application.component.modellist');

class SaxumpickerModelSpreads extends JModelList
{
	public function __construct($config = array())
	{
		if (empty($config['filter_fields'])) {
			$config['filter_fields'] = array(
				'id', 'a.id',
				'userid', 'a.userid',
				'name', 't.name',
				'tstamp', 'a.tstamp',
				'title', 'a.title', 'a.type','a.publicid','a.pmtype','a.paymentid'
			);
		}

		parent::__construct($config);
	}
	
	protected function getListQuery()
	{
		// Create a new query object.		
		$db = JFactory::getDBO();
		$query = $db->getQuery(true);
		// Select some fields
		$query->select(
			$this->getState(
				'list.select',
				'a.*'
			)
		);
		$query->from('#__saxumpicker_saved_spreads a');
		
		$query->select('t.name AS name');
		$query->join('LEFT', '`#__users` AS t ON a.userid=t.id');
		
		$query->select('s.name AS type');
		$query->join('LEFT', '`#__saxumpicker_type` AS s ON a.typeid=s.id');
				
		// Filter by search in title.
		$search = $this->getState('filter.search');
		if (!empty($search))
		{
			if (stripos($search, 'id:') === 0)
			{
				$query->where('a.id = ' . (int) substr($search, 3));
			}
			elseif (stripos($search, 'user:') === 0)
			{
				$search = $db->quote('%' . $db->escape(substr($search, 5), true) . '%');
				$query->where('(t.name LIKE ' . $search . ')');
			}
			elseif (stripos($search, 'title:') === 0)
			{
				$search = $db->quote('%' . $db->escape(substr($search, 6), true) . '%');
				$query->where('(a.title LIKE ' . $search . ')');
			}
			elseif (stripos($search, 'date:') === 0)
			{
				$search = $db->quote('%' . $db->escape(substr($search, 5), true) . '%');
				$query->where('(a.tstamp LIKE ' . $search . ')');
			}
			elseif (stripos($search, 'public ID:') === 0)
			{
				$search = $db->quote('%' . $db->escape(substr($search, 10), true) . '%');
				$query->where('(a.publicid LIKE ' . $search . ')');
			}
			elseif (stripos($search, 'payment type:') === 0)
			{
				$search = $db->quote('%' . $db->escape(substr($search, 13), true) . '%');
				$query->where('(a.pmtype LIKE ' . $search . ')');
			}
			elseif (stripos($search, 'payment ID:') === 0)
			{
				$search = $db->quote('%' . $db->escape(substr($search, 11), true) . '%');
				$query->where('(a.paymentid LIKE ' . $search . ')');
			}
			else
			{
				$search = $db->quote('%' . $db->escape($search, true) . '%');
				$query->where('(a.title LIKE ' . $search . ')');
			}
		}
		
		// Filter by user
		$userId = $this->getState('filter.userid');
		if (is_numeric($userId)) {
			$query->where('a.userid = '.(int) $userId);
		}
		$typeId = $this->getState('filter.typeid');
		if (is_string($typeId)and $typeId!=='') {
			$query->where('a.title = '. $db->Quote( $typeId));
		}
	/*
		$startdate = $this->getState('filter.start_date');
		if (!is_null($startdate) and $startdate!='') {
			$query->where('a.tstamp >= '. $db->Quote($startdate));
		}
		$enddate = $this->getState('filter.end_date');
		if (!is_null($enddate) and $enddate!=='') {
			$query->where('a.tstamp <= '. $db->Quote($enddate));
		}
		*/
		$orderCol	= $this->state->get('list.ordering');
		$orderDirn	= $this->state->get('list.direction');
		$query->order($db->escape($orderCol.' '.$orderDirn));
		
		return $query;
	}
	
	protected function populateState($ordering = null, $direction = null)
	{
		// Initialise variables.
		$app = JFactory::getApplication('administrator');

		$search = $this->getUserStateFromRequest($this->context . '.filter.search', 'filter_search');
		$this->setState('filter.search', $search);
/*
		// Load the filter state.
		$start_date = $app->getUserStateFromRequest($this->context.'.filter.start_date', 'filter_start_date');      
		$this->setState('filter.start_date', $start_date);
       
        $end_date = $app->getUserStateFromRequest($this->context.'.filter.end_date', 'filter_end_date');     
		$this->setState('filter.end_date', $end_date);
		*/
		$userId = $this->getUserStateFromRequest($this->context.'.filter.userid', 'filter_userid', '');
		$this->setState('filter.userid', $userId);
		
		$typeId = $this->getUserStateFromRequest($this->context.'.filter.typeid', 'filter_typeid', '');
		$this->setState('filter.typeid', $typeId);
		
		// List state information.
		parent::populateState('a.tstamp', 'desc');
	}

	public function getUsers()
	{
		// Create a new query object.
		$db		= $this->getDbo();
		$query	= $db->getQuery(true);

		$query->select('t.id, t.name AS name');
		$query->from('#__users AS t');
		$query->order('t.name ASC');

		$db->setQuery($query);
		$result = $db->loadObjectList();

		return $result;
	}

	public function getTypes()
	{
		// Create a new query object.
		$db		= $this->getDbo();
		$query	= $db->getQuery(true);

		$query->select('distinct t.title as id, t.title AS name');
		$query->from('#__saxumpicker_saved_spreads AS t');
		$query->order('t.title ASC');

		$db->setQuery($query);
		$result = $db->loadObjectList();

		return $result;
	}
}
  	
