<?php
/**
 * $Id: type.php 16 2013-12-09 23:13:51Z Szablac $
 * @Project		Saxum Picker Extension/Component
 * @author 		Laszlo Szabo
 * @package		Saxum Picker
 * @copyright	Copyright (C) 2010 Saxum 2003 Bt. All rights reserved.
 * @license 	http://www.gnu.org/licenses/old-licenses/gpl-3.0.html GNU/GPL version 3
*/

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die();

jimport('joomla.application.component.modeladmin');

class SaxumpickerModelType extends JModelAdmin
{
	public function getTable($type = 'Type', $prefix = 'SaxumpickerTable', $config = array()) 
	{
		return JTable::getInstance($type, $prefix, $config);
	}

	public function getForm($data = array(), $loadData = true) 
	{
		// Get the form.
		$form = $this->loadForm('com_saxumpicker.type', 'type',
		                        array('control' => 'jform', 'load_data' => $loadData));
		if (empty($form)) 
		{
			return false;
		}
		return $form;
	}  
	
	public function getItem($pk = null)
	{
		if ($item = parent::getItem($pk))
		{
			// Convert the metadata field to an array.
			$registry = new JRegistry;
			$registry->loadString($item->formparams);
			$item->formparams = $registry->toArray();
		}

		return $item;
	}

	protected function loadFormData()
	{
		// Check the session for previously entered form data.
		$data = JFactory::getApplication()->getUserState('com_saxumpicker.edit.type.data', array());
		if (empty($data)) 
		{
			$data = $this->getItem();
		}
		$this->preprocessData('com_saxumpicker.type', $data);
		return $data;
	}
}
?>
