CREATE TABLE IF NOT EXISTS `#__saxumpicker_set` (
     `id` int(11) NOT NULL auto_increment,
     `name` varchar(100) character set utf8 NOT NULL,
     `desc` text character set utf8 NOT NULL,
     `back` varchar(200) character set utf8 NOT NULL,  
     `selected` varchar(200) character set utf8 NOT NULL,
     `over` varchar(200) character set utf8 NOT NULL,    
     `published` tinyint(1) NOT NULL,    
     PRIMARY KEY (`id`)
     ) ENGINE=MyISAM AUTO_INCREMENT=1 ;
     
INSERT IGNORE INTO `#__saxumpicker_set` VALUES
(1, 'Deck of Tarot', '<p>Cards designed by <a href="http://discordia.duskglass.com/frogtarot" target="_blank">Lillie Frog</a></p>', 'images/saxumpicker/lillie.gif', 'images/saxumpicker/eyes.gif', 'images/saxumpicker/eyes.gif', 1),
(2, 'Thimble and Pea', '', 'images/saxumpicker/thimble.png', 'images/saxumpicker/thimble_selected.png', 'images/saxumpicker/thimble_selected.png', 1);
    
CREATE TABLE IF NOT EXISTS `#__saxumpicker_item` (
     `id` int(11) NOT NULL auto_increment,
     `setid` int(11) NOT NULL,
     `number` varchar(60) character set utf8 NOT NULL,
     `name` varchar(100) character set utf8 NOT NULL,
     `desc` text character set utf8 NOT NULL,
     `picture` varchar(200) character set utf8 NOT NULL,   
     `published` tinyint(1) NOT NULL,    
     PRIMARY KEY (`id`)
     ) ENGINE=MyISAM AUTO_INCREMENT=1 ;
     
INSERT IGNORE INTO `#__saxumpicker_item` VALUES
(1, 1, 'I', 'The Magician', '', 'images/saxumpicker/magician.gif', 1),
(2, 1, 'II', 'The Priestess', '', 'images/saxumpicker/priestess.gif', 1),
(3, 1, 'III', 'The Empress', '', 'images/saxumpicker/empress.gif', 1),
(4, 1, 'IV', 'The Emperor', '', 'images/saxumpicker/emperor.gif', 1),
(5, 1, 'V', 'The Hierophant', '', 'images/saxumpicker/hierophant.gif', 1),
(6, 1, 'VI', 'The Lovers', '', 'images/saxumpicker/lovers.gif', 1),
(7, 1, 'VII', 'The Charriot', '', 'images/saxumpicker/chariot.gif', 1),
(8, 1, 'VIII', 'Justice', '', 'images/saxumpicker/justice.gif', 1),
(9, 1, 'IX', 'The Hermit', '', 'images/saxumpicker/hermit.gif', 1),
(10, 1, 'X', 'The Wheel', '', 'images/saxumpicker/wheel.gif', 1),
(11, 1, 'XI', 'Strength', '', 'images/saxumpicker/strength.gif', 1),
(12, 1, 'XII', 'The Hanged Man', '', 'images/saxumpicker/hangedman.gif', 1),
(13, 1, 'XIII', 'Death', '', 'images/saxumpicker/death.gif', 1),
(14, 1, 'XIV', 'Temperance', '', 'images/saxumpicker/temperance.gif', 1),
(15, 1, 'XV', 'The Devil', '', 'images/saxumpicker/devil.gif', 1),
(16, 1, 'XVI', 'The Tower', '', 'images/saxumpicker/tower.gif', 1),
(17, 1, 'XVII', 'The Star', '', 'images/saxumpicker/star.gif', 1),
(18, 1, 'XVIII', 'The Moon', '', 'images/saxumpicker/moon.gif', 1),
(19, 1, 'XIX', 'The Sun', '', 'images/saxumpicker/sun.gif', 1),
(20, 1, 'XX', 'Judgement', '', 'images/saxumpicker/judgement.gif', 1),
(21, 1, 'XXI', 'The Universe', '', 'images/saxumpicker/universe.gif', 1),
(22, 1, '0', 'The Fool', '', 'images/saxumpicker/fool.gif', 1),
(23, 2, '1', 'Got it!', '', 'images/saxumpicker/thimble_got.png', 1),
(24, 2, '2', 'It''s empty.', '', 'images/saxumpicker/thimble_empty.png', 1),
(25, 2, '3', 'But it''s empty.', '', 'images/saxumpicker/thimble_empty.png', 1);

CREATE TABLE IF NOT EXISTS `#__saxumpicker_type` (
     `id` int(11) NOT NULL auto_increment,
     `setid` int(11) NOT NULL,
     `name` varchar(100) character set utf8 NOT NULL,
     `pieces` int(11) NOT NULL,     
     `desc` text character set utf8 NOT NULL,
     `evaluation` tinyint(1) NOT NULL,
     `order_counts` tinyint(1) NOT NULL,
     `hits` int(10) NOT NULL DEFAULT 0,
     `published` tinyint(1) NOT NULL,   
	 `pmtype` varchar(30) character set utf8 NOT NULL DEFAULT 'free',
	 `amount` decimal(8,2) NOT NULL DEFAULT 0,
	 `currency` varchar(3) character set utf8 NOT NULL DEFAULT 'EUR',
	 `tax` decimal(8,2) NOT NULL DEFAULT 0,
	 `act_paid` TINYINT NOT NULL DEFAULT 0,
	 `admin_email` varchar(100) character set utf8, 
     `freedesc` text character set utf8 NOT NULL DEFAULT '',
     `formparams` text character set utf8 NOT NULL DEFAULT '',
     PRIMARY KEY (`id`)
     ) ENGINE=MyISAM AUTO_INCREMENT=1 ;

INSERT IGNORE INTO `#__saxumpicker_type` (`id`, `setid`, `name`, `pieces`, `desc`, `evaluation`, `order_counts`, `published`) VALUES
(1, 2, 'Thimble and Pea', 1, '<p>Find the Pea!</p>', 1, 0, 1);

CREATE TABLE IF NOT EXISTS `#__saxumpicker_evaluation` (
     `id` int(11) NOT NULL auto_increment,
     `typeid` int(11) NOT NULL,
     `spread` varchar(300) character set utf8 NULL,
     `itemid` int(11) NULL,
     `position` tinyint(1) NULL,
     `title` varchar(100) character set utf8 NOT NULL,
     `text` mediumtext character set utf8 NOT NULL,   
     `published` tinyint(1) NOT NULL,  
     PRIMARY KEY (`id`)
     ) ENGINE=MyISAM AUTO_INCREMENT=1 ;
       
INSERT IGNORE INTO `#__saxumpicker_evaluation` (`id`, `typeid`, `spread`, `itemid`, `position`, `title`, `text`, `published`) VALUES
(1, 1, '', 23, 0, 'Congratulation!', '<p>You win. Try again!</p>', 1),
(2, 1, '', 24, 0, 'Oooops', '<p>You lose...</p>', 1),
(3, 1, '', 25, 0, 'Nice try', '<p>You lose...</p>', 1);

ALTER TABLE `#__saxumpicker_evaluation` ADD `image_pos` TINYINT NOT NULL DEFAULT '1' AFTER `title`;

CREATE TABLE IF NOT EXISTS `#__saxumpicker_saved_spreads` (
     `id` int(11) NOT NULL auto_increment,
     `userid` int(11) NOT NULL,
     `tstamp` datetime NOT NULL,
     `title` varchar(200) character set utf8 NOT NULL, 
     `typeid` int(11) NOT NULL DEFAULT 0,
     `spread` text character set utf8, 
     `paymentid` varchar(30) character set utf8 NOT NULL DEFAULT '',
     `pmtype` varchar(30) character set utf8 NOT NULL DEFAULT 'free', 
     `add_info` text character set utf8, 
     `publicid` varchar(30) character set utf8 NOT NULL DEFAULT '',
     PRIMARY KEY (`id`),
	 INDEX idx_spss_user( `userid` ),
	 INDEX idx_spss_pmid( `paymentid` ),
	 INDEX idx_spss_pcid(`publicid`)
     ) ENGINE=MyISAM AUTO_INCREMENT=1 ;
     
     