<?php
/**
 * $Id: view.html.php 117 2015-06-17 07:40:53Z Szablac $
 * @Project		Saxum Picker Extension/Component
 * @author 		Laszlo Szabo
 * @package		Saxum Picker
 * @copyright	Copyright (C) 2010 Saxum 2003 Bt. All rights reserved.
 * @license 	http://www.gnu.org/licenses/old-licenses/gpl-3.0.html GNU/GPL version 3
*/

defined('_JEXEC') or die();

jimport( 'joomla.application.component.view' );

class SaxumpickerViewEvaluation extends JViewLegacy
{

	public function display($tpl = null) 
	{
		// get the Data
		$this->form		= $this->get('Form');
		$this->item		= $this->get('Item');
		$this->state	= $this->get('State');
		$this->script	= $this->get('Script');
		$copy = JFactory::getApplication()->input->get('copy');
		$isNew = ($this->item->id == 0);
		   echo $copy;
		   
		$jinput=JFactory::getApplication()->input;
		$post=$jinput->post;
		$jform=$jinput->post->get('jform', '0',null);

		$typeid = $this->item->typeid;
		if ($typeid==0 && !empty($jform)) $typeid=$jform['typeid'];
		$this->type		= SaxumpickerModelEvaluation::getType($typeid);
		
		if ($isNew && $typeid==0 || $copy==1) {
			$this->addToolBarSelectType();
		} else {
			$this->addToolBar();
		}
 
		// Check for errors.
		if (count($errors = $this->get('Errors'))) {
			JError::raiseError(500, implode("\n", $errors));
			return false;
		}
  
		// Display the template
		parent::display($tpl);
 
		// Set the document
		$this->setDocument();
	}
	
	/**
	 * Setting the toolbar
	 */
	protected function addToolBar() 
	{
		JFactory::getApplication()->input->set('hidemainmenu', true);
		$user = JFactory::getUser();
		$isNew = ($this->item->id == 0);
		$canDo = SaxumpickerHelper::getActions();
		JHTML::stylesheet( 'administrator/components/com_saxumpicker/saxumpicker.css' );
		JToolBarHelper::title($isNew ? JText::_( 'COM_SAXUMPICKER' ).' - '.JText::_('COM_SAXUMPICKER_EVALUATION_NEW') : JText::_( 'COM_SAXUMPICKER' ).' - '.JText::_('COM_SAXUMPICKER_EVALUATION_EDIT'), 'evaluation.png');
		if ($isNew) JToolBarHelper::back();
		if ($isNew && $canDo->get('core.create')) 
		{
			JToolBarHelper::apply('evaluation.apply');
			JToolBarHelper::save('evaluation.save');
			JToolBarHelper::custom('evaluation.save2new', 'save-new.png', 'save-new_f2.png', 'JTOOLBAR_SAVE_AND_NEW', false);
		}
		else
		{
			if($canDo->get('core.edit'))	
			{
				JToolBarHelper::apply('evaluation.apply');
				JToolBarHelper::save('evaluation.save');
			}
			if($canDo->get('core.create'))	
			{
				JToolBarHelper::custom('evaluation.save2new', 'save-new.png', 'save-new_f2.png', 'JTOOLBAR_SAVE_AND_NEW', false);
				JToolBarHelper::custom('evaluation.save2copy', 'save-copy.png', 'save-copy_f2.png', 'JTOOLBAR_SAVE_AS_COPY', false);
			}
		}
		JToolBarHelper::cancel('evaluation.cancel', $isNew ? 'JTOOLBAR_CANCEL'
		                                                   : 'JTOOLBAR_CLOSE');
	}
	
	protected function addToolBarSelectType() 
	{
		JFactory::getApplication()->input->set('hidemainmenu', true);
		$user = JFactory::getUser();
		$isNew = ($this->item->id == 0);
		$canDo = SaxumpickerHelper::getActions();
		JHTML::stylesheet( 'administrator/components/com_saxumpicker/saxumpicker.css' );
		JToolBarHelper::title($isNew ? JText::_( 'COM_SAXUMPICKER' ).' - '.JText::_('COM_SAXUMPICKER_EVALUATION_NEW') : JText::_( 'COM_SAXUMPICKER' ).' - '.JText::_('COM_SAXUMPICKER_EVALUATION_EDIT'), 'evaluation.png');
		JToolBarHelper::custom('evaluation.next','forward.png','forward.png',JText::_('COM_SAXUMPICKER_NEXT'),false);
		JToolBarHelper::cancel('evaluation.cancelcopy', $isNew ? 'JTOOLBAR_CANCEL'
		                                                   : 'JTOOLBAR_CLOSE');
	}

	protected function setDocument() 
	{
		$isNew = ($this->item->id < 1);
		$document = JFactory::getDocument();
		$document->addScript(JURI::root() . $this->script);
		$document->addScript(JURI::root() . "/administrator/components/com_saxumpicker"
		                                  . "/views/evaluation/submitbutton.js");
		JText::script('COM_SAXUMPICKER_EVALUATION_ERROR_UNACCEPTABLE');
	}
}
?>

