<?php
/**
 * $Id: view.html.php 7 2013-09-04 05:47:07Z Szablac $
 * @Project		Saxum Picker Extension/Component
 * @author 		Laszlo Szabo
 * @package		Saxum Picker
 * @copyright	Copyright (C) 2010 Saxum 2003 Bt. All rights reserved.
 * @license 	http://www.gnu.org/licenses/old-licenses/gpl-3.0.html GNU/GPL version 3
*/

defined('_JEXEC') or die();

jimport( 'joomla.application.component.view' );

class SaxumpickerViewEvaluations extends JViewLegacy
{
	protected $items;
	protected $pagination;
	protected $state;
	
	function display($tpl = null)
	{
		// Get data from the model
		$this->items		= $this->get('Items');
		$this->pagination	= $this->get('Pagination');
		$this->state		= $this->get('State');
		$this->types		= $this->get('Types');	
		SaxumpickerController::addSubmenu('evaluations');
		
        $this->sortDirection = $this->state->get('list.direction');
        $this->sortColumn = $this->state->get('list.ordering');
        
		// Check for errors.
		if (count($errors = $this->get('Errors'))) {
			JError::raiseError(500, implode('<br />', $errors));
			return false;
		}
		
		// Set the toolbar
		$this->addToolBar();
		$this->sidebar = JHtmlSidebar::render();
		 
		// Display the template
		parent::display($tpl);   
	}

	/**
	 * Setting the toolbar
	 */
	protected function addToolBar() 
	{
		$canDo = SaxumpickerHelper::getActions();
		JHTML::stylesheet( 'administrator/components/com_saxumpicker/saxumpicker.css' );
		JToolBarHelper::title(JText::_( 'COM_SAXUMPICKER' ).' - '.JText::_('COM_SAXUMPICKER_EVALUATIONS'),'evaluation.png');
		if ($canDo->get('core.create')) 
		{
			JToolBarHelper::addNew('evaluation.add');
		}
		if ($canDo->get('core.edit')) 
		{
			JToolBarHelper::editList('evaluation.edit');
		}
		if ($canDo->get('core.edit.state') or $canDo->get('core.delete')) 
		{
			JToolBarHelper::divider();
		}
		if ($canDo->get('core.edit.state'))
		{
			JToolBarHelper::publish('evaluations.publish', 'JTOOLBAR_PUBLISH',true);
			JToolBarHelper::unpublish('evaluations.unpublish', 'JTOOLBAR_UNPUBLISH',true);
		}
		if ($canDo->get('core.delete')) 
		{
			JToolBarHelper::deleteList('', 'evaluations.delete');
		}	

		JHtmlSidebar::setAction('index.php?option=com_saxumpicker&view=evaluations');

		JHtmlSidebar::addFilter(
			JText::_('COM_SAXUMPICKER_SELECT_TYPE'),
			'filter_typeid',
			JHtml::_('select.options', $this->types, 'id', 'typename', $this->state->get('filter.typeid'), true)
		);
		JHtmlSidebar::addFilter(
			JText::_('JOPTION_SELECT_PUBLISHED'),
			'filter_published',
			JHtml::_('select.options', JHtml::_('jgrid.publishedOptions'), 'value', 'text', $this->state->get('filter.published'), true)
		);
	}
	
	protected function getSortFields()
	{
		return array(
			'a.id' => JText::_('JGRID_HEADING_ID'),
			'typename' => JText::_('COM_SAXUMPICKER_TYPE'),
			'a.title' => JText::_('COM_SAXUMPICKER_TITLE'),
			'picked' => JText::_('COM_SAXUMPICKER_SPREADITEM'),
			'a.published' => JText::_('JSTATUS')
		);
	}
}
?>
