<?php
/**
 * $Id: view.html.php 7 2013-09-04 05:47:07Z Szablac $
 * @Project		Saxum Picker Extension/Component
 * @author 		Laszlo Szabo
 * @package		Saxum Picker
 * @copyright	Copyright (C) 2010 Saxum 2003 Bt. All rights reserved.
 * @license 	http://www.gnu.org/licenses/old-licenses/gpl-3.0.html GNU/GPL version 3
*/

defined('_JEXEC') or die();

jimport( 'joomla.application.component.view' );

class SaxumpickerViewItem extends JViewLegacy
{

	public function display($tpl = null) 
	{
		// get the Data
		$this->form		= $this->get('Form');
		$this->item		= $this->get('Item');
		$this->state	= $this->get('State');
 
		// Check for errors.
		if (count($errors = $this->get('Errors'))) {
			JError::raiseError(500, implode("\n", $errors));
			return false;
		}
 
		// Set the toolbar
		$this->addToolBar();
 
		// Display the template
		parent::display($tpl);
	}
	
	/**
	 * Setting the toolbar
	 */
	protected function addToolBar() 
	{
		JFactory::getApplication()->input->set('hidemainmenu', true);
		$user = JFactory::getUser();
		$isNew = ($this->item->id == 0);
		$canDo = SaxumpickerHelper::getActions();
		JHTML::stylesheet( 'administrator/components/com_saxumpicker/saxumpicker.css' );
		JToolBarHelper::title($isNew ? JText::_( 'COM_SAXUMPICKER' ).' - '.JText::_('COM_SAXUMPICKER_ITEM_NEW') : JText::_( 'COM_SAXUMPICKER' ).' - '.JText::_('COM_SAXUMPICKER_ITEM_EDIT'), 'item.png');
		if ($isNew && $canDo->get('core.create')) 
		{
			JToolBarHelper::apply('item.apply');
			JToolBarHelper::save('item.save');
			JToolBarHelper::custom('item.save2new', 'save-new.png', 'save-new_f2.png', 'JTOOLBAR_SAVE_AND_NEW', false);
		}
		else
		{
			if($canDo->get('core.edit'))	
			{
				JToolBarHelper::apply('item.apply');
				JToolBarHelper::save('item.save');
			}
			if($canDo->get('core.create'))	
			{
				JToolBarHelper::custom('item.save2new', 'save-new.png', 'save-new_f2.png', 'JTOOLBAR_SAVE_AND_NEW', false);
				JToolBarHelper::custom('item.save2copy', 'save-copy.png', 'save-copy_f2.png', 'JTOOLBAR_SAVE_AS_COPY', false);
			}
		}
		JToolBarHelper::cancel('item.cancel', $isNew ? 'JTOOLBAR_CANCEL'
		                                                   : 'JTOOLBAR_CLOSE');
	}
	
}
?>

