<?php
/**
 * $Id: view.html.php 7 2013-09-04 05:47:07Z Szablac $
 * @Project		Saxum Picker Extension/Component
 * @author 		Laszlo Szabo
 * @package		Saxum Picker
 * @copyright	Copyright (C) 2010 Saxum 2003 Bt. All rights reserved.
 * @license 	http://www.gnu.org/licenses/old-licenses/gpl-3.0.html GNU/GPL version 3
*/

defined('_JEXEC') or die();

jimport( 'joomla.application.component.view' );

class SaxumpickerViewSets extends JViewLegacy
{
	protected $items;
	protected $pagination;
	protected $state;
	
	function display($tpl = null) 
	{
		$this->items		= $this->get('Items');
		$this->pagination	= $this->get('Pagination');
		$this->state		= $this->get('State');
		SaxumpickerController::addSubmenu('sets');
		
        $this->sortDirection = $this->state->get('list.direction');
        $this->sortColumn = $this->state->get('list.ordering');
 
		// Check for errors.
		if (count($errors = $this->get('Errors'))) {
			JError::raiseError(500, implode("\n", $errors));
			return false;
		}
				
		// Set the toolbar
		$this->addToolBar();
		$this->sidebar = JHtmlSidebar::render();
 
		// Display the template
		parent::display($tpl);
	}
	
	protected function addToolBar() 
	{
		$canDo = SaxumpickerHelper::getActions();
		JHTML::stylesheet( 'administrator/components/com_saxumpicker/saxumpicker.css' );
		JToolBarHelper::title(JText::_( 'COM_SAXUMPICKER' ).' - '.JText::_('COM_SAXUMPICKER_SETS'),'set.png');
		if ($canDo->get('core.create')) 
		{
			JToolBarHelper::addNew('set.add');
		}
		if ($canDo->get('core.edit')) 
		{
			JToolBarHelper::editList('set.edit');
		}
		if ($canDo->get('core.edit.state') or $canDo->get('core.delete')) 
		{
			JToolBarHelper::divider();
		}
		if ($canDo->get('core.edit.state'))
		{
			JToolBarHelper::publish('sets.publish', 'JTOOLBAR_PUBLISH',true);
			JToolBarHelper::unpublish('sets.unpublish', 'JTOOLBAR_UNPUBLISH',true);
		}
		if ($canDo->get('core.delete')) 
		{
			JToolBarHelper::deleteList('', 'sets.delete');
		}
	}
	
	protected function getSortFields()
	{
		return array(
			'a.id' => JText::_('JGRID_HEADING_ID'),
			'a.name' => JText::_('COM_SAXUMPICKER_NAME'),
			'a.published' => JText::_('JSTATUS')
		);
	}
	
}
?>
