<?php
/**
 * $Id: view.html.php 16 2013-12-09 23:13:51Z Szablac $
 * @Project		Saxum Picker Extension/Component
 * @author 		Laszlo Szabo
 * @package		Saxum Picker
 * @copyright	Copyright (C) 2010 Saxum 2003 Bt. All rights reserved.
 * @license 	http://www.gnu.org/licenses/old-licenses/gpl-3.0.html GNU/GPL version 3
*/

defined('_JEXEC') or die();

jimport( 'joomla.application.component.view' );

class SaxumpickerViewSpreads extends JViewLegacy
{
	protected $items;
	protected $pagination;
	protected $state;
	
	function display($tpl = null)
	{
		// Get data from the model
		$this->items		= $this->get('Items');
		$this->pagination	= $this->get('Pagination');
		$this->state		= $this->get('State');
		$this->users		= $this->get('Users');	
		$this->types		= $this->get('Types');	
		SaxumpickerController::addSubmenu('spreads');
 
        $this->sortDirection = $this->state->get('list.direction');
        $this->sortColumn = $this->state->get('list.ordering');
		
		// Check for errors.
		if (count($errors = $this->get('Errors'))) 
		{
			JError::raiseError(500, implode('<br />', $errors));
			return false;
		}
		
		// Set the toolbar
		$this->addToolBar();
		$this->sidebar = JHtmlSidebar::render();
		 
		// Display the template
		parent::display($tpl);   
	}

	/**
	 * Setting the toolbar
	 */
	protected function addToolBar() 
	{
		$canDo = SaxumpickerHelper::getActions();
		JHTML::stylesheet( 'administrator/components/com_saxumpicker/saxumpicker.css' );
		JToolBarHelper::title(JText::_( 'COM_SAXUMPICKER' ).' - '.JText::_('COM_SAXUMPICKER_SPREADS'),'spreads.png');
		if ($canDo->get('core.delete')) 
		{
			JToolBarHelper::deleteList('', 'spreads.delete');
		}
		
		JHtmlSidebar::setAction('index.php?option=com_saxumpicker&view=items');

		JHtmlSidebar::addFilter(
			JText::_('COM_SAXUMPICKER_SELECT_TYPE'),
			'filter_typeid',
			JHtml::_('select.options', $this->types, 'id', 'name', $this->state->get('filter.typeid'), true)
		);
		JHtmlSidebar::addFilter(
			JText::_('COM_SAXUMPICKER_SELECT_USER'),
			'filter_user',
			JHtml::_('select.options', $this->users, 'id', 'name', $this->state->get('filter.userid'), true)
		);
	}
	
	protected function getSortFields()
	{
		return array(
			'a.id' => JText::_('JGRID_HEADING_ID'),
			'name' => JText::_('COM_SAXUMPICKER_USER'),
			'a.type' => JText::_('COM_SAXUMPICKER_TYPE'),
			'a.title' => JText::_('COM_SAXUMPICKER_TITLE'),
			'a.publicid' => JText::_('COM_SAXUMPICKER_PUBLICID'),
			'a.pmtype' => JText::_('COM_SAXUMPICKER_PMTYPE'),
			'a.paymentid' => JText::_('COM_SAXUMPICKER_PMID'),
			'a.tstamp' => JText::_('COM_SAXUMPICKER_TSTAMP')
		);
	}
}
?>
