<?php
/**
 * $Id: default.php 60 2014-07-09 11:54:26Z Szablac $
 * @Project		Saxum Picker Extension/Component
 * @author 		Laszlo Szabo
 * @package		Saxum Picker
 * @copyright	Copyright (C) 2010 Saxum 2003 Bt. All rights reserved.
 * @license 	http://www.gnu.org/licenses/old-licenses/gpl-3.0.html GNU/GPL version 3
*/
defined('_JEXEC') or die('Restricted access'); 
JHtml::_('behavior.tooltip');
JHtml::_('formbehavior.chosen', 'select');

$user		= JFactory::getUser();
$userId		= $user->get('id');

$listOrder	= $this->escape($this->state->get('list.ordering'));
$listDirn	= $this->escape($this->state->get('list.direction'));
$sortFields = $this->getSortFields();
?>
<script type="text/javascript">
	Joomla.orderTable = function()
	{
		table = document.getElementById("sortTable");
		direction = document.getElementById("directionTable");
		order = table.options[table.selectedIndex].value;
		if (order != '<?php echo $listOrder; ?>')
		{
			dirn = 'asc';
		}
		else
		{
			dirn = direction.options[direction.selectedIndex].value;
		}
		Joomla.tableOrdering(order, dirn, '');
	}
</script>

<form action="<?php echo JRoute::_('index.php?option=com_saxumpicker&view=types'); ?>" method="post" name="adminForm" id="adminForm">
<?php if (!empty( $this->sidebar)) : ?>
	<div id="j-sidebar-container" class="span2">
		<?php echo $this->sidebar; ?>
	</div>
	<div id="j-main-container" class="span10">
<?php else : ?>
	<div id="j-main-container">
<?php endif;?>
		<div id="filter-bar" class="btn-toolbar">
			<div class="filter-search btn-group pull-left">
				<label for="filter_search" class="element-invisible"><?php echo JText::_('COM_SAXUMPICKER_FILTER_SEARCH_DESC'); ?></label>
				<input type="text" name="filter_search" id="filter_search" placeholder="<?php echo JText::_('JSEARCH_FILTER'); ?>" value="<?php echo $this->escape($this->state->get('filter.search')); ?>" class="hasTooltip" title="<?php echo JHtml::tooltipText('COM_SAXUMPICKER_FILTER_SEARCH_DESC'); ?>" />
			</div>
			<div class="btn-group pull-left hidden-phone">
				<button type="submit" class="btn hasTooltip" title="<?php echo JHtml::tooltipText('JSEARCH_FILTER_SUBMIT'); ?>"><i class="icon-search"></i></button>
				<button type="button" class="btn hasTooltip" title="<?php echo JHtml::tooltipText('JSEARCH_FILTER_CLEAR'); ?>" onclick="document.id('filter_search').value='';this.form.submit();"><i class="icon-remove"></i></button>
			</div>
			<div class="btn-group pull-right hidden-phone">
				<label for="limit" class="element-invisible"><?php echo JText::_('JFIELD_PLG_SEARCH_SEARCHLIMIT_DESC'); ?></label>
				<?php echo $this->pagination->getLimitBox(); ?>
			</div>
			<div class="btn-group pull-right hidden-phone">
				<label for="directionTable" class="element-invisible"><?php echo JText::_('JFIELD_ORDERING_DESC'); ?></label>
				<select name="directionTable" id="directionTable" class="input-medium" onchange="Joomla.orderTable()">
					<option value=""><?php echo JText::_('JFIELD_ORDERING_DESC'); ?></option>
					<option value="asc" <?php if ($listDirn == 'asc') echo 'selected="selected"'; ?>><?php echo JText::_('JGLOBAL_ORDER_ASCENDING'); ?></option>
					<option value="desc" <?php if ($listDirn == 'desc') echo 'selected="selected"'; ?>><?php echo JText::_('JGLOBAL_ORDER_DESCENDING');  ?></option>
				</select>
			</div>
			<div class="btn-group pull-right">
				<label for="sortTable" class="element-invisible"><?php echo JText::_('JGLOBAL_SORT_BY'); ?></label>
				<select name="sortTable" id="sortTable" class="input-medium" onchange="Joomla.orderTable()">
					<option value=""><?php echo JText::_('JGLOBAL_SORT_BY');?></option>
					<?php echo JHtml::_('select.options', $sortFields, 'value', 'text', $listOrder); ?>
				</select>
			</div>
		</div>
		<div class="clearfix"> </div>

	<table class="table table-striped" id="typeList">
	<thead>
		<tr>
			<th width="1%">
				<?php echo JHtml::_('grid.sort', 'JGRID_HEADING_ID', 'a.id',  $this->sortDirection, $this->sortColumn); ?>
			</th>
			<th width="1%" class="hidden-phone">
				<?php echo JHtml::_('grid.checkall'); ?>
			</th>
			<th width="100">
				<?php echo JHtml::_('grid.sort',  'COM_SAXUMPICKER_SET', 'setname',  $this->sortDirection, $this->sortColumn); ?>
			</th>
			<th>
				<?php echo JHtml::_('grid.sort',  'COM_SAXUMPICKER_NAME', 'a.name', $this->sortDirection, $this->sortColumn); ?>
			</th>
			<th width="20">
				<?php echo JHtml::_('grid.sort',  'COM_SAXUMPICKER_PIECES', 'a.pieces', $this->sortDirection, $this->sortColumn); ?>
			</th>
			<?php if ($this->params->get('hitcounter')==1){?>
			<th>
				<?php echo JHtml::_('grid.sort', 'COM_SAXUMPICKER_HITS', 'a.hits', $this->sortDirection, $this->sortColumn); ?>
			</th>
			<?php }?>
			<th width="5%">
				<?php echo JHtml::_('grid.sort', 'JSTATUS', 'a.published', $this->sortDirection, $this->sortColumn); ?>
			</th>
		</tr>
	</thead>
	<?php foreach($this->items as $i => $item): 
	$canChange	= $user->authorise('core.edit.state','com_saxumpicker');
	$canEdit	= $user->authorise('core.edit','com_saxumpicker');
	?>
		<tr class="row<?php echo $i % 2; ?>">
			<td>
				<?php echo $item->id; ?>
			</td>
			<td>
				<?php echo JHtml::_('grid.id', $i, $item->id); ?>
			</td>
			<td align="center">
				<?php echo $item->setname; ?>
			</td>
			<td>
			<?php if ($canEdit) : ?>
				<a href="<?php echo JRoute::_('index.php?option=com_saxumpicker&task=type.edit&id='.$item->id);?>">
				<?php echo $item->name; ?></a>
			<?php else : ?>
				<?php echo $item->name; ?>
			<?php endif; ?>
			</td>
			<td  align="center">
				<?php echo $item->pieces; ?>
			</td>		
			<?php if ($this->params->get('hitcounter')==1){?>
			<td  align="center">
				<?php echo $item->hits; ?>
			</td>		
			<?php }?>
	    	<td align="center">
	    		<?php echo JHtml::_('jgrid.published', $item->published, $i, 'types.', $canChange, 'cb'); ?>
			</td>
		</tr>
	<?php endforeach; ?>
	<tfoot>
    	<tr>
      		<td colspan="9">
      			<?php echo $this->pagination->getListFooter(); ?>
      		</td>
    	</tr>
  	</tfoot>
	</table>
	<div>
	<input type="hidden" name="task" value="" />
	<input type="hidden" name="boxchecked" value="0" />
	<input type="hidden" name="filter_order" value="<?php echo $this->sortColumn; ?>" />
	<input type="hidden" name="filter_order_Dir" value="<?php echo $this->sortDirection; ?>" />
	<?php echo JHtml::_('form.token'); ?>
	</div>
</form>
<?php 
include_once(JPATH_COMPONENT.DIRECTORY_SEPARATOR.'footer.php'); 
?>
