<?php
/**
 * $Id: view.html.php 60 2014-07-09 11:54:26Z Szablac $
 * @Project		Saxum Picker Extension/Component
 * @author 		Laszlo Szabo
 * @package		Saxum Picker
 * @copyright	Copyright (C) 2010 Saxum 2003 Bt. All rights reserved.
 * @license 	http://www.gnu.org/licenses/old-licenses/gpl-3.0.html GNU/GPL version 3
*/

defined('_JEXEC') or die();

jimport( 'joomla.application.component.view' );

class SaxumpickerViewTypes extends JViewLegacy
{
	protected $items;
	protected $pagination;
	protected $state;
	
	function display($tpl = null)
	{
		// Get data from the model
		$this->items		= $this->get('Items');
		$this->pagination	= $this->get('Pagination');
		$this->state		= $this->get('State');
		$this->sets			= $this->get('Sets');
		$this->params = JComponentHelper::getParams( 'com_saxumpicker' );
		SaxumpickerController::addSubmenu('types');
	
        $this->sortDirection = $this->state->get('list.direction');
        $this->sortColumn = $this->state->get('list.ordering');
        
		// Check for errors.
		if (count($errors = $this->get('Errors'))) 
		{
			JError::raiseError(500, implode('<br />', $errors));
			return false;
		}
		
		// Set the toolbar
		$this->addToolBar();
		$this->sidebar = JHtmlSidebar::render();
		 
		// Display the template
		parent::display($tpl);
	}

	/**
	 * Setting the toolbar
	 */
	protected function addToolBar() 
	{
		$canDo = SaxumpickerHelper::getActions();
		JHTML::stylesheet( 'administrator/components/com_saxumpicker/saxumpicker.css' );
		JToolBarHelper::title(JText::_( 'COM_SAXUMPICKER' ).' - '.JText::_('COM_SAXUMPICKER_TYPES'),'type.png');
		if ($canDo->get('core.create')) 
		{
			JToolBarHelper::addNew('type.add');
		}
		if ($canDo->get('core.edit')) 
		{
			JToolBarHelper::editList('type.edit');
		}
		if ($canDo->get('core.edit.state') or $canDo->get('core.delete')) 
		{
			JToolBarHelper::divider();
		}
		if ($canDo->get('core.edit.state'))
		{
			JToolBarHelper::publish('types.publish', 'JTOOLBAR_PUBLISH',true);
			JToolBarHelper::unpublish('types.unpublish', 'JTOOLBAR_UNPUBLISH',true);
		}
		if ($canDo->get('core.delete')) 
		{
			JToolBarHelper::deleteList('', 'types.delete');
		}
		
		JHtmlSidebar::setAction('index.php?option=com_saxumpicker&view=types');

		JHtmlSidebar::addFilter(
			JText::_('COM_SAXUMPICKER_SELECT_SET'),
			'filter_setid',
			JHtml::_('select.options', $this->sets, 'id', 'setname', $this->state->get('filter.setid'), true)
		);
		JHtmlSidebar::addFilter(
			JText::_('JOPTION_SELECT_PUBLISHED'),
			'filter_published',
			JHtml::_('select.options', JHtml::_('jgrid.publishedOptions'), 'value', 'text', $this->state->get('filter.published'), true)
		);
	}	
	
	protected function getSortFields()
	{
		$sortfields=array(
			'a.id' => JText::_('JGRID_HEADING_ID'),
			'setname' => JText::_('COM_SAXUMPICKER_SET'),
			'a.name' => JText::_('COM_SAXUMPICKER_NAME'),
			'a.pieces' => JText::_('COM_SAXUMPICKER_PIECES'),
			'a.published' => JText::_('JSTATUS')
		);
			
		if ($this->params->get('hitcounter')==1){
			$sortfields['a.hits']=JText::_('COM_SAXUMPICKER_HITS');
		}
		
		return $sortfields;
	}
	
}
?>
