<?php
/**
 * $Id: install.php 7 2013-09-04 05:47:07Z Szablac $
 * @Project		Saxum Picker Extension/Component
 * @author 		Laszlo Szabo
 * @package		Saxum Picker
 * @copyright	Copyright (C) 2010 Saxum 2003 Bt. All rights reserved.
 * @license 	http://www.gnu.org/licenses/old-licenses/gpl-3.0.html GNU/GPL version 3
*/

// No direct access to this file
defined('_JEXEC') or die('Restricted access');

class com_SaxumpickerInstallerScript
{
	/**
	 * method to install the component
	 *
	 * @return void
	 */
	function install($parent) 
	{
		// $parent is the class calling this method
		//$parent->getParent()->setRedirectURL('index.php?option=com_saxumPICKER');
	}
 
	/**
	 * method to uninstall the component
	 *
	 * @return void
	 */
	function uninstall($parent) 
	{
		// $parent is the class calling this method
		//echo '<p>' . JText::_('COM_SAXUMPICKER_UNINSTALL_TEXT') . '</p>';
			 
	}
 
	/**
	 * method to update the component
	 *
	 * @return void
	 */
	function update($parent) 
	{
		// $parent is the class calling this method
		if(JFolder::exists(JPATH_SITE.DIRECTORY_SEPARATOR.'media'.DIRECTORY_SEPARATOR.'saxumpicker')){
			JFolder::move(JPATH_SITE.DIRECTORY_SEPARATOR.'media'.DIRECTORY_SEPARATOR.'saxumpicker',JPATH_SITE.DIRECTORY_SEPARATOR.'images'.DIRECTORY_SEPARATOR.'saxumpicker');
		}
		
		$db = JFactory::getDBO();
		$query = $db->getQuery(true);
		// Select some fields
		$query->select('a.*');
		$query->from('#__saxumpicker_saved_spreads a');
		$query->where('a.typeid = 0');
		
		$db->setQuery($query);
		$result = $db->loadObjectList();
		
		foreach ($result as $r){
			$object = new stdClass();
 			$object->id = $r->id;
 			$object->typeid = -1;
			$object->spread = base64_encode($r->spread);
			JFactory::getDbo()->updateObject('#__saxumpicker_saved_spreads', $object, 'id');
			
		}
	}
 
	/**
	 * method to run before an install/update/uninstall method
	 *
	 * @return void
	 */
	function preflight($type, $parent) 
	{
		// $parent is the class calling this method
		// $type is the type of change (install, update or discover_install)
		//echo '<p>' . JText::_('COM_SAXUMPICKER_PREFLIGHT_' . $type . '_TEXT') . '</p>';
	}
 
	/**
	 * method to run after an install/update/uninstall method
	 *
	 * @return void
	 */
	function postflight($type, $parent) 
	{
		// $parent is the class calling this method
		// $type is the type of change (install, update or discover_install)
		//echo '<p>' . JText::_('COM_SAXUMPICKER_POSTFLIGHT_' . $type . '_TEXT') . '</p>';
	}
}