<?php
/**
 * $Id: controller.php 60 2014-07-09 11:54:26Z Szablac $
 * @Project		Saxum Picker Extension/Component
 * @author 		Laszlo Szabo
 * @package		Saxum Picker
 * @copyright	Copyright (C) 2010 Saxum 2003 Bt. All rights reserved.
 * @license 	http://www.gnu.org/licenses/old-licenses/gpl-3.0.html GNU/GPL version 3
*/

defined('_JEXEC') or die();
jimport('joomla.application.component.controller');

/**
 * Auto Component Controller
 */
class SaxumpickerController extends JControllerLegacy
{
	function display($cachable = false, $urlparams = false)
	{	
		parent::display();
	}	
			  
	function sendmail2admin()
	{
		$app	= JFactory::getApplication();	
		//$user	= JFactory::getUser();
		$menus	= $app->getMenu();
		$menu   = $menus->getActive();
		
		$rawDataPost = JRequest::get('POST', 2);
		$rawDataGet = JRequest::get('GET', 2);
		$post = array_merge($rawDataGet, $rawDataPost);
		
		$model=$this->getModel('savedspread');
		$item=$model->getItem();
		$type=$model->getType($item->typeid);
		
		$mailer = JFactory::getMailer();
		
		$config = JFactory::getConfig();
	    $sender_name =  $config->get( 'fromname' );
	    $sender = array(
		    $config->get( 'mailfrom' ),
		    $sender_name );
		 
		$mailer->setSender($sender);
	    
	    $recipient = array($type->admin_email);
	    $mailer->addRecipient($recipient);
	    
	    $info_array=json_decode($item->add_info,true);
	    $info = str_replace(',', '<br/>', $item->add_info);
	    $text = JText::sprintf('COM_SAXUMPICKER_ADMIN_EMAIL_TEXT',$info_array['firstname'],$info_array['lastname'],$menu->title);
	    $ref = JText::_('COM_SAXUMPICKER_REF').': '.$item->id;
	    
	    $body = $item->spread;
	 	$body = base64_decode($body);
	 	$body = $text.'<br/>'.$ref.'<br/>'.$info.'<br/>'.$body;
	
	 	jimport( 'joomla.mail.helper' );

	    $subject = $sender_name . ' - ' . $menu->title;
	
	    $subject = JMailHelper::cleanSubject($subject);
	    $body = JMailHelper::cleanBody($body);
	
		$mailer->isHTML(true);
		$mailer->Encoding = 'base64';
	    $mailer->setSubject($subject);
		$mailer->setBody($body);
	
		$send = $mailer->Send();
		if ( $send !== true ) {
	        JError::raiseNotice( 500, JText::_('COM_SAXUMPICKER_EMAIL_FAILED') );
	    }
	    else {
	    	JError::raiseNotice( 500, JText::_('COM_SAXUMPICKER_EMAIL_SENT') );
	    }
		
	    $this->display();
	}		
			  
	function sendmail()
	{
	    JRequest::checkToken() or jexit( 'Invalid Token' );
		$app	= JFactory::getApplication();	
		$user	= JFactory::getUser();
		$menus	= $app->getMenu();
		$menu   = $menus->getActive();
		$mailer = JFactory::getMailer();
		$rawDataPost = JRequest::get('POST', 2);
		$rawDataGet = JRequest::get('GET', 2);
		$post = array_merge($rawDataGet, $rawDataPost);
		
		$config = JFactory::getConfig();
	    $sender_name =  $config->get( 'fromname' );
	    $sender = array(
		    $config->get( 'mailfrom' ),
		    $sender_name );
		 
		$mailer->setSender($sender);
		
	    $recipient = $post['email'];
	    $mailer->addRecipient($recipient);
	    
	    $body = JRequest::getVar( 'body', '', 'post', 'string', JREQUEST_ALLOWRAW);
	 	$body = base64_decode($body);
	
	 	jimport( 'joomla.mail.helper' );

	    $subject = $sender_name . ' - ' . $menu->title;
	
	    $subject = JMailHelper::cleanSubject($subject);
	    $body = JMailHelper::cleanBody($body);
	
		$mailer->isHTML(true);
		$mailer->Encoding = 'base64';
	    $mailer->setSubject($subject);
		$mailer->setBody($body);
		
		$send = $mailer->Send();
		if ( $send !== true ) {
	        JError::raiseNotice( 500, JText::_('COM_SAXUMPICKER_EMAIL_FAILED') );
	    }
	    else {
	    	JError::raiseNotice( 500, JText::_('COM_SAXUMPICKER_EMAIL_SENT') );
	    }
		
	    $this->display();
	}	
			  
	function save()
	{
	    JRequest::checkToken() or jexit( 'Invalid Token' );
		$app	= JFactory::getApplication();	
		$user	= JFactory::getUser();
		$menus	= $app->getMenu();
		$menu   = $menus->getActive();
		$params = $app->getPageParameters('com_saxumpicker');
	    		
		$rawDataPost = JRequest::get('POST', 2);
		$rawDataGet = JRequest::get('GET', 2);
		$post = array_merge($rawDataGet, $rawDataPost);
	    $body = $post['body'];
	    //$body = JRequest::getVar( 'body', '', 'post', 'string', JREQUEST_ALLOWRAW);
	    $email='';
	    $email=$user->email;
	    if(isset($post['email'])) $email=$post['email'];
	 	
		JTable::addIncludePath(JPATH_COMPONENT_ADMINISTRATOR. DIRECTORY_SEPARATOR . 'tables');
		$row = JTable::getInstance('Spreads','SaxumpickerTable'); 

		$now  = JFactory::getDate();
		$date = $now->toSql();
			 
		//generate public id
		$rnd_id = crypt(uniqid(rand())); 
		//to remove any slashes that might have come 
		$rnd_id = strip_tags(stripslashes($rnd_id)); 
		//Removing any . or / and reversing the string 
		$rnd_id = str_replace(".","",$rnd_id); 
		$rnd_id = strrev(str_replace("/","",$rnd_id)); 
		//finally I take the first 10 characters from the $rnd_id 
		$rnd_id = strtoupper(substr($rnd_id,0,10)); 
		//end generation
		
		$obj = array();
		$obj['userid']=$user->id;
	    $obj['title'] =$menu->title;
	    $obj['tstamp']=$date;
	    $obj['spread']=$body;
	    $obj['typeid']=$post['typeid'];
	    $obj['pmtype']=$post['pmtype'];
	    $obj['publicid']=$rnd_id;
	    unset($post['body']);
	    unset($post['Itemid']);
	    unset($post['option']);
	    unset($post['view']);
	    unset($post['task']);
	    unset($post['saveButton']);
	    $obj['add_info']=json_encode($post);
	    
	    if ($row->save($obj) == true){
	    	JError::raiseNotice( 500, JText::_('COM_SAXUMPICKER_SPREAD_SAVED').' '.$obj['publicid'] );
	    	
	    	if ($params->get('send_after_save')==1 && $email!=''){
			    $mailer = JFactory::getMailer();				
				$config = JFactory::getConfig();
			    $sender_name =  $config->get( 'fromname' );
			    $sender = array(
				    $config->get( 'mailfrom' ),
				    $sender_name );
				 
				$mailer->setSender($sender);
				
			    $recipient = $email;
			    $mailer->addRecipient($recipient);
			    
			    $body = JText::_('COM_SAXUMPICKER_SEND_ID').' '.$obj['publicid'];
			    $body.= '<br/>';
			    $body.= JText::_('COM_SAXUMPICKER_SEND_LINK').' '.JRoute::_('index.php?option=com_saxumpicker&view=savedspread&id=0&publicid='.$obj['publicid'], true, -1);
			
			 	jimport( 'joomla.mail.helper' );
		
			    $subject = $sender_name . ' - ' . $menu->title;
			
			    $subject = JMailHelper::cleanSubject($subject);
			    $body = JMailHelper::cleanBody($body);
			
				$mailer->isHTML(true);
				$mailer->Encoding = 'base64';
			    $mailer->setSubject($subject);
				$mailer->setBody($body);
				
				$send = $mailer->Send();
				if ( $send !== true ) {
			        JError::raiseNotice( 500, JText::_('COM_SAXUMPICKER_EMAIL_FAILED'));
			    }
			    else {
			    	JError::raiseNotice( 500, JText::_('COM_SAXUMPICKER_EMAIL_SENT') );
			    }
	    	}
	    }
	    else {
	        JError::raiseNotice( 500, JText::_('COM_SAXUMPICKER_SAVE_FAILED') );
	    }
		
		$view = $this->getView('spread', 'html'); // get the view
		$view->assignRef('savedid', $obj['publicid']); // set the data to the view
		//JRequest::setVar('savedid',$rnd_id);		
	    $this->display();
	}
	
	function callback()
	{ 
		$rawDataPost = JRequest::get('POST', 2);
		$rawDataGet = JRequest::get('GET', 2);
		$post = array_merge($rawDataGet, $rawDataPost);

		JPluginHelper::importPlugin('saxumpayment',$post['paymentmethod']); // Load plugin
		$dispatcher = JDispatcher::getInstance();
		$result = $dispatcher->trigger('onPaymentCallback',array(
				$post['paymentmethod'],
				$post
			));
				
		if ($result) {
			$db = JFactory::getDbo();
			$query = $db->getQuery(true);
			
			// Fields to update.
			$fields = array('paymentid=\''.$post['txn_id'].'\'');
			 
			// Conditions for which records should be updated.
			$conditions = array('publicid=\''.$post['custom'].'\'');
			 
			$query->update($db->quoteName('#__saxumpicker_saved_spreads'))->set($fields)->where($conditions);
			
			$db->setQuery($query);
	
			//$result = $db->query(); // Use for Joomla 2.5.
			$res=$db->execute();
		}
		
		return true;
			
	}
}
?>