<?php
/**
 * $Id: savedspreads.php 16 2013-12-09 23:13:51Z Szablac $
 * @Project		Saxum Picker Extension/Component
 * @author 		Laszlo Szabo
 * @package		Saxum Picker
 * @copyright	Copyright (C) 2010 Saxum 2003 Bt. All rights reserved.
 * @license 	http://www.gnu.org/licenses/old-licenses/gpl-3.0.html GNU/GPL version 3
*/

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die();

jimport('joomla.application.component.modellist');

class SaxumpickerModelSavedspreads extends JModelList
{	
	public function __construct($config = array())
	{
		if (empty($config['filter_fields'])) {
			$config['filter_fields'] = array(
				'id', 'a.id',
				'name', 'name','a.title','a.publicid','a.tstamp'
			);
		}

		parent::__construct($config);
	}
		
	protected function getListQuery()
	{
		// Create a new query object.		
		$db = JFactory::getDBO();
		$query = $db->getQuery(true);
		// Select some fields
		$query->select(
			$this->getState(
				'list.select',
				'a.*'
			)
		);
		$query->from('#__saxumpicker_saved_spreads a');
		
		$query->select('t.name AS name');
		$query->join('INNER', '`#__users` AS t ON a.userid=t.id');
			
		// Filter by user
		$user		= JFactory::getUser();
		$userId		= $user->id;
		
		if (is_numeric($userId)) {
			$query->where('a.userid = '.(int) $userId);
		}
		
		$typeId = $this->getState('filter.typeid');
		if (is_string($typeId)and $typeId!=='') {
			$query->where('a.title = '. $db->Quote( $typeId));
		}
	
		$startdate = $this->getState('filter.start_date');
		if (!is_null($startdate) and $startdate!='') {
			$query->where('a.tstamp >= '. $db->Quote($startdate));
		}
		$enddate = $this->getState('filter.end_date');
		if (!is_null($enddate) and $enddate!=='') {
			$query->where('a.tstamp <= '. $db->Quote($enddate));
		}
	
		$orderCol	= $this->state->get('list.ordering');
		$orderDirn	= $this->state->get('list.direction');
		$query->order($db->escape($orderCol.' '.$orderDirn));
			
		return $query;
	}
	
	protected function populateState($ordering = null, $direction = null)
	{
		// Initialise variables.
		$app = JFactory::getApplication();

		// Load the filter state.
		$start_date = $app->getUserStateFromRequest($this->context.'.filter.start_date', 'filter_start_date');      
		$this->setState('filter.start_date', $start_date);
       
        $end_date = $app->getUserStateFromRequest($this->context.'.filter.end_date', 'filter_end_date');     
		$this->setState('filter.end_date', $end_date);
        
		$userId = $this->getUserStateFromRequest($this->context.'.filter.userid', 'filter_userid', '');
		$this->setState('filter.userid', $userId);
		
		$typeId = $this->getUserStateFromRequest($this->context.'.filter.typeid', 'filter_typeid', '');
		$this->setState('filter.typeid', $typeId);
		
		$state = $this->getUserStateFromRequest($this->context.'.filter.state', 'filter_state', '', 'string');
		$this->setState('filter.state', $state);

		// List state information.
		parent::populateState('tstamp', 'desc');
	}

	public function getTypes()
	{
		// Create a new query object.
		$db		= $this->getDbo();
		$query	= $db->getQuery(true);

		$query->select('distinct t.title as id, t.title AS name');
		$query->from('#__saxumpicker_saved_spreads AS t');
		$query->order('t.title ASC');

		$db->setQuery($query);
		$result = $db->loadObjectList();

		return $result;
	}
	

}