<?php
/**
 * $Id: router.php 191 2016-07-01 16:12:25Z Szablac $
 * @Project		Saxum Picker Extension/Component
 * @author 		Laszlo Szabo
 * @package		Saxum Picker
 * @copyright	Copyright (C) 2010 Saxum 2003 Bt. All rights reserved.
 * @license 	http://www.gnu.org/licenses/old-licenses/gpl-3.0.html GNU/GPL version 3
*/
defined('_JEXEC') or die('Restricted access'); 

jimport('joomla.application.categories');

function SaxumpickerBuildRoute( &$query )
{
	$app = JFactory::getApplication ();
	$config = JFactory::getConfig ();
	static $appSuffix;
	if ($appSuffix) {
		$config->set ( 'sef_suffix', $appSuffix );
	}
    $segments = array();
    if(isset($query['view']))
    {
    	$segments[] = $query['view'];
        unset( $query['view'] );
    }
    if(isset($query['id']))
    {
        $segments[] = $query['id'];
        unset( $query['id'] );
    };
    if(isset($query['typeid']))
    {
        $segments[] = $query['typeid'];
        unset( $query['typeid'] );
    };
	// UNSET FORMAT
	if (isset ( $query ['format'] )) {
		// Assign and unset
		$segments [] = $query ['format'];
		//unset ( $query ['format'] );
		
		// Manage XML/NOT HTML JDocument format if detected
		$appSuffix = $config->get ( 'sef_suffix' );
		$config->set ( 'sef_suffix', false );
		
		// Manage suffix for backend routing executing site application
		if ($app->getClientId () == 1 && $componentParams->get ( 'sitemap_links_sef', false )) {
			$siteApplication = JApplication::getInstance ( 'site' );
			if (method_exists ( $siteApplication, 'set' )) {
				$siteApplication->set ( 'sef_suffix', false );
			}
		}
	}
    return $segments;
}

function SaxumpickerParseRoute( $segments )
{
       $vars = array();
       switch($segments[0])
       {
			case 'picker':
				$vars['view'] = 'picker';
				$typeid = explode( ':', $segments[1] );
				$vars['typeid'] = (int) $typeid[0];
				break;
			case 'savedspreads':
				$vars['view'] = 'savedspreads';
				break;
			case 'savedspread':
				$vars['view'] = 'savedspread';
				$id = explode( ':', $segments[1] );
				$vars['id'] = (int) $id[0];
				break;
			case 'spread':
				$vars['view'] = 'spread';
				if(isset($segments[1])) $vars['format'] = $segments[1];
				break;
       }
       return $vars;
}
?>