<?php
/**
 * $Id: saxumpicker.php 115 2015-06-11 08:12:28Z Szablac $
 * @Project		Saxum Picker Extension/Component
 * @author 		Laszlo Szabo
 * @package		Saxum Picker
 * @copyright	Copyright (C) 2010 Saxum 2003 Bt. All rights reserved.
 * @license 	http://www.gnu.org/licenses/old-licenses/gpl-3.0.html GNU/GPL version 3
*/

defined('_JEXEC') or die('Restricted access');

$mainframe = JFactory::getApplication();

if ( version_compare( JVERSION, '3.4', '<' ) == 1) {             
   JHTML::_('behavior.formvalidation');
} else {	            
	JHtml::_('jquery.framework', false);
	JHTML::_('behavior.formvalidator');
}

$document = JFactory::GetDocument();
$path = 'components/com_saxumpicker/js/';
if(!JFactory::getApplication()->get('jquery')){
	JFactory::getApplication()->set('jquery',true);
	$filename = 'jquery-1.7.1.js';
	JHTML::script($path.$filename);
}
$filename = 'jQueryRotate.2.1.js';
JHTML::script($path.$filename);
$filename = 'saxumpicker.js';
JHTML::script($path.$filename);

JText::script('COM_SAXUMPICKER_EMAIL_MANDATORY');
JText::script('COM_SAXUMPICKER_QUESTION_MANDATORY');

require_once (JPATH_COMPONENT.DIRECTORY_SEPARATOR.'controller.php');
require_once (JPATH_ADMINISTRATOR.DIRECTORY_SEPARATOR.'components'.DIRECTORY_SEPARATOR.'com_saxumpicker'.DIRECTORY_SEPARATOR.'helpers'.DIRECTORY_SEPARATOR.'saxumpicker.php');
if($controller = JRequest::getWord('controller')) {
	$path = JPATH_COMPONENT.DIRECTORY_SEPARATOR.'controllers'.DIRECTORY_SEPARATOR.$controller.'.php';
	if (file_exists($path)) {
		require_once $path;
	} else {
		$controller = '';
	}
}

$classname	= 'SaxumpickerController'.ucfirst($controller);
$controller = new $classname( );

$controller->execute(JRequest::getCmd('task'));

$controller->redirect();

$params = $mainframe->getPageParameters('com_saxumpicker');
$lang   = JFactory::getLanguage();
$locale = $lang->getTag();

if ($params->get('facebook')==1) {
	$document->addScriptDeclaration("
		(function(d, s, id) {
		  var js, fjs = d.getElementsByTagName(s)[0];
		  if (d.getElementById(id)) return;
		  js = d.createElement(s); js.id = id;
		  js.src = \"//connect.facebook.net/".str_replace("-","_",$locale)."/all.js#xfbml=1\";
		  fjs.parentNode.insertBefore(js, fjs);
		}(document, 'script', 'facebook-jssdk'));
		");
}
if ($params->get('gplus')==1) {
	$document->addScriptDeclaration("
			window.___gcfg = {
				lang: '".$locale."'
			};
		
		  (function() {
		    var po = document.createElement('script'); po.type = 'text/javascript'; po.async = true;
		    po.src = 'https://apis.google.com/js/platform.js';
		    var s = document.getElementsByTagName('script')[0]; s.parentNode.insertBefore(po, s);
		  })();
		");
}

$rotation=$params->get('rotation');
$agent=getenv("HTTP_USER_AGENT");
if (!(preg_match("/MSIE 6/",$agent) || preg_match("/MSIE 7/",$agent) || preg_match("/MSIE 8/",$agent) ) and $rotation==1 ) {
	$angle=$params->get('angle');
	if ($angle==null) $angle=15;
	
		$document->addScriptDeclaration("
		(function($){
		$(document).ready(function() {
			var numbers=document.getElementById('numbers');
			for (j=0;j<numbers.value; j++){
				$('#'+j).rotate(Math.floor(Math.random() * (2*".$angle.") - ".$angle."));
			}
		});
		} ) ( jQuery );
		");
	
}
?>

