<?php
/**
 * $Id: view.html.php 60 2014-07-09 11:54:26Z Szablac $
 * @Project		Saxum Picker Extension/Component
 * @author 		Laszlo Szabo
 * @package		Saxum Picker
 * @copyright	Copyright (C) 2010 Saxum 2003 Bt. All rights reserved.
 * @license 	http://www.gnu.org/licenses/old-licenses/gpl-3.0.html GNU/GPL version 3
*/

defined('_JEXEC') or die();

jimport( 'joomla.application.component.view' );

class SaxumpickerViewPicker extends JViewLegacy
{
	function display($tpl = null)
	{	
	    // Use our own browser side cache settings - because using browser's Back button.
	    JResponse::allowCache(true);
		JResponse::setHeader( 'Expires', 'Mon, 1 Jan 2001 00:00:00 GMT', true );
	    JResponse::setHeader( 'Last-Modified', gmdate("D, d M Y H:i:s") . ' GMT', true );
	    JResponse::setHeader( 'Cache-Control', 'no-store, must-revalidate, post-check=0, pre-check=0', true );
    
		$mainframe	= JFactory::getApplication();

		$user		= JFactory::getUser();
		$pathway	= $mainframe->getPathway();
		$document	= JFactory::getDocument();
		$model		= $this->getModel();

		// Get the parameters of the active menu item
		$menus	= $mainframe->getMenu();
		$menu   = $menus->getActive();

		$Itemid = JRequest::getInt('Itemid',0);
		$typeid = JRequest::getInt('typeid',0);
		$pparams = $mainframe->getPageParameters('com_saxumpicker');
		
		// Push a model into the view
		$model	= $this->getModel();

		// query options
		$options['typeid']	= $typeid;

		$item	= $model->getItem( $options );
		$type	= $model->getType($typeid);
		
		JHTML::_('behavior.formvalidation');
		
		$imagePath	= SaxumpickerHelper::getPathSet('');
		$check['l']	= SaxumpickerHelper::render();
		$path	= str_replace ( '../', JURI::root(), $imagePath['orig_rel_ds']);
		
		$this->assignRef('Itemid',	$Itemid);		
		$this->assignRef('item',	$item);		
		$this->assignRef('params',	$pparams);
		$this->assignRef('type',	$type);
		$this->assignRef('path', 	$path);
		$this->assignRef('check',	$check);
		$this->assignRef('user', 	$user);
		$this->assignRef('menu', 	$menu);

		$this->_prepareDocument();
		parent::display($tpl);
	}
	
	protected function _prepareDocument()
	{
		$app		= JFactory::getApplication();
		$menus		= $app->getMenu();
		$title 		= null;

		// Because the application sets a default page title,
		// we need to get it from the menu item itself
		$menu = $menus->getActive();
		if ($menu)
		{
			$this->params->def('page_heading', $this->params->get('page_title', $menu->title));
		} else {
			$this->params->def('page_heading', JText::_('JGLOBAL_ARTICLES'));
		}

		$title = $this->params->get('page_title', '');
		if (empty($title)) {
			$title = $app->getCfg('sitename');
		}
		elseif ($app->getCfg('sitename_pagetitles', 0) == 1) {
			$title = JText::sprintf('JPAGETITLE', $app->getCfg('sitename'), $title);
		}
		elseif ($app->getCfg('sitename_pagetitles', 0) == 2) {
			$title = JText::sprintf('JPAGETITLE', $title, $app->getCfg('sitename'));
		}
		$this->document->setTitle($title);

		if ($this->params->get('menu-meta_description'))
		{
			$this->document->setDescription($this->params->get('menu-meta_description'));
		}

		if ($this->params->get('menu-meta_keywords'))
		{
			$this->document->setMetadata('keywords', $this->params->get('menu-meta_keywords'));
		}

		if ($this->params->get('robots'))
		{
			$this->document->setMetadata('robots', $this->params->get('robots'));
		}
	}	
}
?>