<?php
/**
 * $Id: view.html.php 60 2014-07-09 11:54:26Z Szablac $
 * @Project		Saxum Picker Extension/Component
 * @author 		Laszlo Szabo
 * @package		Saxum Picker
 * @copyright	Copyright (C) 2010 Saxum 2003 Bt. All rights reserved.
 * @license 	http://www.gnu.org/licenses/old-licenses/gpl-3.0.html GNU/GPL version 3
*/
// No direct access to this file
defined('_JEXEC') or die('Restricted access');
 
// import Joomla view library
jimport('joomla.application.component.view');
 
class SaxumpickerViewSavedspread extends JViewLegacy
{

	public function display($tpl = null) 
	{
		$app		= JFactory::getApplication();
		$menus		= $app->getMenu();
		$pathway	= $app->getPathway();
		
		$this->params = JComponentHelper::getParams( 'com_saxumpicker' );

		$user		= JFactory::getUser();
		$document	= JFactory::getDocument();

		$menu   = $menus->getActive();
		$model	= $this->getModel();
		
		// get the Data
		$this->item		= $this->get('Item');
		$check['l']	= SaxumpickerHelper::render();
		if ($this->item) $type=$model->getType( $this->item->typeid );
 
		// Check for errors.
		if (count($errors = $this->get('Errors'))) {
			JError::raiseError(500, implode("\n", $errors));
			return false;
		}
  
		$this->assignRef('user', 	$user);
		$this->assignRef('menu', 	$menu);
		$this->assignRef('check', 	$check);
		$this->assignRef('type', 	$type);
		
		// Display the template
		$this->_prepareDocument();
		parent::display($tpl);
	}
	
	protected function _prepareDocument()
	{
		$app		= JFactory::getApplication();
		$menus		= $app->getMenu();
		$title 		= null;

		// Because the application sets a default page title,
		// we need to get it from the menu item itself
		$menu = $menus->getActive();
		if ($menu)
		{
			$this->params->def('page_heading', $this->params->get('page_title', $menu->title));
		} else {
			$this->params->def('page_heading', JText::_('JGLOBAL_ARTICLES'));
		}

		$title = $this->params->get('page_title', '');
		if (empty($title)) {
			$title = $app->getCfg('sitename');
		}
		elseif ($app->getCfg('sitename_pagetitles', 0) == 1) {
			$title = JText::sprintf('JPAGETITLE', $app->getCfg('sitename'), $title);
		}
		elseif ($app->getCfg('sitename_pagetitles', 0) == 2) {
			$title = JText::sprintf('JPAGETITLE', $title, $app->getCfg('sitename'));
		}
		$this->document->setTitle($title);

		if ($this->params->get('menu-meta_description'))
		{
			$this->document->setDescription($this->params->get('menu-meta_description'));
		}

		if ($this->params->get('menu-meta_keywords'))
		{
			$this->document->setMetadata('keywords', $this->params->get('menu-meta_keywords'));
		}

		if ($this->params->get('robots'))
		{
			$this->document->setMetadata('robots', $this->params->get('robots'));
		}
	}
 
}