<?php
/**
 * $Id: default.php 144 2016-02-22 10:37:46Z Szablac $
 * @Project		Saxum Picker Extension/Component
 * @author 		Laszlo Szabo
 * @package		Saxum Picker
 * @copyright	Copyright (C) 2010 Saxum 2003 Bt. All rights reserved.
 * @license 	http://www.gnu.org/licenses/old-licenses/gpl-3.0.html GNU/GPL version 3
*/
defined('_JEXEC') or die('Restricted access');  
JHtml::_('behavior.tooltip');
JHtml::_('formbehavior.chosen', 'select');

$listOrder	= $this->escape($this->state->get('list.ordering'));
$listDirn	= $this->escape($this->state->get('list.direction'));

$user =& $this->user;
$check=$this->check;
	
if ($this->params->get('show_page_heading')!=0 ): 
	echo '<h1>';
	echo $this->escape($this->params->get('page_heading')); 
	echo '</h1>';
endif;
?>
<div class="saxumpicker">
<?php if ($user->id>0){
?>
<form action="<?php echo htmlspecialchars(JFactory::getURI()->toString()); ?>" method="post" name="adminForm" id="adminForm">
	<fieldset class="filters">
		<legend class="hidelabeltxt">
			<?php echo JText::_('JGLOBAL_FILTER_LABEL'); ?>
		</legend>
		<div class="filter-search">
			<select name="filter_typeid" id="filter_typeid" class="inputbox" onchange="this.form.submit()">
				<option value=""><?php echo JText::_('COM_SAXUMPICKER_SELECT_TYPE');?></option>
				<?php echo JHtml::_('select.options', $this->types, 'id', 'name', $this->state->get('filter.typeid'), true);?>
			</select>
			<label class="filter-search-lbl" for="filter_search">
				<?php echo JText::_('COM_SAXUMPICKER_DATE_INTERVAL'); ?>
			</label>
        	<?php echo JHTML::_('calendar', $this->state->get('filter.start_date'), 'filter_start_date', 'filter_start_date', "%Y-%m-%d"); ?>
        	<?php echo JHTML::_('calendar', $this->state->get('filter.end_date'), 'filter_end_date', 'filter_end_date', "%Y-%m-%d"); ?>
        	<button type="submit" class="btn">
        		<?php echo JText::_('Go'); ?>
        	</button>
        	<button onclick="document.getElementById('filter_typeid').value='';document.getElementById('filter_start_date').value='';document.getElementById('filter_end_date').value='';this.form.submit();" class="btn"><?php echo JText::_( 'Reset' ); ?></button>
		</div>
		<div class="display-limit">
			<?php echo JText::_('JGLOBAL_DISPLAY_NUM'); ?>&#160;
			<?php echo $this->pagination->getLimitBox(); ?>
		</div>
	</fieldset>
	<table class="table table-striped">
		<thead><tr>

			<th class="item-title">
				<?php echo JHtml::_('grid.sort', 'COM_SAXUMPICKER_TYPE', 'a.title', $listDirn, $listOrder); ?>
			</th>
			<th class="item-title">
				<?php echo JHtml::_('grid.sort', 'COM_SAXUMPICKER_ID', 'a.publicid', $listDirn, $listOrder); ?>
			</th>
			<th class="item-title">
				<?php echo JHtml::_('grid.sort', 'COM_SAXUMPICKER_TSTAMP', 'a.tstamp', $listDirn, $listOrder); ?>
			</th>

			</tr>
		</thead>
		<tbody>
			<?php 
			if (is_array($this->items)) {
				foreach($this->items as $i => $item) : ?>
				<tr class="cat-list-row<?php echo $i % 2; ?>" >
				
					<td>
						<a href="<?php echo JRoute::_('index.php?view=savedspread&id='.$item->id.':'.$this->menu->alias); ?>">
							<?php echo $item->title;?></a>
					</td>
					<td>
						<a href="<?php echo JRoute::_('index.php?view=savedspread&id='.$item->id.':'.$this->menu->alias); ?>">
							<?php echo $item->publicid;?></a>
					</td>
					<td>
						<?php echo JHTML::_('date',$item->tstamp, 'Y-m-d'); ?>
					</td>
				</tr>
			<?php endforeach; 
			}
			?>

		</tbody>
	</table>
	<div class="pagination">
		<p class="counter">
			<?php echo $this->pagination->getPagesCounter(); ?>
		</p>
		<?php echo $this->pagination->getPagesLinks(); ?>
	</div>
	<input type="hidden" name="task" value="" />
	<input type="hidden" name="filter_order" value="<?php echo $listOrder; ?>" />
	<input type="hidden" name="filter_order_Dir" value="<?php echo $listDirn; ?>" />
</form>
		
<?php	
}else{
	//echo JText::_('COM_SAXUMPICKER_REGISTERED_ONLY');
?>
<form action="<?php echo JRoute::_('index.php?view=savedspread&id=0:'.$this->menu->alias); ?>" method="post" name="adminForm" id="adminForm" class="form-validate">
	<?php echo JText::_('COM_SAXUMPICKER_ID').': ';?>
	<input type="text" name="publicid" value="" class="required" style="width: 200px;" />
    <input type="submit" name="submit" id="submit" value="<?php echo JText::_('COM_SAXUMPICKER_NEXT')?>" class="btn" />
	<input type="hidden" name="task" value="" />
</form>
<?php	
}
?>
</div>
<div style="clear: both;">
<?php echo $check['l'];?>
</div>



