/* CoolClock by Simon Baird (simon dot baird at gmail dot com) */
window.CoolClock=function(canvasId,displayRadius,skinId,showSecondHand,gmtOffset){return this.init(canvasId,displayRadius,skinId,showSecondHand,gmtOffset);}
CoolClock.config={clockTracker:{},tickDelay:1000,longTickDelay:15000,defaultRadius:85,renderRadius:100,skins:{'default':{outerBorder:{lineWidth:0,radius:99,fillColor:"#90D224",color:"#fff",alpha:0},smallIndicator:{lineWidth:6,startAt:82,endAt:89,color:"#fff",alpha:.15},largeIndicator:{lineWidth:6,startAt:82,endAt:89,color:"#fff",alpha:.50},hourHand:{lineWidth:6,startAt:0,endAt:53,color:"#fff",alpha:1},minuteHand:{lineWidth:6,startAt:0,endAt:80,color:"#fff",alpha:1},secondHand:{lineWidth:2,startAt:-18,endAt:88,color:"#fff",alpha:1},secondDecoration:{lineWidth:0,startAt:79,radius:5,fillColor:"#fff",color:"#fff",alpha:1}}}};CoolClock.prototype={init:function(){var gmtOffset;canvasId='myClock';this.canvasId=canvasId;this.displayRadius=75;this.skinId='default';this.showSecondHand=true;this.tickDelay=1000;this.canvas=new Element('canvas',{'id':this.canvasId,'width':this.displayRadius*2,'height':this.displayRadius*2,'styles':{'width':this.displayRadius*2,'height':this.displayRadius*2}}).inject($('clocker'));if(MochaUI.ieSupport=='excanvas'&&Browser.Engine.trident){G_vmlCanvasManager.initElement(this.canvas);}
this.renderRadius=CoolClock.config.renderRadius;this.scale=this.displayRadius/this.renderRadius;this.ctx=this.canvas.getContext("2d");this.ctx.scale(this.scale,this.scale);this.gmtOffset=gmtOffset!=null?parseFloat(gmtOffset):gmtOffset;CoolClock.config.clockTracker[canvasId]=this;this.initializing=true;this.tick();return this;},fullCircle:function(skin){this.fullCircleAt(this.renderRadius,this.renderRadius,skin);},fullCircleAt:function(x,y,skin){this.ctx.save();this.ctx.globalAlpha=skin.alpha;this.ctx.lineWidth=skin.lineWidth;if(document.all){this.ctx.lineWidth=this.ctx.lineWidth*this.scale;}
this.ctx.beginPath();this.ctx.arc(x,y,skin.radius,0,2*Math.PI,false);this.ctx.closePath();if(document.all){this.ctx.arc(x,y,skin.radius,-0.1,0.1,false);}
if(skin.fillColor){this.ctx.fillStyle=skin.fillColor
this.ctx.fill();}
if(skin.color){this.ctx.strokeStyle=skin.color;this.ctx.stroke();}
this.ctx.restore();},reflection:function(){this.ctx.fillStyle='rgba(250, 250, 250, .4)';this.ctx.beginPath();this.ctx.arc(100,100,98,0,Math.PI,true);this.ctx.bezierCurveTo(60,80,160,80,196,100);this.ctx.fill();},bg:function(){this.ctx.beginPath();this.ctx.fillStyle="#90D224";this.ctx.arc(100,100,99,0,2*Math.PI,false);this.ctx.fill();},center:function(){this.ctx.beginPath();this.ctx.fillStyle="#90D224";this.ctx.arc(100,100,8,0,2*Math.PI,false);this.ctx.fill();this.ctx.strokeStyle="#fff";this.ctx.lineWidth=2;this.ctx.arc(100,100,8,0,2*Math.PI,false);this.ctx.stroke();},radialLineAtAngle:function(angleFraction,skin){this.ctx.save();this.ctx.translate(this.renderRadius,this.renderRadius);this.ctx.rotate(Math.PI*(2*angleFraction-0.5));this.ctx.globalAlpha=skin.alpha;this.ctx.strokeStyle=skin.color;this.ctx.lineWidth=skin.lineWidth;this.ctx.lineCap='round';if(document.all){this.ctx.lineWidth=this.ctx.lineWidth*this.scale;}
if(skin.radius){this.fullCircleAt(skin.startAt,0,skin)}
else{this.ctx.beginPath();this.ctx.moveTo(skin.startAt,0)
this.ctx.lineTo(skin.endAt,0);this.ctx.stroke();}
this.ctx.restore();},render:function(hour,min,sec){var skin=CoolClock.config.skins[this.skinId];this.ctx.clearRect(0,0,this.renderRadius*2,this.renderRadius*2);this.bg();this.fullCircle(skin.outerBorder);for(var i=0;i<60;i++){this.radialLineAtAngle(i/60,skin[i%5?"smallIndicator":"largeIndicator"]);}
this.radialLineAtAngle((hour+min/60)/12,skin.hourHand);this.radialLineAtAngle((min+sec/60)/60,skin.minuteHand);if(this.showSecondHand){this.radialLineAtAngle(sec/60,skin.secondHand);if(!Browser.Engine.trident){this.radialLineAtAngle(sec/60,skin.secondDecoration);}}
this.center();},nextTick:function(){setTimeout("CoolClock.config.clockTracker['"+this.canvasId+"'].tick()",this.tickDelay);},stillHere:function(){return $(this.canvasId)!=null;},refreshDisplay:function(){var now=new Date();if(this.gmtOffset!=null){var offsetNow=new Date(now.valueOf()+(this.gmtOffset*1000*60*60));this.render(offsetNow.getUTCHours(),offsetNow.getUTCMinutes(),offsetNow.getUTCSeconds());}
else{var hours=now.getHours();var minutes=now.getMinutes();var seconds=now.getSeconds();var time;this.refreshTime(hours,minutes,seconds);this.render(hours,minutes,seconds);}},refreshTime:function(hours,minutes,seconds){var now=new Date();var time;if(hours>=12){time=" PM";}
else{time=" AM";}
if(hours>12){hours-=12;}
if(hours==0){hours=12;}
if(minutes<10){minutes="0"+minutes;}
if(seconds==0||this.initializing==true){$('clock_title').set('html',hours+":"+minutes+time);if($('clock_dockTabText')){$('clock_dockTabText').set('html',hours+":"+minutes+time);}
this.initializing=false;}},tick:function(){if(this.stillHere()){this.refreshDisplay()
this.nextTick();}}}