<?php

    ///////////////////////////////////////////////////////////
    // razorCMS                                              //
    // install.php                                           //
    // GPLv3                                                 //
    // smiffy6969                                            //
    // www.razorcms.co.uk                                    //
    // www.mis-limited.com                                   //
    // 03/2008                                               //
    // ----------------------------------------------------- //
    // V0.1  -  03/2008  -  Version 0.1 first release        //
    // ----------------------------------------------------- //
    // V0.2  -  06/2008  -  This file contains changes for   //
    //                      up issue to V0.2BETA and RC      //
    // ----------------------------------------------------- //
    // V0.2  -  08/2008  -  RC2 Bug fix release              //
    //                      No changes to this file          //
    // ----------------------------------------------------- //
    // V0.3  -  11/2008  -  BETA1 Bug fix and new features   //
    // ----------------------------------------------------- //
    // V0.3  -  12/2008  -  RC Bug fix and code walk         //
    // ----------------------------------------------------- //
    // V0.3  -  02/2009  -  RC2 Bug fix, code walk and some  //
    //                      movement of functions.           //
    // ----------------------------------------------------- //
    // V1.0  -  06/2009  -  ALPHA Security, Bug fix and new  //
    //                      functionality                    //
    // ----------------------------------------------------- //
    // V1.0  -  07/2009  -  BETA Bug fix and new             //
    //                      functionality                    //
    // ----------------------------------------------------- //
    // V1.0  -  08/2009  -  BETA2 Bug fix and new            //
    //                      functionality                    //
    // ----------------------------------------------------- //
    // V1.0  -  09/2009  -  RC Bug fix                       //
    // ----------------------------------------------------- //
    // V1.0  -  10/2009  -  Stable - Bug fix                 //
    // ----------------------------------------------------- //
    // V1.1  -  06/2010  -  Stable - Bug fix + Security fix  //
    // ----------------------------------------------------- //
    // V1.2  -  09/2011  -  Stable - Bug fix + Security fix  //
	//                      + Features                       //
    // ----------------------------------------------------- //
    ///////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////

    ///////////////////////////////////////////////////////////
    //    General purpose variables for installer to work    //
    ///////////////////////////////////////////////////////////

    $RAZOR = array();

    // location of logs directory //
    $RAZOR['logs_dir'] = 'datastore/razor_temp_logs/';

    // location of failed login log //
    $RAZOR['failed_logs'] = 'razor_failed_login.txt';

    // location of datastore directory //
    $RAZOR['datastore_dir'] = 'datastore/';

    // location of system data file razor_data.txt //
    $RAZOR['pages_info'] = 'datastore/razor_data.txt';

    // location of pages dir for stored content //
    $RAZOR['pages_dir'] = 'datastore/pages/';

    // location of media dir for stored content //
    $RAZOR['media_dir'] = 'datastore/media/';

    // location of blade packs //
    $RAZOR['bladepack_dir'] = 'blade_packs/';

    // name of homepage filename //
    $RAZOR['index_filename'] = 'index.php';

    // name and location of admin filename //
    $RAZOR['admin_filename'] = 'admin/index.php';

    // name and location of admin config //
    $RAZOR['admin_config'] = 'admin/core/admin_config.php';

    // name and location of default public CSS file //
    $RAZOR['css_file_name'] = 'theme/default_css.css';

    // path to script directory to use in themes //
    $RAZOR['script_path'] = 'theme/scripts/';

    // default content name, sets the name of content loaded into the page //
    $RAZOR['default_content_name'] = 'slab';

    // default file upload limit for media manager in kb, eg 250 = 250kb //
    $RAZOR['default_upload_limit'] = '500';

    // sets amount of time max login attempts allowed in seconds eg 3600 = 60min //
    $RAZOR['razor_logat_time'] = 3600;

    // sets amount of failed login attempts allowed in time above //
    $RAZOR['razor_log_att'] = 8;

    // coning amount to reduce logs when checking, will not check more than this amount in the max time //
    $RAZOR['razor_log_amount'] = 60;

    ///////////////////////////////////////////////
    //  Assigning variables into data constants  //
    //          DO NOT EDIT THESE LINES          //
    ///////////////////////////////////////////////

    define( 'RAZOR_LOGS_DIR' , $RAZOR['logs_dir'] );
    define( 'RAZOR_FAILED_LOGIN_LOG' , $RAZOR['failed_logs'] );
    define( 'RAZOR_DATASTORE_DIR' , $RAZOR['datastore_dir'] );
    define( 'RAZOR_DATA' , $RAZOR['pages_info'] );
    define( 'RAZOR_EXTENSIONS_ORDER' , "php,html,htm,txt" );
    define( 'RAZOR_PAGES_DIR' , $RAZOR['pages_dir'] );
    define( 'RAZOR_MEDIA_DIR' ,  $RAZOR['media_dir'] );
    define( 'RAZOR_URL_FORMAT' , $RAZOR['index_filename'].'?'.$RAZOR['default_content_name'].'=%s' );
    define( 'RAZOR_ADMIN_FILENAME' , $RAZOR['admin_filename'] );
    define( 'RAZOR_ADMIN_CONFIG' , $RAZOR['admin_config'] );
    define( 'RAZOR_HOME_FILENAME' , $RAZOR['index_filename'] );
    define( 'RAZOR_BLADEPACK_DIR' , $RAZOR['bladepack_dir'] );
    define( 'RAZOR_CSS_FILE' , $RAZOR['css_file_name'] );
    define( 'RAZOR_SCRIPT_PATH' , $RAZOR['script_path'] );
    define( 'RAZOR_DEFAULT_CONTENT_NAME' , $RAZOR['default_content_name'] );
    define( 'RAZOR_UPLOAD_LIMIT' , $RAZOR['default_upload_limit'] );
    define( 'RAZOR_LOGAT_TIME' , $RAZOR['razor_logat_time'] );
    define( 'RAZOR_LOG_ATT' , $RAZOR['razor_log_att'] );
    define( 'RAZOR_LOG_AMOUNT' , $RAZOR['razor_log_amount'] );

    $adminUserName = '';
    $adminPassWord = '';
    $adminPassWordC = '';

    ///////////////////////////////////////////////////////////
    //    General purpose functions for installer to work    //
    ///////////////////////////////////////////////////////////

    // message system for process messages //
    function MsgBox($msg,$class='greenbox',$style='',$echo=true) {
        $t = "<div class='$class' style=\"$style\">$msg</div>";
        if( $echo ) {
            echo $t;
        } else {
            return $t;
        }
    }
    // end //////////////////////////////////

    // copy dir plus contents //
    function copyDirR($fromDir, $toDir) {
        $result = false;
        $readFromDir = getSystemRoot(RAZOR_ADMIN_FILENAME).$fromDir;
        $readToDir = getSystemRoot(RAZOR_ADMIN_FILENAME).$toDir;
        createDir($toDir, false);
        if (is_dir($readFromDir)) {
            $filesArray = array();
            $filesArray = readDirContents($readFromDir);
            // do recursive copy if dir contains files //
            foreach($filesArray as $name) {
                if (is_dir($readFromDir.'/'.$name)) {
                    $result = copyDirR($fromDir.'/'.$name, $toDir.'/'.$name);
                } elseif (file_exists($readFromDir.'/'.$name)) {
                    $mode = FTP_ASCII;
                    $result = copyFile($fromDir.'/'.$name, $toDir.'/'.$name, false);
                }
            }
        }
        return $result;
    }
    // end ///////////

    // copy a file //
    function copyFile($copyFrom, $copyTo, $msgOut = true) {
        $fileFrom = getSystemRoot(RAZOR_ADMIN_FILENAME).$copyFrom;
        $fileTo = getSystemRoot(RAZOR_ADMIN_FILENAME).$copyTo;
        if (copy($fileFrom, $fileTo)) {
            if (findServerOS() == 'LINUX') {
                $perms = file_perms($fileTo);
                if ( $perms != '0644') {
                    chmod($fileTo, 0644);
                }
            }
            if($msgOut) {
                MsgBox( "File copy complete", 'greenbox' );
            }
            return true;
        } else {
            if($msgOut) {
                MsgBox( "File copy error", 'redbox' );
            }
            return false;
        }
    }
    // end ///////////

    // function for writing to a file //
    function saveAdminDetails($remote_file,$contents) {
        $ftpFilePath = $remote_file;
        $filename = $remote_file;
        $f=@fopen($filename,"w");
        if (!$f) {
            return false;
        } else {
            fwrite($f,$contents);
            fclose($f);
            $perms = sprintf('%o', fileperms($filename));
            if ( $perms != '100644' && findServerOS() == 'LINUX') {
                $paDirContents = opendir($pagesDir);
                chmod($filename, 0644);
                @closedir($paDirContents);
            }
            return true;
        }
    }
    // end /////////////////////////////

    // delete file //
    function deleteFile($remote_file) {
        if ( @unlink($remote_file) ) {
            return true;
        } else {
            return false;  
        }
    }
    // end ///////////

    // work out file permissions for linux //
    function file_perms($file)
    {
        if(!file_exists($file)) {
            return false;
        }
        $perms = sprintf('%o', fileperms($file));
        if ( substr($perms, 0, 2) == '40' ) {
            $perms = substr($perms, 1, 4);
        } elseif ( substr($perms, 0, 2) == '10' ) {
            $perms = substr($perms, 2, 4);
        }
        return $perms;
    }
    // end /////////////////////////////////

    // function to obscure passwords //
    function createHash($inText, $saltHash=NULL, $mode='sha1'){
        // check if hash function available, else fallback to sha1 //
        $hashOK = false;
        if(function_exists('hash')) {
            $hashOK = true;        
        }
        // hash the text //
        if($hashOK) {
            $textHash = hash($mode, $inText);
        } else {
            $textHash = sha1($inText);
        }
        // set where salt will appear in hash //
        $saltStart = strlen($inText);
        // if no salt given create random one //
        if($saltHash == NULL) {
            if($hashOK) {
                $saltHash = hash($mode, uniqid(rand(), true));
            } else {
                $saltHash = sha1(uniqid(rand(), true));
            }
        }
        // add salt into text hash at pass length position and hash it //
        if($saltStart > 0 && $saltStart < strlen($saltHash)) {
            $textHashStart = substr($textHash,0,$saltStart);
            $textHashEnd = substr($textHash,$saltStart,strlen($saltHash));
            if($hashOK) {
                $outHash = hash($mode, $textHashEnd.$saltHash.$textHashStart);
            } else {
                $outHash = sha1($textHashEnd.$saltHash.$textHashStart);
            }
        } elseif($saltStart > (strlen($saltHash)-1)) {
            if($hashOK) {
                $outHash = hash($mode, $textHash.$saltHash);
            } else {
                $outHash = sha1($textHash.$saltHash);
            }
        } else {
            if($hashOK) {
                $outHash = hash($mode, $saltHash.$textHash);
            } else {
                $outHash = sha1($saltHash.$textHash);
            }
        }
        // put salt at front of hash //
        $output = $saltHash.$outHash;
        return $output;
    }
    // end ///////////////////////////

    // detect server OS type //
    function findServerOS() {
        if (strtoupper(substr(PHP_OS, 0, 3)) === 'WIN') {
            $OSType = 'WIN';
        } elseif (strtoupper(substr(PHP_OS, 0, 5)) === 'LINUX') {
            $OSType = 'LINUX';
        }
        return $OSType;
    }
    // end ////////////////////

    // find system root, specify what to chop off end of running script //
    function getSystemRoot($ignoreEnd) {
        $rootAddress = array();
        $rootAddress = explode($ignoreEnd, $_SERVER['PHP_SELF']);
        if ( $ignoreEnd == RAZOR_ADMIN_FILENAME ) {
             return '../';      
        } else {
            return '';
        }
    }
    // end ///////////////////////////////////////////////////////////////

    //////////////////////////
    //  Installer functions //
    //////////////////////////

    // check admin details correct //
    function checkAdminDetails() {
       global $adminUserName, $adminPassWord, $adminPassWordC;

       $adminUserName = $_POST['adminUser'];
       $adminPassWord = $_POST['adminPass'];
       $adminPassWordC = $_POST['adminPassC'];

       // validate username //
       if(!isset($_POST['adminUser'])) {
           $result = '<div class="contentinstallred"><p>Error a username field is empty...</p></div>';
           return $result;
       } else {
           if($adminUserName == '' || preg_match('/[!$%^&*():;@~#<>?\'"|{}]/', $adminUserName)) {
               $result = '<div class="contentinstallred"><p>Error invalid character in username field...</p></div>';
               return $result;
           }
       }

       // validate password fields (already sha coded so no real validation needed as its encoded) //
       if(!isset($_POST['adminPass']) || !isset($_POST['adminPassC'])) {
           $result = '<div class="contentinstallred"><p>Error a password field is empty...</p></div>';
           return $result;
       } else {
           if($_POST['adminPass'] == '' || $_POST['adminPassC'] == '') {
               $result = '<div class="contentinstallred"><p>Error a password field is empty...</p></div>';
               return $result;
           }
           if($adminPassWord != $adminPassWordC) {
               $result = '<div class="contentinstallred"><p>Error passwords do not match...</p></div>';
               return $result;
           }
       }
       return false;
    }
    // end /////////////////////////////

    // Write file write admin details //
    function writeFileAdminDetails() {
       global $adminUserName, $adminPassWord;
       include_once("admin/core/admin_config.php");

       $adminFile = 'admin/core/admin_config.php';
       $adminProfile = file_get_contents( $adminFile );
       if (isset($adminProfile)) { 
           $adminProfile = str_replace("RAZOR['sadmin_username'] = 'razor'", "RAZOR['sadmin_username'] = '".$adminUserName."'", $adminProfile);
           $adminProfile = str_replace("RAZOR['sadmin_password'] = '".createHash('razor',substr(RAZOR_SADMIN_PASS,0,(strlen(RAZOR_SADMIN_PASS)/2)),'sha1')."'", "RAZOR['sadmin_password'] = '".createHash($adminPassWord,NULL,'sha1')."'", $adminProfile);
       }
       saveAdminDetails($adminFile,$adminProfile);
    }
    // end /////////////////////////////

    // complete install script //
    function completeInstall() {
        global $content;
            if(isset($_GET['type']) && $_GET['type'] == 'complete') {
                $tempPath = explode("install",$_SERVER['REQUEST_URI']);
                if($_SERVER['SERVER_PORT'] != '80') {
                    $serverPort = ':'.$_SERVER['SERVER_PORT'];
                } else {
                    $serverPort = '';
                }
                if(isset($_POST['deleteinstall']) && $_POST['deleteinstall']) {
                    if(deleteFile('install.php') && deleteFile('razorCMS_parcel.zip') && deleteFile('pclzip.lib.php')) {
                        if (isset($_POST['website'])){
                            $pathToInstall = $_SERVER['SERVER_NAME'].$serverPort.$tempPath[0];
                            header("Location: http://$pathToInstall");
                        } elseif(isset($_POST['admin'])) {
                            $pathToInstall = $_SERVER['SERVER_NAME'].$serverPort.$tempPath[0].'admin';
                            header("Location: http://$pathToInstall");
                        }
                    } else {
                        $content.= '<div class="contentinstall"><h2>Install Completed with Error</h2><p>razorCMS installer was unable to correctly delete itself, this is normally due to a permissions error with your server, please delete the install.php file, razorCMS_parcel.zip archive and pclzip.lib.php class from the installed root of your server manually before you can view your website home page.</p>';
                        $content.= '</div><form action="?type=complete" method="post">';
                        $content.= '<input class="button" type="submit" name="website" value="Proceed to website"> <input class="button" type="submit" name="admin" value="Proceed to admin"></form><p></p>';                    
                    }
                } elseif ($_POST['website'] || $_POST['admin']) {
                    if (isset($_POST['website'])){
                        $pathToInstall = $_SERVER['SERVER_NAME'].$serverPort.$tempPath[0];
                        header("Location: http://$pathToInstall");
                    } elseif(isset($_POST['admin'])) {
                        $pathToInstall = $_SERVER['SERVER_NAME'].$serverPort.$tempPath[0].'admin';
                        header("Location: http://$pathToInstall");
                    }
                }
            } else {
                $content.= '<h2>To complete installation</h2><p>Finally to complete your installation, choose from the options below to either delete the installer files or simply continue and delete manually later.</p>';
                if (findServerOS() == 'LINUX') {
                    $content.= '<p><b>PLEASE NOTE : Please ensure you set your install root directory back to 755 permissions using your ftp client, this will ensure you keep the installation as tight as possible. Please do this after you have continued using one of the buttons below.</b></p>';
                }
                $content.= '</div><form action="?type=complete" method="post">';
                $content.= '<input type="checkbox" name="deleteinstall" value="deleteinstall" checked /><label for="deleteinstall">Delete install files</label><br />';
                $content.= '<br /><input class="button" type="submit" name="website" value="Proceed to website"> <input class="button" type="submit" name="admin" value="Proceed to admin"></form><p></p>';
            }
    }
    /////////////////////////////

    //////////////////////////
    //    Installer code    //
    //////////////////////////

    $fileWrite = false;
    $fileWriteDo = false;
    $complete = false;

    if (isset($_GET['type'])) {
        if ($_GET['type'] == 'file') {
            $fileWrite = true;
        } elseif ($_GET['type'] == 'filedo') {
            $fileWriteDo = true;
        } elseif ($_GET['type'] == 'complete') {
            $complete = true;
            completeInstall();
        }
    }

    /////////////////////////////////////////////
    /////// Run file write mode installer  //////
    /////////////////////////////////////////////

    if ($fileWriteDo) {
        $failed = checkAdminDetails();
        if ( !$failed ) {
            // new pclzip class extract //
            include_once('pclzip.lib.php');
            $archive = new PclZip('razorCMS_parcel.zip');            
            // extract files //
            $installOK = true;
            $restoring = '';
			if($archive->extract() == 0 ){
                $installOK = false;
                $restoring.= "<br />Error Unpacking Files";
			} else {
                $installOK = true;
                $restoring.= "<br />Files Unpacked";
			}        
            
            // configure //
            writeFileAdminDetails();        
            if ($installOK) {
                $content = '<div class="contentinstall">';
                $content.= $restoring;
                $content.= '<h2>Now Configuring razorCMS</h2>';
                if ( findServerOS() == 'LINUX' ) {
                    $content.= '<p>Admin details being written...<p>';
                    $content.= '<p>All razorCMS folders secured (0755 permissions)</p>';
                    $content.= '<p>All razorCMS files secured (0644 permissions)</p>';
                }
                completeInstall();
            } else {
                $content.= '<div class="contentinstall"><h2>Setup failed...</h2>';
                $content.= $restoring;
                $content.= '<p>razorCMS failed installation, please delete and re-try installation.</p></div>';
            }
        } else {
           $content.= $failed;
           $fileWrite = true;
        }
    }

    /////////////////////////////////////////////
    ///////// choose your install type //////////
    /////////////////////////////////////////////    

    if(!$fileWrite && !$fileWriteDo && !$complete) {
        $content = '<h2>Install razorCMS</h2>';
        $content.= '<div class="contentinstall">';
        $content.= '<p>Welcome to the razorCMS self unpacking installer, this installer will automatically unpack, configure and secure your installation, please click the link below to begin.</p>';
        $content.= '<p><a href="?type=file">CLICK TO PERFORM INSTALLATION</a></p></div>';
    }

    /////////////////////////////////////////////
    //////// Output form for file install ///////
    /////////////////////////////////////////////    

    if($fileWrite) {
        $rootDirChmod = sprintf('%o', fileperms('./'));
        $bypass = false;
        if (isset($_GET['bypass']) || findServerOS() == 'WIN') {
            $bypass = true;
        }
        if ( $rootDirChmod == '40777' || $bypass ) {
            $content = '<div class="contentinstall"><h2>Please Provide Details</h2>';
            $content.= '<p>Please use the form below to input your super administrator username and password, this will be used to access the administration console when altering your website or making certain changes that might affect security or site data.</p>';
            $content.= '<p>PLEASE NOTE : Please make a note of your super administrator username and password, do not lose this or you will be unable to access the administration console or configure certain parts of your system.</p>';
            $content.= '<h2>Administration Console Super Administrator Details</h2>';
            $content.= '<form action="?type=filedo" method="post"><table>';
            $content.= '<tr><td>Username</td><td><input class="user" type="text" name="adminUser" value="'.$adminUserName.'"></td></tr>';
            $content.= '<tr><td>Password</td><td><input class="user" type="password" name="adminPass"></td></tr>';
            $content.= '<tr><td>Password Confirm</td><td><input class="user" type="password" name="adminPassC"></td></tr>';
            $content.= '</table><input class="button" type="submit" name="admindetails" value="INSTALL"></form></div>';
        } else {
            $content.= '<h2>Installation halted...</h2>';
            $content.= '<div class="contentinstallred"><p><b>WARNING : FILE PERMISSION CHECK FAILED</b></P>';
            $content.= '<p>File permissions incorrect, please ensure your install root directory is set to open permissions (0777) temporarily to allow the installer to unpack razorCMS to your server.</p></div>';
            $content.= '<p>Please correct file permission errors before proceeding or installation may fail!!!<br /><br />Once file permissions set, please press F5 key to relaod this page.</p>';
            $content.= '<p>If you wish to bypass the permissions check please <a href="?type=file&bypass=true">click here</a>, please note this may make the installation fail...</p>';
        }
    }

    /////////////////////////////////////////////
    //////// Output xhtml page structure ////////
    /////////////////////////////////////////////

    $out=<<<TET
        <!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
        <html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
        <head>
            <title>razorCMS Installation Tool</title>
            <meta http-equiv="Content-Type" content="application/xhtml+xml; charset=iso-8859-1" />
            <style type="text/css">
                body {
                    margin: 0px;
                    padding: 0px;
                    background-color: #b6d7ee;
                    font-family: "Trebuchet MS", Arial, Helvetica, sans-serif;
                    text-align: center;
                }

                h1 {
                    margin: 10px;
                    padding: 0px;
                    font-family: "Trebuchet MS", Arial, Helvetica, sans-serif;
                    font-size: 105%;
                    color: #444444;
                }

                h2 {
                    margin: 10px;
                    padding: 0px;
                    font-family: "Trebuchet MS", Arial, Helvetica, sans-serif;
                    font-size: 95%;
                    color: #444444;
                    clear: left;
                }

                p, td {
                    margin: 10px 10px;
                    padding: 0px;
                    font-family: "Trebuchet MS", Arial, Helvetica, sans-serif;
                    font-size: 85%;
                    color: #444444;
                }

                li {
                    margin: 0px;
                    padding: 0px;
                    color: #444444;
                    text-decoration: none;
                }

                a, a:visited, a:active {
                    margin: 0px;
                    padding: 0px;
                    font-family: "Trebuchet MS", Arial, Helvetica, sans-serif;
                    color: #3d8bbf;
                    text-decoration: none;
                }

                a:hover {
                    margin: 0px;
                    padding: 0px;
                    color: #ff0000;
                }

                #header {
                    margin: 0px;
                    padding: 0px 0px 0px 0px;
                    height: 60px;
                    width: 100%;
                }

                #midbox {
                    margin: 0px 40px 0px 40px;
                    padding: 10px 0px;
                    width: auto;
                    background-color: #ffffff;
                }

                #content {
                    margin: 20px;
                    padding: 0px 0px 0px 0px;
                    height: auto;
                    width: auto;
                    border: none;
                    text-align: center;
                }

                .contentinstallred {
                    background-color: #ff7d7d;
                    border: 1px solid #c00000;
                    color: #c00000;
                }

                #button {
                    border: 1px solid #ff7200;
                    background-color: #ffc18e;
                    width: auto;
                    text-align: center;
                }

                table {
                    margin-top: 2px;
                    margin-bottom: 2px;
                    margin-left: 10%;
                    margin-right: 10%;
                    width: 80%;
                    border: 1px solid #bbbbbb;
                    border-spacing: 0px;
                    border-collapse: collapse;
                    background-color: #eeeeee;
                }

                th {
                    background-color: #dddddd;
                    color: #888888;
                    border-bottom: 1px solid #bbbbbb;
                    border-right: 1px solid #bbbbbb;
                }

                td {
                    font-family: "Trebuchet MS", Arial, Helvetica, sans-serif;
                    font-size: 80%;
                    color: #444444;
                    border-top: 1px solid #dddddd;
                    border-left: 1px solid #dddddd;
                }

                #footnav {
                    margin: 0px 0px 0px 0px;
                    padding: 0px 0px 0px 0px;
                    height: 135px;
                    text-align: center;
                    display: block;
                }

                #footerLeft {
                    padding-top: 26px;
                    width: 50%;
                    height: 70px;
                    text-align: right;
                    float: left;
                    display: block;
                }

                #footerRight {
                    padding-top: 26px;
                    width: 50%;
                    height: 70px;
                    text-align: left;
                    float: right;
                    display: block;
                }

                #footerLeft a, #footerLeft a:active, #footerLeft a:visited {
                    margin: 0px;
                    padding: 0px 36px 0px 0px;
                    text-decoration: none;
                    font-size: 80%;
                }

                #footerRight a, #footerRight a:active, #footerRight a:visited {
                    margin: 0px;
                    padding: 0px 0px 0px 36px;
                    text-decoration: none;
                    font-size: 80%;
                }

                #footerLeft a:hover, #footerRight a:hover{
                    color: #ff0000;
                }
            </style>
        </head>
        <body>
            <div id="header">
                <h1>razorCMS</h1>
                <h2>Installation Tool</h2>
           </div>
           <div id="midbox">
                <div id="content">
                    $content
                </div>
           </div>
           <div id="footnav">
                <div id="footerLeft">
                    <a href="http://www.razorcms.co.uk">www.razorcms.co.uk</a>
                </div>
                <div id="footerRight">
                    <a href="http://www.mis-limited.com">www.mis-limited.com</a>
                </div>
           </div>
        </body>
        </html>
TET;
    echo $out;
?>
