<?php
    ///////////////////////////////////////////////////////////
    // razorCMS v0.1                                         //
    // admin/lib/listOrder.bri.php                           //
    // GPLv3                                                 //
    // smiffy6969                                            //
    // www.razorcms.co.uk                                    //
    // www.darkhorizonproject.com                            //
	// Dark Horizon Project - Web Development                //
    // 03/2008                                               //
    // ----------------------------------------------------- //
    // V0.1  -  03/2008  -  Version 0.1 first release        //
    //                                                       //
    //                      Some parts loosely based on      //
    //                      nanoCMS V0.3 - with thanks to    //
    //                      Kalyan Chakravarthy              //
    // ----------------------------------------------------- //
    // V0.2  -  06/2008  -  No changes in this file          //
    //                      up issue to V0.2BETA or RC       //
    // ----------------------------------------------------- //
    // V0.2  -  08/2008  -  RC2 Bug fix release              //
    //                      Changes in this file             //
    // ----------------------------------------------------- //
    // V0.3  -  11/2008  -  BETA1 Bug fix and new features   //
    // ----------------------------------------------------- //
    // V0.3  -  12/2008  -  RC Bug fix and code walk         //
    // ----------------------------------------------------- //
    // V0.3  -  02/2009  -  RC2 Bug fix, code walk and some  //
    //                      movement of functions.           //
    // ----------------------------------------------------- //
    // V1.0  -  06/2009  -  ALPHA Security, Bug fix and new  //
    //                      functionality                    //
    // ----------------------------------------------------- //
    // V1.0  -  07/2009  -  BETA Bug fix and new             //
    //                      functionality                    //
    // ----------------------------------------------------- //
    // V1.0  -  08/2009  -  BETA2 Bug fix and new            //
    //                      functionality                    //
    // ----------------------------------------------------- //
    // V1.0  -  09/2009  -  RC Bug fix                       //
    // ----------------------------------------------------- //
    // V1.0  -  10/2009  -  Stable - Bug fix                 //
    // ----------------------------------------------------- //
    // V1.2  -  09/2011  -  Stable - Bug fix + Security fix  //
	//                      + Features                       //
    // ----------------------------------------------------- //
    ///////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////

    // start a new login session and fetch admin configuration //
    session_start();
    $oldSessionId = session_id();
    session_regenerate_id();
    include_once("../core/admin_config.php");
    include_once("../../core/public_config.php");
    include_once("../../core/public_func.php");
    include_once("../../core/public_class.php");
    /////////////////////////////////////////////////////////////

    // set variables //////////////////////////////////////////
    $razorArray = array();
    ///////////////////////////////////////////////////////////

    // Load razor data file  //////////////////////////////////
    $razorArray = unserialize( file_get_contents( '../'.getSystemRoot(RAZOR_ADMIN_FILENAME).RAZOR_DATA ) );
    ///////////////////////////////////////////////////////////

    //  login  //
    if( !isset( $_SESSION['adminLogIn'] ) ) {
            @session_destroy();
            die();
    } else {
        if($_SESSION['adminLogIn'] == sha1($_SERVER['REMOTE_ADDR'].RAZOR_SADMIN_USER.$_SESSION['loginTimeStamp'].$_SERVER['HTTP_USER_AGENT'])) {
            $_SESSION['loginTimeStamp'] = $ts = time();
            $_SESSION['adminLogIn'] = sha1($_SERVER['REMOTE_ADDR'].RAZOR_SADMIN_USER.$ts.$_SERVER['HTTP_USER_AGENT']);
            $_SESSION['adminType'] = 'sadmin';
        } elseif($_SESSION['adminLogIn'] == sha1($_SERVER['REMOTE_ADDR'].RAZOR_ADMIN_USER.$_SESSION['loginTimeStamp'].$_SERVER['HTTP_USER_AGENT'])) {
            $_SESSION['loginTimeStamp'] = $ts = time();
            $_SESSION['adminLogIn'] = sha1($_SERVER['REMOTE_ADDR'].RAZOR_ADMIN_USER.$ts.$_SERVER['HTTP_USER_AGENT']);
            $_SESSION['adminType'] = 'admin';
        } elseif($_SESSION['adminLogIn'] == sha1($_SERVER['REMOTE_ADDR'].RAZOR_USER_USER.$_SESSION['loginTimeStamp'].$_SERVER['HTTP_USER_AGENT'])) {
            $_SESSION['loginTimeStamp'] = $ts = time();
            $_SESSION['adminLogIn'] = sha1($_SERVER['REMOTE_ADDR'].RAZOR_USER_USER.$ts.$_SERVER['HTTP_USER_AGENT']);
            $_SESSION['adminType'] = 'user';
        } else {
            @session_destroy();
            unset( $_SESSION['adminLogIn'] );
        }
    }
    // end //////

    // check and clean input //
    $name = '';
    $order = '';
    $ok = false;
    if(isset($_GET['name']) && isset($_GET['order'])) {
        $name = htmlspecialchars(stripslashes($_GET['name']), ENT_QUOTES);
        $order = htmlspecialchars(stripslashes($_GET['order']), ENT_QUOTES);
        $ok = true;
    } else {
        $ok = false;
    }

    // verify everything passed validation //
    if(!$ok or $name == '' or $order == '') {
        die();
    } else {
		// save settings //
		if(isset($razorArray['links_cats'][$name])){
			// settings exists //
			$newOrder = array();
			$newOrder = explode(',',$order);
			if(intval($newOrder[0]) > 0 && count($newOrder) > 0){
				foreach($newOrder as $key=>$sOrder){
					$newOrder[$key] = intval($sOrder);
				}
				$razorArray['links_cats'][$name] = $newOrder;
    			// save data to file //
			    $pagesdata = serialize( $razorArray );
        		put2file( RAZOR_DATA, $pagesdata );
    		}
		}
	}
	
    // write to file //
    function put2file($remote_file,$contents) {
        $filename = '../'.getSystemRoot(RAZOR_ADMIN_FILENAME).$remote_file;
        $f=@fopen($filename,"w");
        if (!$f) {
            return false;
        } else {
            fwrite($f,$contents);
            fclose($f);
            if (findServerOS() == 'LINUX') {
                $perms = file_perms($filename);
                if ( $perms != '0644') {
                    @chmod($filename, 0644);
                }
            }
            return true;
        } 
    }
    // end ///////////   
    
?>
