# Contributing

We are more than happy to accept external contributions to the project in the form of feedback, bug reports and even better - pull requests :)

## Issue submission

In order for us to help you please check that you've completed the following steps:

* Made sure you're bug isn't already fixed in the master branch.
* Used the search feature to ensure that the bug hasn't been reported before
* Included as much information about the bug as possible, including any output you've received, what Server OS, PHP version you're on, etc.
* Make sure you only submit one problem per issue

[Submit your issue](https://github.com/BanManagement/BanManager-WebUI/issues/new)

## Pull Request Guidelines

* Please check to make sure that there aren't existing pull requests attempting to address the issue mentioned. 
* Non-trivial changes should be discussed in an issue first
* Develop in a topic branch, not master (e.g. `feature/new-view`)
* Write a convincing description of your PR and why we should land it
* If you write JavaScript, make sure you follow https://github.com/bengourley/js-style-guide/
