<?php
/*
###################################################################################
  Bigware Shop 2.3
  Release Datum: 23.08.2015
  
  Bigware Shop
  http://www.bigware.de

  Copyright (c) 2015 Bigware LTD
  (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
  (c) 2015	Bigware LTD

  Copyrightvermerke duerfen nicht entfernt werden.
  ------------------------------------------------------------------------
  Dieses Programm ist freie Software. Sie koennen es unter den Bedingungen
  der GNU General Public License, wie von der Free Software Foundation
  veroeffentlicht, weitergeben und/oder modifizieren, entweder gemaess Version 2 
  der Lizenz oder (nach Ihrer Option) jeder spaeteren Version.
  Die Veroeffentlichung dieses Programms erfolgt in der Hoffnung, dass es Ihnen
  von Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE, sogar ohne die
  implizite Garantie der MARKTREIFE oder der VERWENDBARKEIT FUER EINEN
  BESTIMMTEN ZWECK. Details finden Sie in der GNU General Public License.
  
  Sie sollten eine Kopie der GNU General Public License zusammen mit diesem
  Programm erhalten haben. Falls nicht, schreiben Sie an die Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.

  Infos:
  ------------------------------------------------------------------------
  Der Bigware Shop wurde vor vielen Jahren bereits aus dem bekannten Shopsystem osCommerce
  weiter- und neuentwickelt.
  Der Bigware Shop legt im hohen Masse Wert auf Bedienerfreundlichkeit, beinhaltet eine leichte
  Installation, viele neue professionelle Werkzeuge und zeichnet sich aus durch eine grosse 
  Community, die bei Problemen weiterhelfen kann.
  
  Der Bigware Shop ist auf jedem System lauffaehig, welches eine PHP Umgebung
  (ab PHP 4.1.3) und mySQL zur Verfuegung stellt und auf Linux basiert.
 
  Hilfe erhalten Sie im Forum auf www.bigware.de 
  
  -----------------------------------------------------------------------
  
 ##################################################################################




*/
?>
<?php   
  class currencies {
    var $currencies; 
    function currencies() {
      $this->currencies = array();
      $currencies_query = go_db_query("select code, title, symbol_left, symbol_right, decimal_point, thousands_point, decimal_places, roundings, value from " . DB_TBL_CURRENCIES);
      while ($currencies = go_db_fetch_array($currencies_query)) {
	    $this->currencies[$currencies['code']] = array('title' => $currencies['title'],
                                                       'symbol_left' => $currencies['symbol_left'] . ' ',
                                                       'symbol_right' => ' ' . $currencies['symbol_right'],
                                                       'decimal_point' => $currencies['decimal_point'],
                                                       'thousands_point' => $currencies['thousands_point'],
                                                       'decimal_places' => $currencies['decimal_places'],
														'roundings'=>$currencies['roundings'],
                                                       'value' => $currencies['value']);
      }
    } 
    function format($number, $calculate_currency_value = true, $currency_type = DEFAULT_CURRENCY, $currency_value = '') {
      if ($calculate_currency_value) {
        $rate = ($currency_value) ? $currency_value : $this->currencies[$currency_type]['value'];
        $amount = $this->go_round($number * $rate,$this->currencies[$currency_type]['decimal_places'],$this->currencies[$currency_type]['roundings']);
        $format_string = $this->currencies[$currency_type]['symbol_left'] . number_format($amount, $this->currencies[$currency_type]['decimal_places'], $this->currencies[$currency_type]['decimal_point'], $this->currencies[$currency_type]['thousands_point']) . $this->currencies[$currency_type]['symbol_right'];  
        if ( (DEFAULT_CURRENCY == 'EUR') && ($currency_type == 'DEM' || $currency_type == 'BEF' || $currency_type == 'LUF' || $currency_type == 'ESP' || $currency_type == 'FRF' || $currency_type == 'IEP' || $currency_type == 'ITL' || $currency_type == 'NLG' || $currency_type == 'ATS' || $currency_type == 'PTE' || $currency_type == 'FIM' || $currency_type == 'GRD') ) {
          $format_string .= ' <small>[' . $this->format($number, true, ' EUR') . ']</small>';
        }
      } else {
        $format_string = $this->currencies[$currency_type]['symbol_left'] . number_format($number, $this->currencies[$currency_type]['decimal_places'], $this->currencies[$currency_type]['decimal_point'], $this->currencies[$currency_type]['thousands_point']) . $this->currencies[$currency_type]['symbol_right'];
      }
      return $format_string;
    }
    function get_value($code) {
      return $this->currencies[$code]['value'];
    }
    function display_price($items_price, $items_tax, $quantity = 1) {
      return $this->format(go_add_tax($items_price, $items_tax) * $quantity);
    }
	function go_round($value, $precision,$roundings) {
	  	if ($roundings != 'std'){  
	  	  	list($roundings_from,$roundings_customed) = explode(";",$roundings);
	  	  	$roundings_customed = explode(",",$roundings_customed);
	  	  	$value = floor( $value * pow(10, $roundings_from) );
	  	  	$digit = $value % 10;
	  	  	$offset = 	$roundings_customed[$digit] - $digit / pow(10, $roundings_from);
	  	  	$value = $value / pow(10, $roundings_from) + $offset;
	  		return $value;
	  	}	
	    if (PHP_VERSION < 4) {
	      $exp = pow(10, $precision);
	      return round($value * $exp) / $exp;
	    } else {
	      return round($value, $precision);
	    }
	  }  
  }
?>
