<?php
/*
###################################################################################
  Bigware Shop 2.3
  Release Datum: 23.08.2015
  
  Bigware Shop
  http://www.bigware.de

  Copyright (c) 2015 Bigware LTD
  (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
  (c) 2015	Bigware LTD

  Copyrightvermerke duerfen nicht entfernt werden.
  ------------------------------------------------------------------------
  Dieses Programm ist freie Software. Sie koennen es unter den Bedingungen
  der GNU General Public License, wie von der Free Software Foundation
  veroeffentlicht, weitergeben und/oder modifizieren, entweder gemaess Version 2 
  der Lizenz oder (nach Ihrer Option) jeder spaeteren Version.
  Die Veroeffentlichung dieses Programms erfolgt in der Hoffnung, dass es Ihnen
  von Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE, sogar ohne die
  implizite Garantie der MARKTREIFE oder der VERWENDBARKEIT FUER EINEN
  BESTIMMTEN ZWECK. Details finden Sie in der GNU General Public License.
  
  Sie sollten eine Kopie der GNU General Public License zusammen mit diesem
  Programm erhalten haben. Falls nicht, schreiben Sie an die Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.

  Infos:
  ------------------------------------------------------------------------
  Der Bigware Shop wurde vor vielen Jahren bereits aus dem bekannten Shopsystem osCommerce
  weiter- und neuentwickelt.
  Der Bigware Shop legt im hohen Masse Wert auf Bedienerfreundlichkeit, beinhaltet eine leichte
  Installation, viele neue professionelle Werkzeuge und zeichnet sich aus durch eine grosse 
  Community, die bei Problemen weiterhelfen kann.
  
  Der Bigware Shop ist auf jedem System lauffaehig, welches eine PHP Umgebung
  (ab PHP 4.1.3) und mySQL zur Verfuegung stellt und auf Linux basiert.
 
  Hilfe erhalten Sie im Forum auf www.bigware.de 
  
  -----------------------------------------------------------------------
  
 ##################################################################################




*/
?>
<?php
class PHPlot{
	var $is_inline = 0; 
	var $browser_cache = '1';  
	var $session_set = ''; 
	var $scale_is_set = ''; 
	var $fetch_plot_area_background = '';
	var $picture_width; 
	var $picture_height; 
	var $picture_border_type = ''; 
	var $x_left_margin;
	var $y_top_margin;
	var $x_right_margin;
	var $y_bot_margin;
	var $plot_area = array(5,5,600,400);
	var $x_axis_position = 0; 
	var $y_axis_position = ''; 
	var $xscale_type = 'linear'; 
	var $yscale_type = 'linear'; 
	var $print_picture = 1;  
	var $use_ttf  = 0; 
	var $font_path = './'; 
	var $font = './benjamingothic.ttf'; 
	var $small_ttffont_size = 12;  
	var $small_font = 2; 
	var $small_font_width = 6.0; 
	var $small_font_height = 8.0;  
	var $title_ttffont = './benjamingothic.ttf';
	var $title_ttffont_size = 14;
	var $title_angle= 0; 
	var $title_font = '4';  
	var $axis_ttffont = './benjamingothic.ttf';
	var $axis_ttffont_size = 8;
	var $x_datalabel_angle = 0; 
	var $axis_font = 2; 
	var $datalabel_font = '2'; 
	var $x_label_ttffont = './benjamingothic.ttf';
	var $x_label_ttffont_size = '12';
	var $x_label_angle = '0';
	var $y_label_ttffont = './benjamingothic.ttf';
	var $y_label_ttffont_size = '12';
	var $y_label_angle = 90;
	var $y_label_width = ''; 
	var $file_format = 'png';
	var $file_name = '';  
	var $shading = 0;
	var $color_array = 1;   
	var $bg_color;
	var $plot_bg_color;
	var $grid_color;
	var $light_grid_color;
	var $tick_color;
	var $title_color;
	var $label_color;
	var $text_color;
	var $i_light = ''; 
	var $data_type = 'text-data'; 
	var $plot_type= 'linepoints'; 
	var $line_width = 2;
	var $line_style = array('solid','solid','solid','dashed','dashed','solid'); 
	var $data_color = ''; 
	var $data_border_color = '';
	var $label_scale_position = '.5'; 
	var $group_frac_width = '.7'; 
	var $bar_width_adjust = '1'; 
	var $point_size = 10;
	var $point_shape = 'diamond'; 
	var $error_bar_shape = 'tee'; 
	var $error_bar_size = 5; 
	var $error_bar_line_width = ''; 
	var $error_bar_color = ''; 
	var $data_values;
	var $plot_border_type = 'full'; 
	var $plot_area_width = '';
	var $number_x_points;
	var $plot_min_x; 
	var $plot_max_x= ''; 
	var $plot_min_y= ''; 
	var $plot_max_y = ''; 
	var $min_y = '';
	var $max_y = '';
	var $max_x = 10; 
	var $y_precision = '1';
	var $x_precision = '1';
	var $si_units = ''; 
	var $fetch_data_labels = '0';  
	var $legend = ''; 
	var $legend_x_pos = '';
	var $legend_y_pos = '';
	var $title_txt = "";
	var $y_label_txt = '';
	var $x_label_txt = ""; 
	var $y_grid_label_type = 'data'; 
	var $y_grid_label_pos = 'plotleft'; 
	var $x_grid_label_type = 'data'; 
	var $fetch_x_data_labels = ''; 
	var $x_time_format = "%H:%m:%s"; 
	var $x_datalabel_maxlength = 10; 
	var $tick_length = '10';   
	var $fetch_vert_ticks = 1; 
	var $num_vert_ticks = '';
	var $vert_tick_increment=''; 
	var $vert_tick_position = 'both';  
	var $horiz_tick_increment=''; 
	var $num_horiz_ticks='';
	var $skip_top_tick = '0';
	var $skip_bottom_tick = '0'; 
	var $fetch_x_grid = 0;
	var $fetch_y_grid = 1;   
	function PHPlot($which_width=600,$which_height=400,$which_output_file="",$which_input_file="") {
		$this->SetRGBArray('2'); 
		$this->background_done = 0; 
		if ($which_output_file != "") { $this->SetOutputFile($which_output_file);  };
		if ($which_input_file != "") { 
			$this->SetInputFile($which_input_file) ; 
		} else { 
			$this->SetImageArea($which_width, $which_height);
			$this->InitImage();
		}
		if ( ($this->session_set == 1) && ($this->img == "") ) {  
		} else { 
			$this->SetDefaultColors();
		}
		$this->SetIndexColors();
	} 
	function InitImage() {   
		$this->img = ImageCreate($this->picture_width, $this->picture_height);
		return true;
	}
	function SetBrowserCache($which_browser_cache) { 
		$this->browser_cache = $which_browser_cache;
		return true;
	}
	function SetPrintImage($which_pi) {
		$this->print_picture = $which_pi;
		return true;
	}
	function SetIsInline($which_ii) {
		$this->is_inline = $which_ii;
		return true;
	}
	function SetUseTTF($which_ttf) {
		$this->use_ttf = $which_ttf;
		return true;
	}
	function SetTitleFontSize($which_tfs) { 
		$this->title_ttffont_size = $which_tfs;  
		if (($which_tfs > 5) && (!$this->use_ttf)) {
			$this->DrawError('Non-TTF font size must be 1,2,3,4 or 5');
			return false;
		} else {
			$this->title_font = $which_tfs;  
		}
		return true;
	}
	function SetLineStyles($which_sls){
		$this->line_style = $which_sls;
		return true;
	}
	function SetLegend($which_leg){
		if (is_array($which_leg)) { 
			$this->legend = $which_leg;
			return true;
		} else { 
			$this->DrawError('Error: SetLegend argument must be an array');
			return false;
		}
	}
	function SetLegendPixels($which_x,$which_y,$which_type) { 
		$this->legend_x_pos = $which_x;
		$this->legend_y_pos = $which_y;
		return true;
	}
	function SetLegendWorld($which_x,$which_y,$which_type='') {  
		if ($this->scale_is_set != 1) { $this->SetTranslation(); };
		$this->legend_x_pos = $this->xtr($which_x);
		$this->legend_y_pos = $this->ytr($which_y);
		return true;
	}
 	function SetFileFormat($which_file_format) { 
		$asked = strtolower(trim($which_file_format));
		if( ($asked=='jpg') || ($asked=='png') || ($asked=='gif') || ($asked=='wbmp') ) {
			$this->file_format = $asked;
			return true;
		} else {
			return false;
		}
	}
	function SetInputFile($which_input_file) { 
		$size = GetImageSize($which_input_file);
		$input_type = $size[2]; 
		switch($input_type) { 
			case "1":
				$im = @ImageCreateFromGIF ($which_input_file);
				if (!$im) { 
					$this->PrintError("Unable to open $which_input_file as a GIF");
					return false;
				}
			break;
			case "3":
				$im = @ImageCreateFromPNG ($which_input_file); 
				if (!$im) { 
					$this->PrintError("Unable to open $which_input_file as a PNG");
					return false;
				}
			break;
			case "2":
				$im = @ImageCreateFromJPEG ($which_input_file); 
				if (!$im) { 
					$this->PrintError("Unable to open $which_input_file as a JPG");
					return false;
				}
			break;
			default:
				$this->PrintError('Please select wbmp,gif,jpg, or png for picture type!');
				return false;
			break;
		} 
		$this->SetImageArea($size[0],$size[1]);
		$this->img = $im;
		return true;
	}
	function SetOutputFile($which_output_file) { 
		$this->output_file = $which_output_file;
		return true;
	}
	function SetImageArea($which_iw,$which_ih) { 
		$this->picture_width = $which_iw;
		$this->picture_height = $which_ih;
		return true;
	}
	function SetYAxisPosition($which_pos) {
		$this->y_axis_position = $which_pos;
		return true;
	}
	function SetXAxisPosition($which_pos) {
		$this->x_axis_position = $which_pos;
		return true;
	}
	function SetXTimeFormat($which_xtf) {
		$this->x_time_format = $which_xtf;
		return true;
	}
	function SetXDataLabelMaxlength($which_xdlm) { 
		if ($which_xdlm >0 ) { 
			$this->x_datalabel_maxlength = $which_xdlm;
			return true;
		} else { 
			return false;
		}
	}
	function SetXDataLabelAngle($which_xdla) { 
		$this->x_datalabel_angle = $which_xdla;
		return true;
	}
	function SetXScaleType($which_xst) { 
		$this->xscale_type = $which_xst;
		return true;
	}
	function SetYScaleType($which_yst) { 
		$this->yscale_type = $which_yst;
		if ($this->x_axis_position <= 0) { 
			$this->x_axis_position = 1;
		}
		return true;
	}
	function SetPrecisionX($which_prec) {
		$this->x_precision = $which_prec;
		return true;
	}
	function SetPrecisionY($which_prec) {
		$this->y_precision = $which_prec;
		return true;
	}
	function SetIndexColors() {   
		$this->ndx_i_light = $this->SetIndexColor($this->i_light);
		$this->ndx_i_dark  = $this->SetIndexColor($this->i_dark);
		$this->ndx_bg_color= $this->SetIndexColor($this->bg_color);
		$this->ndx_plot_bg_color= $this->SetIndexColor($this->plot_bg_color);
		$this->ndx_title_color= $this->SetIndexColor($this->title_color);
		$this->ndx_tick_color= $this->SetIndexColor($this->tick_color);
		$this->ndx_label_color= $this->SetIndexColor($this->label_color);
		$this->ndx_text_color= $this->SetIndexColor($this->text_color);
		$this->ndx_light_grid_color= $this->SetIndexColor($this->light_grid_color);
		$this->ndx_grid_color= $this->SetIndexColor($this->grid_color);
		reset($this->error_bar_color);  
		unset($ndx_error_bar_color);
		$i = 0; 
		while (list(, $col) = each($this->error_bar_color)) {
		  $this->ndx_error_bar_color[$i] = $this->SetIndexColor($col);
			$i++;
		} 
		unset($ndx_data_border_color);
		$i = 0;
		while (list(, $col) = each($this->data_border_color)) {
			$this->ndx_data_border_color[$i] = $this->SetIndexColor($col);
			$i++;
		} 
		unset($ndx_data_color);
		$i = 0;
		while (list(, $col) = each($this->data_color)) {
			$this->ndx_data_color[$i] = $this->SetIndexColor($col);
			$i++;
		}
		return true;
	}
	function SetDefaultColors() {
		$this->i_light = array(194,194,194);
		$this->i_dark =  array(100,100,100);
		$this->SetPlotBgColor(array(222,222,222));
		$this->SetBackgroundColor(array(200,222,222)); 
		$this->SetLabelColor('black');
		$this->SetTextColor('black');
		$this->SetGridColor('black');
		$this->SetLightGridColor(array(175,175,175));
		$this->SetTickColor('black');
		$this->SetTitleColor(array(0,0,0)); 
		$this->data_color = array('blue','green','yellow','red','orange');
		$this->error_bar_color = array('blue','green','yellow','red','orange');
		$this->data_border_color = array('black');
		$this->session_set = 1; 
	}
	function PrintImage() {
		if ( ($this->browser_cache == 0) && ($this->is_inline == 0)) { 
			header('Expires: Mon, 26 Jul 1997 05:00:00 GMT');
			header('Last-Modified: ' . gmdate("D, d M Y H:i:s") . 'GMT');
			header('Cache-Control: no-cache, must-revalidate');
			header('Pragma: no-cache');
		}
		switch($this->file_format) {
			case "png":
				if ($this->is_inline == 0) {
					Header('Content-type: picture/png');
				}
				if ($this->is_inline == 1 && $this->output_file != "") {
					ImagePng($this->img,$this->output_file);
				} else {
					ImagePng($this->img);
				}
				break;
			case "jpg":
				if ($this->is_inline == 0) {
					Header('Content-type: picture/jpeg');
				}
				if ($this->is_inline == 1 && $this->output_file != "") {
					ImageJPEG($this->img,$this->output_file);
				} else {
					ImageJPEG($this->img);
				}
				break;
			case "gif":
				if ($this->is_inline == 0) {
					Header('Content-type: picture/gif');
				}
				if ($this->is_inline == 1 && $this->output_file != "") {
					ImageGIF($this->img,$this->output_file);
				} else {
					ImageGIF($this->img);
				}
				break;
			case "wbmp":
				if ($this->is_inline == 0) {
					Header('Content-type: picture/wbmp');
				}
				if ($this->is_inline == 1 && $this->output_file != "") {
					ImageWBMP($this->img,$this->output_file);
				} else {
					ImageWBMP($this->img);
				}
				break;
			default:
				$this->PrintError('Please select an picture type!<br>');
				break;
		}
		ImageDestroy($this->img);
		return true;
	}
	function DrawBackground() { 
		if ($this->background_done == 0) { 
			ImageFilledRectangle($this->img, 0, 0,
				$this->picture_width, $this->picture_height, $this->ndx_bg_color);
			$this->background_done = 1;
		}
		return true;
	}
	function DrawImageBorder() {
		switch ($this->picture_border_type) {
			case "raised":
				ImageLine($this->img,0,0,$this->picture_width-1,0,$this->ndx_i_light);
				ImageLine($this->img,1,1,$this->picture_width-2,1,$this->ndx_i_light);
				ImageLine($this->img,0,0,0,$this->picture_height-1,$this->ndx_i_light);
				ImageLine($this->img,1,1,1,$this->picture_height-2,$this->ndx_i_light);
				ImageLine($this->img,$this->picture_width-1,0,$this->picture_width-1,$this->picture_height-1,$this->ndx_i_dark);
				ImageLine($this->img,0,$this->picture_height-1,$this->picture_width-1,$this->picture_height-1,$this->ndx_i_dark);
				ImageLine($this->img,$this->picture_width-2,1,$this->picture_width-2,$this->picture_height-2,$this->ndx_i_dark);
				ImageLine($this->img,1,$this->picture_height-2,$this->picture_width-2,$this->picture_height-2,$this->ndx_i_dark);
			break;
			case "plain":
				ImageLine($this->img,0,0,$this->picture_width,0,$this->ndx_i_dark);
				ImageLine($this->img,$this->picture_width-1,0,$this->picture_width-1,$this->picture_height,$this->ndx_i_dark);
				ImageLine($this->img,$this->picture_width-1,$this->picture_height-1,0,$this->picture_height-1,$this->ndx_i_dark);
				ImageLine($this->img,0,0,0,$this->picture_height,$this->ndx_i_dark);
			break;
			default:
			break;
		}
		return true;
	}
	function SetPlotBorderType($which_pbt) {
		$this->plot_border_type = $which_pbt; 
	}
	function SetImageBorderType($which_sibt) {
		$this->picture_border_type = $which_sibt; 
	}
	function SetDrawPlotAreaBackground($which_dpab) {
		$this->fetch_plot_area_background = $which_dpab; 
	}
	function SetDrawDataLabels($which_ddl) { 
		$this->fetch_data_labels = $which_ddl; 
	}
	function SetDrawXDataLabels($which_dxdl) { 
		$this->fetch_x_data_labels = $which_dxdl; 
	}
	function SetDrawYGrid($which_dyg) {
		$this->fetch_y_grid = $which_dyg; 
	}
	function SetDrawXGrid($which_dxg) {
		$this->fetch_x_grid = $which_dxg; 
	}
	function SetYGridLabelType($which_yglt) {
		$this->y_grid_label_type = $which_yglt;
		return true;
	}
	function SetXGridLabelType($which_xglt) {
		$this->x_grid_label_type = $which_xglt;
		return true;
	}
	function SetXLabel($xlbl) {
		$this->x_label_txt = $xlbl;
		return true;
	}
	function SetYLabel($ylbl) {
		$this->y_label_txt = $ylbl;
		return true;
	}
	function SetTitle($title) {
		$this->title_txt = $title;
		return true;
	}     
	function DrawLabels() {
		$this->DrawTitle();
		$this->DrawXLabel();
		$this->DrawYLabel();
		return true;
	}
	function DrawXLabel() {
		if ($this->use_ttf == 1) { 
			$xpos = $this->xtr(($this->plot_max_x + $this->plot_min_x)/2.0) ;
			$ypos = $this->ytr($this->plot_min_y) + $this->x_label_height/2.0;
			$this->DrawText($this->x_label_ttffont, $this->x_label_angle,
				$xpos, $ypos, $this->ndx_label_color, $this->x_label_ttffont_size, $this->x_label_txt,'center');
		} else { 
			$xpos = 0.0 + $this->xtr(($this->plot_max_x+$this->plot_min_x)/2.0) ;
			$ypos = ($this->ytr($this->plot_min_y) + $this->x_label_height/2);
			$this->DrawText($this->small_font, $this->x_label_angle, 
				$xpos, $ypos, $this->ndx_label_color, "", $this->x_label_txt, 'center');
		}
		return true;
	}
	function DrawYLabel() {
		if ($this->use_ttf == 1) { 
			$size = $this->TTFBBoxSize($this->y_label_ttffont_size, 90, $this->y_label_ttffont, $this->y_label_txt);
			$xpos = 8 + $size[0];
			$ypos = ($size[1])/2 + $this->ytr(($this->plot_max_y + $this->plot_min_y)/2.0) ;
			$this->DrawText($this->y_label_ttffont, 90,
				$xpos, $ypos, $this->ndx_label_color, $this->y_label_ttffont_size, $this->y_label_txt);
		} else { 
			$xpos = 8;
			$ypos = (($this->small_font_width*strlen($this->y_label_txt)/2.0) +
					$this->ytr(($this->plot_max_y + $this->plot_min_y)/2.0) );
			$this->DrawText($this->small_font, 90,
				$xpos, $ypos, $this->ndx_label_color, $this->y_label_ttffont_size, $this->y_label_txt);
		}
		return true;
	}
	function DrawText($which_font,$which_angle,$which_xpos,$which_ypos,$which_color,$which_size,$which_text,$which_halign='left',$which_valign='') {
		if ($this->use_ttf == 1 ) { 
			$size = $this->TTFBBoxSize($which_size, $which_angle, $which_font, $which_text); 
			if ($which_valign == 'bottom') { 
				$which_ypos = $which_ypos + ImageFontHeight($which_font);
			}
			if ($which_halign == 'center') { 
				$which_xpos = $which_xpos - $size[0]/2;
			}
			ImageTTFText($this->img, $which_size, $which_angle, 
				$which_xpos, $which_ypos, $which_color, $which_font, $which_text); 
		} else { 
			if ($which_valign == 'top') { 
				$which_ypos = $which_ypos - ImageFontHeight($which_font);
			}
			$which_text = preg_replace("/\r/","",$which_text);
			$str = preg_split("/\n/",$which_text); 
			$height = ImageFontHeight($which_font);
			$width = ImageFontWidth($which_font);
			if ($which_angle == 90) { 
				for($i=0;$i<count($str);$i++) { 
					ImageStringUp($this->img, $which_font, ($i*$height + $which_xpos), $which_ypos, $str[$i], $which_color);
				} 
			} else {
				for($i=0;$i<count($str);$i++) { 
					if ($which_halign == 'center') { 
                    	$xpos = $which_xpos - strlen($str[$i]) * $width/2;
 						ImageString($this->img, $which_font, $xpos, ($i*$height + $which_ypos), $str[$i], $which_color);
					} else { 
						ImageString($this->img, $which_font, $which_xpos, ($i*$height + $which_ypos), $str[$i], $which_color); 
					}
				} 
			}
		} 
		return true; 
	}
	function DrawTitle() {
		if ($this->use_ttf == 1 ) { 
			$xpos = ($this->plot_area[0] + $this->plot_area_width / 2);
			$ypos = $this->y_top_margin/2;
			$this->DrawText($this->title_ttffont, $this->title_angle, 
				$xpos, $ypos, $this->ndx_title_color, $this->title_ttffont_size, $this->title_txt,'center'); 
		} else { 
			$xpos = ($this->plot_area[0] + $this->plot_area_width / 2);
			$ypos = ImageFontHeight($this->title_font); 
			$this->DrawText($this->title_font, $this->title_angle, 
				$xpos, $ypos, $this->ndx_title_color, '', $this->title_txt,'center'); 
		} 
		return true; 
	}
	function DrawPlotAreaBackground() {
		ImageFilledRectangle($this->img,$this->plot_area[0],
			$this->plot_area[1],$this->plot_area[2],$this->plot_area[3],
			$this->ndx_plot_bg_color);
	}
	function SetBackgroundColor($which_color) {
		$this->bg_color= $which_color;
		$this->ndx_bg_color= $this->SetIndexColor($which_color);
		return true;
	}
	function SetPlotBgColor($which_color) {
		$this->plot_bg_color= $which_color;
		$this->ndx_plot_bg_color= $this->SetIndexColor($which_color);
		return true;
	}
	function SetShading($which_s) { 
		$this->shading = $which_s;
		return true;
	}
	function SetTitleColor($which_color) {
		$this->title_color= $which_color;
		$this->ndx_title_color= $this->SetIndexColor($which_color);
		return true;
	}
	function SetTickColor ($which_color) {
		$this->tick_color= $which_color;
		$this->ndx_tick_color= $this->SetIndexColor($which_color);
		return true;
	}
	function SetLabelColor ($which_color) {
		$this->label_color= $which_color;
		$this->ndx_label_color= $this->SetIndexColor($which_color);
		return true;
	}
	function SetTextColor ($which_color) {
		$this->text_color= $which_color;
		$this->ndx_text_color= $this->SetIndexColor($which_color);
		return true;
	}
	function SetLightGridColor ($which_color) {
		$this->light_grid_color= $which_color;
		$this->ndx_light_grid_color= $this->SetIndexColor($which_color);
		return true;
	}
	function SetGridColor ($which_color) {
		$this->grid_color = $which_color;
		$this->ndx_grid_color= $this->SetIndexColor($which_color);
		return true;
	}
	function SetCharacterHeight() { 
		return true;
	}
	function SetPlotType($which_pt) {
		$accepted = "bars,lines,linepoints,area,points,pie,thinbarline";
		$asked = trim($which_pt);
		if (preg_match("/$asked/i", $accepted)) {
			$this->plot_type = $which_pt;
			return true;
		} else {
			$this->DrawError('$which_pt not an acceptable plot type');
			return false;
		}
	}
	function FindDataLimits() {    
		$this->number_x_points = count($this->data_values);
		switch ($this->data_type) {
			case "text-data":
				$minx = 0; 
				$maxx = $this->number_x_points - 1 ; 
				$miny = (double) $this->data_values[0][1];
				$maxy = $miny;
				if ($this->fetch_x_data_labels == "") { 
					$this->fetch_x_data_labels = 1; 
				}
			break;
			default: 
				$maxx = $this->data_values[0][1];
				$minx = $maxx;
				$miny = $this->data_values[0][2];
				$maxy = $miny;
				$maxy = $miny;
			break;
		}
		$max_records_per_group = 0;
		$total_records = 0;
		$mine = 0; 
		$maxe = 0; 
		reset($this->data_values);
		while (list($dat_key, $dat) = each($this->data_values)) {  
			$tmp = 0;
			$total_records += count($dat) - 1; 
			switch ($this->data_type) {
				case "text-data": 
					while (list($key, $val) = each($dat)) {
						if ($key != 0) { 
							SetType($val,"double");
							if ($val > $maxy) {
								$maxy = $val ;
							}
							if ($val < $miny) {
								$miny = (double) $val ;
							}
						}
						$tmp++;
					}
				break;
				case "data-data": 
					while (list($key, $val) = each($dat)) {
						if ($key == 1) { 
							SetType($val,"double");
							if ($val > $maxx) {
								$maxx = $val;
							} elseif ($val < $minx) {
								$minx = $val;
							}
						} elseif ($key > 1) {
							SetType($val,"double");
							if ($val > $maxy) {
								$maxy = $val ;
							} elseif ($val < $miny) {
								$miny = $val ;
							}
						}
						$tmp++;
					}
					$tmp = $tmp - 1; 
				break;
				case "data-data-error":  
					while (list($key, $val) = each($dat)) {
						if ($key == 1) { 
							SetType($val,'double');
							if ($val > $maxx) {
								$maxx = $val;
							} elseif ($val < $minx) {
								$minx = $val;
							}
						} elseif ($key%3 == 2) {
							SetType($val,'double');
							if ($val > $maxy) {
								$maxy = $val ;
							} elseif ($val < $miny) {
								$miny = $val ;
							}
						} elseif ($key%3 == 0) {
							SetType($val,'double');
							if ($val > $maxe) {
								$maxe = $val ;
							}
						} elseif ($key%3 == 1) {
							SetType($val,'double');
							if ($val > $mine) {
								$mine = $val ;
							}
						}
						$tmp++;
					}
					$maxy = $maxy + $maxe;
					$miny = $miny - $mine; 
				break;
				default:
					$this->PrintError('ERROR: unknown chart type');
				break;
			}
			if ($tmp > $max_records_per_group) {
				$max_records_per_group = $tmp;
			}
		}
		$this->min_x = $minx;
		$this->max_x = $maxx;
		$this->min_y = $miny;
		$this->max_y = $maxy;
		if ($max_records_per_group > 1) {
			$this->records_per_group = $max_records_per_group - 1;
		} else {
			$this->records_per_group = 1;
		} 
	} 
	function SetMargins() {       
		$str = preg_split("/\n/",$this->title_txt); 
		$nbLines = count($str); 
		if ($this->use_ttf == 1) {
			$title_size = $this->TTFBBoxSize($this->title_ttffont_size, $this->title_angle, $this->title_ttffont, 'X'); 
			if ($nbLines == 1) { 
				$this->y_top_margin = $title_size[1] * 4;
			} else { 
				$this->y_top_margin = $title_size[1] * ($nbLines+3);
			}  
			$this->y_bot_margin = $this->x_label_height ;
			$this->x_left_margin = $this->y_label_width * 2 + $this->tick_length;
			$this->x_right_margin = 33.0; 
		} else {
			$title_size = array(ImageFontWidth($this->title_font) * strlen($this->title_txt),ImageFontHeight($this->title_font)); 
			if ($nbLines == 1) { 
				$this->y_top_margin = $title_size[1] * 4;
			} else { 
				$this->y_top_margin = $title_size[1] * ($nbLines+3);
			}
			if ($this->x_datalabel_angle == 90) {
				$this->y_bot_margin = 76.0; 
			} else {
				$this->y_bot_margin = 66.0; 
			}
			$this->x_left_margin = 77.0; 
			$this->x_right_margin = 33.0; 
		} 
		$this->x_tot_margin = $this->x_left_margin + $this->x_right_margin;
		$this->y_tot_margin = $this->y_top_margin + $this->y_bot_margin;
		if ($this->plot_max_x && $this->plot_max_y && $this->plot_area_width ) { 
			$this->SetTranslation();
		}
	}
	function SetMarginsPixels($which_lm,$which_rm,$which_tm,$which_bm) { 
		$this->SetNewPlotAreaPixels($which_lm,$which_tm,($this->picture_width - $which_rm),($this->picture_height - $which_bm));
		return true;
	}
	function SetNewPlotAreaPixels($x1,$y1,$x2,$y2) { 
		$this->plot_area = array($x1,$y1,$x2,$y2);
		$this->plot_area_width = $this->plot_area[2] - $this->plot_area[0];
		$this->plot_area_height = $this->plot_area[3] - $this->plot_area[1];
		$this->y_top_margin = $this->plot_area[1];
		if ($this->plot_max_x) {
			$this->SetTranslation();
		}
		return true;
	}
	function SetPlotAreaPixels($x1,$y1,$x2,$y2) { 
		if (!$this->x_tot_margin) {
			$this->SetMargins();
		}
		if ($x2 && $y2) {
			$this->plot_area = array($x1,$y1,$x2,$y2);
		} else {
			$this->plot_area = array($this->x_left_margin, $this->y_top_margin,
								$this->picture_width - $this->x_right_margin,
								$this->picture_height - $this->y_bot_margin
							);
		}
		$this->plot_area_width = $this->plot_area[2] - $this->plot_area[0];
		$this->plot_area_height = $this->plot_area[3] - $this->plot_area[1];
		return true;
	}
	function SetPlotAreaWorld($xmin,$ymin,$xmax,$ymax) {
		if (($xmin == "")  && ($xmax == "")) { 
				if (!$this->max_y) {
					$this->FindDataLimits() ;
				}
				if ($this->data_type == 'text-data') { 
					$xmax = $this->max_x + 1 ; 
					$xmin = 0 ; 
				} else {
					$xmax = $this->max_x * 1.02;
					$xmin = $this->min_x;
				}
				$ymax = ceil($this->max_y * 1.2);
				if ($this->min_y < 0) {
					$ymin = floor($this->min_y * 1.2);
				} else {
					$ymin = 0;
				}
		}
		$this->plot_min_x = $xmin;
		$this->plot_max_x = $xmax;
		if ($ymin == $ymax) {
			$ymax += 1;
		}
		if ($this->yscale_type == "log") { 
			if ($ymin <= 0) { 
				$ymin = 1;
			} 
			if ($ymax <= 0) { 
				$this->PrintError('Log plots need data greater than 0');
			}
		}
		$this->plot_min_y = $ymin;
		$this->plot_max_y = $ymax;
		if ($ymax <= $ymin) {
			$this->DrawError('Error in Data - max not gt min');
		}     
		if ($this->plot_area_width) {
			$this->SetTranslation();
		}
		return true;
	} 
	function PrintError($error_message) { 
		echo "<p><b>Fatal error</b>: $error_message<p>";
		die;
	}
	function DrawError($error_message) {  
		if (($this->img) == "") { $this->InitImage(); } ;
		$ypos = $this->picture_height/2;
		if ($this->use_ttf == 1) {
			ImageRectangle($this->img, 0,0,$this->picture_width,$this->picture_height,ImageColorAllocate($this->img,255,255,255));
			ImageTTFText($this->img, $this->small_ttffont_size, 0, $xpos, $ypos, ImageColorAllocate($this->img,0,0,0), $this->axis_ttffont, $error_message);
		} else {
			ImageRectangle($this->img, 0,0,$this->picture_width,$this->picture_height,ImageColorAllocate($this->img,255,255,255));
			ImageString($this->img, $this->small_font,1,$ypos,$error_message, ImageColorAllocate($this->img,0,0,0));
		}
		$this->PrintImage();
		return true;
	}
	function TTFBBoxSize($size, $angle, $font, $string) { 
		$arr = ImageTTFBBox($size, 0, $font, $string);
		$flat_width  = $arr[0] - $arr[2];
		$flat_height = abs($arr[3] - $arr[5]);   
		$angle = deg2rad($angle);
		$width  = ceil(abs($flat_width*cos($angle) + $flat_height*sin($angle))); 
		$height = ceil(abs($flat_width*sin($angle) + $flat_height*cos($angle))); 
		return array($width, $height);
	}
	function SetXLabelHeight() {
		if ($this->use_ttf == 1) { 
			$size = $this->TTFBBoxSize($this->x_label_ttffont_size, 0, $this->axis_ttffont, $this->x_label_txt);
			$tmp = $size[1]; 
			$i = 0;
			$string = '';
			while ($i < $this->x_datalabel_maxlength) {
			  $string .= 'w';
			  $i++;
			} 
			$size = $this->TTFBBoxSize($this->axis_ttffont_size, $this->x_datalabel_angle, $this->axis_ttffont, $string);
			$this->x_label_height = 2*$tmp + $size[1] + 4;
		} else { 
			if ($this->x_datalabel_angle == 90) {
				$this->x_label_height = $this->x_datalabel_maxlength * ImageFontWidth($this->small_font) / 1.5;
			} else {
				$this->x_label_height = 5 * ImageFontHeight($this->small_font);
			}
		}
		$this->SetMargins();
		return true;
	} 
	function SetYLabelWidth() {  
		$ylab = number_format($this->max_y, $this->y_precision, ".", ",") . $this->si_units . ".";
		if ($this->use_ttf == 1) {
			$size = $this->TTFBBoxSize($this->axis_ttffont_size, 0, $this->axis_ttffont, $ylab);
		} else {
			$size[0] = StrLen($ylab) * $this->small_font_width * .6;
		}
		$this->y_label_width = $size[0] * 2;  
		$this->SetMargins();
		return true;
	}
	function SetEqualXCoord() { 
		$space = ($this->plot_area[2] - $this->plot_area[0]) / ($this->number_x_points * 2) * $this->group_frac_width;
		$group_width = $space * 2;
		$bar_width = $group_width / $this->records_per_group; 
		$this->data_group_space = $space;
		$this->record_bar_width = $bar_width;
		return true;
	}
	function SetLabelScalePosition($which_blp) { 
		$this->label_scale_position = $which_blp;
		return true;
	}
	function SetErrorBarSize($which_ebs) { 
		$this->error_bar_size = $which_ebs;
		return true;
	}
	function SetErrorBarShape($which_ebs) { 
		$this->error_bar_shape = $which_ebs;
		return true;
	}
	function SetPointShape($which_pt) { 
		$this->point_shape = $which_pt;
		return true;
	}
	function SetPointSize($which_ps) { 
		SetType($which_ps,'integer');
		$this->point_size = $which_ps;
		if ($this->point_shape == "diamond" or $this->point_shape == "triangle") {
			if ($this->point_size % 2 != 0) {
				$this->point_size++;
			}
		}
		return true;
	}
	function SetDataType($which_dt) { 
		if ($which_dt == "text-linear") { $which_dt = "text-data"; };
		if ($which_dt == "linear-linear") { $which_dt = "data-data"; };
		if ($which_dt == "linear-linear-error") { $which_dt = "data-data-error"; };
		$this->data_type = $which_dt; 
		return true;
	}
	function SetDataValues($which_dv) {
		$this->data_values = $which_dv; 
		return true;
	} 
	function SetRGBArray ($which_color_array) { 
		if ( is_array($which_color_array) ) { 
			$this->rgb_array = $which_color_array;
			return true;
		} elseif ($which_color_array == 2) { 
		$this->rgb_array = array(
			"white"			=> array(255, 255, 255),
			"snow"			=> array(255, 250, 250),
			"PeachPuff"		=> array(255, 218, 185),
			"ivory"			=> array(255, 255, 240),
			"lavender"		=> array(230, 230, 250),
			"black"			=> array(  0,   0,   0),
			"DimGrey"			=> array(105, 105, 105),
			"gray"			=> array(190, 190, 190),
			"grey"			=> array(190, 190, 190),
			"navy"			=> array(  0,   0, 128),
			"SlateBlue"			=> array(106,  90, 205),
			"blue"			=> array(  0,   0, 255),
			"SkyBlue"			=> array(135, 206, 235),
			"cyan"			=> array(  0, 255, 255),
			"DarkGreen"			=> array(  0, 100,   0),
			"green"			=> array(  0, 255,   0),
			"YellowGreen"			=> array(154, 205,  50),
			"yellow"			=> array(255, 255,   0),
			"orange"			=> array(255, 165,   0),
			"gold"			=> array(255, 215,   0),
			"peru"			=> array(205, 133,  63),
			"beige"			=> array(245, 245, 220),
			"wheat"			=> array(245, 222, 179),
			"tan"			=> array(210, 180, 140),
			"brown"			=> array(165,  42,  42),
			"salmon"			=> array(250, 128, 114),
			"red"			=> array(255,   0,   0),
			"pink"			=> array(255, 192, 203),
			"maroon"			=> array(176,  48,  96),
			"magenta"			=> array(255,   0, 255),
			"violet"			=> array(238, 130, 238),
			"plum"			=> array(221, 160, 221),
			"orchid"			=> array(218, 112, 214),
			"purple"			=> array(160,  32, 240),
			"azure1"			=> array(240, 255, 255),
			"aquamarine1"		=> array(127, 255, 212)
			);
			return true;
		} elseif ($which_color_array == 1)  { 
			include("./rgb.inc.php"); 
			$this->rgb_array = $RGBArray;
		} else { 
			$this->rgb_array = array("white" =>array(255,255,255), "black" => array(0,0,0));
			exit;
		}
		return true;
	}
	function SetColor($which_color) { 
		SetRgbColor($which_color);
		return true;
	}
	function SetIndexColor($which_color) { 
  		list ($r, $g, $b) = $this->SetRgbColor($which_color); 
		$index = ImageColorExact($this->img, $r, $g, $b);
		if ($index == -1) {  
	  			return ImageColorResolve($this->img, $r, $g, $b); 
 		} else {
	  			return $index;
  		}
	}
	
	function SetTransparentColor($which_color) { 
		ImageColorTransparent($this->img,$this->SetIndexColor($which_color));
		return true;
	}
	function SetRgbColor($color_asked) { 
		if ($color_asked == "") { $color_asked = array(0,0,0); };
		if ( count($color_asked) == 3 ) { 
	   		$ret_val =  $color_asked;
		} else { 
			if(substr($color_asked,0,1) == "#") { 
				$ret_val =  array(hexdec(substr($color_asked,1,2)), hexdec(substr($color_asked,3,2)), hexdec(substr($color,5,2)));
			} else { 
				$ret_val =  $this->rgb_array[$color_asked];
			}
		}
		return $ret_val;
	}
	function SetDataColors($which_data,$which_border) { 
		if (!$which_data) {
			$which_data = array(array(0,255,0),array(0,0,248),'yellow',array(255,0,0),'orange');
			$which_border = array('black');
		}
		$this->data_color = $which_data; 
		$this->data_border_color = $which_border; 
		unset($this->ndx_data_color);
		reset($this->data_color);  
		$i = 0;
		while (list(, $col) = each($which_data)) {
			$this->ndx_data_color[$i] = $this->SetIndexColor($col);
			$i++;
		}    
		unset($this->ndx_data_border_color);
		reset($this->data_border_color);
		$i = 0;
		while (list(, $col) = each($this->data_border_color)) {
			$this->ndx_data_border_color[$i] = $this->SetIndexColor($col);
			$i++;
		} 
		if (!$this->error_bar_color) { 
				reset($which_data);
				$this->SetErrorBarColors($which_data);
		}
		return true;
	} 
	function SetErrorBarColors($which_data) { 
	 if ($which_data) {
		$this->error_bar_color = $which_data; 
		unset($this->ndx_error_bar_color);
		reset($this->error_bar_color); 
		$i = 0;
		while (list(, $col) = each($this->error_bar_color)) {
			$this->ndx_error_bar_color[$i] = $this->SetIndexColor($col);
			$i++;
		}
		return true;
	  }
	  return false;
	} 
	function DrawPlotBorder() {
		switch ($this->plot_border_type) {
			case "left" :
				ImageLine($this->img, $this->plot_area[0],$this->ytr($this->plot_min_y),
					$this->plot_area[0],$this->ytr($this->plot_max_y),$this->ndx_grid_color);
			break;
			case "none": 
			break;
			default:
				ImageRectangle($this->img, $this->plot_area[0],$this->ytr($this->plot_min_y),
					$this->plot_area[2],$this->ytr($this->plot_max_y),$this->ndx_grid_color);
			break;
		}
		$this->DrawYAxis();
		$this->DrawXAxis();
		return true;
	}
	function SetHorizTickIncrement($which_ti) { 
		if ($which_ti) {
			$this->horiz_tick_increment = $which_ti; 
		} else {
			if (!$this->max_x) {
				$this->FindDataLimits(); 
			} 
			$this->horiz_tick_increment =  ($this->plot_max_x  - $this->plot_min_x  )/10;
		}
		$this->num_horiz_ticks = ''; 
		return true;
	}
	function SetDrawVertTicks($which_dvt) {
		$this->fetch_vert_ticks = $which_dvt;
		return true;
	} 
	function SetVertTickIncrement($which_ti) { 
		if ($which_ti) {
			$this->vert_tick_increment = $which_ti; 
		} else {
			if (!$this->max_y) {
				$this->FindDataLimits(); 
			} 
			$this->vert_tick_increment =  ($this->plot_max_y  - $this->plot_min_y  )/10;
		}
		$this->num_vert_ticks = ''; 
		return true;
	}
	function SetNumHorizTicks($which_nt) {
		$this->num_horiz_ticks = $which_nt;
		$this->horiz_tick_increment = ''; 
		return true;
	}
	function SetNumVertTicks($which_nt) {
		$this->num_vert_ticks = $which_nt;
		$this->vert_tick_increment = ''; 
		return true;
	}
	function SetVertTickPosition($which_tp) {
		$this->vert_tick_position = $which_tp; 
		return true;
	}
	function SetSkipBottomTick($which_sbt) {
		$this->skip_bottom_tick = $which_sbt;
		return true;
	}
	function SetTickLength($which_tl) {
		$this->tick_length = $which_tl;
		return true;
	}
	function DrawYAxis() { 
		if ($this->y_axis_position != "") { 
			$yaxis_x = $this->xtr($this->y_axis_position);
		} else { 
			$yaxis_x = $this->plot_area[0];
		}
		ImageLine($this->img, $yaxis_x, $this->plot_area[1], 
			$yaxis_x, $this->plot_area[3], $this->ndx_grid_color); 
		if ($this->fetch_vert_ticks == 1) { 
			$this->DrawVerticalTicks();
		}
	} 
	function DrawXAxis() { 
		$ylab =$this->FormatYTickLabel($this->x_axis_position);
		if ($this->skip_bottom_tick != 1) { 
			$this->DrawVerticalTick($ylab,$this->x_axis_position);
		} 
		ImageLine($this->img,$this->plot_area[0]+1,$this->ytr($this->x_axis_position),
				$this->xtr($this->plot_max_x)-1,$this->ytr($this->x_axis_position),$this->ndx_tick_color); 
		if ($this->data_type != 'text-data') { 
			$this->DrawHorizontalTicks();
		}
		return true;
	}
	function DrawHorizontalTicks() {  
		ImageLine($this->img,$this->plot_area[0],
				$this->plot_area[3]+$this->tick_length,
				$this->plot_area[0],$this->plot_area[3],$this->ndx_tick_color);
		switch ($this->x_grid_label_type) {
			case "title":
				$xlab = $this->data_values[0][0];
			break;
			case "data":
				$xlab = number_format($this->plot_min_x,$this->x_precision,".",",") . "$this->si_units";
			break;
			case "none":
				$xlab = '';
			break;
			case "time": 
				$xlab = strftime($this->x_time_format,$this->plot_min_x);
			break;
			default: 
				$xlab = $this->plot_min_x;
			break;
		}
		if ($this->x_datalabel_angle == 90) { 
			$xpos =  $this->plot_area[0] - $this->small_font_height/2;
			$ypos = ( $this->small_font_width*strlen($xlab) + $this->plot_area[3] + $this->small_font_height);
			ImageStringUp($this->img, $this->small_font,$xpos, $ypos, $xlab, $this->ndx_text_color);
		} else {
			$xpos = $this->plot_area[0] - $this->small_font_width*strlen($xlab)/2 ;
			$ypos = $this->plot_area[3] + $this->small_font_height;
			ImageString($this->img, $this->small_font,$xpos, $ypos, $xlab, $this->ndx_text_color);
		}   
		if ($this->horiz_tick_increment) {
			$delta_x = $this->horiz_tick_increment;
		} elseif ($this->num_horiz_ticks) {
			$delta_x = ($this->plot_max_x - $this->plot_min_x) / $this->num_horiz_ticks;
		} else {
			$delta_x =($this->plot_max_x - $this->plot_min_x) / 10 ;
		}
		$i = 0;
		$x_tmp = $this->plot_min_x;
		SetType($x_tmp,'double');
		while ($x_tmp <= $this->plot_max_x){ 
			switch ($this->x_grid_label_type) {
				case "title":
					$xlab = $this->data_values[$x_tmp][0];
				break;
				case "data":
					$xlab = number_format($x_tmp,$this->x_precision,".",",") . "$this->si_units";
				break;
				case "none":
					$xlab = '';
				break;
				case "time": 
					$xlab = strftime($this->x_time_format,$x_tmp);
				break;
				default: 
					$xlab = $x_tmp;
				break;
			}
			$x_pixels = $this->xtr($x_tmp); 
			ImageLine($this->img,$x_pixels,$this->plot_area[3] + $this->tick_length,
				$x_pixels,$this->plot_area[3], $this->ndx_tick_color);   
			if ($this->fetch_x_grid == 1) {
				ImageLine($this->img,$x_pixels,$this->plot_area[1],
					$x_pixels,$this->plot_area[3], $this->ndx_light_grid_color);
			}
			if ($this->x_datalabel_angle == 90) { 
 			   ImageStringUp($this->img, $this->small_font,
				( $x_pixels - $this->small_font_height/2),
				( $this->small_font_width*strlen($xlab) + $this->plot_area[3] + $this->small_font_height),$xlab, $this->ndx_text_color);
			} else {
				ImageString($this->img, $this->small_font,
					( $x_pixels - $this->small_font_width*strlen($xlab)/2) ,
					( $this->small_font_height + $this->plot_area[3]),$xlab, $this->ndx_text_color);
			}
			$i++;
			$x_tmp += $delta_x;
		}
	} 
	function FormatYTickLabel($which_ylab) { 
		switch ($this->y_grid_label_type) {
			case "data":
				$ylab = number_format($which_ylab,$this->y_precision,".",",") . "$this->si_units";
			break;
			case "none":
				$ylab = '';
			break;
			case "time":
				$ylab = strftime($this->y_time_format,$which_ylab);
			break;
			case "right":  
				$sstr = "%".strlen($this->plot_max_y)."s";
				$ylab = sprintf($sstr,$which_ylab);
			break;
			default: 
				$ylab = $which_ylab;
			break;
		}
		return($ylab);
	} 
	function DrawVerticalTick($which_ylab,$which_ypos) {       
		if ($this->y_axis_position != "") { 
			$yaxis_x = $this->xtr($this->y_axis_position);
		} else { 
			$yaxis_x = $this->plot_area[0];
		}
		$y_pixels = $this->ytr($which_ypos); 
		if ($this->fetch_y_grid == 1) {
			ImageLine($this->img,$this->plot_area[0]+1,$y_pixels,
				$this->plot_area[2]-1,$y_pixels,$this->ndx_light_grid_color);
		} 
		if (($this->vert_tick_position == "plotleft") || ($this->vert_tick_position == "both") ) { 
			ImageLine($this->img,(-$this->tick_length+$yaxis_x),
			$y_pixels,$yaxis_x,
			$y_pixels, $this->ndx_tick_color);
		} 
		if (($this->vert_tick_position == "plotright") || ($this->vert_tick_position == "both") ) { 
			ImageLine($this->img,($this->plot_area[2]+$this->tick_length),
			$y_pixels,$this->plot_area[2],
			$y_pixels,$this->ndx_tick_color);
		} 
		if (($this->vert_tick_position == "yaxis") ) { 
			ImageLine($this->img,($yaxis_x - $this->tick_length),
			$y_pixels,$yaxis_x,$y_pixels,$this->ndx_tick_color);
		}    
		ImageString($this->img, $this->small_font, ($yaxis_x - $this->y_label_width - $this->tick_length/2),
			( -($this->small_font_height/2.0) + $y_pixels),$which_ylab, $this->ndx_text_color);
	}
	function DrawVerticalTicks() {
		if ($this->skip_top_tick != 1) {         
			ImageLine($this->img,$this->plot_area[0]+1,$this->ytr($this->plot_max_y),
					$this->plot_area[2]-1,$this->ytr($this->plot_max_y),$this->ndx_light_grid_color);
		}
		if ($this->skip_bottom_tick != 1) {     
			ImageLine($this->img,$this->xtr($this->plot_min_x)+1,$this->ytr($this->plot_min_y),
					$this->xtr($this->plot_max_x),$this->ytr($this->plot_min_y),$this->ndx_light_grid_color);
		} 
		if ($this->vert_tick_increment) {
			$delta_y = $this->vert_tick_increment;
		} elseif ($this->num_vert_ticks) {
			$delta_y = ($this->plot_max_y - $this->plot_min_y) / $this->num_vert_ticks;
		} else {
			$delta_y =($this->plot_max_y - $this->plot_min_y) / 10 ;
		}
		$y_tmp = $this->plot_min_y;
		SetType($y_tmp,'double');
		if ($this->skip_bottom_tick == 1) { 
			$y_tmp += $delta_y;
		}
		while ($y_tmp <= $this->plot_max_y){ 
			if (($this->yscale_type == "log") && ($this->plot_min_y == 1) && 
				($delta_y%10 == 0) && ($y_tmp == $this->plot_min_y)) { 
				$y_tmp = $y_tmp - 1; 
			}
			$ylab = $this->FormatYTickLabel($y_tmp);
			$this->DrawVerticalTick($ylab,$y_tmp);
			$y_tmp += $delta_y;
		}
		return true;
	} 
	function SetTranslation() {
		if ($this->xscale_type == "log") { 
			$this->xscale = ($this->plot_area_width)/(log10($this->plot_max_x) - log10($this->plot_min_x));
		} else { 
			$this->xscale = ($this->plot_area_width)/($this->plot_max_x - $this->plot_min_x);
		}
		if ($this->yscale_type == "log") { 
			$this->yscale = ($this->plot_area_height)/(log10($this->plot_max_y) - log10($this->plot_min_y));
		} else { 
			$this->yscale = ($this->plot_area_height)/($this->plot_max_y - $this->plot_min_y);
		} 
		if ($this->xscale_type == "log") { 
			$this->plot_origin_x = $this->plot_area[0] - ($this->xscale * log10($this->plot_min_x) );
		} else { 
			$this->plot_origin_x = $this->plot_area[0] - ($this->xscale * $this->plot_min_x);
		}
		if ($this->yscale_type == "log") { 
			$this->plot_origin_y = $this->plot_area[3] + ($this->yscale * log10($this->plot_min_y));
		} else { 
			$this->plot_origin_y = $this->plot_area[3] + ($this->yscale * $this->plot_min_y);
		}
		$this->scale_is_set = 1;
	} 
	function xtr($x_world) {    
		if ($this->xscale_type == "log") { 
			$x_pixels =  $this->plot_origin_x + log10($x_world) * $this->xscale ;
		} else { 
			$x_pixels =  $this->plot_origin_x + $x_world * $this->xscale ;
		}
		return($x_pixels);
	}
	function ytr($y_world) { 
		if ($this->yscale_type == "log") { 
			$y_pixels =  $this->plot_origin_y - log10($y_world) * $this->yscale ; 
		} else { 
			$y_pixels =  $this->plot_origin_y - $y_world * $this->yscale ;  
		}
		return ($y_pixels);
	}
	function DrawDataLabel($lab,$x_world,$y_world) {      
			if ($this->use_ttf) { 
				$lab_size = $this->TTFBBoxSize($this->axis_ttffont_size, $this->x_datalabel_angle, $this->axis_ttffont, $lab); 
				$y = $this->ytr($y_world) - $lab_size[1] ; 
				$x = $this->xtr($x_world) - $lab_size[0]/2;
				ImageTTFText($this->img, $this->axis_ttffont_size, $this->x_datalabel_angle, $x, $y, $this->ndx_text_color, $this->axis_ttffont, $lab);
			} else {
				$lab_size = array($this->small_font_width*StrLen($lab), $this->small_font_height*3);
				if ($this->x_datalabel_angle == 90) {
					$y = $this->ytr($y_world) - $this->small_font_width*StrLen($lab); 
					$x = $this->xtr($x_world) - $this->small_font_height;
					ImageStringUp($this->img, $this->small_font,$x, $y ,$lab, $this->ndx_text_color);
				} else {
					$y = $this->ytr($y_world) - $this->small_font_height; 
					$x = $this->xtr($x_world) - ($this->small_font_width*StrLen($lab))/2;
					ImageString($this->img, $this->small_font,$x, $y ,$lab, $this->ndx_text_color);
				}
			}
	}
	function DrawXDataLabel($xlab,$xpos) {  
			if ($this->use_ttf) {
				$xlab_size = $this->TTFBBoxSize($this->axis_ttffont_size,
					$this->x_datalabel_angle, $this->axis_ttffont, $xlab); 
				$y = $this->plot_area[3] + $xlab_size[1] + 4; 
				$x = $xpos - $xlab_size[0]/2;
				ImageTTFText($this->img, $this->axis_ttffont_size,
					$this->x_datalabel_angle, $x, $y, $this->ndx_text_color, $this->axis_ttffont, $xlab);
			} else {
				$xlab_size = array(ImageFontWidth($this->axis_font)*StrLen($xlab), $this->small_font_height*3);
				if ($this->x_datalabel_angle == 90) {
					$y = $this->plot_area[3] + ImageFontWidth($this->axis_font)*StrLen($xlab); 
					$x = $xpos - ($this->small_font_height);
					ImageStringUp($this->img, $this->axis_font,$x, $y ,$xlab, $this->ndx_text_color);
				} else {
					$y = $this->plot_area[3] + ImageFontHeight($this->axis_font); 
					$x = $xpos - (ImageFontWidth($this->axis_font)*StrLen($xlab))/2;
					ImageString($this->img, $this->axis_font,$x, $y ,$xlab, $this->ndx_text_color);
				}
			}
	}
	function DrawPieChart() { 
		$xpos = $this->plot_area[0] + $this->plot_area_width/2;
		$ypos = $this->plot_area[1] + $this->plot_area_height/2;
		$diameter = (min($this->plot_area_width, $this->plot_area_height)) ;
		$radius = $diameter/2;
		ImageArc($this->img, $xpos, $ypos, $diameter, $diameter, 0, 360, $this->ndx_grid_color);
		$total = 0;
		reset($this->data_values);
		$tmp = $this->number_x_points - 1;
		while (list($j, $row) = each($this->data_values)) { 
			$color_index = 0;
			$i = 0; 
			while (list($k, $v) = each($row)) {
				if ($k != 0) {
					if ($j == 0) { 
						$sumarr[$i] = $v;
					} elseif ($j < $tmp) { 
						$sumarr[$i] += $v;
					} else { 
						$sumarr[$i] += $v; 
						$sumarr[$i] = abs($sumarr[$i]); 
						$total += $sumarr[$i];
					}
				}
			$i++;
			}
		}
		$color_index = 0;
		$start_angle = 0;
		reset($sumarr);
		$end_angle = 0;
		while (list(, $val) = each($sumarr)) {
			if ($color_index >= count($this->ndx_data_color)) $color_index=0; 
			$label_txt = number_format(($val / $total * 100), $this->y_precision, ".", ",") . "%";
			$val = 360 * ($val / $total);
			$end_angle += $val;
			$mid_angle = $end_angle - ($val / 2);
			$slicecol = $this->ndx_data_color[$color_index]; 
			ImageArc($this->img, $xpos, $ypos, $diameter, $diameter, 0, 360, $this->ndx_grid_color);
			$out_x = $radius * cos(deg2rad($end_angle));
			$out_y = - $radius * sin(deg2rad($end_angle));
			$mid_x = $xpos + ($radius/2 * cos(deg2rad($mid_angle))) ;
			$mid_y = $ypos + (- $radius/2 * sin(deg2rad($mid_angle)));
			$label_x = $xpos + ($radius * cos(deg2rad($mid_angle))) * $this->label_scale_position;
			$label_y = $ypos + (- $radius * sin(deg2rad($mid_angle))) * $this->label_scale_position;
			$out_x = $xpos + $out_x;
			$out_y = $ypos + $out_y;
			ImageLine($this->img, $xpos, $ypos, $out_x, $out_y, $this->ndx_grid_color); 
			ImageFillToBorder($this->img, $mid_x, $mid_y, $this->ndx_grid_color, $slicecol);
			if ($this->use_ttf) {
				ImageTTFText($this->img, $this->axis_ttffont_size, 0, $label_x, $label_y, $this->ndx_grid_color, $this->axis_ttffont, $label_txt);
			} else {
				ImageString($this->img, $this->small_font, $label_x, $label_y, $label_txt, $this->ndx_grid_color);
			}
			$start_angle = $val;
			$color_index++;
		}
	}
	function DrawLinesError() { 
		$start_lines = 0;
		reset($this->data_values);
		while (list(, $row) = each($this->data_values)) {
			$color_index = 0;
			$i = 0;
			while (list($key, $val) = each($row)) { 
				if ($key == 0) {
					$lab = $val;
				} elseif ($key == 1) {
					$x_now = $val;
					$x_now_pixels = $this->xtr($x_now); 
				} elseif ($key%3 == 2) {
					$y_now = $val;
					$y_now_pixels = $this->ytr($y_now); 
					if ( $this->fetch_data_labels == 1) {
						$this->DrawDataLabel($lab,$x_now,$y_now);
					}
					if ($color_index >= count($this->ndx_data_color)) { $color_index=0;};
					$barcol = $this->ndx_data_color[$color_index];
					$error_barcol = $this->ndx_error_bar_color[$color_index]; 
					if ($start_lines == 1) {
						for ($width = 0; $width < $this->line_width; $width++) {
							ImageLine($this->img, $x_now_pixels, $y_now_pixels + $width,
								$lastx[$i], $lasty[$i] + $width, $barcol);
						}
					}
					$lastx[$i] = $x_now_pixels;
					$lasty[$i] = $y_now_pixels;
					$color_index++;
					$i++;
					$start_lines = 1;
				} elseif ($key%3 == 0) {
					$this->DrawYErrorBar($x_now,$y_now,$val,$this->error_bar_shape,$error_barcol);
				} elseif ($key%3 == 1) {
					$this->DrawYErrorBar($x_now,$y_now,-$val,$this->error_bar_shape,$error_barcol);
				}
			}
		}
	}
	function DrawDotsError() { 
		reset($this->data_values);
		while (list(, $row) = each($this->data_values)) {
			$color_index = 0; 
			while (list($key, $val) = each($row)) {
				if ($key == 0) {
				} elseif ($key == 1) {
					$xpos = $val;
				} elseif ($key%3 == 2) {
					if ($color_index >= count($this->ndx_data_color)) $color_index=0;
					$barcol = $this->ndx_data_color[$color_index];
					$error_barcol = $this->ndx_error_bar_color[$color_index];
					$ypos = $val;
					$color_index++;
					$this->DrawDot($xpos,$ypos,$this->point_shape,$barcol);
				} elseif ($key%3 == 0) {
					$this->DrawYErrorBar($xpos,$ypos,$val,$this->error_bar_shape,$error_barcol);
				} elseif ($key%3 == 1) {
					$mine = $val ;
					$this->DrawYErrorBar($xpos,$ypos,-$val,$this->error_bar_shape,$error_barcol);
				}
			}
		}
	}
	function DrawDots() { 
		reset($this->data_values);
		while (list($j, $row) = each($this->data_values)) {
			$color_index = 0; 
			while (list($k, $v) = each($row)) {
				if ($k == 0) {
				} elseif (($k == 1) && ($this->data_type == "data-data"))  { 
					$xpos = $v;
				} else {
					if ($this->data_type == "text-data") { 
						$xpos = ($j+.5); 
					} 
					if ($color_index >= count($this->ndx_data_color)) $color_index=0;
					$barcol = $this->ndx_data_color[$color_index]; 
					if ((strval($v) != "") ) { 
						$this->DrawDot($xpos,$v,$this->point_shape,$barcol);
					}
					$color_index++;
				}
			}
		}
	} 
	function DrawDotSeries() { 
		$this->DrawDots();
	}
	function DrawThinBarLines() {   
		if ($this->data_type != "data-data") { $this->DrawError('Data Type for ThinBarLines must be data-data'); };
		$y1 = $this->ytr($this->x_axis_position);
		reset($this->data_values);
		while (list(, $row) = each($this->data_values)) {
			$color_index = 0;
			while (list($k, $v) = each($row)) {
				if ($k == 0) {
						$xlab = $v;
				} elseif ($k == 1) {
					$xpos = $this->xtr($v);
					if ( ($this->fetch_x_data_labels == 1) )  { 
						$this->DrawXDataLabel($xlab,$xpos);
					}
				} else {
					if ($color_index >= count($this->ndx_data_color)) $color_index=0;
					$barcol = $this->ndx_data_color[$color_index];
					ImageLine($this->img,$xpos,$y1,$xpos,$this->ytr($v),$barcol);
					$color_index++;
				}
			}
		}
	} 
	function DrawYErrorBar($x_world,$y_world,$error_height,$error_bar_type,$color) {
		$x1 = $this->xtr($x_world);
		$y1 = $this->ytr($y_world);
		$y2 = $this->ytr($y_world+$error_height) ;
		for ($width = 0; $width < $this->error_bar_line_width; $width++) {
			ImageLine($this->img, $x1+$width, $y1 , $x1+$width, $y2, $color);
			ImageLine($this->img, $x1-$width, $y1 , $x1-$width, $y2, $color);
		}
		switch ($error_bar_type) {
			case "line":
				break;
			case "tee":
				ImageLine($this->img, $x1-$this->error_bar_size, $y2, $x1+$this->error_bar_size, $y2, $color);
				break;
			default:
				ImageLine($this->img, $x1-$this->error_bar_size, $y2, $x1+$this->error_bar_size, $y2, $color);
				break;
		}
		return true;
	}
	function DrawDot($x_world,$y_world,$dot_type,$color) {
		$half_point = $this->point_size / 2;
		$x1 = $this->xtr($x_world) - $half_point;
		$x2 = $this->xtr($x_world) + $half_point;
		$y1 = $this->ytr($y_world) - $half_point;
		$y2 = $this->ytr($y_world) + $half_point;
		switch ($dot_type) {
			case "halfline":
				ImageFilledRectangle($this->img, $x1, $this->ytr($y_world), $this->xtr($x_world), $this->ytr($y_world), $color);
				break;
			case "line":
				ImageFilledRectangle($this->img, $x1, $this->ytr($y_world), $x2, $this->ytr($y_world), $color);
				break;
			case "rect":
				ImageFilledRectangle($this->img, $x1, $y1, $x2, $y2, $color);
				break;
			case "circle":
				ImageArc($this->img, $x1 + $half_point, $y1 + $half_point, $this->point_size, $this->point_size, 0, 360, $color);
				break;
			case "dot":
				ImageArc($this->img, $x1 + $half_point, $y1 + $half_point, $this->point_size, $this->point_size, 0, 360, $color);
				ImageFillToBorder($this->img, $x1 + $half_point, $y1 + $half_point, $color, $color);
				break;
			case "diamond":
				$arrpoints = array(
					$x1,$y1 + $half_point,
					$x1 + $half_point, $y1,
					$x2,$y1 + $half_point,
					$x1 + $half_point, $y2
				);
				ImageFilledPolygon($this->img, $arrpoints, 4, $color);
				break;
			case "triangle":
				$arrpoints = array( $x1, $y1 + $half_point,
					$x2, $y1 + $half_point,
					$x1 + $half_point, $y2
				);
				ImageFilledPolygon($this->img, $arrpoints, 3, $color);
				break;
			default:
				ImageFilledRectangle($this->img, $x1, $y1, $x2, $y2, $color);
				break;
		}
		return true;
	}
	function SetErrorBarLineWidth($which_seblw) {
		$this->error_bar_line_width = $which_seblw;
		return true;
	}
	function SetLineWidth($which_lw) {
		$this->line_width = $which_lw;
		if (!$this->error_bar_line_width) { 
			$this->error_bar_line_width = $which_lw;
		}
		return true;
	}
	function DrawArea() {  
		$i = 0;
		while ($i < $this->records_per_group) {
			$posarr[$i][] =  $this->xtr($this->min_x); 
			$posarr[$i][] =  $this->ytr($this->x_axis_position); 
			$i++;
		}
		reset($this->data_values);
		while (list($j, $row) = each($this->data_values)) {
			$color_index = 0; 
			while (list($k, $v) = each($row)) {
				if ($k == 0) { 
					$xlab = SubStr($v,0,$this->x_datalabel_maxlength);
				} elseif ($k == 1) {
					$x = $this->xtr($v);  
				} else { 
					$y = $this->ytr($v);
					$posarr[$color_index][] = $x;
					$posarr[$color_index][] = $y;
					$color_index++;
				}
			}
		} 
		for ($i = 0; $i < $this->records_per_group; $i++) {
			$posarr[$i][] =  $this->xtr($this->max_x); 
			$posarr[$i][] =  $this->ytr($this->x_axis_position); 
	   	}
		$color_index=0; 
		reset($posarr);
		while (list(, $row) = each($posarr)) {
			if ($color_index >= count($this->ndx_data_color)) $color_index=0;
			$barcol = $this->ndx_data_color[$color_index]; 
			ImageFilledPolygon($this->img, $row, (count($row)) / 2, $barcol);
			$color_index++;
		} 
	}
	function DrawAreaSeries() { 
		$i = 0;
		while ($i < $this->records_per_group) {
			$posarr[$i][] =  $this->xtr(.5); 
			$posarr[$i][] =  $this->ytr($this->x_axis_position); 
			$i++;
		}
		reset($this->data_values);
		while (list($j, $row) = each($this->data_values)) {
			$color_index = 0; 
			while (list($k, $v) = each($row)) {
				if ($k == 0) { 
					$xlab = SubStr($v,0,$this->x_datalabel_maxlength);
					$this->DrawXDataLabel($xlab,$this->xtr($j + .5));
				} else { 
					$x = round($this->xtr($j + .5 ));
					$y = round($this->ytr($v));
					$posarr[$color_index][] = $x;
					$posarr[$color_index][] = $y;
					$color_index++;
				}
			}
		} 
		for ($i = 0; $i < $this->records_per_group; $i++) {
			$posarr[$i][] =  round($this->xtr($this->max_x + .5)); 
			$posarr[$i][] =  $this->ytr($this->x_axis_position); 
	   	}
		$color_index=0; 
		reset($posarr);
		while (list(, $row) = each($posarr)) {
			if ($color_index >= count($this->ndx_data_color)) $color_index=0;
			$barcol = $this->ndx_data_color[$color_index]; 
			ImageFilledPolygon($this->img, $row, (count($row)) / 2, $barcol);
			$color_index++;
		}
	}
	function DrawLines() { 
		$start_lines = 0;
		if ($this->data_type == "text-data") { 
			$lastx[0] = $this->xtr(0);
			$lasty[0] = $this->xtr(0);
		} 
		reset($this->data_values);
		while (list($j, $row) = each($this->data_values)) {
			$color_index = 0;
			$i = 0; 
			while (list($k, $v) = each($row)) {
				if ($k == 0) { 
					$xlab = SubStr($v,0,$this->x_datalabel_maxlength);
				} elseif (($k == 1) && ($this->data_type == "data-data"))  { 
						$x_now = $this->xtr($v);
				} else {  
					if ($this->data_type == "text-data") { 
						$x_now = $this->xtr($j+.5); 
					} 
					if ((strval($v) != "") ) { 
						$y_now = $this->ytr($v);
						if ($color_index >= count($this->ndx_data_color)) { $color_index=0;} ;
						$barcol = $this->ndx_data_color[$color_index];
						if ($start_lines == 1) {
							for ($width = 0; $width < $this->line_width; $width++) {
								if ($this->line_style[$i] == "dashed") {
									$this->DrawDashedLine($x_now, $y_now + $width, $lastx[$i], $lasty[$i] + $width, 4,4, $barcol);
								} else {
									ImageLine($this->img, $x_now, $y_now + $width, $lastx[$i], $lasty[$i] + $width, $barcol);
								}
							}
						}
						$lastx[$i] = $x_now;
					} else { 
						$y_now = $lasty[$i]; 
					} 
					$lasty[$i] = $y_now;
					$color_index++;
					$i++;
				} 
				if ( ($this->fetch_x_data_labels == 1) && ($k == 1) )  { 
					$this->DrawXDataLabel($xlab,$x_now);
				}
			} 
			$start_lines = 1;
		}
	} 
	function DrawLineSeries() {   
		return false;
	} 
	function DrawDashedLine($x1pix,$y1pix,$x2pix,$y2pix,$dash_length,$dash_space,$color) {       
		$line_length = ceil (sqrt(pow(($x2pix - $x1pix),2) + pow(($y2pix - $y1pix),2)) );
		$dx = ($x2pix - $x1pix) / $line_length;
		$dy = ($y2pix - $y1pix) / $line_length;
		$lastx	= $x1pix;
		$lasty	= $y1pix; 
		for ($i = 0; $i < $line_length; $i += ($dash_length + $dash_space)) {
			$xpix = ($dash_length * $dx) + $lastx;
			$ypix = ($dash_length * $dy) + $lasty;
			ImageLine($this->img,$lastx,$lasty,$xpix,$ypix,$color);
			$lastx = $xpix + ($dash_space * $dx);
			$lasty = $ypix + ($dash_space * $dy);
		}
	} 
	function DrawBars() {
		if ($this->data_type != "text-data") { 
			$this->DrawError('Bar plots must be text-data: use function SetDataType("text-data")');
		}
		$xadjust = ($this->records_per_group * $this->record_bar_width )/4;
		reset($this->data_values);
		while (list($j, $row) = each($this->data_values)) {
			$color_index = 0;
			$colbarcount = 0;
			$x_now = $this->xtr($j+.5);
			while (list($k, $v) = each($row)) {
				if ($k == 0) { 
					$xlab = SubStr($v,0,$this->x_datalabel_maxlength);
					$this->DrawXDataLabel($xlab,$x_now);
				} else { 
					$x1 = $x_now - $this->data_group_space + ($k-1)*$this->record_bar_width;
					$x2 = $x1 + $this->record_bar_width*$this->bar_width_adjust; 
					if ($v < $this->x_axis_position) {
						$y1 = $this->ytr($this->x_axis_position);
						$y2 = $this->ytr($v);
					} else {
						$y1 = $this->ytr($v);
						$y2 = $this->ytr($this->x_axis_position);
					}
					if ($color_index >= count($this->ndx_data_color)) $color_index=0;
					if ($colbarcount >= count($this->ndx_data_border_color)) $colbarcount=0;
					$barcol = $this->ndx_data_color[$color_index];
					$bordercol = $this->ndx_data_border_color[$colbarcount];
					if ((strval($v) != "") ) { 
						if ($this->shading > 0) {
							for($i=0;$i<($this->shading);$i++) { 
							ImageFilledRectangle($this->img, $x1+$i, $y1-$i, $x2+$i, $y2-$i, $this->ndx_i_light);
							}
						}
						ImageFilledRectangle($this->img, $x1, $y1, $x2, $y2, $barcol);
						ImageRectangle($this->img, $x1, $y1, $x2, $y2, $bordercol);
						if ($this->fetch_data_labels == '1') { 
							$y1 = $this->ytr($this->label_scale_position * $v); 
							$this->DrawText($this->x_label_ttffont, $this->x_label_angle,
								$x1+$this->record_bar_width/2, $y1, $this->ndx_label_color, $this->x_label_ttffont_size, $v,'center','top');
						}
					} 
					$color_index++;
					$colbarcount++;
				}
			}
		}
	} 
	function DrawLegend($which_x1,$which_y1,$which_frametype) { 
		$max_legend_length=0;
		reset($this->legend);
		while (list(,$leg) = each($this->legend)) {
			$len = strlen($leg);
			if ($max_legend_length < $len) {
				$max_legend_length = $len;
			}
		}
		$line_spacing = 1.25;
		$vert_margin = $this->small_font_height/2 ;
		$dot_height = $this->small_font_height*$line_spacing - 1; 
		if ((!$which_x1) || (!$which_y1) ) {
			$frame_start_x = $this->plot_area[2] - $this->small_font_width*($max_legend_length+4);
			$frame_start_y = $this->plot_area[1] + 4;
		} else { 
			$frame_start_x = $which_x1;
			$frame_start_y = $which_y1;
		} 
		$frame_end_y = $frame_start_y + $this->small_font_height*(count($this->legend)+1) + 2*$vert_margin; 
		$frame_end_x = $frame_start_x + $this->small_font_width*($max_legend_length+4) - 5; 
		ImageFilledRectangle($this->img,
			$frame_start_x, $frame_start_y,$frame_end_x,
			$frame_end_y, $this->ndx_bg_color);
		ImageRectangle($this->img,
			$frame_start_x, $frame_start_y,$frame_end_x,
			$frame_end_y, $this->ndx_grid_color);
		$color_index=0;
		$i = 0;
		reset($this->legend);
		while (list(,$leg) = each($this->legend)) {
			$y_pos = $frame_start_y + $this->small_font_height*($i)*($line_spacing) + $vert_margin;
			ImageString($this->img, $this->small_font,
			$frame_start_x + $this->small_font_width*( $max_legend_length - strlen($leg) + 1 ) ,
			$y_pos,
			$leg, $this->ndx_text_color);
			if ($color_index >= count($this->ndx_data_color)) $color_index=0; 
			ImageFilledRectangle($this->img,
				$frame_end_x - $this->small_font_width*2,
				$y_pos + 1, $frame_end_x - $this->small_font_width,
				$y_pos + $dot_height,
				$this->ndx_data_color[$color_index]);
			ImageRectangle($this->img,
				$frame_end_x - $this->small_font_width*2,
				$y_pos + 1, $frame_end_x - $this->small_font_width,
				$y_pos + $dot_height,
				$this->ndx_text_color);
			$i++;
			$color_index++;
		}
	} 
	function DrawGraph() {
		if (($this->img) == "") {
			$this->DrawError('No Image Defined: DrawGraph'); 
        }
		if (! is_array($this->data_values)) {
			$this->DrawBackground();
			$this->DrawError("No array of data in \$data_values");
		} else {
			if (!$this->data_color) {
				$this->SetDataColors(array('blue','green','yellow','red','orange','blue'),array('black'));
			}
			$this->FindDataLimits(); 
			$this->SetXLabelHeight(); 
			$this->SetYLabelWidth(); 
			if (!$this->plot_area_width) {
				$this->SetPlotAreaPixels('','','',''); 
			}
			if (!$this->plot_max_y) { 
				$this->SetPlotAreaWorld('','','','');
			}
			if ($this->data_type == "text-data") {
				$this->SetEqualXCoord();
			}
			$this->SetPointSize($this->point_size);
			$this->DrawBackground();
			$this->DrawImageBorder();
			$this->SetTranslation();
			if ($this->fetch_plot_area_background == 1) {
				$this->DrawPlotAreaBackground();
			}  
			switch ($this->plot_type) {
				case "bars":
					$this->DrawPlotBorder();
					$this->DrawLabels();
					$this->DrawBars();
					$this->DrawXAxis();
					break;
				case "thinbarline":
					$this->DrawPlotBorder();
					$this->DrawLabels();
					$this->DrawThinBarLines();
					break;
				case "lines":
					$this->DrawPlotBorder();
					$this->DrawLabels();
					if ( $this->data_type == "text-data") {
						$this->DrawLines();
					} elseif ( $this->data_type == "data-data-error") {
						$this->DrawLinesError();
					} else {
						$this->DrawLines();
					}
					break;
				case "area":
					$this->DrawPlotBorder();
					$this->DrawLabels();
					if ( $this->data_type == "text-data") {
						$this->DrawAreaSeries();
					} else {
						$this->DrawArea();
					}
					break;
				case "linepoints":
					$this->DrawPlotBorder();
					$this->DrawLabels();
					if ( $this->data_type == "text-data") {
						$this->DrawLines();
						$this->DrawDots();
					} elseif ( $this->data_type == "data-data-error") {
						$this->DrawLinesError();
						$this->DrawDotsError();
					} else {
						$this->DrawLines();
						$this->DrawDots();
					}
					break;
				case "points";
					$this->DrawPlotBorder();
					$this->DrawLabels();
					if ( $this->data_type == "text-data") {
						$this->DrawDots();
					} elseif ( $this->data_type == "data-data-error") {
						$this->DrawDotsError();
					} else {
						$this->DrawDots();
					}
					break;
				case "pie":
					$this->DrawPieChart();
					$this->DrawLabels();
					break;
				default:
					$this->DrawPlotBorder();
					$this->DrawLabels();
					$this->DrawBars();
					break;
			}
			if ($this->legend) {
				$this->DrawLegend($this->legend_x_pos,$this->legend_y_pos,'');
			}
		}
		if ($this->print_picture == 1) { 
			$this->PrintImage();
		}
	} 
 }  
?>
