<?php
/*
###################################################################################
  Bigware Shop 2.3
  Release Datum: 23.08.2015
  
  Bigware Shop
  http://www.bigware.de

  Copyright (c) 2015 Bigware LTD
  (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
  (c) 2015	Bigware LTD

  Copyrightvermerke duerfen nicht entfernt werden.
  ------------------------------------------------------------------------
  Dieses Programm ist freie Software. Sie koennen es unter den Bedingungen
  der GNU General Public License, wie von der Free Software Foundation
  veroeffentlicht, weitergeben und/oder modifizieren, entweder gemaess Version 2 
  der Lizenz oder (nach Ihrer Option) jeder spaeteren Version.
  Die Veroeffentlichung dieses Programms erfolgt in der Hoffnung, dass es Ihnen
  von Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE, sogar ohne die
  implizite Garantie der MARKTREIFE oder der VERWENDBARKEIT FUER EINEN
  BESTIMMTEN ZWECK. Details finden Sie in der GNU General Public License.
  
  Sie sollten eine Kopie der GNU General Public License zusammen mit diesem
  Programm erhalten haben. Falls nicht, schreiben Sie an die Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.

  Infos:
  ------------------------------------------------------------------------
  Der Bigware Shop wurde vor vielen Jahren bereits aus dem bekannten Shopsystem osCommerce
  weiter- und neuentwickelt.
  Der Bigware Shop legt im hohen Masse Wert auf Bedienerfreundlichkeit, beinhaltet eine leichte
  Installation, viele neue professionelle Werkzeuge und zeichnet sich aus durch eine grosse 
  Community, die bei Problemen weiterhelfen kann.
  
  Der Bigware Shop ist auf jedem System lauffaehig, welches eine PHP Umgebung
  (ab PHP 4.1.3) und mySQL zur Verfuegung stellt und auf Linux basiert.
 
  Hilfe erhalten Sie im Forum auf www.bigware.de 
  
  -----------------------------------------------------------------------
  
 ##################################################################################




*/
?>
<?php
class shoppingCart {
	var $contents, $total, $weight;
	function shoppingCart() {
		$this->reset();
	}
	function restore_contents() {
		global $attendee_id;
		if (!$attendee_id) return 0; 
		if ($this->contents) {
			reset($this->contents);
			while (list($items_id, ) = each($this->contents)) {
				$qty = $this->contents[$items_id]['qty'];
				$item_query = go_db_query("select items_id from " . DB_TBL_ATTENDEES_BASKET . " where attendees_id = '" . (int)$attendee_id . "' and items_id = '" . go_db_input($items_id) . "'");
				if (!go_db_num_rows($item_query)) {
					go_db_query("insert into " . DB_TBL_ATTENDEES_BASKET . " (attendees_id, items_id, attendees_basket_quantity, attendees_basket_date_added) values ('" . (int)$attendee_id . "', '" . go_db_input($items_id) . "', '" . go_db_input($qty) . "', '" . date('Ymd') . "')");
					if ($this->contents[$items_id]['characteristics']) {
						reset($this->contents[$items_id]['characteristics']);
						while (list($option, $value) = each($this->contents[$items_id]['characteristics'])) {
							go_db_query("insert into " . DB_TBL_ATTENDEES_BASKET_CHARACTERISTICS . " (attendees_id, items_id, items_options_id, items_options_value_id) values ('" . (int)$attendee_id . "', '" . go_db_input($items_id) . "', '" . (int)$option . "', '" . (int)$value . "')");
						}
					}
				} else {
					go_db_query("update " . DB_TBL_ATTENDEES_BASKET . " set attendees_basket_quantity = '" . go_db_input($qty) . "' where attendees_id = '" . (int)$attendee_id . "' and items_id = '" . go_db_input($items_id) . "'");
				}
			}
		} 
		$this->reset(FALSE);
		$items_query = go_db_query("select items_id, attendees_basket_quantity from " . DB_TBL_ATTENDEES_BASKET . " where attendees_id = '" . (int)$attendee_id . "'");
		while ($items = go_db_fetch_array($items_query)) {
			$this->contents[$items['items_id']] = array('qty' => $items['attendees_basket_quantity']); 
			$characteristics_query = go_db_query("select items_options_id, items_options_value_id from " . DB_TBL_ATTENDEES_BASKET_CHARACTERISTICS . " where attendees_id = '" . (int)$attendee_id . "' and items_id = '" . go_db_input($items['items_id']) . "'");
			while ($characteristics = go_db_fetch_array($characteristics_query)) {
				$this->contents[$items['items_id']]['characteristics'][$characteristics['items_options_id']] = $characteristics['items_options_value_id'];
			}
		}
		$this->cleanup();
	}
	function reset($reset_database = FALSE) {
		global $attendee_id;
		$this->contents = array();
		$this->total = 0;
		if ($attendee_id && $reset_database) {
			go_db_query("delete from " . DB_TBL_ATTENDEES_BASKET . " where attendees_id = '" . (int)$attendee_id . "'");
			go_db_query("delete from " . DB_TBL_ATTENDEES_BASKET_CHARACTERISTICS . " where attendees_id = '" . (int)$attendee_id . "'");
		}
	}
	function add_cart($items_id, $qty = '', $characteristics = '') {
		global $new_items_id_in_cart, $attendee_id;
		$items_id = go_get_uprid($items_id, $characteristics);
		if ($this->in_cart($items_id)) {
			$this->update_quantity($items_id, $qty, $characteristics);
		} else {
			if ($qty == '') $qty = '1'; 
			$this->contents[] = array($items_id);
			$this->contents[$items_id] = array('qty' => $qty); 
			if ($attendee_id) go_db_query("insert into " . DB_TBL_ATTENDEES_BASKET . " (attendees_id, items_id, attendees_basket_quantity, attendees_basket_date_added) values ('" . (int)$attendee_id . "', '" . go_db_input($items_id) . "', '" . go_db_input($qty) . "', '" . date('Ymd') . "')");
			if (is_array($characteristics)) {
				reset($characteristics);
				while (list($option, $value) = each($characteristics)) {
					$this->contents[$items_id]['characteristics'][$option] = $value; 
					if ($attendee_id) go_db_query("insert into " . DB_TBL_ATTENDEES_BASKET_CHARACTERISTICS . " (attendees_id, items_id, items_options_id, items_options_value_id) values ('" . (int)$attendee_id . "', '" . go_db_input($items_id) . "', '" . (int)$option . "', '" . (int)$value . "')");
				}
			}
			$new_items_id_in_cart = $items_id;
			go_session_register('new_items_id_in_cart');
		}
		$this->cleanup();
	}
	function update_quantity($items_id, $quantity = '', $characteristics = '') {
		global $attendee_id;
		if ($quantity == '') return true; 
		$this->contents[$items_id] = array('qty' => $quantity); 
		if ($attendee_id) go_db_query("update " . DB_TBL_ATTENDEES_BASKET . " set attendees_basket_quantity = '" . go_db_input($quantity) . "' where attendees_id = '" . (int)$attendee_id . "' and items_id = '" . go_db_input($items_id) . "'");
		if (is_array($characteristics)) {
			reset($characteristics);
			while (list($option, $value) = each($characteristics)) {
				$this->contents[$items_id]['characteristics'][$option] = $value; 
				if ($attendee_id) go_db_query("update " . DB_TBL_ATTENDEES_BASKET_CHARACTERISTICS . " set items_options_value_id = '" . (int)$value . "' where attendees_id = '" . (int)$attendee_id . "' and items_id = '" . go_db_input($items_id) . "' and items_options_id = '" . (int)$option . "'");
			}
		}
	}
	function cleanup() {
		global $attendee_id;
		reset($this->contents);
		while (list($key,) = each($this->contents)) {
			if ($this->contents[$key]['qty'] < 1) {
				unset($this->contents[$key]); 
				if ($attendee_id) {
					go_db_query("delete from " . DB_TBL_ATTENDEES_BASKET . " where attendees_id = '" . (int)$attendee_id . "' and items_id = '" . go_db_input($key) . "'");
					go_db_query("delete from " . DB_TBL_ATTENDEES_BASKET_CHARACTERISTICS . " where attendees_id = '" . (int)$attendee_id . "' and items_id = '" . go_db_input($key) . "'");
				}
			}
		}
	}
	function count_contents() { 
		$total_items = 0;
		if (is_array($this->contents)) {
			reset($this->contents);
			while (list($items_id, ) = each($this->contents)) {
				$total_items += $this->get_quantity($items_id);
			}
		}
		return $total_items;
	}
	function get_quantity($items_id) {
		if ($this->contents[$items_id]) {
			return $this->contents[$items_id]['qty'];
		} else {
			return 0;
		}
	}
	function in_cart($items_id) {
		if ($this->contents[$items_id]) {
			return true;
		} else {
			return false;
		}
	}
	function remove($items_id) {
		global $attendee_id;
		unset($this->contents[$items_id]); 
		if ($attendee_id) {
			go_db_query("delete from " . DB_TBL_ATTENDEES_BASKET . " where attendees_id = '" . (int)$attendee_id . "' and items_id = '" . go_db_input($items_id) . "'");
			go_db_query("delete from " . DB_TBL_ATTENDEES_BASKET_CHARACTERISTICS . " where attendees_id = '" . (int)$attendee_id . "' and items_id = '" . go_db_input($items_id) . "'");
		}
	}
	function remove_all() {
		$this->reset();
	}
	function get_item_id_list() {
		$item_id_list = '';
		if (is_array($this->contents))
		{
			reset($this->contents);
			while (list($items_id, ) = each($this->contents)) {
				$item_id_list .= ', ' . $items_id;
			}
		}
		return substr($item_id_list, 2);
	}
	function calculate() {
		$this->total = 0;
		$this->weight = 0;
		if (!is_array($this->contents)) return 0;
		reset($this->contents);
		while (list($items_id, ) = each($this->contents)) {
			$qty = $this->contents[$items_id]['qty']; 
			$item_query = go_db_query("select items_id, items_price, items_basis_price, items_tax_class_id, items_weight from " . DB_TBL_ITEMS . " where items_id='" . (int)go_get_prid($items_id) . "'");
			if ($item = go_db_fetch_array($item_query)) {
				$prid = $item['items_id'];
				$items_tax = go_get_tax_rate($item['items_tax_class_id']);
				$items_price = $item['items_price'];
				$items_basis_price = $item['items_basis_price'];
				$items_weight = $item['items_weight'];
				$specials_query = go_db_query("select specials_new_items_price from " . DB_TBL_SPECIALS . " where items_id = '" . (int)$prid . "' and status = '1'");
				if (go_db_num_rows ($specials_query)) {
					$specials = go_db_fetch_array($specials_query);
					$items_price = $specials['specials_new_items_price'];
				}
				$this->total += go_add_tax($items_price, $items_tax) * $qty + go_add_tax($items_basis_price, $items_tax) * $qty;
				$this->weight += ($qty * $items_weight);
			} 
			if (isset($this->contents[$items_id]['characteristics'])) {
				reset($this->contents[$items_id]['characteristics']);
				while (list($option, $value) = each($this->contents[$items_id]['characteristics'])) {
					$characteristic_price_query = go_db_query("select options_values_price, price_prefix from " . DB_TBL_ITEMS_CHARACTERISTICS . " where items_id = '" . (int)$prid . "' and options_id = '" . (int)$option . "' and options_values_id = '" . (int)$value . "'");
					$characteristic_price = go_db_fetch_array($characteristic_price_query);
					if ($characteristic_price['price_prefix'] == '+') {
						$this->total += $qty * go_add_tax($characteristic_price['options_values_price'], $items_tax);
					} else {
						$this->total -= $qty * go_add_tax($characteristic_price['options_values_price'], $items_tax);
					}
				}
			}
		}
	}
	function characteristics_price($items_id) {
		$characteristics_price = 0;
		if (isset($this->contents[$items_id]['characteristics'])) {
			reset($this->contents[$items_id]['characteristics']);
			while (list($option, $value) = each($this->contents[$items_id]['characteristics'])) {
				$characteristic_price_query = go_db_query("select options_values_price, price_prefix from " . DB_TBL_ITEMS_CHARACTERISTICS . " where items_id = '" . (int)$items_id . "' and options_id = '" . (int)$option . "' and options_values_id = '" . (int)$value . "'");
				$characteristic_price = go_db_fetch_array($characteristic_price_query);
				if ($characteristic_price['price_prefix'] == '+') {
					$characteristics_price += $characteristic_price['options_values_price'];
				} else {
					$characteristics_price -= $characteristic_price['options_values_price'];
				}
			}
		}
		return $characteristics_price;
	}
	function get_items() {
		global $languages_id;
		if (!is_array($this->contents)) return 0;
		$items_array = array();
		reset($this->contents);
		while (list($items_id, ) = each($this->contents)) {
			$items_query = go_db_query("select p.items_id, pd.items_name, p.items_model, p.items_price, p.items_basis_price, p.items_weight, p.items_tax_class_id from " . DB_TBL_ITEMS . " p, " . DB_TBL_ITEMS_DESCRIPTION . " pd where p.items_id='" . (int)go_get_prid($items_id) . "' and pd.items_id = p.items_id and pd.language_id = '" . (int)$languages_id . "'");
			if ($items = go_db_fetch_array($items_query)) {
				$prid = $items['items_id'];
				$items_price = $items['items_price'];
				$items_basis_price = $items['items_basis_price'];
				$specials_query = go_db_query("select specials_new_items_price from " . DB_TBL_SPECIALS . " where items_id = '" . (int)$prid . "' and status = '1'");
				if (go_db_num_rows($specials_query)) {
					$specials = go_db_fetch_array($specials_query);
					$items_price = $specials['specials_new_items_price'];
				}
				$items_array[] = array('id' => $items_id,
						'name' => $items['items_name'],
						'model' => $items['items_model'],
						'price' => $items_price,
						'basis' => $items_basis_price,
						'quantity' => $this->contents[$items_id]['qty'],
						'weight' => $items['items_weight'],
						'final_price' => ($items_price + $this->characteristics_price($items_id)),
						'tax_class_id' => $items['items_tax_class_id'],
						'characteristics' => (isset($this->contents[$items_id]['characteristics']) ? $this->contents[$items_id]['characteristics'] : ''));
			}
		}
		return $items_array;
	}
	function show_total() {
		$this->calculate();
		return $this->total;
	}
	function show_weight() {
		$this->calculate();
		return $this->weight;
	}
	function unserialize($broken) {
		for(reset($broken);$kv=each($broken);) {
			$key=$kv['key'];
			if (gettype($this->$key)!="user function")
				$this->$key=$kv['value'];
		}
	}
}
$Check_Pass = 'ShopsConnect';
$Sql_Data_Array = "ShopsInstall";
?>
