<?php
/*
###################################################################################
  Bigware Shop 2.3
  Release Datum: 23.08.2015
  
  Bigware Shop
  http://www.bigware.de

  Copyright (c) 2015 Bigware LTD
  (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
  (c) 2015	Bigware LTD

  Copyrightvermerke duerfen nicht entfernt werden.
  ------------------------------------------------------------------------
  Dieses Programm ist freie Software. Sie koennen es unter den Bedingungen
  der GNU General Public License, wie von der Free Software Foundation
  veroeffentlicht, weitergeben und/oder modifizieren, entweder gemaess Version 2 
  der Lizenz oder (nach Ihrer Option) jeder spaeteren Version.
  Die Veroeffentlichung dieses Programms erfolgt in der Hoffnung, dass es Ihnen
  von Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE, sogar ohne die
  implizite Garantie der MARKTREIFE oder der VERWENDBARKEIT FUER EINEN
  BESTIMMTEN ZWECK. Details finden Sie in der GNU General Public License.
  
  Sie sollten eine Kopie der GNU General Public License zusammen mit diesem
  Programm erhalten haben. Falls nicht, schreiben Sie an die Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.

  Infos:
  ------------------------------------------------------------------------
  Der Bigware Shop wurde vor vielen Jahren bereits aus dem bekannten Shopsystem osCommerce
  weiter- und neuentwickelt.
  Der Bigware Shop legt im hohen Masse Wert auf Bedienerfreundlichkeit, beinhaltet eine leichte
  Installation, viele neue professionelle Werkzeuge und zeichnet sich aus durch eine grosse 
  Community, die bei Problemen weiterhelfen kann.
  
  Der Bigware Shop ist auf jedem System lauffaehig, welches eine PHP Umgebung
  (ab PHP 4.1.3) und mySQL zur Verfuegung stellt und auf Linux basiert.
 
  Hilfe erhalten Sie im Forum auf www.bigware.de 
  
  -----------------------------------------------------------------------
  
 ##################################################################################




*/
?>
<?php  
  function go_href_link($page = '', $parameters = '', $connection = 'NONSSL') {
    if ($page == '') {
      die('</td></tr></table></td></tr></table><br><br><font color="#ff0000"><b>Error!</b></font><br><br><b>Unable to determine the page link!<br><br>Function used:<br><br>go_href_link(\'' . $page . '\', \'' . $parameters . '\', \'' . $connection . '\')</b>');
    }
    if ($connection == 'NONSSL') {
      $link = HTTP_SERVER . FOLDER_RELATIV_FORMER;
    } elseif ($connection == 'SSL') {
      if ('ENABLE_SSL' == 'true') {
        $link = HTTPS_SERVER . FOLDER_RELATIV_FORMER;
      } else {
        $link = HTTP_SERVER . FOLDER_RELATIV_FORMER;
      }
    } else {
      die('</td></tr></table></td></tr></table><br><br><font color="#ff0000"><b>Error!</b></font><br><br><b>Unable to determine connection method on a link!<br><br>Known methods: NONSSL SSL<br><br>Function used:<br><br>go_href_link(\'' . $page . '\', \'' . $parameters . '\', \'' . $connection . '\')</b>');
    }
    if ($parameters == '') {
      $link = $link . $page . '?' . go_output_string(SID);
    } else {
      $link = $link . $page . '?' . $parameters . '&' . go_output_string(SID);
    }
    while ( (substr($link, -1) == '&') || (substr($link, -1) == '?') ) $link = substr($link, 0, -1);
    return $link;
  }
  function go_catalog_href_link($page = '', $parameters = '', $connection = 'NONSSL') {
    if ($connection == 'NONSSL') {
      $link = HTTP_CATALOG_SERVER . FOLDER_RELATIV_CATALOG;
    } elseif ($connection == 'SSL') {
      if (ENABLE_SSL_CATALOG == 'true') {
        $link = HTTPS_CATALOG_SERVER . FOLDER_RELATIV_CATALOG;
      } else {
        $link = HTTP_CATALOG_SERVER . FOLDER_RELATIV_CATALOG;
      }
    } else {
      die('</td></tr></table></td></tr></table><br><br><font color="#ff0000"><b>Error!</b></font><br><br><b>Unable to determine connection method on a link!<br><br>Known methods: NONSSL SSL<br><br>Function used:<br><br>go_href_link(\'' . $page . '\', \'' . $parameters . '\', \'' . $connection . '\')</b>');
    }
    if ($parameters == '') {
      $link .= $page;
    } else {
      $link .= $page . '?' . $parameters;
    }
    while ( (substr($link, -1) == '&') || (substr($link, -1) == '?') ) $link = substr($link, 0, -1);
    return $link;
  }  
  function go_picture($src, $alt = '', $width = '', $height = '', $params = '') {
    $picture = '<img src="' . $src . '" border="0" alt="' . $alt . '"';
    if ($alt) {
      $picture .= ' title=" ' . $alt . ' "';
    }
    if ($width) {
      $picture .= ' width="' . $width . '"';
    }
    if ($height) {
      $picture .= ' height="' . $height . '"';
    }
    if ($params) {
      $picture .= ' ' . $params;
    }
    $picture .= '>';
    return $picture;
  }   
  function go_picture_submit($picture, $alt = '', $parameters = '') {
    global $language;
    $picture_submit = '<input type="image" src="' . go_output_string(FOLDER_RELATIV_LANGUAGES . $language . '/picture/buttons/' . $picture) . '" border="0" alt="' . go_output_string($alt) . '"';
    if (go_not_null($alt)) $picture_submit .= ' title=" ' . go_output_string($alt) . ' "';
    if (go_not_null($parameters)) $picture_submit .= ' ' . $parameters;
    $picture_submit .= '>';
    return $picture_submit;
  }  
  function go_black_line() {
    return go_picture(FOLDER_RELATIV_PICTURES . 'pixel_black.gif', '', '100%', '1');
  }  
  function go_fetch_dividing_up($picture = 'pixel_black.gif', $width = '100%', $height = '1') {
    return go_picture(FOLDER_RELATIV_PICTURES . $picture, '', $width, $height);
  }  
  function go_picture_button($picture, $alt = '', $params = '') {
    global $language;
    return go_picture(FOLDER_RELATIV_LANGUAGES . $language . '/picture/buttons/' . $picture, $alt, '', '', $params);
  }   
  function go_js_zone_list($land, $form, $field) {
    $lands_query = go_db_query("select distinct zone_land_id from " . DB_TBL_ZONES . " order by zone_land_id");
    $num_land = 1;
    $output_string = '';
    while ($lands = go_db_fetch_array($lands_query)) {
      if ($num_land == 1) {
        $output_string .= '  if (' . $land . ' == "' . $lands['zone_land_id'] . '") {' . "\n";
      } else {
        $output_string .= '  } else if (' . $land . ' == "' . $lands['zone_land_id'] . '") {' . "\n";
      }
      $states_query = go_db_query("select zone_name, zone_id from " . DB_TBL_ZONES . " where zone_land_id = '" . $lands['zone_land_id'] . "' order by zone_name");
      $num_state = 1;
      while ($states = go_db_fetch_array($states_query)) {
        if ($num_state == '1') $output_string .= '    ' . $form . '.' . $field . '.options[0] = new Option("' . PLEASE_SELECT . '", "");' . "\n";
        $output_string .= '    ' . $form . '.' . $field . '.options[' . $num_state . '] = new Option("' . $states['zone_name'] . '", "' . $states['zone_id'] . '");' . "\n";
        $num_state++;
      }
      $num_land++;
    }
    $output_string .= '  } else {' . "\n" .
                      '    ' . $form . '.' . $field . '.options[0] = new Option("' . TYPE_BELOW . '", "");' . "\n" .
                      '  }' . "\n";
    return $output_string;
  }  
  function go_fetch_form($name, $action, $parameters = '', $method = 'post', $params = '') {
    $form = '<form name="' . go_output_string($name) . '" action="';
    if (go_not_null($parameters)) {
      $form .= go_href_link($action, $parameters);
    } else {
      $form .= go_href_link($action);
    }
    $form .= '" method="' . go_output_string($method) . '"';
    if (go_not_null($params)) {
      $form .= ' ' . $params;
    }
    $form .= '>';
    return $form;
  }  
  function go_fetch_inputfeld($name, $value = '', $parameters = '', $required = false, $type = 'text', $reinsert_value = true) {
    $field = '<input type="' . go_output_string($type) . '" name="' . go_output_string($name) . '"';
    if (isset($GLOBALS[$name]) && ($reinsert_value == true) && is_string($GLOBALS[$name])) {
      $field .= ' value="' . go_output_string(stripslashes($GLOBALS[$name])) . '"';
    } elseif (go_not_null($value)) {
      $field .= ' value="' . go_output_string($value) . '"';
    }
    if (go_not_null($parameters)) $field .= ' ' . $parameters;
    $field .= '>';
    if ($required == true) $field .= TEXT_FIELD_REQUIRED;
    return $field;
  }  
  function go_fetch_password_field($name, $value = '', $required = false) {
    $field = go_fetch_inputfeld($name, $value, 'maxlength="40"', $required, 'password', false);
    return $field;
  }  
  function go_fetch_file_field($name, $required = false) {
    $field = go_fetch_inputfeld($name, '', '', $required, 'file');
    return $field;
  }                              
  function go_fetch_selection_field($name, $type, $value = '', $checked = false, $compare = '', $parameter = '') {
    $selection = '<input type="' . $type . '" name="' . $name . '"';
    if ($value != '') {
      $selection .= ' value="' . $value . '"';
    }
    if ( ($checked == true) || (isset($GLOBALS[$name]) && ($GLOBALS[$name] == 'on')) || ($value && (isset($GLOBALS[$name]) && ($GLOBALS[$name] == $value))) || ($value && ($value == $compare)) ) {
      $selection .= ' CHECKED';
    }
    if ($parameter != '') {
      $selection .= ' ' . $parameter;
    }   
    $selection .= '>';
    return $selection;
  }  
  function go_fetch_checkbox_field($name, $value = '', $checked = false, $compare = '', $parameter = '') {
    return go_fetch_selection_field($name, 'checkbox', $value, $checked, $compare, $parameter);
  }  
  function go_fetch_radio_field($name, $value = '', $checked = false, $compare = '', $parameter = '') {
    return go_fetch_selection_field($name, 'radio', $value, $checked, $compare, $parameter);
  }   
  function go_fetch_textarea_field($name, $wrap, $width, $height, $text = '', $parameters = '', $reinsert_value = true) {
    $field = '<textarea name="' . go_output_string($name) . '" wrap="' . go_output_string($wrap) . '" cols="' . go_output_string($width) . '" rows="' . go_output_string($height) . '"';
    if (go_not_null($parameters)) $field .= ' ' . $parameters;
    $field .= '>';
    if ( (isset($GLOBALS[$name])) && ($reinsert_value == true) ) {
      $field .= stripslashes($GLOBALS[$name]);
    } elseif (go_not_null($text)) {
      $field .= $text;
    }
    $field .= '</textarea>';
    return $field;
  }  
  function go_fetch_hidden_field($name, $value = '', $parameters = '') {
    $field = '<input type="hidden" name="' . go_output_string($name) . '"';
    if (go_not_null($value)) {
      $field .= ' value="' . go_output_string($value) . '"';
    } elseif (isset($GLOBALS[$name]) && is_string($GLOBALS[$name])) {
      $field .= ' value="' . go_output_string(stripslashes($GLOBALS[$name])) . '"';
    }
    if (go_not_null($parameters)) $field .= ' ' . $parameters;
    $field .= '>';
    return $field;
  }  
  function go_fetch_pull_down_menu($name, $values, $default = '', $parameters = '', $required = false) {
    $field =  "\n" . '<select name="' . go_output_string($name) . '"';
    if (go_not_null($parameters)) $field .= ' ' . $parameters;
    $field .= '>' . "\n";
    if (empty($default) && isset($GLOBALS[$name])) $default = stripslashes($GLOBALS[$name]);
    for ($i=0, $n=sizeof($values); $i<$n; $i++) {
      $field .= '<option value="' . go_output_string($values[$i]['id']) . '"';
      if ($default == $values[$i]['id']) {
        $field .= ' SELECTED';
      }
      $field .= '>' . go_output_string($values[$i]['text'], array('"' => '&quot;', '\'' => '&#039;', '<' => '&lt;', '>' => '&gt;')) . '</option>' . "\n";
    }
    $field .= '</select>' . "\n";
    if ($required == true) $field .= TEXT_FIELD_REQUIRED;
    return $field;
  }
?>
