<?php
/*
###################################################################################
  Bigware Shop 2.3
  Release Datum: 23.08.2015
  
  Bigware Shop
  http://www.bigware.de

  Copyright (c) 2012 Bigware LTD
  (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
  (c) 2012	Bigware LTD

  Copyrightvermerke duerfen nicht entfernt werden.
  ------------------------------------------------------------------------
  Dieses Programm ist freie Software. Sie koennen es unter den Bedingungen
  der GNU General Public License, wie von der Free Software Foundation
  veroeffentlicht, weitergeben und/oder modifizieren, entweder gemaess Version 2 
  der Lizenz oder (nach Ihrer Option) jeder spaeteren Version.
  Die Veroeffentlichung dieses Programms erfolgt in der Hoffnung, dass es Ihnen
  von Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE, sogar ohne die
  implizite Garantie der MARKTREIFE oder der VERWENDBARKEIT FUER EINEN
  BESTIMMTEN ZWECK. Details finden Sie in der GNU General Public License.
  
  Sie sollten eine Kopie der GNU General Public License zusammen mit diesem
  Programm erhalten haben. Falls nicht, schreiben Sie an die Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.

  Infos:
  ------------------------------------------------------------------------
  Der Bigware Shop wurde vor vielen Jahren bereits aus dem bekannten Shopsystem osCommerce
  weiter- und neuentwickelt.
  Der Bigware Shop legt im hohen Masse Wert auf Bedienerfreundlichkeit, beinhaltet eine leichte
  Installation, viele neue professionelle Werkzeuge und zeichnet sich aus durch eine gro�e 
  Community, die bei Problemen weiterhelfen kann.
  
  Der Bigware Shop ist auf jedem System lauffaehig, welches eine PHP Umgebung
  (ab PHP 4.1.3) und mySQL zur Verfuegung stellt und auf Linux basiert.
 
  Hilfe erhalten Sie im Forum auf www.bigware.de
  
  -----------------------------------------------------------------------
  
 ##################################################################################




*/
?>
<?php    
  function go_array_merge($array1, $array2, $array3 = '') {
    if ($array3 == '') $array3 = array();
    if (function_exists('array_merge')) {
      $array_merged = array_merge($array1, $array2, $array3);
    } else {
      while (list($key, $val) = each($array1)) $array_merged[$key] = $val;
      while (list($key, $val) = each($array2)) $array_merged[$key] = $val;
      if (sizeof($array3) > 0) while (list($key, $val) = each($array3)) $array_merged[$key] = $val;
    }
    return (array) $array_merged;
  }
function go_former_check_login() {
  global $PHP_SELF, $login_groups_id, $login_id;
  if (!go_session_is_registered('login_id')) {
    go_forward(go_href_link(NAME_OF_FILE_LOGIN, '', 'SSL'));
  } else {
    $filename = basename( $PHP_SELF );
    if ($filename != NAME_OF_FILE_DEFAULT && $filename != NAME_OF_FILE_FORBIDEN && $filename != NAME_OF_FILE_LOGOFF && $filename != NAME_OF_FILE_FORMER_MEMBER && $filename != NAME_OF_FILE_POPUP_PICTURE && $filename != 'main_bigware_92.php' && $filename != 'main_bigware_62.php') {
      $db_file_query = go_db_query("select former_files_name from " . DB_TBL_FORMER_FILES . " where FIND_IN_SET( '" . $login_groups_id . "', former_groups_id) or FIND_IN_SET( '" . $login_id . "', former_id) and former_files_name = '" . $filename . "'");
	
      if (!go_db_num_rows($db_file_query)) {
        go_forward(go_href_link(NAME_OF_FILE_FORBIDEN));
      }
    }
  }
}  
function go_former_check_frames($filename, $frames='') {
  global $login_groups_id, $login_id;
  $is_frames = 1;
  if ($frames == 'sub_frames') {
    $is_frames = 0;
  }
  $dbquery = go_db_query("select former_files_id from " . DB_TBL_FORMER_FILES . " where FIND_IN_SET( '" . $login_groups_id . "', former_groups_id) or FIND_IN_SET( '" . $login_id . "', former_id) and former_files_is_frames = '" . $is_frames . "' and former_files_name = '" . $filename . "'");
  $return_value = false;
  if (go_db_num_rows($dbquery)) {
    $return_value = true;
  }
  return $return_value;
}  
function go_former_files_frames($filename, $sub_frame_name) {
  global $login_groups_id, $login_id;
  $sub_frames = '';
  $dbquery = go_db_query("select former_files_name from " . DB_TBL_FORMER_FILES . " where FIND_IN_SET( '" . $login_groups_id . "', former_groups_id) or FIND_IN_SET( '" . $login_id . "', former_id) and former_files_is_frames = '0' and former_files_name = '" . $filename . "'");
   
  if (go_db_num_rows($dbquery)) {
    $sub_frames = '<a class="menuItem" href="' . go_href_link($filename) . '">' . $sub_frame_name . '</a>';
  }
  return $sub_frames;
}  
function go_selected_file($filename) {
  global $login_groups_id, $login_id;
  $randomize = NAME_OF_FILE_FORMER_MEMBER;
  $dbquery = go_db_query("select former_files_id as frames_id from " . DB_TBL_FORMER_FILES . " where FIND_IN_SET( '" . $login_groups_id . "', former_groups_id) or FIND_IN_SET( '" . $login_id . "', former_id) and former_files_is_frames = '1' and former_files_name = '" . $filename . "'");
  if (go_db_num_rows($dbquery)) {
    $frames_id = go_db_fetch_array($dbquery);
    $randomize_query = go_db_query("select former_files_name from " . DB_TBL_FORMER_FILES . " where FIND_IN_SET( '" . $login_groups_id . "', former_groups_id) or FIND_IN_SET( '" . $login_id . "', former_id) and former_files_is_frames = '0' and former_files_to_frames = '" . $frames_id['frames_id'] . "'");
	
    if (go_db_num_rows($randomize_query)) {
      $file_selected = go_db_fetch_array($randomize_query);
      $randomize = $file_selected['former_files_name'];
    }
  }
  return $randomize;
}   
  function go_set_categories_status($category_id, $status) {
    if ($status == '1') {
      go_db_query("update " . DB_TBL_CATEGORIES . " set categories_status = '1', last_modified = now() where categories_id = '" . $category_id . "'");
      $tree = go_get_category_tree($category_id);
      for ($i=1; $i<sizeof($tree); $i++) {
        go_db_query("update " . DB_TBL_CATEGORIES . " set categories_status = '1', last_modified = now() where categories_id = '" . $tree[$i]['id'] . "'");
      }
    } elseif ($status == '0') {
      go_db_query("update " . DB_TBL_CATEGORIES . " set categories_status = '0', last_modified = now() where categories_id = '" . $category_id . "'");
      $tree = go_get_category_tree($category_id);
      for ($i=1; $i<sizeof($tree); $i++) {
        go_db_query("update " . DB_TBL_CATEGORIES . " set categories_status = '0', last_modified = now() where categories_id = '" . $tree[$i]['id'] . "'");
      }
    }
  } 
  function go_forward($url) {
    global $logger;
    header('Location: ' . $url);
    if (SHOP_PAGE_PARSE_TIME == 'true') {
      if (!is_object($logger)) $logger = new logger;
      $logger->timer_stop();
    }
    exit;
  }  
  function go_analysis_inputfeld_data($data, $parse) {
    return strtr(trim($data), $parse);
  }
  function go_output_string($string, $translate = false, $protected = false) {
    if ($protected == true) {
      return isohtmlspecialchars($string);
    } else {
      if ($translate == false) {
        return go_analysis_inputfeld_data($string, array('"' => '&quot;'));
      } else {
        return go_analysis_inputfeld_data($string, $translate);
      }
    }
  }
  function go_output_string_protected($string) {
    return go_output_string($string, false, true);
  }
  function go_sanitize_string($string) {
    $string = preg_replace(' +', ' ', $string);
    return preg_replace("/[<>]/", '_', $string);
  }
  function go_attendees_name($attendees_id) {
    $attendees = go_db_query("select attendees_firstname, attendees_lastname from " . DB_TBL_ATTENDEES . " where attendees_id = '" . (int)$attendees_id . "'");
    $attendees_values = go_db_fetch_array($attendees);
    return $attendees_values['attendees_firstname'] . ' ' . $attendees_values['attendees_lastname'];
  }
  function go_get_path($current_category_id = '') {
    global $bigPfad_array;
    if ($current_category_id == '') {
      $bigPfad_new = implode('_', $bigPfad_array);
    } else {
      if (sizeof($bigPfad_array) == 0) {
        $bigPfad_new = $current_category_id;
      } else {
        $bigPfad_new = '';
        $last_category_query = go_db_query("select parent_id from " . DB_TBL_CATEGORIES . " where categories_id = '" . (int)$bigPfad_array[(sizeof($bigPfad_array)-1)] . "'");
        $last_category = go_db_fetch_array($last_category_query);
        $current_category_query = go_db_query("select parent_id from " . DB_TBL_CATEGORIES . " where categories_id = '" . (int)$current_category_id . "'");
        $current_category = go_db_fetch_array($current_category_query);
        if ($last_category['parent_id'] == $current_category['parent_id']) {
          for ($i = 0, $n = sizeof($bigPfad_array) - 1; $i < $n; $i++) {
            $bigPfad_new .= '_' . $bigPfad_array[$i];
          }
        } else {
          for ($i = 0, $n = sizeof($bigPfad_array); $i < $n; $i++) {
            $bigPfad_new .= '_' . $bigPfad_array[$i];
          }
        }
        $bigPfad_new .= '_' . $current_category_id;
        if (substr($bigPfad_new, 0, 1) == '_') {
          $bigPfad_new = substr($bigPfad_new, 1);
        }
      }
    }
    return 'bigPfad=' . $bigPfad_new;
  }
  function go_get_all_get_parameter($exclude_array = '') {
    global $_GET;
    if ($exclude_array == '') $exclude_array = array();
    $get_url = '';
    reset($_GET);
    while (list($key, $value) = each($_GET)) {
      if (($key != go_session_name()) && ($key != 'error') && (!in_array($key, $exclude_array))) $get_url .= $key . '=' . $value . '&';
    }
    return $get_url;
  }
  function go_date_long($raw_date) {
    if ( ($raw_date == '0000-00-00 00:00:00') || ($raw_date == '') ) return false;
    $year = (int)substr($raw_date, 0, 4);
    $month = (int)substr($raw_date, 5, 2);
    $day = (int)substr($raw_date, 8, 2);
    $hour = (int)substr($raw_date, 11, 2);
    $minute = (int)substr($raw_date, 14, 2);
    $second = (int)substr($raw_date, 17, 2);
    return strftime(DATE_FORMAT_LONG, mktime($hour, $minute, $second, $month, $day, $year));
  }    
  function go_date_short($raw_date) {
    if ( ($raw_date == '0000-00-00 00:00:00') || ($raw_date == '') ) return false;
    $year = substr($raw_date, 0, 4);
    $month = (int)substr($raw_date, 5, 2);
    $day = (int)substr($raw_date, 8, 2);
    $hour = (int)substr($raw_date, 11, 2);
    $minute = (int)substr($raw_date, 14, 2);
    $second = (int)substr($raw_date, 17, 2);
    if (@date('Y', mktime($hour, $minute, $second, $month, $day, $year)) == $year) {
      return date(DATE_FORMAT, mktime($hour, $minute, $second, $month, $day, $year));
    } else {
      return preg_replace('2037' . '$', $year, date(DATE_FORMAT, mktime($hour, $minute, $second, $month, $day, 2037)));
    }
  }
  function go_datetime_short($raw_datetime) {
    if ( ($raw_datetime == '0000-00-00 00:00:00') || ($raw_datetime == '') ) return false;
    $year = (int)substr($raw_datetime, 0, 4);
    $month = (int)substr($raw_datetime, 5, 2);
    $day = (int)substr($raw_datetime, 8, 2);
    $hour = (int)substr($raw_datetime, 11, 2);
    $minute = (int)substr($raw_datetime, 14, 2);
    $second = (int)substr($raw_datetime, 17, 2);
    return strftime(DATE_TIME_FORMAT, mktime($hour, $minute, $second, $month, $day, $year));
  }
  function go_get_category_tree($parent_id = '0', $spacing = '', $exclude = '', $category_tree_array = '', $include_itself = false) {
    global $languages_id;
    if (!is_array($category_tree_array)) $category_tree_array = array();
    if ( (sizeof($category_tree_array) < 1) && ($exclude != '0') ) $category_tree_array[] = array('id' => '0', 'text' => TEXT_TOP);
    if ($include_itself) {
      $category_query = go_db_query("select cd.categories_name from " . DB_TBL_CATEGORIES_DESCRIPTION . " cd where cd.language_id = '" . (int)$languages_id . "' and cd.categories_id = '" . (int)$parent_id . "'");
      $category = go_db_fetch_array($category_query);
      $category_tree_array[] = array('id' => $parent_id, 'text' => $category['categories_name']);
    }
    $categories_query = go_db_query("select c.categories_id, cd.categories_name, c.parent_id from " . DB_TBL_CATEGORIES . " c, " . DB_TBL_CATEGORIES_DESCRIPTION . " cd where c.categories_id = cd.categories_id and cd.language_id = '" . (int)$languages_id . "' and c.parent_id = '" . (int)$parent_id . "' order by c.sort_order, cd.categories_name");
    while ($categories = go_db_fetch_array($categories_query)) {
      if ($exclude != $categories['categories_id']) $category_tree_array[] = array('id' => $categories['categories_id'], 'text' => $spacing . $categories['categories_name']);
      $category_tree_array = go_get_category_tree($categories['categories_id'], $spacing . '&nbsp;&nbsp;&nbsp;', $exclude, $category_tree_array);
    }
    return $category_tree_array;
  }
  function go_fetch_items_pull_down($name, $parameters = '', $exclude = '') {
    global $currencies, $languages_id;
    if ($exclude == '') {
      $exclude = array();
    }
    $select_string = '<select name="' . $name . '"';
    if ($parameters) {
      $select_string .= ' ' . $parameters;
    }
    $select_string .= '>'; 
	$all_groups=array();
	$attendees_groups_query = go_db_query("select attendees_group_name, attendees_group_id from " . DB_TBL_ATTENDEES_GROUPS . " order by attendees_group_id ");
	while ($existing_groups =  go_db_fetch_array($attendees_groups_query)) {
		$all_groups[$existing_groups['attendees_group_id']]=$existing_groups['attendees_group_name'];
	} 
    $items_query = go_db_query("select p.items_id, pd.items_name, p.items_price from " . DB_TBL_ITEMS . " p, " . DB_TBL_ITEMS_DESCRIPTION . " pd where p.items_id = pd.items_id AND items_price != '123456.7890' and pd.language_id = '" . (int)$languages_id . "' order by items_name");
    while ($items = go_db_fetch_array($items_query)) { 
		  
		if (!in_array($items['items_id'], $exclude)) {
			$price_query=go_db_query("select attendees_group_price, attendees_group_id from " . DB_TBL_ITEMS_GROUPS . " where items_id = " . $items['items_id']);
			$item_prices=array();
			while($prices_array=go_db_fetch_array($price_query)){
				$item_prices[$prices_array['attendees_group_id']]=$prices_array['attendees_group_price'];
			}
			reset($all_groups);
			$price_string="";
			$sde=0;
			while(list($sdek,$sdev)=each($all_groups)){
				if (!in_array((int)$items['items_id'].":".(int)$sdek, $exclude)) {
					if($sde)
						$price_string.=", ";
					$price_string.=$sdev.": ".$currencies->format(isset($item_prices[$sdek]) ? $item_prices[$sdek]:$items['items_price']);
					$sde=1;
				}
			}
			$select_string .= '<option value="' . $items['items_id'] . '">' . $items['items_name'] . ' (' . $price_string . ')</option>\n';
		} 
	}
    $select_string .= '</select>';
    return $select_string;
  }
  function go_options_name($options_id) {
    global $languages_id;
    $options = go_db_query("select items_options_name from " . DB_TBL_ITEMS_OPTIONS . " where items_options_id = '" . (int)$options_id . "' and language_id = '" . (int)$languages_id . "'");
    $options_values = go_db_fetch_array($options);
    return $options_values['items_options_name'];
  }
	
	 function go_options_conf_name($options_conf_id) {
    global $languages_id;
    $options_conf = go_db_query("select items_options_conf_name from " . DB_TBL_ITEMS_OPTIONS_CONF . " where items_options_conf_id = '" . (int)$options_conf_id . "' and language_id = '" . (int)$languages_id . "'");
    $options_conf_values = go_db_fetch_array($options_conf);
    return $options_conf_values['items_options_conf_name'];
  }	
 
 ////////////////////////////////////////////////////////////////
 
//	    $options_name = go_configurator_options_name($items_options_conf_id, $is_items_id);
//	    $values_name = go_configurator_values_name($items_options_conf_values_id, $is_items_id);
//	    $values_description = go_configurator_description($options_conf_values_id, $is_items_id);
//			$characteristics_price = go_configurator_price($items_characteristics_conf_id, $is_items_id);
//			$characteristics_price_prefix = go_configurator_price_prefix($items_characteristics_conf_id, $is_items_id);
  
	 function go_configurator_options_name($options_conf_id, $is_items_id) {
    global $languages_id;
    if ($is_items_id == '0'){
    	$options_conf = go_db_query("select items_options_conf_name from " . DB_TBL_CONFIGURATOR_OPTION . " where items_options_conf_id = '" . (int)$options_conf_id . "' and language_id = '" . (int)$languages_id . "'");
    	$options_conf_values = go_db_fetch_array($options_conf);
    	return $options_conf_values['items_options_conf_name'];
  	}else{
      $options_conf = go_db_query("select pd.items_name from " . DB_TBL_ITEMS . " p, " . DB_TBL_ITEMS_DESCRIPTION . " pd where pd.items_id = p.items_id and pd.items_id = " . $is_items_id . " and pd.language_id = '" . (int)$languages_id . "' order by pd.items_name");
      $options_conf_values = go_db_fetch_array($options_conf);	
  		return $options_conf_values['items_name'];
  	}
  }	
	function go_configurator_values_name($values_conf_id, $is_items_id) {
    global $languages_id;
    if ($is_items_id == '0'){
    	$values_conf = go_db_query("select items_options_conf_values_name from " . DB_TBL_CONFIGURATOR_OPTIONS_VALUES . " where items_options_conf_values_id = '" . (int)$values_conf_id . "' and language_id = '" . (int)$languages_id . "'");
    	$values_conf_values = go_db_fetch_array($values_conf);
    	return $values_conf_values['items_options_conf_values_name'];
    }else{
      $values_conf = go_db_query("select pd.items_name2 from " . DB_TBL_ITEMS . " p, " . DB_TBL_ITEMS_DESCRIPTION . " pd where pd.items_id = p.items_id and pd.items_id = " . $is_items_id . " and pd.language_id = '" . (int)$languages_id . "' order by pd.items_name");
      $values_conf_values = go_db_fetch_array($values_conf);
      return $values_conf_values['items_name2'];
  	}
  }	
	function go_configurator_description($values_conf_id, $is_items_id) {
    global $languages_id;
    if ($is_items_id == '0'){
    	$values_conf = go_db_query("select items_options_conf_values_desc from " . DB_TBL_CONFIGURATOR_OPTIONS_VALUES . " where items_options_conf_values_id = '" . (int)$values_conf_id . "' and language_id = '" . (int)$languages_id . "'");
    	$values_conf_values = go_db_fetch_array($values_conf);
    	return $values_conf_values['items_options_conf_values_desc'];
  	}else{
      $values_conf = go_db_query("select pd.items_description from " . DB_TBL_ITEMS . " p, " . DB_TBL_ITEMS_DESCRIPTION . " pd where pd.items_id = p.items_id and pd.items_id = " . $is_items_id . " and pd.language_id = '" . (int)$languages_id . "' order by pd.items_name");
      $values_conf_values = go_db_fetch_array($values_conf);
      return $values_conf_values['items_description'];	
  	}
  }	
	function go_configurator_price($items_characteristics_conf_id, $is_items_id) {
    global $languages_id;
    if ($is_items_id == '0'){
    	$price_conf = go_db_query("select options_conf_values_price from " . DB_TBL_CONFIGURATOR_CHARACTERISTICS . " where items_characteristics_conf_id = '" . (int)$items_characteristics_conf_id . "'");
    	$price_conf_values = go_db_fetch_array($price_conf);
    	return $price_conf_values['options_conf_values_price'];
  	}else{
      $price_conf = go_db_query("select p.items_price from " . DB_TBL_ITEMS . " p, " . DB_TBL_ITEMS_DESCRIPTION . " pd where pd.items_id = p.items_id and pd.items_id = " . $is_items_id . " and pd.language_id = '" . $languages_id . "' order by pd.items_name");
      $price_conf_values = go_db_fetch_array($price_conf);
      return $price_conf_values['items_price'];
  	}
  }	
	function go_configurator_price_prefix($items_characteristics_conf_id, $is_items_id) {
    global $languages_id;
    if ($is_items_id == '0'){
    	$price_prefix_conf = go_db_query("select price_prefix from " . DB_TBL_CONFIGURATOR_CHARACTERISTICS . " where items_characteristics_conf_id = '" . (int)$items_characteristics_conf_id . "'");
    	$price_prefix = go_db_fetch_array($price_prefix_conf);
    	return $price_prefix['price_prefix'];
  	}else{
      $price_prefix = '+';
      return $price_prefix;
  	}
  }
/////////////////////////////////////////////////////////////////////
  function go_values_name($values_id) {
    global $languages_id;
    $values = go_db_query("select items_options_values_name from " . DB_TBL_ITEMS_OPTIONS_VALUES . " where items_options_values_id = '" . (int)$values_id . "' and language_id = '" . (int)$languages_id . "'");
    $values_values = go_db_fetch_array($values);
    return $values_values['items_options_values_name'];
  }
	
	function go_values_conf_name($values_conf_id) {
    global $languages_id;
    $values_conf = go_db_query("select items_options_conf_values_name from " . DB_TBL_ITEMS_OPTIONS_CONF_VALUES . " where items_options_conf_values_id = '" . (int)$values_conf_id . "' and language_id = '" . (int)$languages_id . "'");
    $values_conf_values = go_db_fetch_array($values_conf);
    return $values_conf_values['items_options_conf_values_name'];
  }
  function go_info_picture($picture, $alt, $width = '', $height = '') {
    if (go_not_null($picture) && (file_exists(FOLDER_ABSOLUT_CATALOG_PICTURES . $picture)) ) {
      $picture = go_picture(FOLDER_RELATIV_CATALOG_PICTURES . $picture, $alt, $width, $height);
    } else {
      $picture = TEXT_PICTURE_NONEXISTENT;
    }
    return $picture;
  }
  function go_break_string($string, $len, $break_char = '-') {
    $l = 0;
    $output = '';
    for ($i=0, $n=strlen($string); $i<$n; $i++) {
      $char = substr($string, $i, 1);
      if ($char != ' ') {
        $l++;
      } else {
        $l = 0;
      }
      if ($l > $len) {
        $l = 1;
        $output .= $break_char;
      }
      $output .= $char;
    }
    return $output;
  }
  function go_get_land_name($land_id) {
    $land_query = go_db_query("select lands_name from " . DB_TBL_LANDS . " where lands_id = '" . (int)$land_id . "'");
    if (!go_db_num_rows($land_query)) {
      return $land_id;
    } else {
      $land = go_db_fetch_array($land_query);
      return $land['lands_name'];
    }
  }
  function go_get_zone_name($land_id, $zone_id, $default_zone) {
    $zone_query = go_db_query("select zone_name from " . DB_TBL_ZONES . " where zone_land_id = '" . (int)$land_id . "' and zone_id = '" . (int)$zone_id . "'");
    if (go_db_num_rows($zone_query)) {
      $zone = go_db_fetch_array($zone_query);
      return $zone['zone_name'];
    } else {
      return $default_zone;
    }
  }
  function go_not_null($value) {
    if (is_array($value)) {
      if (sizeof($value) > 0) {
        return true;
      } else {
        return false;
      }
    } else {
      if ( (is_string($value) || is_int($value)) && ($value != '') && ($value != 'NULL') && (strlen(trim($value)) > 0)) {
        return true;
      } else {
        return false;
      }
    }
  }
  function go_browser_detect($component) {
    global $HTTP_USER_AGENT;
    return stristr($HTTP_USER_AGENT, $component);
  }
  function go_tax_classes_pull_down($parameters, $selected = '') {
    $select_string = '<select ' . $parameters . '>';
    $classes_query = go_db_query("select tax_class_id, tax_class_title from " . DB_TBL_TAX_CLASS . " order by tax_class_title");
    while ($classes = go_db_fetch_array($classes_query)) {
      $select_string .= '<option value="' . $classes['tax_class_id'] . '"';
      if ($selected == $classes['tax_class_id']) $select_string .= ' SELECTED';
      $select_string .= '>' . $classes['tax_class_title'] . '</option>';
    }
    $select_string .= '</select>';
    return $select_string;
  }
  function go_geo_zones_pull_down($parameters, $selected = '') {
    $select_string = '<select ' . $parameters . '>';
    $zones_query = go_db_query("select geo_zone_id, geo_zone_name from " . DB_TBL_GEO_ZONES . " order by geo_zone_name");
    while ($zones = go_db_fetch_array($zones_query)) {
      $select_string .= '<option value="' . $zones['geo_zone_id'] . '"';
      if ($selected == $zones['geo_zone_id']) $select_string .= ' SELECTED';
      $select_string .= '>' . $zones['geo_zone_name'] . '</option>';
    }
    $select_string .= '</select>';
    return $select_string;
  }
  function go_get_geo_zone_name($geo_zone_id) {
    $zones_query = go_db_query("select geo_zone_name from " . DB_TBL_GEO_ZONES . " where geo_zone_id = '" . (int)$geo_zone_id . "'");
    if (!go_db_num_rows($zones_query)) {
      $geo_zone_name = $geo_zone_id;
    } else {
      $zones = go_db_fetch_array($zones_query);
      $geo_zone_name = $zones['geo_zone_name'];
    }
    return $geo_zone_name;
  }
  function go_form_of_address($form_of_address_id, $address, $html, $boln, $eoln) {
    $form_of_address_query = go_db_query("select form_of_address as format from " . DB_TBL_FORM_OF_ADDRESS . " where form_of_address_id = '" . (int)$form_of_address_id . "'");
    $form_of_address = go_db_fetch_array($form_of_address_query);
    $company = go_output_string_protected($address['company']);  
    $piva = go_output_string_protected($address['piva']);
    $cf = go_output_string_protected($address['cf']);  
    if (isset($address['firstname']) && go_not_null($address['firstname'])) {
      $firstname = go_output_string_protected($address['firstname']);
      $lastname = go_output_string_protected($address['lastname']);
    } elseif (isset($address['name']) && go_not_null($address['name'])) {
      $firstname = go_output_string_protected($address['name']);
      $lastname = '';
    } else {
      $firstname = '';
      $lastname = '';
    }
    $street = go_output_string_protected($address['street_address']);
    if ($address['street_address2'] !='') { $street2 = go_output_string_protected($address['street_address2']); }
    $suburb = go_output_string_protected($address['suburb']);
    $city = go_output_string_protected($address['city']);
    $state = go_output_string_protected($address['state']);
    $email = go_output_string_protected($address['email_address']);
    if (isset($address['land_id']) && go_not_null($address['land_id'])) {
      $land = go_get_land_name($address['land_id']);
      if (isset($address['zone_id']) && go_not_null($address['zone_id'])) {
        $state = go_get_zone_code($address['land_id'], $address['zone_id'], $state);
      }
    } elseif (isset($address['land']) && go_not_null($address['land'])) {
      $land = go_output_string_protected($address['land']);
    } else {
      $land = '';
    }
    $postcode = go_output_string_protected($address['postcode']);
    $zip = $postcode;
    if ($html) { 
      $HR = '<hr>';
      $hr = '<hr>';
      if ( ($boln == '') && ($eoln == "\n") ) { 
        $CR = '<br>';
        $cr = '<br>';
        $eoln = $cr;
      } else { 
        $CR = $eoln . $boln;
        $cr = $CR;
      }
    } else { 
      $CR = $eoln;
      $cr = $CR;
      $HR = '----------------------------------------';
      $hr = '----------------------------------------';
    }
    $statecomma = '';
    $streets = $street;
   if (isset($street2) && go_not_null($street2)) {
      $streets = $street . $cr . $street2;
         if ($suburb != '') $streets = $street . $cr . $street2 . $cr . $suburb;
   }
   else {
      $streets = $street;
         if ($suburb != '') $streets = $street . $cr . $suburb;
   }
    if ($land == '') $land = go_output_string_protected($address['land']);
    if ($state != '') $statecomma = $state . ', ';
    $fmt = $form_of_address['format'];
    eval("\$address = \"$fmt\";");
    if ( (MEMBER_COMPANY == 'true') && (go_not_null($company)) ) { 
      $address = $company . $cr . $piva . $cr . $address; 
    }
    return $address;
  }             
  function go_get_zone_code($land, $zone, $def_state) {
    $state_prov_query = go_db_query("select zone_code from " . DB_TBL_ZONES . " where zone_land_id = '" . (int)$land . "' and zone_id = '" . (int)$zone . "'");
    if (!go_db_num_rows($state_prov_query)) {
      $state_prov_code = $def_state;
    }
    else {
      $state_prov_values = go_db_fetch_array($state_prov_query);
      $state_prov_code = $state_prov_values['zone_code'];
    }
    return $state_prov_code;
  }
  function go_get_uprid($prid, $params) {
    $uprid = $prid;
    if ( (is_array($params)) && (!strstr($prid, '{')) ) {
      while (list($option, $value) = each($params)) {
        $uprid = $uprid . '{' . $option . '}' . $value;
      }
    }
    return $uprid;
  }
  function go_get_prid($uprid) {
    $pieces = explode('{', $uprid);
    return $pieces[0];
  }
  function go_get_languages() {
    $languages_query = go_db_query("select languages_id, name, code, picture, directory from " . DB_TBL_LANGUAGES . " order by sort_order");
    while ($languages = go_db_fetch_array($languages_query)) {
      $languages_array[] = array('id' => $languages['languages_id'],
                                 'name' => $languages['name'],
                                 'code' => $languages['code'],
                                 'picture' => $languages['picture'],
                                 'directory' => $languages['directory']);
    }
    return $languages_array;
  }
  function go_get_category_name($category_id, $language_id) {
    $category_query = go_db_query("select categories_name from " . DB_TBL_CATEGORIES_DESCRIPTION . " where categories_id = '" . (int)$category_id . "' and language_id = '" . (int)$language_id . "'");
    $category = go_db_fetch_array($category_query);
    return $category['categories_name'];
  }
 function go_get_category_desc($category_id, $language_id) {
    $category_query = go_db_query("select categories_desc from " . DB_TBL_CATEGORIES_DESCRIPTION . " where categories_id = '" . (int)$category_id . "' and language_id = '" . (int)$language_id . "'");
    $category = go_db_fetch_array($category_query);
    return $category['categories_desc'];
  }
  function go_get_orders_status_name($orders_status_id, $language_id = '') {
    global $languages_id;
    if (!$language_id) $language_id = $languages_id;
    $orders_status_query = go_db_query("select orders_status_name from " . DB_TBL_ORDERS_STATUS . " where orders_status_id = '" . (int)$orders_status_id . "' and language_id = '" . (int)$language_id . "'");
    $orders_status = go_db_fetch_array($orders_status_query);
    return $orders_status['orders_status_name'];
  }
  function go_get_orders_status() {
    global $languages_id;
    $orders_status_array = array();
    $orders_status_query = go_db_query("select orders_status_id, orders_status_name from " . DB_TBL_ORDERS_STATUS . " where language_id = '" . (int)$languages_id . "' order by orders_status_id");
    while ($orders_status = go_db_fetch_array($orders_status_query)) {
      $orders_status_array[] = array('id' => $orders_status['orders_status_id'],
                                     'text' => $orders_status['orders_status_name']);
    }
    return $orders_status_array;
  }
  function go_get_values_from_items_description($item_id, $language_id = 0, $databasefield) {
    global $languages_id;
    if ($language_id == 0) $language_id = $languages_id;
    $item_query = go_db_query("select " . $databasefield . " from " . DB_TBL_ITEMS_DESCRIPTION . " where items_id = '" . (int)$item_id . "' and language_id = '" . (int)$language_id . "'");
    $item = go_db_fetch_array($item_query);
    return $item[$databasefield];
  }
  function go_get_values_from_download_description($item_id, $language_id = 0, $databasefield) {
    global $languages_id;
    if ($language_id == 0) $language_id = $languages_id;
    $item_query = go_db_query("select " . $databasefield . " from " . DB_TBL_ITEMS_DOWNLOADS_DESCRIPTION . " where items_id_downloads = '" . (int)$item_id . "' and languages_id = '" . (int)$language_id . "'");
    $item = go_db_fetch_array($item_query);
    return $item[$databasefield];
  }
  function go_get_from_items($item_id, $databasefield) {
    $item_query = go_db_query("select " . $databasefield . " from " . DB_TBL_ITEMS . " where items_id = '" . (int)$item_id . "'");
    $item = go_db_fetch_array($item_query);
    return $item[$databasefield]; 	
  }  
  function go_get_items_name2($item_id, $language_id = 0) {
    global $languages_id;
    if ($language_id == 0) $language_id = $languages_id;
    $item_query = go_db_query("select items_name2 from " . DB_TBL_ITEMS_DESCRIPTION . " where items_id = '" . (int)$item_id . "' and language_id = '" . (int)$language_id . "'");
    $item = go_db_fetch_array($item_query);
    return $item['items_name2'];
  } 
  function go_get_bezeichnung1($item_id, $language_id = 0) {
    global $languages_id;
    if ($language_id == 0) $language_id = $languages_id;
    $item_query = go_db_query("select bezeichnung1 from " . DB_TBL_ITEMS_DESCRIPTION . " where items_id = '" . (int)$item_id . "' and language_id = '" . (int)$language_id . "'");
    $item = go_db_fetch_array($item_query);
    return $item['bezeichnung1'];
  }  
  function go_get_bezeichnung2($item_id, $language_id = 0) {
    global $languages_id;
    if ($language_id == 0) $language_id = $languages_id;
    $item_query = go_db_query("select bezeichnung2 from " . DB_TBL_ITEMS_DESCRIPTION . " where items_id = '" . (int)$item_id . "' and language_id = '" . (int)$language_id . "'");
    $item = go_db_fetch_array($item_query);
    return $item['bezeichnung2'];
  }  
  function go_get_bezeichnung3($item_id, $language_id = 0) {
    global $languages_id;
    if ($language_id == 0) $language_id = $languages_id;
    $item_query = go_db_query("select bezeichnung3 from " . DB_TBL_ITEMS_DESCRIPTION . " where items_id = '" . (int)$item_id . "' and language_id = '" . (int)$language_id . "'");
    $item = go_db_fetch_array($item_query);
    return $item['bezeichnung3'];
  }  
  function go_get_bezeichnung4($item_id, $language_id = 0) {
    global $languages_id;
    if ($language_id == 0) $language_id = $languages_id;
    $item_query = go_db_query("select bezeichnung4 from " . DB_TBL_ITEMS_DESCRIPTION . " where items_id = '" . (int)$item_id . "' and language_id = '" . (int)$language_id . "'");
    $item = go_db_fetch_array($item_query);
    return $item['bezeichnung4'];
  }  
  function go_get_bezeichnung5($item_id, $language_id = 0) {
    global $languages_id;
    if ($language_id == 0) $language_id = $languages_id;
    $item_query = go_db_query("select bezeichnung5 from " . DB_TBL_ITEMS_DESCRIPTION . " where items_id = '" . (int)$item_id . "' and language_id = '" . (int)$language_id . "'");
    $item = go_db_fetch_array($item_query);
    return $item['bezeichnung5'];
  }  
  function go_get_bezeichnung6($item_id, $language_id = 0) {
    global $languages_id;
    if ($language_id == 0) $language_id = $languages_id;
    $item_query = go_db_query("select bezeichnung6 from " . DB_TBL_ITEMS_DESCRIPTION . " where items_id = '" . (int)$item_id . "' and language_id = '" . (int)$language_id . "'");
    $item = go_db_fetch_array($item_query);
    return $item['bezeichnung6'];
  }
    
  function go_get_inhalt1($item_id, $language_id = 0) {
    global $languages_id;
    if ($language_id == 0) $language_id = $languages_id;
    $item_query = go_db_query("select inhalt1 from " . DB_TBL_ITEMS_DESCRIPTION . " where items_id = '" . (int)$item_id . "' and language_id = '" . (int)$language_id . "'");
    $item = go_db_fetch_array($item_query);
    return $item['inhalt1'];
  }  
  function go_get_inhalt2($item_id, $language_id = 0) {
    global $languages_id;
    if ($language_id == 0) $language_id = $languages_id;
    $item_query = go_db_query("select inhalt2 from " . DB_TBL_ITEMS_DESCRIPTION . " where items_id = '" . (int)$item_id . "' and language_id = '" . (int)$language_id . "'");
    $item = go_db_fetch_array($item_query);
    return $item['inhalt2'];
  }  
  function go_get_inhalt3($item_id, $language_id = 0) {
    global $languages_id;
    if ($language_id == 0) $language_id = $languages_id;
    $item_query = go_db_query("select inhalt3 from " . DB_TBL_ITEMS_DESCRIPTION . " where items_id = '" . (int)$item_id . "' and language_id = '" . (int)$language_id . "'");
    $item = go_db_fetch_array($item_query);
    return $item['inhalt3'];
  }  
  function go_get_inhalt4($item_id, $language_id = 0) {
    global $languages_id;
    if ($language_id == 0) $language_id = $languages_id;
    $item_query = go_db_query("select inhalt4 from " . DB_TBL_ITEMS_DESCRIPTION . " where items_id = '" . (int)$item_id . "' and language_id = '" . (int)$language_id . "'");
    $item = go_db_fetch_array($item_query);
    return $item['inhalt4'];
  }  
  function go_get_inhalt5($item_id, $language_id = 0) {
    global $languages_id;
    if ($language_id == 0) $language_id = $languages_id;
    $item_query = go_db_query("select inhalt5 from " . DB_TBL_ITEMS_DESCRIPTION . " where items_id = '" . (int)$item_id . "' and language_id = '" . (int)$language_id . "'");
    $item = go_db_fetch_array($item_query);
    return $item['inhalt5'];
  }  
  function go_get_inhalt6($item_id, $language_id = 0) {
    global $languages_id;
    if ($language_id == 0) $language_id = $languages_id;
    $item_query = go_db_query("select inhalt6 from " . DB_TBL_ITEMS_DESCRIPTION . " where items_id = '" . (int)$item_id . "' and language_id = '" . (int)$language_id . "'");
    $item = go_db_fetch_array($item_query);
    return $item['inhalt6'];
  }
  function go_get_items_description($item_id, $language_id) {
    $item_query = go_db_query("select items_description from " . DB_TBL_ITEMS_DESCRIPTION . " where items_id = '" . (int)$item_id . "' and language_id = '" . (int)$language_id . "'");
    $item = go_db_fetch_array($item_query);
    return $item['items_description'];
  }
  function go_get_items_description_in_cat_list($item_id, $language_id) {
    $item_query = go_db_query("select items_description_in_cat_list from " . DB_TBL_ITEMS_DESCRIPTION . " where items_id = '" . (int)$item_id . "' and language_id = '" . (int)$language_id . "'");
    $item = go_db_fetch_array($item_query);
    return $item['items_description_in_cat_list'];
  }
  function go_get_items_url($item_id, $language_id) {
    $item_query = go_db_query("select items_url from " . DB_TBL_ITEMS_DESCRIPTION . " where items_id = '" . (int)$item_id . "' and language_id = '" . (int)$language_id . "'");
    $item = go_db_fetch_array($item_query);
    return $item['items_url'];
  }   
  function go_get_producer_url($producer_id, $language_id) {
    $producer_query = go_db_query("select producers_url from " . DB_TBL_PRODUCERS_INFO . " where producers_id = '" . (int)$producer_id . "' and languages_id = '" . (int)$language_id . "'");
    $producer = go_db_fetch_array($producer_query);
    return $producer['producers_url'];
  }
  function go_get_pages_title($pages_id, $language_id = 0) {
    global $languages_id;
    if ($language_id == 0) $language_id = $languages_id;
    $pages_query = go_db_query("select pages_title from " . DB_TBL_PAGES . " where pages_id = '" . (int)$pages_id . "' and language_id = '" . (int)$language_id . "'");
    $page = go_db_fetch_array($pages_query);
    return $page['pages_title'];
  }
  function go_get_pages_html_text($pages_id, $language_id = 0) {
    global $languages_id;
    if ($language_id == 0) $language_id = $languages_id;
    $pages_html_text_query = go_db_query("select pages_html_text from " . DB_TBL_PAGES . " where pages_id = '" . (int)$pages_id . "' and language_id = '" . (int)$language_id . "'");
    $pages_html_text = go_db_fetch_array($pages_html_text_query);
    return $pages_html_text['pages_html_text'];
  }
  function go_get_agb_text($id, $language_id = 0) {
    global $languages_id;
    if ($language_id == 0) $language_id = $languages_id;
    $agb_text_query = go_db_query("select text from info_conditions where id = '" . (int)$id . "' and language_id = '" . (int)$language_id . "'");
    $agb_text = go_db_fetch_array($agb_text_query);
    return $agb_text['text'];
  }
  function go_get_give_back_text($id, $language_id = 0) {
    global $languages_id;
    if ($language_id == 0) $language_id = $languages_id;
    $give_back_text_query = go_db_query("select text from info_give_back where id = '" . (int)$id . "' and language_id = '" . (int)$language_id . "'");
    $give_back_text = go_db_fetch_array($give_back_text_query);
    return $give_back_text['text'];
  }
  function go_get_privacy_text($id, $language_id = 0) {
    global $languages_id;
    if ($language_id == 0) $language_id = $languages_id;
    $privacy_text_query = go_db_query("select text from info_privacy where id = '" . (int)$id . "' and language_id = '" . (int)$language_id . "'");
    $privacy_text = go_db_fetch_array($privacy_text_query);
    return $privacy_text['text'];
  }
  function go_get_shipping_text($id, $language_id = 0) {
    global $languages_id;
    if ($language_id == 0) $language_id = $languages_id;
    $shipping_text_query = go_db_query("select text from info_shipping where id = '" . (int)$id . "' and language_id = '" . (int)$language_id . "'");
    $shipping_text = go_db_fetch_array($shipping_text_query);
    return $shipping_text['text'];
  }   
  function go_class_exists($class_name) {
    if (function_exists('class_exists')) {
      return class_exists($class_name);
    } else {
      return true;
    }
  }   
  function go_items_in_category_count($categories_id, $include_deactivated = false) {
    $items_count = 0;
    if ($include_deactivated) {
      $items_query = go_db_query("select count(*) as total from " . DB_TBL_ITEMS . " p, " . DB_TBL_ITEMS_TO_CATEGORIES . " p2c where p.items_id = p2c.items_id and p2c.categories_id = '" . (int)$categories_id . "'");
    } else {
      $items_query = go_db_query("select count(*) as total from " . DB_TBL_ITEMS . " p, " . DB_TBL_ITEMS_TO_CATEGORIES . " p2c where p.items_id = p2c.items_id and p.items_status = '1' and p2c.categories_id = '" . (int)$categories_id . "'");
    }
    $items = go_db_fetch_array($items_query);
    $items_count += $items['total'];
    $childs_query = go_db_query("select categories_id from " . DB_TBL_CATEGORIES . " where parent_id = '" . (int)$categories_id . "'");
    if (go_db_num_rows($childs_query)) {
      while ($childs = go_db_fetch_array($childs_query)) {
        $items_count += go_items_in_category_count($childs['categories_id'], $include_deactivated);
      }
    }
    return $items_count;
  }   
  function go_childs_in_category_count($categories_id) {
    $categories_count = 0;
    $categories_query = go_db_query("select categories_id from " . DB_TBL_CATEGORIES . " where parent_id = '" . (int)$categories_id . "'");
    while ($categories = go_db_fetch_array($categories_query)) {
      $categories_count++;
      $categories_count += go_childs_in_category_count($categories['categories_id']);
    }
    return $categories_count;
  }   
  function go_get_lands($default = '') {
    $lands_array = array();
    if ($default) {
      $lands_array[] = array('id' => '',
                                 'text' => $default);
    }
    $lands_query = go_db_query("select lands_id, lands_name from " . DB_TBL_LANDS . " order by lands_name");
    while ($lands = go_db_fetch_array($lands_query)) {
      $lands_array[] = array('id' => $lands['lands_id'],
                                 'text' => $lands['lands_name']);
    }
    return $lands_array;
  }  
  function go_get_land_zones($land_id) {
    $zones_array = array();
    $zones_query = go_db_query("select zone_id, zone_name from " . DB_TBL_ZONES . " where zone_land_id = '" . (int)$land_id . "' order by zone_name");
    while ($zones = go_db_fetch_array($zones_query)) {
      $zones_array[] = array('id' => $zones['zone_id'],
                             'text' => $zones['zone_name']);
    }
    return $zones_array;
  }
  function go_prepare_land_zones_pull_down($land_id = '') { 
    $pre = '';
    if ( (!go_browser_detect('MSIE')) && (go_browser_detect('Mozilla/4')) ) {
      for ($i=0; $i<45; $i++) $pre .= '&nbsp;';
    }
    $zones = go_get_land_zones($land_id);
    if (sizeof($zones) > 0) {
      $zones_select = array(array('id' => '', 'text' => PLEASE_SELECT));
      $zones = array_merge($zones_select, $zones);
    } else {
      $zones = array(array('id' => '', 'text' => TYPE_BELOW)); 
      if ( (!go_browser_detect('MSIE')) && (go_browser_detect('Mozilla/4')) ) {
        for ($i=0; $i<9; $i++) {
          $zones[] = array('id' => '', 'text' => $pre);
        }
      }
    }
    return $zones;
  }  
  function go_get_form_of_addresss() {
    $form_of_address_query = go_db_query("select form_of_address_id from " . DB_TBL_FORM_OF_ADDRESS . " order by form_of_address_id");
    $form_of_address_array = array();
    while ($form_of_address_values = go_db_fetch_array($form_of_address_query)) {
      $form_of_address_array[] = array('id' => $form_of_address_values['form_of_address_id'],
                                      'text' => $form_of_address_values['form_of_address_id']);
    }
    return $form_of_address_array;
  }  
  function go_cfg_pull_down_land_list($land_id) {
    return go_fetch_pull_down_menu('set_it_up_value', go_get_lands(), $land_id);
  }
  function go_cfg_pull_down_zone_list($zone_id) {
    return go_fetch_pull_down_menu('set_it_up_value', go_get_land_zones(SHOP_LAND), $zone_id);
  }
  function go_cfg_pull_down_tax_classes($tax_class_id, $key = '') {
    $name = (($key) ? 'set_it_up[' . $key . ']' : 'set_it_up_value');
    $tax_class_array = array(array('id' => '0', 'text' => TEXT_NONE));
    $tax_class_query = go_db_query("select tax_class_id, tax_class_title from " . DB_TBL_TAX_CLASS . " order by tax_class_title");
    while ($tax_class = go_db_fetch_array($tax_class_query)) {
      $tax_class_array[] = array('id' => $tax_class['tax_class_id'],
                                 'text' => $tax_class['tax_class_title']);
    }
    return go_fetch_pull_down_menu($name, $tax_class_array, $tax_class_id);
  }  
 function go_cfg_textarea($text) {
    return go_fetch_textarea_field('set_it_up_value', false, 35, 5, $text);
  }
  function go_cfg_get_zone_name($zone_id) {
    $zone_query = go_db_query("select zone_name from " . DB_TBL_ZONES . " where zone_id = '" . (int)$zone_id . "'");
    if (!go_db_num_rows($zone_query)) {
      return $zone_id;
    } else {
      $zone = go_db_fetch_array($zone_query);
      return $zone['zone_name'];
    }
  }  
  function go_set_banner_status($banners_id, $status) {
    if ($status == '1') {
      return go_db_query("update " . DB_TBL_BANNERS . " set status = '1', expires_impressions = NULL, expires_date = NULL, date_status_change = NULL where banners_id = '" . $banners_id . "'");
    } elseif ($status == '0') {
      return go_db_query("update " . DB_TBL_BANNERS . " set status = '0', date_status_change = now() where banners_id = '" . $banners_id . "'");
    } else {
      return -1;
    }
  }  
  function go_set_item_status($items_id, $status) {
    if ($status == '1') {
      return go_db_query("update " . DB_TBL_ITEMS . " set items_status = '1', items_last_modified = now() where items_id = '" . (int)$items_id . "'");
    } elseif ($status == '0') {
      return go_db_query("update " . DB_TBL_ITEMS . " set items_status = '0', items_last_modified = now() where items_id = '" . (int)$items_id . "'");
    } else {
      return -1;
    }
  }    
  function go_set_specials_status($specials_id, $status) {
    if ($status == '1') {
      return go_db_query("update " . DB_TBL_SPECIALS . " set status = '1', expires_date = NULL, date_status_change = NULL where specials_id = '" . (int)$specials_id . "'");
    } elseif ($status == '0') {
      return go_db_query("update " . DB_TBL_SPECIALS . " set status = '0', date_status_change = now() where specials_id = '" . (int)$specials_id . "'");
    } else {
      return -1;
    }
  }   
  function go_set_time_limit($limit) {
    if (!get_cfg_var('safe_mode')) {
      set_time_limit($limit);
    }
  }  
  function go_cfg_select_option($select_array, $key_value, $key = '') {
    $string = '';
    for ($i=0, $n=sizeof($select_array); $i<$n; $i++) {
      $name = ((go_not_null($key)) ? 'set_it_up[' . $key . ']' : 'set_it_up_value');
      $string .= '<br><input type="radio" name="' . $name . '" value="' . $select_array[$i] . '"';
      if ($key_value == $select_array[$i]) $string .= ' CHECKED';
      $string .= '> ' . constants_language($select_array[$i]);
    }
    return $string;
  }  
  function go_mod_select_option($select_array, $key_name, $key_value) {
    reset($select_array);
    while (list($key, $value) = each($select_array)) {
      if (is_int($key)) $key = $value;
      $string .= '<br><input type="radio" name="set_it_up[' . $key_name . ']" value="' . $key . '"';
      if ($key_value == $key) $string .= ' CHECKED';
      $string .= '> ' . $value;
    }
    return $string;
  }  
  function go_get_system_information() {
    global $_SERVER;
    global $db_link;
    $db_query = go_db_query("select now() as datetime");
    $db = go_db_fetch_array($db_query);
    list($system, $host, $kernel) = preg_split('/[\s,]+/', @exec('uname -a'), 5);
    return array('date' => go_datetime_short(date('Y-m-d H:i:s')),
                 'system' => $system,
                 'kernel' => $kernel,
                 'host' => $host,
                 'ip' => gethostbyname($host),
                 'uptime' => @exec('uptime'),
                 'http_server' => $_SERVER['SERVER_SOFTWARE'],
                 'php' => PHP_VERSION,
                 'zend' => (function_exists('zend_version') ? zend_version() : ''),
                 'db_server' => DB_SERVER,
                 'db_ip' => gethostbyname(DB_SERVER),
                 'db_version' => 'MySQL ' . (function_exists('mysqli_get_server_info') ? mysqli_get_server_info($db_link) : ''),
                 'db_date' => go_datetime_short($db['datetime']));
  }
  function go_generate_category_path($id, $from = 'category', $categories_array = '', $index = 0) {
    global $languages_id;
    if (!is_array($categories_array)) $categories_array = array();
    if ($from == 'item') {
      $categories_query = go_db_query("select categories_id from " . DB_TBL_ITEMS_TO_CATEGORIES . " where items_id = '" . (int)$id . "'");
      while ($categories = go_db_fetch_array($categories_query)) {
        if ($categories['categories_id'] == '0') {
          $categories_array[$index][] = array('id' => '0', 'text' => TEXT_TOP);
        } else {
          $category_query = go_db_query("select cd.categories_name, c.parent_id from " . DB_TBL_CATEGORIES . " c, " . DB_TBL_CATEGORIES_DESCRIPTION . " cd where c.categories_id = '" . (int)$categories['categories_id'] . "' and c.categories_id = cd.categories_id and cd.language_id = '" . (int)$languages_id . "'");
          $category = go_db_fetch_array($category_query);
          $categories_array[$index][] = array('id' => $categories['categories_id'], 'text' => $category['categories_name']);
          if ( (go_not_null($category['parent_id'])) && ($category['parent_id'] != '0') ) $categories_array = go_generate_category_path($category['parent_id'], 'category', $categories_array, $index);
          $categories_array[$index] = array_reverse($categories_array[$index]);
        }
        $index++;
      }
    } elseif ($from == 'category') {
      $category_query = go_db_query("select cd.categories_name, c.parent_id from " . DB_TBL_CATEGORIES . " c, " . DB_TBL_CATEGORIES_DESCRIPTION . " cd where c.categories_id = '" . (int)$id . "' and c.categories_id = cd.categories_id and cd.language_id = '" . (int)$languages_id . "'");
      $category = go_db_fetch_array($category_query);
      $categories_array[$index][] = array('id' => $id, 'text' => $category['categories_name']);
      if ( (go_not_null($category['parent_id'])) && ($category['parent_id'] != '0') ) $categories_array = go_generate_category_path($category['parent_id'], 'category', $categories_array, $index);
    }
    return $categories_array;
  }
  function go_output_generated_category_path($id, $from = 'category') {
    $calculated_category_path_string = '';
    $calculated_category_path = go_generate_category_path($id, $from);
    for ($i=0, $n=sizeof($calculated_category_path); $i<$n; $i++) {
      for ($j=0, $k=sizeof($calculated_category_path[$i]); $j<$k; $j++) {
        $calculated_category_path_string .= $calculated_category_path[$i][$j]['text'] . '&nbsp;&gt;&nbsp;';
      }
      $calculated_category_path_string = substr($calculated_category_path_string, 0, -16) . '<br>';
    }
    $calculated_category_path_string = substr($calculated_category_path_string, 0, -4);
    if (strlen($calculated_category_path_string) < 1) $calculated_category_path_string = TEXT_TOP;
    return $calculated_category_path_string;
  }
  function go_get_generated_category_path_ids($id, $from = 'category') {
    $calculated_category_path_string = '';
    $calculated_category_path = go_generate_category_path($id, $from);
    for ($i=0, $n=sizeof($calculated_category_path); $i<$n; $i++) {
      for ($j=0, $k=sizeof($calculated_category_path[$i]); $j<$k; $j++) {
        $calculated_category_path_string .= $calculated_category_path[$i][$j]['id'] . '_';
      }
      $calculated_category_path_string = substr($calculated_category_path_string, 0, -1) . '<br>';
    }
    $calculated_category_path_string = substr($calculated_category_path_string, 0, -4);
    if (strlen($calculated_category_path_string) < 1) $calculated_category_path_string = TEXT_TOP;
    return $calculated_category_path_string;
  }
  function go_remove_category($category_id) {
    $category_picture_query = go_db_query("select categories_picture from " . DB_TBL_CATEGORIES . " where categories_id = '" . (int)$category_id . "'");
    $category_picture = go_db_fetch_array($category_picture_query);
    $duplicate_picture_query = go_db_query("select count(*) as total from " . DB_TBL_CATEGORIES . " where categories_picture = '" . go_db_input($category_picture['categories_picture']) . "'");
    $duplicate_picture = go_db_fetch_array($duplicate_picture_query);
    if ($duplicate_picture['total'] < 2) {
      if (file_exists(FOLDER_ABSOLUT_CATALOG_PICTURES . $category_picture['categories_picture'])) {              
        @unlink(FOLDER_ABSOLUT_CATALOG_PICTURES . $category_picture['categories_picture']);
      }
    }
    go_db_query("delete from " . DB_TBL_CATEGORIES . " where categories_id = '" . (int)$category_id . "'");
    go_db_query("delete from " . DB_TBL_CATEGORIES_DESCRIPTION . " where categories_id = '" . (int)$category_id . "'");
    go_db_query("delete from " . DB_TBL_ITEMS_TO_CATEGORIES . " where categories_id = '" . (int)$category_id . "'");
    if (USE_CACHE == 'true') {
      go_reset_cache_block('categories');
      go_reset_cache_block('also_purchased');
    }
  }
  
  
  function go_remove_category_api($category_id) {
  }  
  
  
  
  function go_remove_item($item_id) {
    $item_picture_query = go_db_query("select items_picture from " . DB_TBL_ITEMS . " where items_id = '" . (int)$item_id . "'");
    $item_picture = go_db_fetch_array($item_picture_query);
    $duplicate_picture_query = go_db_query("select count(*) as total from " . DB_TBL_ITEMS . " where items_picture = '" . go_db_input($item_picture['items_picture']) . "'");
    $duplicate_picture = go_db_fetch_array($duplicate_picture_query);
    if ($duplicate_picture['total'] < 2) {
      if (file_exists(FOLDER_ABSOLUT_CATALOG_PICTURES . $item_picture['items_picture'])) {      
        	@unlink(FOLDER_ABSOLUT_CATALOG_PICTURES . $item_picture['items_picture']);
      }
    }
    go_db_query("delete from " . DB_TBL_SPECIALS . " where items_id = '" . (int)$item_id . "'");
    go_db_query("delete from " . DB_TBL_ITEMS . " where items_id = '" . (int)$item_id . "'");
		if (file_exists(FOLDER_ABSOLUT_CATALOG . 'modules/masseinheitenartikel')) {
    	go_db_query("delete from " . DB_TBL_ITEMS_MASSEINHEIT . " where items_id_ms = '" . (int)$item_id . "'");
	  }  
		if (file_exists(FOLDER_ABSOLUT_CATALOG . 'modules/download')) {
			$item_downloads_query = go_db_query("select download_file from " . DB_TBL_ITEMS_DOWNLOADS . " where items_id_downloads = '" . (int)$item_id . "'"); 
			$item_downloads = go_db_fetch_array($item_downloads_query);		
			@unlink(FOLDER_ABSOLUT_DOCUMENT_ROOT . 'download/' . $item_downloads['download_file']);
    	go_db_query("delete from " . DB_TBL_ITEMS_DOWNLOADS . " where items_id_downloads = '" . (int)$item_id . "'");
    	go_db_query("delete from " . DB_TBL_ITEMS_DOWNLOADS_DESCRIPTION . " where items_id_downloads = '" . (int)$item_id . "'");
	  }  
    go_db_query("delete from " . DB_TBL_ITEMS_TO_CATEGORIES . " where items_id = '" . (int)$item_id . "'");
    go_db_query("delete from " . DB_TBL_ITEMS_DESCRIPTION . " where items_id = '" . (int)$item_id . "'");
//    go_db_query("delete from " . DB_TBL_ITEMS_CHARACTERISTICS . " where items_id = '" . (int)$item_id . "'");
    go_db_query("delete from " . DB_TBL_ATTENDEES_BASKET . " where items_id = '" . (int)$item_id . "'");
    go_db_query("delete from " . DB_TBL_ATTENDEES_BASKET_CHARACTERISTICS . " where items_id = '" . (int)$item_id . "'");
    $item_reviews_query = go_db_query("select reviews_id from " . DB_TBL_REVIEWS . " where items_id = '" . (int)$item_id . "'");
    while ($item_reviews = go_db_fetch_array($item_reviews_query)) {
      go_db_query("delete from " . DB_TBL_REVIERELATIV_DESCRIPTION . " where reviews_id = '" . (int)$item_reviews['reviews_id'] . "'");
    }
    go_db_query("delete from " . DB_TBL_REVIEWS . " where items_id = '" . (int)$item_id . "'");
    if (USE_CACHE == 'true') {
      go_reset_cache_block('categories');
      go_reset_cache_block('also_purchased');
    }

    $option_id_query = go_db_query("SELECT options_id FROM " . DB_TBL_ITEMS_CHARACTERISTICS . " WHERE items_id = '" . (int)$item_id . "'");
    while($option_id_result=go_db_fetch_array($option_id_query)){
	$option_id = $option_id_result['options_id'];		
		
	$option_check_query = go_db_query("select count(*) as total from " . DB_TBL_ITEMS_CHARACTERISTICS . " where options_id = '" . $option_id . "' AND items_id != '" . (int)$item_id . "'");
       	$option_check = go_db_fetch_array($option_check_query);
       	if ($option_check['total'] < '1') {
       		
       		go_db_query("delete from " . DB_TBL_ITEMS_OPTIONS . " where items_options_id = '" . $option_id . "'");
       	}
       	
	$options_values_id_query = go_db_query("SELECT options_values_id FROM " . DB_TBL_ITEMS_CHARACTERISTICS . " WHERE options_id='" . $option_id . "' AND  items_id = '" . (int)$item_id . "'");
	while($options_values_result=go_db_fetch_array($options_values_id_query)){
		$options_values_id = $options_values_result['options_values_id'];
			
		$option_value_check_query = go_db_query("select count(*) as total from " . DB_TBL_ITEMS_CHARACTERISTICS . " where options_values_id = '" . $options_values_id . "' AND items_id != '" . (int)$item_id . "'");
       		$option_value_check = go_db_fetch_array($option_value_check_query);
       		if ($option_value_check['total'] < '1') {
       			go_db_query("delete from " . DB_TBL_ITEMS_OPTIONS_VALUES . " where items_options_values_id = '" . $options_values_id . "'");		
       		}
		$option_value_to_option_check_query = go_db_query("select count(*) as total from " . DB_TBL_ITEMS_CHARACTERISTICS . " where options_id='" . $option_id . "' AND options_values_id = '" . $options_values_id . "' AND items_id != '" . (int)$item_id . "'");
       		$option_value_to_option_check = go_db_fetch_array($option_value_to_option_check_query);
       		if ($option_value_to_option_check['total'] < '1') {
       			go_db_query("delete from " . DB_TBL_ITEMS_OPTIONS_VALUES_TO_ITEMS_OPTIONS . " where items_options_values_id = '" . $options_values_id . "' AND  items_options_id='" . $option_id . "'");	
       		}		
			
	}		            	
       	
       	go_db_query("delete from " . DB_TBL_ITEMS_CHARACTERISTICS . " where items_id = '" . (int)$item_id . "'");
		
    }	
  }
  function go_remove_order($order_id, $restock = false) {
    if ($restock == 'on') {
      $order_query = go_db_query("select items_id, items_quantity from " . DB_TBL_ORDERS_ITEMS . " where orders_id = '" . (int)$order_id . "'");
      while ($order = go_db_fetch_array($order_query)) {
        go_db_query("update " . DB_TBL_ITEMS . " set items_quantity = items_quantity + " . $order['items_quantity'] . ", items_ordered = items_ordered - " . $order['items_quantity'] . " where items_id = '" . (int)$order['items_id'] . "'");
      }
    }
    go_db_query("delete from " . DB_TBL_ORDERS . " where orders_id = '" . (int)$order_id . "'");
    go_db_query("delete from " . DB_TBL_ORDERS_ITEMS . " where orders_id = '" . (int)$order_id . "'"); 
		go_db_query("delete from " . DB_TBL_ITEMS_GROUPS . " where items_id = '" . (int)$item_id . "'"); 
    go_db_query("delete from " . DB_TBL_ORDERS_ITEMS_CHARACTERISTICS . " where orders_id = '" . (int)$order_id . "'");
    go_db_query("delete from " . DB_TBL_ORDERS_STATUS_HISTORY . " where orders_id = '" . (int)$order_id . "'");
    go_db_query("delete from " . DB_TBL_ORDERS_TOTAL . " where orders_id = '" . (int)$order_id . "'");
		go_db_query("DELETE FROM " . DB_TBL_BANKTRANSFER . " WHERE orders_id = '" . (int)$order_id . "'");
		go_db_query("DELETE FROM " . DB_TBL_BANKTRANSFER_SEPA . " WHERE orders_id = '" . (int)$order_id . "'");
		go_db_query("DELETE FROM " . DB_TBL_ORDERS_ITEMS_DOWNLOAD . " WHERE orders_id = '" . (int)$order_id . "'");
  }
  function go_reset_cache_block($cache_block) {
    global $cache_blocks;
    for ($i=0, $n=sizeof($cache_blocks); $i<$n; $i++) {
      if ($cache_blocks[$i]['code'] == $cache_block) {
        if ($cache_blocks[$i]['multiple']) {
          if ($dir = @opendir(FOLDER_ABSOLUT_CACHE)) {
            while ($cache_file = readdir($dir)) {
              $cached_file = $cache_blocks[$i]['file'];
              $languages = go_get_languages();
              for ($j=0, $k=sizeof($languages); $j<$k; $j++) {
                $cached_file_unlink = preg_replace('-language', '-' . $languages[$j]['directory'], $cached_file);
                if (preg_match('^' . $cached_file_unlink, $cache_file)) {
                  @unlink(FOLDER_ABSOLUT_CACHE . $cache_file);
                }
              }
            }
            closedir($dir);
          }
        } else {
          $cached_file = $cache_blocks[$i]['file'];
          $languages = go_get_languages();
          for ($i=0, $n=sizeof($languages); $i<$n; $i++) {
            $cached_file = preg_replace('-language', '-' . $languages[$i]['directory'], $cached_file);
            @unlink(FOLDER_ABSOLUT_CACHE . $cached_file);
          }
        }
        break;
      }
    }
  }
  function go_get_file_permissions($mode) { 
    if ( ($mode & 0xC000) == 0xC000) { 
      $type = 's';
    } elseif ( ($mode & 0x4000) == 0x4000) { 
      $type = 'd';
    } elseif ( ($mode & 0xA000) == 0xA000) { 
      $type = 'l';
    } elseif ( ($mode & 0x8000) == 0x8000) { 
      $type = '-';
    } elseif ( ($mode & 0x6000) == 0x6000) { 
      $type = 'b';
    } elseif ( ($mode & 0x2000) == 0x2000) { 
      $type = 'c';
    } elseif ( ($mode & 0x1000) == 0x1000) { 
      $type = 'p';
    } else { 
      $type = '?';
    } 
    $owner['read']    = ($mode & 00400) ? 'r' : '-';
    $owner['write']   = ($mode & 00200) ? 'w' : '-';
    $owner['execute'] = ($mode & 00100) ? 'x' : '-';
    $group['read']    = ($mode & 00040) ? 'r' : '-';
    $group['write']   = ($mode & 00020) ? 'w' : '-';
    $group['execute'] = ($mode & 00010) ? 'x' : '-';
    $world['read']    = ($mode & 00004) ? 'r' : '-';
    $world['write']   = ($mode & 00002) ? 'w' : '-';
    $world['execute'] = ($mode & 00001) ? 'x' : '-'; 
    if ($mode & 0x800 ) $owner['execute'] = ($owner['execute'] == 'x') ? 's' : 'S';
    if ($mode & 0x400 ) $group['execute'] = ($group['execute'] == 'x') ? 's' : 'S';
    if ($mode & 0x200 ) $world['execute'] = ($world['execute'] == 'x') ? 't' : 'T';
    return $type .
           $owner['read'] . $owner['write'] . $owner['execute'] .
           $group['read'] . $group['write'] . $group['execute'] .
           $world['read'] . $world['write'] . $world['execute'];
  }
  function go_remove($source) {
    global $messageStack, $go_remove_error;
    if (isset($go_remove_error)) $go_remove_error = false;
    if (is_dir($source)) {
      $dir = dir($source);
      while ($file = $dir->read()) {
        if ( ($file != '.') && ($file != '..') ) {
          if (is_writeable($source . '/' . $file)) {
            go_remove($source . '/' . $file);
          } else {
            $messageStack->add(sprintf(ERROR_FILE_NOT_REMOVEABLE, $source . '/' . $file), 'error');
            $go_remove_error = true;
          }
        }
      }
      $dir->close();
      if (is_writeable($source)) {
        rmdir($source);
      } else {
        $messageStack->add(sprintf(ERROR_DIRECTORY_NOT_REMOVEABLE, $source), 'error');
        $go_remove_error = true;
      }
    } else {
      if (is_writeable($source)) {
        unlink($source);
      } else {
        $messageStack->add(sprintf(ERROR_FILE_NOT_REMOVEABLE, $source), 'error');
        $go_remove_error = true;
      }
    }
  }  
  function go_display_tax_value($value, $padding = TAX_DECIMAL_PLACES) {
    if (strpos($value, '.')) {
      $loop = true;
      while ($loop) {
        if (substr($value, -1) == '0') {
          $value = substr($value, 0, -1);
        } else {
          $loop = false;
          if (substr($value, -1) == '.') {
            $value = substr($value, 0, -1);
          }
        }
      }
    }
    if ($padding > 0) {
      if ($decimal_pos = strpos($value, '.')) {
        $decimals = strlen(substr($value, ($decimal_pos+1)));
        for ($i=$decimals; $i<$padding; $i++) {
          $value .= '0';
        }
      } else {
        $value .= '.';
        for ($i=0; $i<$padding; $i++) {
          $value .= '0';
        }
      }
    }
    return $value;
  }
  function go_mail($to_name, $to_email_address, $email_subject, $email_text, $from_email_name, $from_email_address) {
    if (SEND_EMAILS != 'true') return false; 
    $message = new email(array('X-Mailer: bigware')); 
    $text = strip_tags($email_text);
    if (EMAIL_USE_HTML == 'true') {
      $message->add_html($email_text, $text);
    } else {
      $message->add_text($text);
    } 
    $message->build_message();
    $message->send($to_name, $to_email_address, $from_email_name, $from_email_address, $email_subject);
  }
  function go_get_tax_class_title($tax_class_id) {
    if ($tax_class_id == '0') {
      return TEXT_NONE;
    } else {
      $classes_query = go_db_query("select tax_class_title from " . DB_TBL_TAX_CLASS . " where tax_class_id = '" . (int)$tax_class_id . "'");
      $classes = go_db_fetch_array($classes_query);
      return $classes['tax_class_title'];
    }
  }
  function go_banner_picture_extension() {
    if (function_exists('imagetypes')) {
      if (imagetypes() & IMG_PNG) {
        return 'png';
      } elseif (imagetypes() & IMG_JPG) {
        return 'jpg';
      } elseif (imagetypes() & IMG_GIF) {
        return 'gif';
      }
    } elseif (function_exists('imagecreatefrompng') && function_exists('imagepng')) {
      return 'png';
    } elseif (function_exists('imagecreatefromjpeg') && function_exists('imagejpeg')) {
      return 'jpg';
    } elseif (function_exists('imagecreatefromgif') && function_exists('imagegif')) {
      return 'gif';
    }
    return false;
  }  
  function go_round($value, $precision) {
    if (PHP_VERSION < 4) {
      $exp = pow(10, $precision);
      return round($value * $exp) / $exp;
    } else {
      return round($value, $precision);
    }
  }  
  function go_add_tax($price, $tax) {
    global $currencies;
    if (SHOW_PRICE_WITH_TAX == 'true') {
      return go_round($price, $currencies->currencies[DEFAULT_CURRENCY]['decimal_places']) + go_calculate_tax($price, $tax);
    } else {
      return go_round($price, $currencies->currencies[DEFAULT_CURRENCY]['decimal_places']);
    }
  } 
  function go_calculate_tax($price, $tax) {
    global $currencies;
    return go_round($price * $tax / 100, $currencies->currencies[DEFAULT_CURRENCY]['decimal_places']);
  }   
  function go_get_tax_rate($class_id, $land_id = -1, $zone_id = -1) {
    global $attendee_zone_id, $attendee_land_id;
    if ( ($land_id == -1) && ($zone_id == -1) ) {
      if (!go_session_is_registered('attendee_id')) {
        $land_id = SHOP_LAND;
        $zone_id = SHOP_ZONE;
      } else {
        $land_id = $attendee_land_id;
        $zone_id = $attendee_zone_id;
      }
    }
    $tax_query = go_db_query("select SUM(tax_rate) as tax_rate from (((" . DB_TBL_TAX_RATES . " tr) left join " . DB_TBL_ZONES_TO_GEO_ZONES . " za ON tr.tax_zone_id = za.geo_zone_id) left join " . DB_TBL_GEO_ZONES . " tz ON tz.geo_zone_id = tr.tax_zone_id) WHERE (za.zone_land_id IS NULL OR za.zone_land_id = '0' OR za.zone_land_id = '" . (int)$land_id . "') AND (za.zone_id IS NULL OR za.zone_id = '0' OR za.zone_id = '" . (int)$zone_id . "') AND tr.tax_class_id = '" . (int)$class_id . "' GROUP BY tr.tax_priority");
    if (go_db_num_rows($tax_query)) {
      $tax_multiplier = 0;
      while ($tax = go_db_fetch_array($tax_query)) {
        $tax_multiplier += $tax['tax_rate'];
      }
      return $tax_multiplier;
    } else {
      return 0;
    }
  }   
  function go_get_tax_rate_value($class_id) {
    $tax_query = go_db_query("select SUM(tax_rate) as tax_rate from " . DB_TBL_TAX_RATES . " where tax_class_id = '" . (int)$class_id . "' group by tax_priority");
    if (go_db_num_rows($tax_query)) {
      $tax_multiplier = 0;
      while ($tax = go_db_fetch_array($tax_query)) {
        $tax_multiplier += $tax['tax_rate'];
      }
      return $tax_multiplier;
    } else {
      return 0;
    }
  }
  function go_call_function($function, $parameter, $object = '') {
    if ($object == '') {
      return call_user_func($function, $parameter);
    } elseif (PHP_VERSION < 4) {
      return call_user_func($function, $object, $parameter);
    } else {
      return call_user_func(array($object, $function), $parameter);
    }
  }
  function go_get_zone_class_title($zone_class_id) {
    if ($zone_class_id == '0') {
      return TEXT_NONE;
    } else {
      $classes_query = go_db_query("select geo_zone_name from " . DB_TBL_GEO_ZONES . " where geo_zone_id = '" . (int)$zone_class_id . "'");
      $classes = go_db_fetch_array($classes_query);
      return $classes['geo_zone_name'];
    }
  }
  function go_cfg_pull_down_zone_classes($zone_class_id, $key = '') {
    $name = (($key) ? 'set_it_up[' . $key . ']' : 'set_it_up_value');
    $zone_class_array = array(array('id' => '0', 'text' => TEXT_NONE));
    $zone_class_query = go_db_query("select geo_zone_id, geo_zone_name from " . DB_TBL_GEO_ZONES . " order by geo_zone_name");
    while ($zone_class = go_db_fetch_array($zone_class_query)) {
      $zone_class_array[] = array('id' => $zone_class['geo_zone_id'],
                                  'text' => $zone_class['geo_zone_name']);
    }
    return go_fetch_pull_down_menu($name, $zone_class_array, $zone_class_id);
  }
  function go_cfg_pull_down_order_statuses($order_status_id, $key = '') {
    global $languages_id;
    $name = (($key) ? 'set_it_up[' . $key . ']' : 'set_it_up_value');
    $statuses_array = array(array('id' => '0', 'text' => TEXT_DEFAULT));
    $statuses_query = go_db_query("select orders_status_id, orders_status_name from " . DB_TBL_ORDERS_STATUS . " where language_id = '" . (int)$languages_id . "' order by orders_status_name");
    while ($statuses = go_db_fetch_array($statuses_query)) {
      $statuses_array[] = array('id' => $statuses['orders_status_id'],
                                'text' => $statuses['orders_status_name']);
    }
    return go_fetch_pull_down_menu($name, $statuses_array, $order_status_id);
  }
  function go_get_order_status_name($order_status_id, $language_id = '') {
    global $languages_id;
    if ($order_status_id < 1) return TEXT_DEFAULT;
    if (!is_numeric($language_id)) $language_id = $languages_id;
    $status_query = go_db_query("select orders_status_name from " . DB_TBL_ORDERS_STATUS . " where orders_status_id = '" . (int)$order_status_id . "' and language_id = '" . (int)$language_id . "'");
    $status = go_db_fetch_array($status_query);
    return $status['orders_status_name'];
  }  
  function go_rand($min = null, $max = null) {
    static $seeded;
    if (!$seeded) {
      mt_srand((double)microtime()*1000000);
      $seeded = true;
    }
    if (isset($min) && isset($max)) {
      if ($min >= $max) {
        return $min;
      } else {
        return mt_rand($min, $max);
      }
    } else {
      return mt_rand();
    }
  } 
  function go_convert_linefeeds($from, $to, $string) {
    if ((PHP_VERSION < "4.0.5") && is_array($from)) {
      return preg_replace('(' . implode('|', $from) . ')', $to, $string);
    } else {
      return str_replace($from, $to, $string);
    }
  }
  function go_string_to_int($string) {
    return (int)$string;
  }  
  function go_analysis_category_path($bigPfad) { 
    $bigPfad_array = array_map('go_string_to_int', explode('_', $bigPfad)); 
    $tmp_array = array();
    $n = sizeof($bigPfad_array);
    for ($i=0; $i<$n; $i++) {
      if (!in_array($bigPfad_array[$i], $tmp_array)) {
        $tmp_array[] = $bigPfad_array[$i];
      }
    }
    return $tmp_array;
  }
if (isset($cronjob) && $cronjob != 1){ 
require(FOLDER_ABSOLUT_FORMER . FOLDER_RELATIV_FUNCTIONS . 'func_bigware_4.php'); 
} 
  function go_get_sources_name($source_id, $attendees_id) {
    if ($source_id == '9999') {
      $sources_query = go_db_query("select sources_other_name as sources_name from " . DB_TBL_SOURCES_OTHER . " where attendees_id = '" . (int)$attendees_id . "'");
    } else {
      $sources_query = go_db_query("select sources_name from " . DB_TBL_SOURCES . " where sources_id = '" . (int)$source_id . "'");
    }
    if (!go_db_num_rows($sources_query)) {
      if ($source_id == '9999') {
        return TEXT_OTHER;
      } else {
        return TEXT_NONE;
      }
    } else {
      $sources = go_db_fetch_array($sources_query);
      return $sources['sources_name'];
    }
  }  
function go_reset_cache_data_seo_urls($action){	
	switch ($action){
		case 'reset':
			go_db_query("DELETE FROM cache WHERE cache_name LIKE '%seo_urls%'");
			go_db_query("UPDATE set_it_up SET set_it_up_value='false' WHERE set_it_up_key='SEO_URLS_CACHE_RESET'");
			break;
		default:
			break;
	}
	# The return value is used to set the value upon viewing
	# It's NOT returining a false to indicate failure!!
	return 'false';
}    
  function go_get_attendees_group($default = '') {
    $attendees_group_array = array();
    if ($default) {
      $attendees_group_array[] = array('id' => '',
                                 'text' => $default);
    }
    $attendees_group_query = go_db_query("select attendees_group_id, attendees_group_name from " . DB_TBL_ATTENDEES_GROUPS . " order by attendees_group_name");
    while ($attendees_group = go_db_fetch_array($attendees_group_query)) {
      $attendees_group_array[] = array('id' => $attendees_group['attendees_group_id'],
                                 'text' => $attendees_group['attendees_group_name']);
    }
    return $attendees_group_array;
  }  
  function go_get_payment_unallowed ($pay_check) {
        $payments = go_db_query("select group_payment_unallowed from " . DB_TBL_ATTENDEES_GROUPS . " ");
    $payments_not_allowed = go_db_fetch_array($payments);
      $payments_unallowed = explode (",",$payments_not_allowed['group_payment_unallowed']);
      $clearance = (!in_array ($pay_check, $payments_unallowed)) ?  true : false;
      return $clearance;
      }    
  function go_get_galerie_cat_name($category_id, $language_id) {
    $category_query = go_db_query("select categories_name from " . DB_TBL_GALERIE_CAT_DESCRIPTION . " where categories_id = '" . (int)$category_id . "' and language_id = '" . (int)$language_id . "'");
    $category = go_db_fetch_array($category_query);
    return $category['categories_name'];
  }
 function go_get_galerie_cat_desc($category_id, $language_id) {
    $category_query = go_db_query("select categories_desc from " . DB_TBL_GALERIE_CAT_DESCRIPTION . " where categories_id = '" . (int)$category_id . "' and language_id = '" . (int)$language_id . "'");
    $category = go_db_fetch_array($category_query);
    return $category['categories_desc'];
  }
  function go_get_galerie_cat_tree($parent_id = '0', $spacing = '', $exclude = '', $category_tree_array = '', $include_itself = false) {
    global $languages_id;
    if (!is_array($category_tree_array)) $category_tree_array = array();
    if ( (sizeof($category_tree_array) < 1) && ($exclude != '0') ) $category_tree_array[] = array('id' => '0', 'text' => TEXT_TOP);
    if ($include_itself) {
      $category_query = go_db_query("select cd.categories_name from " . DB_TBL_GALERIE_CAT_DESCRIPTION . " cd where cd.language_id = '" . (int)$languages_id . "' and cd.categories_id = '" . (int)$parent_id . "'");
      $category = go_db_fetch_array($category_query);
      $category_tree_array[] = array('id' => $parent_id, 'text' => $category['categories_name']);
    }
    $categories_query = go_db_query("select c.categories_id, cd.categories_name, c.parent_id from " . DB_TBL_GALERIE_CAT . " c, " . DB_TBL_GALERIE_CAT_DESCRIPTION . " cd where c.categories_id = cd.categories_id and cd.language_id = '" . (int)$languages_id . "' and c.parent_id = '" . (int)$parent_id . "' order by c.sort_order, cd.categories_name");
    while ($categories = go_db_fetch_array($categories_query)) {
      if ($exclude != $categories['categories_id']) $category_tree_array[] = array('id' => $categories['categories_id'], 'text' => $spacing . $categories['categories_name']);
      $category_tree_array = go_get_galerie_cat_tree($categories['categories_id'], $spacing . '&nbsp;&nbsp;&nbsp;', $exclude, $category_tree_array);
    }
    return $category_tree_array;
  } 
  function go_set_galerie_cat_status($category_id, $status) {
    if ($status == '1') {
      go_db_query("update " . DB_TBL_GALERIE_CAT . " set categories_status = '1', last_modified = now() where categories_id = '" . $category_id . "'");
      $tree = go_get_galerie_cat_tree($category_id);
      for ($i=1; $i<sizeof($tree); $i++) {
        go_db_query("update " . DB_TBL_GALERIE_CAT . " set categories_status = '1', last_modified = now() where categories_id = '" . $tree[$i]['id'] . "'");
      }
    } elseif ($status == '0') {
      go_db_query("update " . DB_TBL_GALERIE_CAT . " set categories_status = '0', last_modified = now() where categories_id = '" . $category_id . "'");
      $tree = go_get_galerie_cat_tree($category_id);
      for ($i=1; $i<sizeof($tree); $i++) {
        go_db_query("update " . DB_TBL_GALERIE_CAT . " set categories_status = '0', last_modified = now() where categories_id = '" . $tree[$i]['id'] . "'");
      }
    }
  }
  function go_generate_galerie_cat_path($id, $from = 'category', $categories_array = '', $index = 0) {
    global $languages_id;
    if (!is_array($categories_array)) $categories_array = array();
    if ($from == 'galerie') {
      $categories_query = go_db_query("select categories_id from " . DB_TBL_GALERIE_TO_CATEGORIES . " where galeries_id = '" . (int)$id . "'");
      while ($categories = go_db_fetch_array($categories_query)) {
        if ($categories['categories_id'] == '0') {
          $categories_array[$index][] = array('id' => '0', 'text' => TEXT_TOP);
        } else {
          $category_query = go_db_query("select cd.categories_name, c.parent_id from " . DB_TBL_GALERIE_CAT . " c, " . DB_TBL_GALERIE_CAT_DESCRIPTION . " cd where c.categories_id = '" . (int)$categories['categories_id'] . "' and c.categories_id = cd.categories_id and cd.language_id = '" . (int)$languages_id . "'");
          $category = go_db_fetch_array($category_query);
          $categories_array[$index][] = array('id' => $categories['categories_id'], 'text' => $category['categories_name']);
          if ( (go_not_null($category['parent_id'])) && ($category['parent_id'] != '0') ) $categories_array = go_generate_galerie_cat_path($category['parent_id'], 'category', $categories_array, $index);
          $categories_array[$index] = array_reverse($categories_array[$index]);
        }
        $index++;
      }
    } elseif ($from == 'category') {
      $category_query = go_db_query("select cd.categories_name, c.parent_id from " . DB_TBL_GALERIE_CAT . " c, " . DB_TBL_GALERIE_CAT_DESCRIPTION . " cd where c.categories_id = '" . (int)$id . "' and c.categories_id = cd.categories_id and cd.language_id = '" . (int)$languages_id . "'");
      $category = go_db_fetch_array($category_query);
      $categories_array[$index][] = array('id' => $id, 'text' => $category['categories_name']);
      if ( (go_not_null($category['parent_id'])) && ($category['parent_id'] != '0') ) $categories_array = go_generate_galerie_cat_path($category['parent_id'], 'category', $categories_array, $index);
    }
    return $categories_array;
  }
  function go_output_generated_galerie_cat_path($id, $from = 'category') {
    $calculated_category_path_string = '';
    $calculated_category_path = go_generate_galerie_cat_path($id, $from);
    for ($i=0, $n=sizeof($calculated_category_path); $i<$n; $i++) {
      for ($j=0, $k=sizeof($calculated_category_path[$i]); $j<$k; $j++) {
        $calculated_category_path_string .= $calculated_category_path[$i][$j]['text'] . '&nbsp;&gt;&nbsp;';
      }
      $calculated_category_path_string = substr($calculated_category_path_string, 0, -16) . '<br>';
    }
    $calculated_category_path_string = substr($calculated_category_path_string, 0, -4);
    if (strlen($calculated_category_path_string) < 1) $calculated_category_path_string = TEXT_TOP;
    return $calculated_category_path_string;
  }
  function go_get_generated_galerie_cat_path_ids($id, $from = 'category') {
    $calculated_category_path_string = '';
    $calculated_category_path = go_generate_galerie_cat_path($id, $from);
    for ($i=0, $n=sizeof($calculated_category_path); $i<$n; $i++) {
      for ($j=0, $k=sizeof($calculated_category_path[$i]); $j<$k; $j++) {
        $calculated_category_path_string .= $calculated_category_path[$i][$j]['id'] . '_';
      }
      $calculated_category_path_string = substr($calculated_category_path_string, 0, -1) . '<br>';
    }
    $calculated_category_path_string = substr($calculated_category_path_string, 0, -4);
    if (strlen($calculated_category_path_string) < 1) $calculated_category_path_string = TEXT_TOP;
    return $calculated_category_path_string;
  }
  function go_remove_galerie_cat($category_id) {
    $category_picture_query = go_db_query("select categories_picture from " . DB_TBL_GALERIE_CAT . " where categories_id = '" . (int)$category_id . "'");
    $category_picture = go_db_fetch_array($category_picture_query);
    $duplicate_picture_query = go_db_query("select count(*) as total from " . DB_TBL_GALERIE_CAT . " where categories_picture = '" . go_db_input($category_picture['categories_picture']) . "'");
    $duplicate_picture = go_db_fetch_array($duplicate_picture_query);
    if ($duplicate_picture['total'] < 2) {
      if (file_exists(FOLDER_ABSOLUT_CATALOG_PICTURES . $category_picture['categories_picture'])) {
        @unlink(FOLDER_ABSOLUT_CATALOG_PICTURES . $category_picture['categories_picture']);
      }
    }
    go_db_query("delete from " . DB_TBL_GALERIE_CAT . " where categories_id = '" . (int)$category_id . "'");
    go_db_query("delete from " . DB_TBL_GALERIE_CAT_DESCRIPTION . " where categories_id = '" . (int)$category_id . "'");
    go_db_query("delete from " . DB_TBL_GALERIE_TO_CATEGORIES . " where categories_id = '" . (int)$category_id . "'");
    if (USE_CACHE == 'true') {
      go_reset_cache_block('categories');
      go_reset_cache_block('also_purchased');
    }
  }
  
  
  function go_remove_galerie_cat_api($category_id) {
  }
  function go_get_galerie_name($galerie_id, $language_id = 0) {
    global $languages_id;
    if ($language_id == 0) $language_id = $languages_id;
    $galerie_query = go_db_query("select galeries_name from " . DB_TBL_GALERIE_DESCRIPTION . " where galeries_id = '" . (int)$galerie_id . "' and language_id = '" . (int)$language_id . "'");
    $galerie = go_db_fetch_array($galerie_query);
    return $galerie['galeries_name'];
  }
  function go_get_galerie_name2($galerie_id, $language_id = 0) {
    global $languages_id;
    if ($language_id == 0) $language_id = $languages_id;
    $galerie_query = go_db_query("select galeries_name2 from " . DB_TBL_GALERIE_DESCRIPTION . " where galeries_id = '" . (int)$galerie_id . "' and language_id = '" . (int)$language_id . "'");
    $galerie = go_db_fetch_array($galerie_query);
    return $galerie['galeries_name2'];
  }
  function go_get_galerie_info1($galerie_id, $language_id = 0) {
    global $languages_id;
    if ($language_id == 0) $language_id = $languages_id;
    $galerie_query = go_db_query("select galeries_info1 from " . DB_TBL_GALERIE_DESCRIPTION . " where galeries_id = '" . (int)$galerie_id . "' and language_id = '" . (int)$language_id . "'");
    $galerie = go_db_fetch_array($galerie_query);
    return $galerie['galeries_info1'];
  }
  function go_get_galerie_info2($galerie_id, $language_id = 0) {
    global $languages_id;
    if ($language_id == 0) $language_id = $languages_id;
    $galerie_query = go_db_query("select galeries_info2 from " . DB_TBL_GALERIE_DESCRIPTION . " where galeries_id = '" . (int)$galerie_id . "' and language_id = '" . (int)$language_id . "'");
    $galerie = go_db_fetch_array($galerie_query);
    return $galerie['galeries_info2'];
  }
  function go_get_galerie_info3($galerie_id, $language_id = 0) {
    global $languages_id;
    if ($language_id == 0) $language_id = $languages_id;
    $galerie_query = go_db_query("select galeries_info3 from " . DB_TBL_GALERIE_DESCRIPTION . " where galeries_id = '" . (int)$galerie_id . "' and language_id = '" . (int)$language_id . "'");
    $galerie = go_db_fetch_array($galerie_query);
    return $galerie['galeries_info3'];
  }
  function go_get_galerie_info4($galerie_id, $language_id = 0) {
    global $languages_id;
    if ($language_id == 0) $language_id = $languages_id;
    $galerie_query = go_db_query("select galeries_info4 from " . DB_TBL_GALERIE_DESCRIPTION . " where galeries_id = '" . (int)$galerie_id . "' and language_id = '" . (int)$language_id . "'");
    $galerie = go_db_fetch_array($galerie_query);
    return $galerie['galeries_info4'];
  }
  function go_get_galerie_description($galerie_id, $language_id) {
    $galerie_query = go_db_query("select galeries_description from " . DB_TBL_GALERIE_DESCRIPTION . " where galeries_id = '" . (int)$galerie_id . "' and language_id = '" . (int)$language_id . "'");
    $galerie = go_db_fetch_array($galerie_query);
    return $galerie['galeries_description'];
  } 
  function go_set_galerie_status($galeries_id, $status) {
    if ($status == '1') {
      return go_db_query("update " . DB_TBL_GALERIE . " set galeries_status = '1', galeries_last_modified = now() where galeries_id = '" . (int)$galeries_id . "'");
    } elseif ($status == '0') {
      return go_db_query("update " . DB_TBL_GALERIE . " set galeries_status = '0', galeries_last_modified = now() where galeries_id = '" . (int)$galeries_id . "'");
    } else {
      return -1;
    }
  }
  
    function go_remove_galerie($galerie_id) {
    $galerie_picture_query = go_db_query("select pictures from " . DB_TBL_GALERIE_TO_PICTURES . " where galeries_id = '" . (int)$galerie_id . "'");
    while ($galerie_picture = go_db_fetch_array($galerie_picture_query)) {
	    $duplicate_picture_query = go_db_query("select count(*) as total from " . DB_TBL_GALERIE_TO_PICTURES . " where pictures = '" . go_db_input($galerie_picture['pictures']) . "' AND galeries_id != '" . (int)$galerie_id . "'");
	    $duplicate_picture = go_db_fetch_array($duplicate_picture_query);
	
	    if ($duplicate_picture['total'] < 1) {
	      if (file_exists(FOLDER_ABSOLUT_CATALOG_PICTURES . $galerie_picture['pictures'])) {
	        @unlink(FOLDER_ABSOLUT_CATALOG_PICTURES . $galerie_picture['pictures']);
	      }
	    }
     }
    go_db_query("delete from " . DB_TBL_GALERIE . " where galeries_id = '" . (int)$galerie_id . "'");
    go_db_query("delete from " . DB_TBL_GALERIE_TO_CATEGORIES . " where galeries_id = '" . (int)$galerie_id . "'");
    go_db_query("delete from " . DB_TBL_GALERIE_DESCRIPTION . " where galeries_id = '" . (int)$galerie_id . "'");
    go_db_query("delete from " . DB_TBL_GALERIE_TO_PICTURES . " where galeries_id = '" . (int)$galerie_id . "'");
    go_db_query("delete from " . DB_TBL_GALERIE_TO_TEMPLATE . " where galeries_id = '" . (int)$galerie_id . "'");
    if (USE_CACHE == 'true') {
      go_reset_cache_block('categories');
      go_reset_cache_block('also_purchased');
    }
  }   
  function go_galeries_in_category_count($categories_id, $include_deactivated = false) {
    $galeries_count = 0;
    if ($include_deactivated) {
      $galeries_query = go_db_query("select count(*) as total from " . DB_TBL_GALERIE . " p, " . DB_TBL_GALERIE_TO_CATEGORIES . " p2c where p.galeries_id = p2c.galeries_id and p2c.categories_id = '" . (int)$categories_id . "'");
    } else {
      $galeries_query = go_db_query("select count(*) as total from " . DB_TBL_GALERIE . " p, " . DB_TBL_GALERIE_TO_CATEGORIES . " p2c where p.galeries_id = p2c.galeries_id and p.galeries_status = '1' and p2c.categories_id = '" . (int)$categories_id . "'");
    }
    $galeries = go_db_fetch_array($galeries_query);
    $galeries_count += $galeries['total'];
    $childs_query = go_db_query("select categories_id from " . DB_TBL_GALERIE_CAT . " where parent_id = '" . (int)$categories_id . "'");
    if (go_db_num_rows($childs_query)) {
      while ($childs = go_db_fetch_array($childs_query)) {
        $galeries_count += go_galeries_in_category_count($childs['categories_id'], $include_deactivated);
      }
    }
    return $galeries_count;
  }
  function go_get_galeries_url($galerie_id, $language_id) {
    $galerie_query = go_db_query("select galeries_url from " . DB_TBL_GALERIE_DESCRIPTION . " where galeries_id = '" . (int)$galerie_id . "' and language_id = '" . (int)$language_id . "'");
    $galerie = go_db_fetch_array($galerie_query);
    return $galerie['galeries_url'];
  }
 function constants_language($cfgValue){
 	
 switch ($cfgValue) {
  case 'ja':
	$constants_language_return = isohtmlspecialchars(DB_LANG_OTHER_TRUE);
 break;
 case 'nein':
	$constants_language_return = isohtmlspecialchars(DB_LANG_OTHER_FALSE);
 break;	
  case 'Ja':
	$constants_language_return = isohtmlspecialchars(DB_LANG_OTHER_TRUE);
 break;
 case 'Nein':
	$constants_language_return = isohtmlspecialchars(DB_LANG_OTHER_FALSE);
 break;		
 case 'true':
	$constants_language_return = isohtmlspecialchars(DB_LANG_OTHER_TRUE);
 break;
 case 'True':
	$constants_language_return = isohtmlspecialchars(DB_LANG_OTHER_TRUE);
 break;
 case 'false':
	$constants_language_return = isohtmlspecialchars(DB_LANG_OTHER_FALSE);
 break;
 case 'False':
	$constants_language_return = isohtmlspecialchars(DB_LANG_OTHER_FALSE);
 break;
 case 'and':
	$constants_language_return = isohtmlspecialchars(DB_LANG_OTHER_AND);
 break;
 case 'or':
	$constants_language_return = isohtmlspecialchars(DB_LANG_OTHER_OR);
 break;
 case 'asc':
	$constants_language_return = isohtmlspecialchars(DB_LANG_OTHER_ASC);
 break;
 case 'desc':
	$constants_language_return = isohtmlspecialchars(DB_LANG_OTHER_DESC);
 break;
 case 'items_name':
	$constants_language_return = isohtmlspecialchars(DB_LANG_OTHER_ITEMS_NAME);
 break;
 case 'date_expected':
	$constants_language_return = isohtmlspecialchars(DB_LANG_OTHER_DATE_EXPECTED);
 break;
 case 'english':
	$constants_language_return = isohtmlspecialchars(DB_LANG_OTHER_EN_S);
 break;
 case 'german':
	$constants_language_return = isohtmlspecialchars(DB_LANG_OTHER_DE_S);
 break;
 case 'browser':
	$constants_language_return = isohtmlspecialchars(DB_LANG_OTHER_BROWSER);
 break;
 case 'weight':
	$constants_language_return = isohtmlspecialchars(DB_LANG_OTHER_PRICE);
 break;
 case 'price':
	$constants_language_return = isohtmlspecialchars(DB_LANG_OTHER_WEIGHT);
 break;
 case 'links': 
	$constants_language_return = isohtmlspecialchars(DB_LANG_OTHER_LINKS);
 break;
 case 'rechts':
	$constants_language_return = isohtmlspecialchars(DB_LANG_OTHER_RECHTS);
 break;
 case 'mitte':
	$constants_language_return = isohtmlspecialchars(DB_LANG_OTHER_MITTE);
 break;
 case 'nur Datum':
	$constants_language_return = isohtmlspecialchars(DB_LANG_OTHER_ONLY_DATE);
 break;
 case 'Datum und Uhrzeit':
	$constants_language_return = isohtmlspecialchars(DB_LANG_OTHER_DATE_AND_OURE);
 break;
 case 'reset':
	$constants_language_return = isohtmlspecialchars(DB_LANG_OTHER_RESET);
 break;
 case 'cName':
	$constants_language_return = isohtmlspecialchars(DB_LANG_OTHER_CNAME);
 break;
 case 'Rewrite':
	$constants_language_return = isohtmlspecialchars(DB_LANG_OTHER_REWRITE);
 break;
 case 'national':
	$constants_language_return = isohtmlspecialchars(DB_LANG_OTHER_NATIONAL);
 break;
 case 'international':
	$constants_language_return = isohtmlspecialchars(DB_LANG_OTHER_INTERNATIONAL);
 break;
 case 'both':
	$constants_language_return = isohtmlspecialchars(DB_LANG_OTHER_IBOTH);
 break;
 default:
	$constants_language_return = isohtmlspecialchars($cfgValue);
 break;
 }
 return $constants_language_return;
 
}
function cut_to_long_string($word_or_string = '', $origi_text = '', $count_max_allow = ''){
	$text=$origi_text;
	// z�hlen
	$count_all= strlen($text);
	// k�rzen ohne ein Wort abzuschneiden, aber nur wenn zu lang.
	if($count_all > $count_max_allow) {
		if ($word_or_string == 'string'){
			$text = substr($text, 0, $count_max_allow); // # schneidet sofort ab.
		}elseif($word_or_string == 'word'){
			$text = preg_replace("/[^ ]*$/", '', substr($text, 0, $count_max_allow)); # schneidet erst nach dem Wort ab.
		}else{
			$text = substr($text, 0, $count_max_allow); // # schneidet sofort ab.
		}
		return $text . '[...]';
	}
	else {
		return $origi_text;
	}
}
  function go_has_category_subcategories($category_id) {
    $child_category_query = go_db_query("select count(*) as count from " . DB_TBL_CATEGORIES . " where parent_id = '" . (int)$category_id . "'");
    $child_category = go_db_fetch_array($child_category_query);
    if ($child_category['count'] > 0) {
      return true;
    } else {
      return false;
    }
  }  
  
  
////////////////////////////////////////////////////////////
///////// Pr�ft ob der Link existiert /////////////////////
// Gibt den Status-Code zur�ck (z.B. 200 = existiert oder 404 = nicht vorhanden)
// siehe print_r($return["Status-Code"])
// $max_sec = wie lange soll auf die Anfrage gewartet werden (sec)

function link_exists($url, $max_sec = '5', $r = FALSE){

  $url = trim($url);
  if (!preg_match("=://=", $url)) $url = "http://$url";
  $url = parse_url($url);
  if (strtolower($url["scheme"]) != "http") return FALSE;

  if (!isset($url["port"])) $url["port"] = 80;
  if (!isset($url["path"])) $url["path"] = "/";

  $fp = @fsockopen($url["host"], $url["port"], $errno, $errstr, $max_sec);
 
  if (!$fp) return FALSE;
  else
  {
    $head = "";
    $httpRequest = "HEAD ". $url["path"] ." HTTP/1.1\r\n"
                  ."Host: ". $url["host"] ."\r\n"
                  ."Connection: close\r\n\r\n";
    fputs($fp, $httpRequest); 
		while (!feof($fp) && $line = trim(fgets($fp, 200))) {
			// Achtung: kein fgets oder fread innerhalb der schleife benutzen.
			// Das geht zwar, ist aber viel zu langsam

            if ($line == "\r\n") break;
            if (preg_match('/:/',$line) == 1) list($key, $val) = explode(': ', $line, 2);
            if (isset($format) && $format)
                if ($val) $headers[$key] = $val;
                else $headers[] = $key;
            else $headers[] = $line;
		}     
    fclose($fp); 




    preg_match("=^(HTTP/\d+\.\d+) (\d{3}) ([^\r\n]*)=", $headers[0], $matches);
    $http["Status-Line"] = $matches[0];
    $http["HTTP-Version"] = $matches[1];
    $http["Status-Code"] = $matches[2];
    $http["Reason-Phrase"] = $matches[3];

    if ($r) return $http["Status-Code"];

    $rclass = array("Informational", "Success",
                    "Redirection", "Client Error",
                    "Server Error");
    $http["Response-Class"] = $rclass[$http["Status-Code"][0] - 1];

    preg_match_all("=^(.+): ([^\r\n]*)=m", $head, $matches, PREG_SET_ORDER);
    foreach($matches as $line) $http[$line[1]] = $line[2];

    if ($http["Status-Code"][0] == 3)
      $http["Location-Status-Code"] = link_exists($http["Location"], TRUE);

    return $http;
  }
}
////////////////////////////////////////////////////////////////////////////////


////////////////////// Pr�ft ob eine Seite Online ist //////////////////////////
//
// Pr�ft ob die Seite Online ist (http://www.irgendwas.de/seite.html)
// $url = komplette url, auch den query
// $max_sec = wie lange soll gewartet werden bei der Anfrage (sec). Bei �berschreitung: false
// R�ckgabewert = false oder true 
//
// ACHTUNG: Diese Funktion ben�tigt die Funktion "link_exists()"
//

function isSiteOnline($url, $max_sec = '5') {
	$link_exists = link_exists($url, $max_sec);
	if ($link_exists["Status-Code"] == '200'){
		return 1;
	}else{
		return 0;
	}
}  
  
  
  
?>
