<?php
/*
  ###################################################################################
  Bigware Shop 2.3
  Release Datum: 01.01.2007

  Bigware Shop
  http://www.bigware.de

  Copyright (c) 2015 Bigware LTD
  (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
  (c) 2015	Bigware LTD

  Copyrightvermerke duerfen nicht entfernt werden.
  ------------------------------------------------------------------------
  Dieses Programm ist freie Software. Sie koennen es unter den Bedingungen
  der GNU General Public License, wie von der Free Software Foundation
  veroeffentlicht, weitergeben und/oder modifizieren, entweder gemaess Version 2
  der Lizenz oder (nach Ihrer Option) jeder spaeteren Version.
  Die Veroeffentlichung dieses Programms erfolgt in der Hoffnung, dass es Ihnen
  von Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE, sogar ohne die
  implizite Garantie der MARKTREIFE oder der VERWENDBARKEIT FUER EINEN
  BESTIMMTEN ZWECK. Details finden Sie in der GNU General Public License.

  Sie sollten eine Kopie der GNU General Public License zusammen mit diesem
  Programm erhalten haben. Falls nicht, schreiben Sie an die Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.

  Infos:
  ------------------------------------------------------------------------
  Der Bigware Shop wurde vor vielen Jahren bereits aus dem bekannten Shopsystem osCommerce
  weiter- und neuentwickelt.
  Der Bigware Shop legt im hohen Masse Wert auf Bedienerfreundlichkeit, beinhaltet eine leichte
  Installation, viele neue professionelle Werkzeuge und zeichnet sich aus durch eine gro�e
  Community, die bei Problemen weiterhelfen kann.

  Der Bigware Shop ist auf jedem System lauffaehig, welches eine PHP Umgebung
  (ab PHP 4.1.3) und mySQL zur Verfuegung stellt und auf Linux basiert.

  Hilfe erhalten Sie im Forum auf www.bigware.de

  -----------------------------------------------------------------------

  ##################################################################################




 */


/* * ************* BEGIN MASTER SETTINGS ***************** */
global $db_link;

require_once('load_this/load_bigware_11.php');

$query = mysqli_query($db_link, "SELECT * FROM preisportale WHERE id = '1'");
$werte = mysqli_fetch_array($query);

define('CONVERT_CURRENCY', '0'); // set to 0 to disable - only needed if a feed in a difference currecny is required
define('OPTIONS_ENABLED', 1);
define('OPTIONS_ENABLED_AGE_RANGE', 0);
define('OPTIONS_ENABLED_BRAND', 0);
define('OPTIONS_ENABLED_CONDITION', 1);
define('OPTIONS_ENABLED_CURRENCY', 0);
define('OPTIONS_ENABLED_FEED_LANGUAGE', 0);
define('OPTIONS_ENABLED_FEED_MANUFACTURE_ID', 1);
define('OPTIONS_ENABLED_FEED_QUANTITY', 0);
define('OPTIONS_ENABLED_MADE_IN', 0);
define('OPTIONS_ENABLED_MANUFACTURER', 1);
define('OPTIONS_ENABLED_PAYMENT_ACCEPTED', 0);
define('OPTIONS_ENABLED_PRODUCT_TYPE', 0);
define('OPTIONS_ENABLED_SHIPPING', 0);
define('OPTIONS_ENABLED_UPC', 1);
define('OPTIONS_ENABLED_WEIGHT', 0);
define('OPTIONS_DEFAULT_PICTURE', 'alle/no_picture.gif');

//the following only matter if the matching option is enabled above.
define('OPTIONS_AGE_RANGE', '0-9');
define('OPTIONS_BRAND', '');
define('OPTIONS_CONDITION', 'neu');  //possible entries are New, Refurbished, Used
define('OPTIONS_DEFAULT_CURRENCY', 'EUR');
define('OPTIONS_DEFAULT_FEED_LANGUAGE', 'de');
define('OPTIONS_LOWEST_SHIPPING', 'DE:::3.90'); // If 'OPTIONS_ENABLED_SHIPPING' is 1, then here you can define the shipping value. For example 'DE:::3.90'.
define('OPTIONS_MADE_IN', 'Germany');
define('OPTIONS_PAYMENT_ACCEPTED_METHODS', ''); //Acceptable values: cash, check, GoogleCheckout, Visa, MasterCard, AmericanExpress, Discover, wiretransfer
define('OPTIONS_WEIGHT_ACCEPTED_METHODS', 'lb'); //Valid units include lb, pound, oz, ounce, g, gram, kg, kilogram.
$begin_to_show_price = '1000.0000'; // Ab welchen nettowarenwert sollen Artikel angezeigt werden
/* * ************* END MASTER SETTINGS ***************** */

/* * ************* NO EDITS NEEDED BELOW THIS LINE **************** */

function short_name($str, $limit = 3) {
    if (defined('SEO_URLS_FILTER_SHORT_WORDS'))
        $limit = SEO_URLS_FILTER_SHORT_WORDS;
    $foo = explode('-', $str);
    foreach ($foo as $index => $value) {
        switch (true) {
            case ( strlen($value) <= $limit ):
                continue;
            default:
                $container[] = $value;
                break;
        }
    } # end foreach
    $container = ( sizeof($container) > 1 ? implode('-', $container) : $str );
    return $container;
}

function strip($convert_me) {
    $strip_array = array("&#39", chr(33), chr(34), chr(35), chr(36), chr(37), chr(38), chr(39), chr(40), chr(41), chr(42), chr(43), chr(44), chr(45), chr(46), chr(47), chr(58), chr(59), chr(60), chr(61), chr(62), chr(63), chr(91), chr(92), chr(93), chr(94), chr(95), chr(96), chr(123), chr(124), chr(125), chr(126));
    $convert_me = str_replace($strip_array, '', $convert_me);
    $convert_me = str_replace(array(' ', '  ', '__', '--'), '-', $convert_me);
    $convert_me = strtolower($convert_me);
    return $convert_me;
}

function display_price($items_price, $tax_id, $quantity = 1) {
    $currencies_query = go_db_query("select code, title, symbol_left, symbol_right, decimal_point, thousands_point, decimal_places, value from " . DB_TBL_CURRENCIES . " where code='" . DEFAULT_CURRENCY . "'");
    $currencies = go_db_fetch_array($currencies_query);

    if (SHOW_PRICE_WITH_TAX == 'true') {
        $items_price = go_round($items_price, '2') + go_round($items_price * go_get_tax_rate($tax_id) / 100, '2');
    } else {
        $items_price = go_round($items_price, '2');
    }

    $format_string = go_round($items_price * $quantity * $currencies['value'], 2);
    return $format_string;
}

//********************
//  Start TIMER
//  -----------
$stimer = explode(' ', microtime());
$stimer = $stimer[1] + $stimer[0];

$cat = (defined('FOLDER_RELATIV_HTTP_CATALOG')) ? FOLDER_RELATIV_HTTP_CATALOG : FOLDER_RELATIV_CATALOG;
$server = HTTP_SERVER;
$imagepath = HTTP_SERVER . $cat . FOLDER_RELATIV_PICTURES;
$onlypage = HTTP_SERVER . $cat . 'main_bigware_34.php';
$detailpage = HTTP_SERVER . $cat . 'main_bigware_34.php' . "?items_id=";

$OutFile = "feeds/" . $werte["google_feedname"];
$destination_file = $werte["google_feedname"];
$source_file = $OutFile;
$imageURL = $imagepath;
if (SEO_URLS == 'true' AND SEO_URLS_TYPE == 'Rewrite') {
    $productURL = HTTP_SERVER . $cat; // ***** Revised for SEO
} else {
    $productURL = $detailpage;
}

$already_sent = array();

if (CONVERT_CURRENCY) {
    $productURL = $onlypage . "?currency=" . $werte["google_currency_type"] . "&items_id=";  //where $werte["google_currency_type"] is your currency type (eg. USD, EUR, GBP)
}

$feed_exp_date = date('Y-m-d', time() + 2592000);

if (!($link = mysqli_connect(DB_SERVER, DB_SERVER_USERNAME, DB_SERVER_PASSWORD))) {
    echo "Error when connecting itself to the data base";
    exit();
}
if (!mysqli_select_db(DB_DATABASE, $link)) {
    echo "Error the data base does not exist";
    exit();
}

$db_link = $link;

$sql = "
    SELECT concat( '" . $productURL . "' ," . DB_TBL_ITEMS . ".items_id) AS product_url,
        herstellernummer AS prodModel,
        " . DB_TBL_PRODUCERS . ".producers_name AS mfgName,
        " . DB_TBL_PRODUCERS . ".producers_id,
        " . DB_TBL_ITEMS . ".items_id AS id,
        " . DB_TBL_ITEMS_DESCRIPTION . ".items_name AS name,
        " . DB_TBL_ITEMS_DESCRIPTION . ".items_description AS description,
        " . DB_TBL_ITEMS . ".items_quantity AS quantity,
        " . DB_TBL_ITEMS . ".items_status AS prodStatus,
        " . DB_TBL_ITEMS . ".items_weight AS prodWeight,
        " . DB_TBL_ITEMS . ".items_tax_class_id AS tax_id,
        " . DB_TBL_ITEMS . ".upc_ean_isbn AS upc_ean_isbn,
        " . DB_TBL_ITEMS . ".items_price AS price,
        " . DB_TBL_SPECIALS . ".specials_new_items_price AS sale_price,
        " . DB_TBL_SPECIALS . ".specials_date_added AS sale_begin,
        " . DB_TBL_SPECIALS . ".expires_date AS sale_end,
        " . DB_TBL_SPECIALS . ".status AS sale_status,
        " . DB_TBL_ITEMS . ".items_picture AS image_url,
        " . DB_TBL_ITEMS_TO_CATEGORIES . ".categories_id AS prodCatID,
        " . DB_TBL_CATEGORIES . ".parent_id AS catParentID,
        " . DB_TBL_CATEGORIES_DESCRIPTION . ".categories_name AS catName
        FROM (" . DB_TBL_CATEGORIES . ",
            " . DB_TBL_CATEGORIES_DESCRIPTION . ",
            " . DB_TBL_ITEMS . ",
            " . DB_TBL_ITEMS_DESCRIPTION . ",
            " . DB_TBL_ITEMS_TO_CATEGORIES . ")

            left join " . DB_TBL_PRODUCERS . " on ( " . DB_TBL_PRODUCERS . ".producers_id = " . DB_TBL_ITEMS . ".producers_id )
            left join " . DB_TBL_SPECIALS . " on ( " . DB_TBL_SPECIALS . ".items_id = " . DB_TBL_ITEMS . ".items_id AND ( ( (" . DB_TBL_SPECIALS . ".expires_date > CURRENT_DATE) OR (" . DB_TBL_SPECIALS . ".expires_date is NULL) OR (" . DB_TBL_SPECIALS . ".expires_date = 0) ) AND ( " . DB_TBL_SPECIALS . ".status = 1 ) ) )

            WHERE " . DB_TBL_ITEMS . ".items_id = " . DB_TBL_ITEMS_DESCRIPTION . ".items_id
            AND " . DB_TBL_ITEMS_DESCRIPTION . ".language_id = '" . $werte["google_default_language"] . "'
            AND " . DB_TBL_ITEMS . ".items_id = " . DB_TBL_ITEMS_TO_CATEGORIES . ".items_id
            AND " . DB_TBL_ITEMS_TO_CATEGORIES . ".categories_id = " . DB_TBL_CATEGORIES . ".categories_id
            AND " . DB_TBL_CATEGORIES . ".categories_id = " . DB_TBL_CATEGORIES_DESCRIPTION . ".categories_id
            AND " . DB_TBL_CATEGORIES_DESCRIPTION . ".language_id = '" . $werte["google_default_language"] . "'
            ORDER BY " . DB_TBL_ITEMS . ".items_id ASC ";

$catInfo = "
    SELECT
    " . DB_TBL_CATEGORIES . ".categories_id AS curCatID,
    " . DB_TBL_CATEGORIES . ".parent_id AS parentCatID,
    " . DB_TBL_CATEGORIES_DESCRIPTION . ".categories_name AS catName
    FROM
    " . DB_TBL_CATEGORIES . ",
    " . DB_TBL_CATEGORIES_DESCRIPTION . "
    WHERE " . DB_TBL_CATEGORIES . ".categories_id = " . DB_TBL_CATEGORIES_DESCRIPTION . ".categories_id
    AND " . DB_TBL_CATEGORIES_DESCRIPTION . ".language_id = '" . $werte["google_default_language"] . "'
    ";

function findCat($curID, $catTempPar, $catTempDes, $catIndex) {
    if ((isset($catTempPar[$curID])) && ($catTempPar[$curID] != 0)) {
        if (isset($catIndex[$catTempPar[$curID]])) {
            $temp = $catIndex[$catTempPar[$curID]];
        } else {
            $catIndex = findCat($catTempPar[$curID], $catTempPar, $catTempDes, $catIndex);
            $temp = $catIndex[$catTempPar[$curID]];
        }
    }
    if ((isset($catTempPar[$curID])) && (isset($catTempDes[$curID])) && ($catTempPar[$curID] == 0)) {
        $catIndex[$curID] = $catTempDes[$curID];
    } else {
        $catIndex[$curID] = $temp . ", " . $catTempDes[$curID];
    }
    return $catIndex;
}

$catIndex = array();
$catTempDes = array();
$catTempPar = array();
$processCat = mysqli_query($db_link, $catInfo)or die($FunctionName . ": SQL error " . mysqli_error($db_link) . "| catInfo = " . htmlentities($catInfo));
while ($catRow = mysqli_fetch_object($processCat)) {
    $catKey = $catRow->curCatID;
    $catName = $catRow->catName;
    $catParID = $catRow->parentCatID;
    if ($catName != "") {
        $catTempDes[$catKey] = $catName;
        $catTempPar[$catKey] = $catParID;
    }
}

foreach ($catTempDes as $curID => $des) {
    $catIndex = findCat($curID, $catTempPar, $catTempDes, $catIndex);
}

$_strip_search = array(
    "![\t ]+$|^[\t ]+!m", // remove leading/trailing space chars
    '%[\r\n]+%m'); // remove CRs and newlines
$_strip_replace = array('', ' ');
$_cleaner_array = array("<br>� <br>� " => " � ", ">" => "> ", "&reg;" => "", "�" => "", "&trade;" => "", "�" => "", "\t" => "", "	" => "");

if (file_exists($OutFile))
    unlink($OutFile);

$output = "link\ttitel\tbeschreibung\tverfallsdatum\tpreis\tbild_url\tid\tSonderangebotspreis\tSonderangebotszeitraum";

//create optional section
if (OPTIONS_ENABLED == 1) {
    if (OPTIONS_ENABLED_AGE_RANGE == 1)
        $output .= "\tage_range";
    if (OPTIONS_ENABLED_BRAND == 1)
        $output .= "\tbrand";
    if (OPTIONS_ENABLED_CONDITION == 1)
        $output .= "\tzustand";
    if (OPTIONS_ENABLED_CURRENCY == 1)
        $output .= "\tcurrency";
    if (OPTIONS_ENABLED_FEED_LANGUAGE == 1)
        $output .= "\tlanguage";
    if (OPTIONS_ENABLED_FEED_MANUFACTURER_ID == 0)
        $output .= "\tmpn";
    if (OPTIONS_ENABLED_FEED_QUANTITY == 0)
        $output .= "\tverf�gbarkeit";
    if (OPTIONS_ENABLED_MADE_IN == 1)
        $output .= "\tmade_in";
    if (OPTIONS_ENABLED_MANUFACTURER == 0)
        $output .= "\tmanufacturer";
    if (OPTIONS_ENABLED_PAYMENT_ACCEPTED == 1)
        $output .= "\tpayment_accepted";
    if (OPTIONS_ENABLED_PRODUCT_TYPE == 1)
        $output .= "\tproduct_type";
    if (OPTIONS_ENABLED_SHIPPING == 1)
        $output .= "\tversand";
    if (OPTIONS_ENABLED_UPC == 1)
        $output .= "\tean";
    $output .= "\tKennzeichnung existiert";
    if (OPTIONS_ENABLED_WEIGHT == 1)
        $output .= "\tweight";
}
$output .= "\n";

$result = mysqli_query($db_link, $sql) or die($FunctionName . ": SQL error " . mysqli_error($db_link) . "| sql = " . htmlentities($sql));

//Currency Information
if (CONVERT_CURRENCY) {
    $sql3 = "
        SELECT
        " . DB_TBL_CURRENCIES . ".value AS curUSD
        FROM
        " . DB_TBL_CURRENCIES . "
        WHERE " . DB_TBL_CURRENCIES . ".code = '" . $werte["google_currency_type"] . "'";

    $result3 = mysqli_query($db_link, $sql3)or die($FunctionName . ": SQL error " . mysqli_error($db_link) . "| sql3 = " . htmlentities($sql3));
    $row3 = mysqli_fetch_object($result3);
}

$loop_counter = 0;
while ($row = mysqli_fetch_object($result)) {

    if (isset($already_sent[$row->id]))
        continue; // if we've sent this one, skip the rest of the while loop

    if ($row->prodStatus == 1 || (OPTIONS_ENABLED == 1 && $quantity == 1)) {
        if (CONVERT_CURRENCY) {
            $row->price = $row->price * $row3->curUSD;
        }

        $description = html_entity_decode($row->description, ENT_QUOTES, 'ISO-8859-1');
        $description = strip_tags($description);
        $description = preg_replace('/;/', '', $description);
        $description = preg_replace('/&nbsp/', ' ', $description);
        $description = preg_replace('/&lt/', '<', $description);
        $description = preg_replace('/&gt/', '>', $description);
        $description = preg_replace('/&amp/', '&', $description);
        $description = preg_replace('/&percnt/', '%', $description);
        $description = preg_replace('/&cent/', '�', $description);
        $description = preg_replace('/&dollar/', '$', $description);
        $description = preg_replace('/&pound/', '�', $description);
        $description = preg_replace('/&yen/', '�', $description);
        $description = preg_replace('/&euro/', '�', $description);
        $description = preg_replace('/&copy/', '�', $description);
        $description = preg_replace('/&reg/', '�', $description);
        $description = preg_replace('/&deg/', '�', $description);
        $description = preg_replace('/&auml/', '�', $description);
        $description = preg_replace('/&Auml/', '�', $description);
        $description = preg_replace('/&ouml/', '�', $description);
        $description = preg_replace('/&Ouml/', '�', $description);
        $description = preg_replace('/&uuml/', '�', $description);
        $description = preg_replace('/&Uuml/', '�', $description);
        $description = preg_replace('/&szlig/', '�', $description);
        $description = preg_replace('/&quot/', '"', $description);


        $row->price = display_price($row->price, $row->tax_id);
        $row->price = number_format($row->price, 2, '.', '');

        $picture = empty($row->image_url) ? OPTIONS_DEFAULT_PICTURE : $row->image_url;
        $image_url = preg_match("/http/i", $picture) ? $picture : $imageURL . $picture;

        $sale_price = '';
        $sale_price_effective_date = '';
        if ($row->sale_status == 1 AND ! empty($row->sale_price)) {
            $sale_begin = $row->sale_begin == "0000-00-00 00:00:00" ? strtotime('now') : strtotime($row->sale_begin);
            $sale_end = $row->sale_end == "0000-00-00 00:00:00" ? strtotime('+1 months') : strtotime($row->sale_end);
            $sale_price = display_price($row->sale_price, $row->tax_id);
            $sale_price = number_format($sale_price, 2, '.', '');
            $sale_price_effective_date = date('Y-m-d', $sale_begin) . 'T00:00:00+0100' . "/" . date('Y-m-d', $sale_end) . 'T23:59:59+0100';
        }

        if (SEO_URLS == 'true' AND SEO_URLS_TYPE == 'Rewrite') {

            if (CONVERT_CURRENCY) {
                $parameter = "?currency=" . $werte["google_currency_type"] . "&items_id=" . $row->id;
            } else {
                $parameter = short_name(strip($row->name)) . '-p-' . $row->id . '.html';
            }

            $output .= $productURL . $parameter . "\t" .
                    preg_replace($_strip_search, $_strip_replace, strip_tags(strtr($row->name, $_cleaner_array))) . "\t" .
                    cut_to_long_string('string', preg_replace($_strip_search, $_strip_replace, strip_tags(strtr($description, $_cleaner_array))), '9999') . "\t" .
                    $feed_exp_date . "\t" .
                    $row->price . "\t" .
                    $image_url . "\t" .
                    $row->id . "\t" .
                    $sale_price . "\t" .
                    $sale_price_effective_date;
        } else {
            $output .= $row->product_url . "\t" .
                    preg_replace($_strip_search, $_strip_replace, strip_tags(strtr($row->name, $_cleaner_array))) . "\t" .
                    cut_to_long_string('string', preg_replace($_strip_search, $_strip_replace, strip_tags(strtr($description, $_cleaner_array))), '9999') . "\t" .
                    $feed_exp_date . "\t" .
                    $row->price . "\t" .
                    $image_url . "\t" .
                    $row->id . "\t" .
                    $sale_price . "\t" .
                    $sale_price_effective_date;
        }

        //optional values section
        if (OPTIONS_ENABLED == 1) {
            if (OPTIONS_ENABLED_AGE_RANGE == 1)
                $output .= " \t " . OPTIONS_AGE_RANGE;
            if (OPTIONS_ENABLED_BRAND == 1)
                $output .= " \t " . OPTIONS_BRAND;
            if (OPTIONS_ENABLED_CONDITION == 1)
                $output .= " \t " . OPTIONS_CONDITION;
            if (OPTIONS_ENABLED_CURRENCY == 1)
                $output .= " \t " . OPTIONS_DEFAULT_CURRENCY;
            if (OPTIONS_ENABLED_FEED_LANGUAGE == 1)
                $output .= " \t " . OPTIONS_DEFAULT_FEED_LANGUAGE;
            if (OPTIONS_ENABLED_FEED_MANUFACTURER_ID == 0)
                $output .= " \t " . $row->prodModel;
            if (OPTIONS_ENABLED_FEED_QUANTITY == 0) {
                $prod_quantity = $row->quantity;
                if ($prod_quantity < 1) {
                    $output .= " \t " . 'nicht auf lager';
                } else {
                    $output .= " \t " . 'auf lager';
                }
            }
            if (OPTIONS_ENABLED_MADE_IN == 1)
                $output .= " \t " . OPTIONS_MADE_IN;
            if (OPTIONS_ENABLED_MANUFACTURER == 0)
                $output .= " \t " . $row->mfgName;
            if (OPTIONS_ENABLED_PAYMENT_ACCEPTED == 1)
                $output .= " \t " . OPTIONS_PAYMENT_ACCEPTED_METHODS;
            if (OPTIONS_ENABLED_PRODUCT_TYPE == 1) {
                $catNameTemp = strtolower($catName);
                $output .= " \t " . $row->catName;
            }
            if (OPTIONS_ENABLED_SHIPPING == 1)
                $output .= " \t " . OPTIONS_LOWEST_SHIPPING;
            if (OPTIONS_ENABLED_UPC == 1)
                $output .= " \t " . $row->upc_ean_isbn;
            $output .= " \t " . (empty($row->upc_ean_isbn) ? 'FALSE' : 'TRUE');
            if (OPTIONS_ENABLED_WEIGHT == 1)
                $output .= " \t " . $row->prodWeight . ' ' . OPTIONS_WEIGHT_ACCEPTED_METHODS;
        }
        $output .= " \n";
    }
    $already_sent[$row->id] = 1;


    $loop_counter++;
    if ($loop_counter > 750) {
        $fp = fopen($OutFile, "a");
        $fout = fwrite($fp, $output);
        fclose($fp);
        $loop_counter = 0;
        $output = "";
    }
}
?>
<!doctype html public "-//W3C//DTD HTML 4.01 Transitional//EN">
<html <?php echo HTML_PARAMS; ?>>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=<?php echo CHARSET; ?>">
        <title><?php echo TITLE; ?></title>
        <link rel="stylesheet" type="text/css" href="load_this/style.css">
        <script language="javascript" src="load_this/menu.js"></script>
        <script type="text/javascript" language="JavaScript">
            <!--//
            function validateFenster() {
                var win = window.open("einlesen_fenster_unten.php", "Progress", "toolbar=no,width=650,height=100,directories=no,status=no,scrollbars=no,resize=no,menubar=no");
            }
            //-->
        </script>
    </head>
    <body  marginwidth="0" marginheight="0" topmargin="0" bottommargin="0" leftmargin="0" rightmargin="0" bgcolor="#FFFFFF">
        <!-- header //-->
<?php require(FOLDER_RELATIV_INCLUDES . 'load_bigware_9.php'); ?>
        <!-- header_eof //-->
        <!-- body //-->
        <table border="0" width="100%" cellspacing="2" cellpadding="2">
            <tr>
                <td width="<?php echo FRAME_WIDTH; ?>" valign="top">
                </td>
                <!-- body_text //-->
                <td width="100%" valign="top"><table border="0" width="100%" cellspacing="0" cellpadding="0">
                        <tr>
                            <td width="100%"><table border="0" width="100%" cellspacing="0" cellpadding="0">
                                    <tr>
                                        <td class="pageGeneralsign"><?php echo Google; ?></td>
                                        <td class="pageGeneralsign" align="right"><?php echo go_fetch_dividing_up('tranparentes.gif', ABOVE_PICTURE_WIDTH, ABOVE_PICTURE_HEIGHT); ?></td>
                                    </tr>
                                </table></td>
                        </tr>
                        <tr>
                            <td><table border="0" width="100%" cellspacing="0" cellpadding="2">
                                    <tr>
                                        <td>

                                            <table border="0" cellpadding="5" cellspacing="1" style="border-collapse: collapse" width="100%" id="AutoNumber1">
                                                <tr class=infoFrameInside>
                                                    <td valign="top" width="100%" class="TbInsideData">


                                                        <br>
                                                        <fieldset>
                                                            <legend><?php echo ALLGEMEIN; ?></legend>

<?php
$fp = fopen($OutFile, "a");
$fout = fwrite($fp, $output);
fclose($fp);
echo "File completed: <a href=\"" . $OutFile . "\" target=\"_blank\">" . $destination_file . "</a><br>\n";
chmod($OutFile, 0777);

//Start FTP
function ftp_file($ftpservername, $ftpusername, $ftppassword, $ftpsourcefile, $ftpdirectory, $ftpdestinationfile) {
    global $db_link;
    // set up basic connection
    $conn_id = ftp_connect($ftpservername);
    if ($conn_id == false) {
        echo "FTP open connection failed to $ftpservername <BR>\n";
        return false;
    }

    // login with username and password
    $login_result = ftp_login($conn_id, $ftpusername, $ftppassword);

    // check connection
    if ((!$conn_id) || (!$login_result)) {
        echo "FTP connection has failed!<BR>\n";
        echo "Attempted to connect to " . $ftpservername . " for user " . $ftpusername . "<BR>\n";
        return false;
    } else {
        echo "Connected to " . $ftpservername . ", for user " . $ftpusername . "<BR>\n";
    }

    if (strlen($ftpdirectory) > 0) {
        if (ftp_chdir($conn_id, $ftpdirectory)) {
            echo "Current directory is now: " . ftp_pwd($conn_id) . "<BR>\n";
        } else {
            echo "Couldn't change directory on $ftpservername<BR>\n";
            return false;
        }
    }

    ftp_pasv($conn_id, true);
    // upload the file
    $upload = ftp_put($conn_id, $ftpdestinationfile, $ftpsourcefile, FTP_ASCII);

    // check upload status
    if (!$upload) {
        echo "$ftpservername: FTP upload has failed!<BR>\n";
        return false;
    } else {
        echo "Uploaded " . $ftpsourcefile . " to " . $ftpservername . " as " . $ftpdestinationfile . "<BR>\n";
        $query8 = "UPDATE preisportale SET google_destination_file = '$ftpdestinationfile' WHERE id = '1'";
        $result8 = mysqli_query($db_link, $query8);
    }

    // close the FTP stream
    ftp_close($conn_id);

    return true;
}

if ($werte["google_ftp_enable"])
    ftp_file($werte["google_ftp_host"], $werte["google_ft_username"], $werte["google_ftp_password"], $source_file, "", $destination_file);

//End FTP
//  End TIMER
$etimer = explode(' ', microtime());
$etimer = $etimer[1] + $etimer[0];
echo '<p style="margin:auto; text-align:center">';
printf("Script timer: <b>%f</b> seconds.", ($etimer - $stimer));
echo '</p>';

echo '<p style="margin:auto; text-align:center"><br><br>';
echo '<a href="main_bigware_98.php"><b>Zur�ck</b></a>';
echo '</p>';
//  ---------
?>
                                                            <br>      	<br>
                                                        </fieldset>

                                                    </td>
                                                </tr>
                                            </table>
                                        </td>
                                    </tr>
                                </table></td>
                        </tr>
                        <tr>
                            <td><table border="0" cellpadding="0" cellspacing="2">
                                    <tr>
                                        <td colspan="2"><?php echo go_fetch_dividing_up('tranparentes.gif', '1', '10'); ?></td>
                                    </tr>
                                    <!-- body_text_eof //-->
                                </table></td>
                        </tr>
                    </table></td>
            </tr>
        </table>
        <!-- body_eof //-->
        <!-- footer //-->
<?php require(FOLDER_RELATIV_INCLUDES . 'load_bigware_7.php'); ?>
        <!-- footer_eof //-->
        <br>
    </body>
</html>
<?php
require(FOLDER_RELATIV_INCLUDES . 'load_bigware_6.php');
?>
