<?php
/*
###################################################################################
  Bigware Shop 2.3
  Release Datum: 23.08.2015
  
  Bigware Shop
  http://www.bigware.de

  Copyright (c) 2012 Bigware LTD
  (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
  (c) 2012	Bigware LTD

  Copyrightvermerke duerfen nicht entfernt werden.
  ------------------------------------------------------------------------
  Dieses Programm ist freie Software. Sie koennen es unter den Bedingungen
  der GNU General Public License, wie von der Free Software Foundation
  veroeffentlicht, weitergeben und/oder modifizieren, entweder gemaess Version 2 
  der Lizenz oder (nach Ihrer Option) jeder spaeteren Version.
  Die Veroeffentlichung dieses Programms erfolgt in der Hoffnung, dass es Ihnen
  von Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE, sogar ohne die
  implizite Garantie der MARKTREIFE oder der VERWENDBARKEIT FUER EINEN
  BESTIMMTEN ZWECK. Details finden Sie in der GNU General Public License.
  
  Sie sollten eine Kopie der GNU General Public License zusammen mit diesem
  Programm erhalten haben. Falls nicht, schreiben Sie an die Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.

  Infos:
  ------------------------------------------------------------------------
  Der Bigware Shop wurde vor vielen Jahren bereits aus dem bekannten Shopsystem osCommerce
  weiter- und neuentwickelt.
  Der Bigware Shop legt im hohen Masse Wert auf Bedienerfreundlichkeit, beinhaltet eine leichte
  Installation, viele neue professionelle Werkzeuge und zeichnet sich aus durch eine grosse 
  Community, die bei Problemen weiterhelfen kann.
  
  Der Bigware Shop ist auf jedem System lauffaehig, welches eine PHP Umgebung
  (ab PHP 4.1.3) und mySQL zur Verfuegung stellt und auf Linux basiert.
 
  Hilfe erhalten Sie im Forum auf www.bigware.de 
  
  -----------------------------------------------------------------------
  
 ##################################################################################




*/
?>
<?php
require('load_this/load_bigware_11.php');
require(FOLDER_RELATIV_CLASSES . 'class_bigware_1.php');
$currencies = new currencies();
$action = (isset($_GET['action']) ? $_GET['action'] : '');


if ( preg_match("/(insert|update|setflag)/i", $action) ) include_once('load_this/load_bigware_14.php');
if (go_not_null($action)) {
	switch ($action) {
		case 'setflag':
			if ( ($_GET['flag'] == '0') || ($_GET['flag'] == '1') ) {
				if (isset($_GET['bigID'])) {
					go_set_item_status($_GET['bigID'], $_GET['flag']);
				}
				if (USE_CACHE == 'true') {
					go_reset_cache_block('categories');
					go_reset_cache_block('also_purchased');
				}
			}
			go_forward(go_href_link(NAME_OF_FILE_CATEGORIES, 'bigPfad=' . $_GET['bigPfad'] . '&bigID=' . $_GET['bigID']));
			break;
		case 'setflag_cat':
			if ( ($_GET['flag'] == '0') || ($_GET['flag'] == '1') )
			{
				if (isset($_GET['bigID']))
				{
					go_set_categories_status($_GET['bigID'], $_GET['flag']);
				}
				if (USE_CACHE == 'true')
				{
					go_reset_cache_block('categories');
					go_reset_cache_block('also_purchased');
				}
			}
			go_forward(go_href_link(NAME_OF_FILE_CATEGORIES, 'bigPfad=' . $_GET['bigPfad'] . '&bigID=' . $_GET['bigID']));
			break;
		case 'insert_category':
		case 'update_category':
			if (isset($_POST['categories_id'])) $categories_id = go_db_producing_input($_POST['categories_id']);
			$sort_order = go_db_producing_input($_POST['sort_order']); 
			$categories_status = go_db_producing_input($_POST['categories_status']);
			$sql_data_array = array('sort_order' => $sort_order, 'categories_status' => $categories_status);
			if ($action == 'insert_category') {
				$insert_sql_data = array('parent_id' => $current_category_id,
						'date_added' => 'now()');
				$sql_data_array = array_merge($sql_data_array, $insert_sql_data);
				go_db_carry(DB_TBL_CATEGORIES, $sql_data_array);
				$categories_id = go_db_insert_id();
			} elseif ($action == 'update_category') {
				$update_sql_data = array('last_modified' => 'now()');
				$sql_data_array = array_merge($sql_data_array, $update_sql_data);
				go_db_carry(DB_TBL_CATEGORIES, $sql_data_array, 'update', "categories_id = '" . (int)$categories_id . "'");
			}
			$languages = go_get_languages();
			for ($i=0, $n=sizeof($languages); $i<$n; $i++) {
				$language_id = $languages[$i]['id'];
				$categories_name_array = $_POST['categories_name'];
				$categories_desc_array = $_POST['categories_desc'.$language_id];
				$sql_data_array = array('categories_name' => go_db_producing_input($categories_name_array[$language_id]),'categories_desc' => go_db_producing_input($categories_desc_array));
				if ($action == 'insert_category') {
					$insert_sql_data = array('categories_id' => $categories_id,
							'language_id' => $languages[$i]['id']);
					$sql_data_array = array_merge($sql_data_array, $insert_sql_data);
					go_db_carry(DB_TBL_CATEGORIES_DESCRIPTION, $sql_data_array);
				} elseif ($action == 'update_category') {
					go_db_carry(DB_TBL_CATEGORIES_DESCRIPTION, $sql_data_array, 'update', "categories_id = '" . (int)$categories_id . "' and language_id = '" . (int)$languages[$i]['id'] . "'");
				}
			}

			$wert1 = '';
			$stuecke = '';

			$stuecke = preg_split ('/"/', $_POST['categories_picture']);
			while (list($schluessel, $wert) = each($stuecke)){

				if (substr_count($wert, FOLDER_RELATIV_PICTURES) > 0){

					$pfad_kommentiert = preg_replace('/\//', '\/', FOLDER_RELATIV_PICTURES);
					$wert1 = preg_replace('/' . $pfad_kommentiert . '/', '', strstr(trim(stripslashes($wert)), FOLDER_RELATIV_PICTURES));


				}

			}    
			if ($wert1 == ''){
				$_POST['categories_picture'] = '';
			}
			else{$_POST['categories_picture'] = $wert1;}



			//          if (isset($_POST['categories_picture']) && go_not_null($_POST['categories_picture']) && ($_POST['categories_picture'] != 'none')) {
			go_db_query("update " . DB_TBL_CATEGORIES . " set categories_picture = '" . go_db_input($_POST['categories_picture']) . "' where categories_id = '" . (int)$categories_id . "'");
			//        	}
			if (USE_CACHE == 'true') {
				go_reset_cache_block('categories');
				go_reset_cache_block('also_purchased');
			}
			go_forward(go_href_link(NAME_OF_FILE_CATEGORIES, 'bigPfad=' . $bigPfad . '&bigID=' . $categories_id));
			break;
		case 'delete_category_confirm':
			if (isset($_POST['categories_id'])) {
				$categories_id = go_db_producing_input($_POST['categories_id']);
				$categories = go_get_category_tree($categories_id, '', '0', '', true);
				$items = array();
				$items_delete = array();
				for ($i=0, $n=sizeof($categories); $i<$n; $i++) {
					$item_ids_query = go_db_query("select items_id from " . DB_TBL_ITEMS_TO_CATEGORIES . " where categories_id = '" . (int)$categories[$i]['id'] . "'");
					while ($item_ids = go_db_fetch_array($item_ids_query)) {
						$items[$item_ids['items_id']]['categories'][] = $categories[$i]['id'];
					}
				}
				reset($items);
				while (list($key, $value) = each($items)) {
					$category_ids = '';
					for ($i=0, $n=sizeof($value['categories']); $i<$n; $i++) {
						$category_ids .= "'" . (int)$value['categories'][$i] . "', ";
					}
					$category_ids = substr($category_ids, 0, -2);
					$check_query = go_db_query("select count(*) as total from " . DB_TBL_ITEMS_TO_CATEGORIES . " where items_id = '" . (int)$key . "' and categories_id not in (" . $category_ids . ")");
					$check = go_db_fetch_array($check_query);
					if ($check['total'] < '1') {
						$items_delete[$key] = $key;
					}
				}  
				for ($i=0, $n=sizeof($categories); $i<$n; $i++) {
					go_remove_category($categories[$i]['id']);
					go_remove_category_api($categories[$i]['id']);
				}
				reset($items_delete);
				while (list($key) = each($items_delete)) {
					go_remove_item($key);
				}
			}
			if (USE_CACHE == 'true') {
				go_reset_cache_block('categories');
				go_reset_cache_block('also_purchased');
			}
			go_forward(go_href_link(NAME_OF_FILE_CATEGORIES, 'bigPfad=' . $bigPfad));
			break;
		case 'delete_item_confirm':
			if (isset($_POST['items_id']) && isset($_POST['item_categories']) && is_array($_POST['item_categories'])) {
				$item_id = go_db_producing_input($_POST['items_id']);
				$item_categories = $_POST['item_categories'];
				for ($i=0, $n=sizeof($item_categories); $i<$n; $i++) {
					go_db_query("delete from " . DB_TBL_ITEMS_TO_CATEGORIES . " where items_id = '" . (int)$item_id . "' and categories_id = '" . (int)$item_categories[$i] . "'");
				} 
				go_db_query("delete from " . DB_TBL_ITEMS_GROUPS . " where items_id = '" . go_db_input($item_id) . "' "); 
				$item_categories_query = go_db_query("select count(*) as total from " . DB_TBL_ITEMS_TO_CATEGORIES . " where items_id = '" . (int)$item_id . "'");
				$item_categories = go_db_fetch_array($item_categories_query);
				if ($item_categories['total'] == '0') {
					go_remove_item($item_id);
				}
			}
			if (USE_CACHE == 'true') {
				go_reset_cache_block('categories');
				go_reset_cache_block('also_purchased');
			}
			go_forward(go_href_link(NAME_OF_FILE_CATEGORIES, 'bigPfad=' . $bigPfad));
			break;
		case 'move_category_confirm':
			if (isset($_POST['categories_id']) && ($_POST['categories_id'] != $_POST['move_to_category_id'])) {
				$categories_id = go_db_producing_input($_POST['categories_id']);
				$new_parent_id = go_db_producing_input($_POST['move_to_category_id']);
				$path = explode('_', go_get_generated_category_path_ids($new_parent_id));
				if (in_array($categories_id, $path)) {
					$messageStack->add_session(ERROR_CANNOT_MOVE_CATEGORY_TO_PARENT, 'error');
					go_forward(go_href_link(NAME_OF_FILE_CATEGORIES, 'bigPfad=' . $bigPfad . '&bigID=' . $categories_id));
				} else {
					go_db_query("update " . DB_TBL_CATEGORIES . " set parent_id = '" . (int)$new_parent_id . "', last_modified = now() where categories_id = '" . (int)$categories_id . "'");
					if (USE_CACHE == 'true') {
						go_reset_cache_block('categories');
						go_reset_cache_block('also_purchased');
					}
					go_forward(go_href_link(NAME_OF_FILE_CATEGORIES, 'bigPfad=' . $new_parent_id . '&bigID=' . $categories_id));
				}
			}
			break;
		case 'move_item_confirm':
			$items_id = go_db_producing_input($_POST['items_id']);
			$new_parent_id = go_db_producing_input($_POST['move_to_category_id']);
			$duplicate_check_query = go_db_query("select count(*) as total from " . DB_TBL_ITEMS_TO_CATEGORIES . " where items_id = '" . (int)$items_id . "' and categories_id = '" . (int)$new_parent_id . "'");
			$duplicate_check = go_db_fetch_array($duplicate_check_query);
			if ($duplicate_check['total'] < 1) go_db_query("update " . DB_TBL_ITEMS_TO_CATEGORIES . " set categories_id = '" . (int)$new_parent_id . "' where items_id = '" . (int)$items_id . "' and categories_id = '" . (int)$current_category_id . "'");
			if (USE_CACHE == 'true') {
				go_reset_cache_block('categories');
				go_reset_cache_block('also_purchased');
			}
			go_forward(go_href_link(NAME_OF_FILE_CATEGORIES, 'bigPfad=' . $new_parent_id . '&bigID=' . $items_id));
			break; 
		case 'neues_item_confirm':
			if (isset($_POST['items_id']) && isset($_POST['item_categories']) && is_array($_POST['item_categories'])) {
				$item_id = go_db_producing_input($_POST['items_id']);
				go_db_query("update " . DB_TBL_ITEMS . " set items_date_added = now() where items_id = '" . $item_id . "'");
			}
			go_forward(go_href_link(NAME_OF_FILE_CATEGORIES, 'bigPfad=' . $bigPfad));
			break; 
		case 'neu_im_category_confirm':
			if (isset($_POST['categories_id'])) {
				$categories_id = go_db_producing_input($_POST['categories_id']);
				$categories = go_get_category_tree($categories_id, '', '0', '', true);
				$items = array();
				$items_delete = array();
				for ($i=0, $n=sizeof($categories); $i<$n; $i++) {
					$item_ids_query = go_db_query("select items_id from " . DB_TBL_ITEMS_TO_CATEGORIES . " where categories_id = '" . (int)$categories[$i]['id'] . "'");
					while ($item_ids = go_db_fetch_array($item_ids_query)) {
						$items[$item_ids['items_id']]['categories'][] = $categories[$i]['id'];
					}
				}
				reset($items);
				while (list($key, $value) = each($items)) {
					$category_ids = '';
					for ($i=0, $n=sizeof($value['categories']); $i<$n; $i++) {
						$category_ids .= "'" . (int)$value['categories'][$i] . "', ";
					}
					$category_ids = substr($category_ids, 0, -2);
					$check_query = go_db_query("select count(*) as total from " . DB_TBL_ITEMS_TO_CATEGORIES . " where items_id = '" . (int)$key . "' and categories_id not in (" . $category_ids . ")");
					$check = go_db_fetch_array($check_query);
					if ($check['total'] < '1') {
						$items_delete[$key] = $key;
					}
				} 
				reset($items_delete);
				while (list($key) = each($items_delete)) {
					go_db_query("update " . DB_TBL_ITEMS . " set items_date_added = now() where items_id = '" . $key . "'");
				}
			}
			go_forward(go_href_link(NAME_OF_FILE_CATEGORIES, 'bigPfad=' . $bigPfad));
			go_forward(go_href_link(NAME_OF_FILE_CATEGORIES, 'bigPfad=' . $new_parent_id . '&bigID=' . $items_id));
			break;
		case 'insert_item':
		case 'update_item':
			if (isset($_POST['change_x']) || isset($_POST['change_y'])) {
				$action = 'new_item';
			} else {
				if (isset($_GET['bigID'])) $items_id = go_db_producing_input($_GET['bigID']);
				$items_date_available = go_db_producing_input($_POST['items_date_available']);
				$items_date_available_end = go_db_producing_input($_POST['items_date_available_end']);
				# FIXME: $items_date_available = (date('Y-m-d') < $items_date_available) ? $items_date_available : 'null';
				# FIXME: $items_date_available = (date('Y-m-d') < $items_date_available_end) ? $items_date_available_end : 'null';


				if ($_POST['domainservice_status'] == '1'){
					$_POST['iss_masseinheit'] = '0';
				}
				// creating_new_variable6       	
				$sql_data_array = array('items_quantity' => go_db_producing_input($_POST['items_quantity']),
						'items_bundle' => go_db_producing_input($_POST['items_bundle']),
						'items_model' => go_db_producing_input($_POST['items_model']),
						'items_ship_price_two' => go_db_producing_input($_POST['items_ship_price_two']),
						'items_ship_price' => go_db_producing_input($_POST['items_ship_price']),
						'items_price' => go_db_producing_input($_POST['items_price']),
						'items_basis_price' => go_db_producing_input($_POST['items_basis_price']),
						'items_price_option' => go_db_producing_input($_POST['items_price_option']),
						'items_price_uvp' => go_db_producing_input($_POST['items_price_uvp']),
						'unit_price_option' => go_db_producing_input($_POST['unit_price_option']),
						'unit_price_factor' => go_db_producing_input($_POST['unit_price_factor']),
						'shipping_zone_1' => go_db_producing_input($_POST['shipping_zone_1']),
						'shipping_zone_2' => go_db_producing_input($_POST['shipping_zone_2']),
						'shipping_greatship' => go_db_producing_input($_POST['shipping_greatship']),
						'items_date_available' => $items_date_available,
						'items_date_available_end' => $items_date_available_end,
						'upc_ean_isbn' => go_db_producing_input($_POST['upc_ean_isbn']),
						'herstellernummer' => go_db_producing_input($_POST['herstellernummer']),
						'items_weight' => go_db_producing_input($_POST['items_weight']),
						'items_status' => go_db_producing_input($_POST['items_status']), 
// Bearbeitung Bert Anfang
						'delivery_time_id' => go_db_producing_input($_POST['delivery_time_id']),
// Bearbeitung Bert Ende
						'domainservice_status' => go_db_producing_input($_POST['domainservice_status']), 
						'domainservice_zahlungsintervall' => go_db_producing_input($_POST['domainservice_zahlungsintervall']), 
						'items_percentage' => go_db_producing_input($_POST['items_percentage']), 
						'items_tax_class_id' => go_db_producing_input($_POST['items_tax_class_id']),
						'shipping_range_group_id' => go_db_producing_input($_POST['shipping_range_group_id']),
						'producers_id' => go_db_producing_input($_POST['producers_id']),
						'extra_item_costumer_input' => go_db_producing_input($_POST['extra_item_costumer_input']),
						'item_costumer_input_height' => go_db_producing_input($_POST['item_costumer_input_height']),
						'item_costumer_input_width' => go_db_producing_input($_POST['item_costumer_input_width']),
						'iss_masseinheit' => go_db_producing_input($_POST['iss_masseinheit']),
						'iss_download' => go_db_producing_input($_POST['iss_download'])); 

				if (isset($_POST['items_picture'])) {
					$sql_data_array['items_picture'] = go_db_producing_input(preg_replace('/%20/', ' ', $_POST['items_picture']));
				} 
				if (isset($_POST['items_bpicture'])) {
					$sql_data_array['items_bpicture'] = go_db_producing_input(preg_replace('/%20/', ' ', $_POST['items_bpicture']));
				}
				if (isset($_POST['items_3picture'])) {
					$sql_data_array['items_3picture'] = go_db_producing_input(preg_replace('/%20/', ' ', $_POST['items_3picture']));
				}
				if (isset($_POST['items_4picture'])) {
					$sql_data_array['items_4picture'] = go_db_producing_input(preg_replace('/%20/', ' ', $_POST['items_4picture']));
				}
				if (isset($_POST['items_5picture'])) {
					$sql_data_array['items_5picture'] = go_db_producing_input(preg_replace('/%20/', ' ', $_POST['items_5picture']));
				}

				if ($action == 'insert_item') {
					// anlegen, wenn neu
					$insert_sql_data = array('items_date_added' => 'now()');
					$sql_data_array = array_merge($sql_data_array, $insert_sql_data);
					go_db_carry(DB_TBL_ITEMS, $sql_data_array);
					$items_id = go_db_insert_id();

					go_db_query("insert into " . DB_TBL_ITEMS_TO_CATEGORIES . " (items_id, categories_id) values ('" . (int)$items_id . "', '" . (int)$current_category_id . "')"); 

					if (sizeof($_POST['items_option_itemlist'])!=0){
						$option_keys = array_keys($_POST['items_option_itemlist']);
						for ($op=0; $op<sizeof($option_keys); $op++){
							$sql_data_option_array['items_options_conf_id'] = $option_keys[$op];
							$sql_data_option_array['items_options_conf_values_id'] = $_POST['items_option_itemlist'][$option_keys[$op]];
							$sql_data_option_array['items_id'] = $items_id;
							if ($sql_data_option_array['items_options_conf_values_id']!=0) {
								go_db_carry(DB_TBL_ITEMS_DEFAULT_OPTIONS_CONF, $sql_data_option_array);
							}	
						}//for options
					}//!=0


					//require('main_bigware_10_save_new_characteristics.php');	

					/////////    Produktmerkmale speichern, wenn ein neuer Artikel angelegt wurde   /////////////////////////////////////////////  
					if ($_POST['set_produktmerkmale'] == '1'){


						for($p=0; $p<5;$p++){

							if ($_POST['new_pro_opt_'.$p] != "" AND count ($_POST['merkmalwert_pro_'.$p]) > '0'){	

								$option_check_query = go_db_query("select count(*) as total from " . DB_TBL_ITEMS_OPTIONS . " where items_options_name = '" . $_POST['new_pro_opt_'.$p] . "' AND  language_id='" . $languages_id . "'");
								$option_check = go_db_fetch_array($option_check_query);
								if ($option_check['total'] > '0') {
									$option_id_query = go_db_query("SELECT items_options_id FROM " . DB_TBL_ITEMS_OPTIONS . " WHERE items_options_name='" . $_POST['new_pro_opt_'.$p] . "' AND  language_id='" . $languages_id . "'");
									$option_id_result=go_db_fetch_array($option_id_query);
									$option_id = $option_id_result['items_options_id'];
								}
								else{
									$option_query = go_db_query("SELECT items_options_id FROM " . DB_TBL_ITEMS_OPTIONS . " WHERE language_id='" . $languages_id . "' ORDER BY items_options_id DESC");
									if($option_result=go_db_fetch_array($option_query)) {
										$option_id =$option_result['items_options_id']+1;
									}
									else{
										$option_id = "1";
									}

									$languages = go_get_languages();
									for ($o=0, $u=sizeof($languages); $o<$u; $o++) {
										$languages_opt_id=$languages[$o]['id'];
										go_db_query("insert into " . DB_TBL_ITEMS_OPTIONS . " SET items_options_name='" . $_POST['new_pro_opt_'.$p] . "', language_id='" . $languages_opt_id . "', items_options_id='" . $option_id . "'");
									}		
								}
								if (count ($_POST['merkmalwert_pro_'.$p]) > '0'){
									foreach ($_POST['merkmalwert_pro_'.$p] as $key => $value) {

										$check_query = go_db_query("select count(*) as total from " . DB_TBL_ITEMS_OPTIONS_VALUES . " where items_options_values_name = '" . $_POST['merkmalwert_pro_'.$p][$key] . "' AND  language_id='" . $languages_id . "'");
										$check = go_db_fetch_array($check_query);
										if ($check['total'] > '0') {				
											$values_select_query = go_db_query("SELECT items_options_values_id FROM " . DB_TBL_ITEMS_OPTIONS_VALUES . " WHERE items_options_values_name='" . $_POST['merkmalwert_pro_'.$p][$key] . "' AND  language_id='" . $languages_id . "'");				
											$values_select_result=go_db_fetch_array($values_select_query);
											$values_id = $values_select_result['items_options_values_id'];

										}
										else{

											$query = go_db_query("SELECT items_options_values_id FROM " . DB_TBL_ITEMS_OPTIONS_VALUES . " WHERE language_id='" . $languages_id . "' ORDER BY `items_options_values_id` DESC");
											if($result=go_db_fetch_array($query)) {
												$values_id =$result['items_options_values_id']+1;
											}
											else{
												$values_id = "1";
											}

											$languages = go_get_languages();
											for ($m=0, $n=sizeof($languages); $m<$n; $m++) {
												$languages_opt_value_id=$languages[$m]['id'];
												go_db_query("insert into " . DB_TBL_ITEMS_OPTIONS_VALUES . " SET items_options_values_name='" . $_POST['merkmalwert_pro_'.$p][$key] . "', language_id='" . $languages_opt_value_id . "', items_options_values_id='" . $values_id . "'");
											}

										}

										$check_option_to_value_query = go_db_query("select count(*) as total from " . DB_TBL_ITEMS_OPTIONS_VALUES_TO_ITEMS_OPTIONS . " where items_options_id = '" . $option_id . "' AND  items_options_values_id='" . $values_id . "'");
										$check_option_to_value = go_db_fetch_array($check_option_to_value_query);
										if ($check_option_to_value['total'] < '1') {						
											go_db_query("insert into " . DB_TBL_ITEMS_OPTIONS_VALUES_TO_ITEMS_OPTIONS . " SET items_options_id='" . $option_id . "', items_options_values_id='" . $values_id . "'");
										}

										$_POST['attributs_sort_order_pro_'.$p][$key] = (is_numeric($_POST['attributs_sort_order_pro_'.$p][$key]) ? $_POST['attributs_sort_order_pro_'.$p][$key] : '0');
										if ($_POST['attributs_sort_order_pro_'.$p][$key] == ''){$_POST['attributs_sort_order_pro_'.$p][$key] = '0';}
										$_POST['anzahl_pro_'.$p][$key] = (is_numeric($_POST['anzahl_pro_'.$p][$key]) ? $_POST['anzahl_pro_'.$p][$key] : '');
										$_POST['preis_pro_'.$p][$key] = preg_replace('/,/i', '.', $_POST['preis_pro_'.$p][$key]);
										$_POST['preis_pro_'.$p][$key] = (is_numeric($_POST['preis_pro_'.$p][$key]) ? $_POST['preis_pro_'.$p][$key] : '');
										$vorzeichenzaeler = '0';
										if ($_POST['vorzeichen_pro_'.$p][$key] == '+'){$vorzeichenzaeler++;}
										if ($_POST['vorzeichen_pro_'.$p][$key] == '-'){$vorzeichenzaeler++;}
										if ($vorzeichenzaeler < '1'){$_POST['vorzeichen_pro_'.$p][$key] = '+';}
										if ($_POST['preis_pro_'.$p][$key] == ""){$_POST['vorzeichen_pro_'.$p][$key] = '';}
										go_db_query("insert into " . DB_TBL_ITEMS_CHARACTERISTICS . " SET items_id = '" . (int)$items_id . "', options_id='" . $option_id . "', options_values_id='" . $values_id . "', options_values_price='" . $_POST['preis_pro_'.$p][$key] . "', price_prefix='" . $_POST['vorzeichen_pro_'.$p][$key] . "', attributs_sort_order='" . $_POST['attributs_sort_order_pro_'.$p][$key] . "', qty='" . $_POST['anzahl_pro_'.$p][$key] . "'");

									}
								}		
							}
						}	
					}
					//////////////////   Produktmerkmale speichern, wenn ein neuer Artikel angelegt wurde ende  ////////////////////////////    


				} // if ENDE = anlegen, wenn neu
				elseif ($action == 'update_item') {
					// aktualisieren, wenn vorhanden

					$update_sql_data = array('items_last_modified' => 'now()');
					$sql_data_array = array_merge($sql_data_array, $update_sql_data);
					go_db_carry(DB_TBL_ITEMS, $sql_data_array, 'update', "items_id = '" . (int)$items_id . "'"); 
					go_db_query("delete from ".DB_TBL_ITEMS_DEFAULT_OPTIONS_CONF." where items_id='".(int)$items_id."'");
					if (sizeof($_POST['items_option_itemlist'])!=0){
						$option_keys = array_keys($_POST['items_option_itemlist']);
						for ($op=0; $op<sizeof($option_keys); $op++){
							$sql_data_option_array['items_options_conf_id'] = $option_keys[$op];
							$sql_data_option_array['items_options_conf_values_id'] = $_POST['items_option_itemlist'][$option_keys[$op]];
							$sql_data_option_array['items_id'] = (int)$items_id;
							if ($sql_data_option_array['items_options_conf_values_id']!=0) {
								go_db_carry(DB_TBL_ITEMS_DEFAULT_OPTIONS_CONF, $sql_data_option_array);
							}	
						}//for options
					}//!=0

					//require('main_bigware_10_update_exist_characteristics.php');	

					/////////    Produktmerkmale aktualisieren, wenn ein existierender Artikel bearbeitet wurde  /////////////////////////////////////////////     
					if ($_POST['set_produktmerkmale'] == '1'){


						for($p=0; $p<5;$p++){

							if ($_POST['pro_opt_'.$p] != ""){	


								if ($_POST['pro_opt_'.$p] == '0'){

									$option_id_query = go_db_query("SELECT items_options_id FROM " . DB_TBL_ITEMS_OPTIONS . " WHERE items_options_name='" . $_POST['pro_opt_delete'.$p] . "' AND  language_id='" . $languages_id . "'");
									$option_id_result=go_db_fetch_array($option_id_query);
									$option_id = $option_id_result['items_options_id'];



									$option_check_query = go_db_query("select count(*) as total from " . DB_TBL_ITEMS_CHARACTERISTICS . " where options_id = '" . $option_id . "' AND items_id != '" . (int)$items_id . "'");
									$option_check = go_db_fetch_array($option_check_query);
									if ($option_check['total'] < '1') {

										go_db_query("delete from " . DB_TBL_ITEMS_OPTIONS . " where items_options_id = '" . $option_id . "'");
									}

									$options_values_id_query = go_db_query("SELECT options_values_id FROM " . DB_TBL_ITEMS_CHARACTERISTICS . " WHERE options_id='" . $option_id . "' AND  items_id = '" . (int)$items_id . "'");
									while($options_values_result=go_db_fetch_array($options_values_id_query)){
										$options_values_id = $options_values_result['options_values_id'];

										$option_value_check_query = go_db_query("select count(*) as total from " . DB_TBL_ITEMS_CHARACTERISTICS . " where options_values_id = '" . $options_values_id . "' AND items_id != '" . (int)$items_id . "'");
										$option_value_check = go_db_fetch_array($option_value_check_query);
										if ($option_value_check['total'] < '1') {
											go_db_query("delete from " . DB_TBL_ITEMS_OPTIONS_VALUES . " where items_options_values_id = '" . $options_values_id . "'");		
										}
										$option_value_to_option_check_query = go_db_query("select count(*) as total from " . DB_TBL_ITEMS_CHARACTERISTICS . " where options_id='" . $option_id . "' AND options_values_id = '" . $options_values_id . "' AND items_id != '" . (int)$items_id . "'");
										$option_value_to_option_check = go_db_fetch_array($option_value_to_option_check_query);
										if ($option_value_to_option_check['total'] < '1') {
											go_db_query("delete from " . DB_TBL_ITEMS_OPTIONS_VALUES_TO_ITEMS_OPTIONS . " where items_options_values_id = '" . $options_values_id . "' AND  items_options_id='" . $option_id . "'");	
										}		

									}		            	

									go_db_query("delete from " . DB_TBL_ITEMS_CHARACTERISTICS . " where options_id = '" . $option_id . "' AND items_id = '" . (int)$items_id . "'");


								}   			
								elseif ($_POST['pro_opt_'.$p] != '' AND count ($_POST['merkmalwert_pro_'.$p]) > '0'){


									$option_id_query = go_db_query("SELECT items_options_id FROM " . DB_TBL_ITEMS_OPTIONS . " WHERE items_options_name='" . $_POST['pro_opt_'.$p] . "' AND  language_id='" . $languages_id . "'");
									$option_id_result=go_db_fetch_array($option_id_query);
									$option_id = $option_id_result['items_options_id'];


									$options_values_id_query = go_db_query("SELECT options_values_id FROM " . DB_TBL_ITEMS_CHARACTERISTICS . " WHERE options_id='" . $option_id . "' AND  items_id = '" . (int)$items_id . "'");
									while($options_values_result=go_db_fetch_array($options_values_id_query)){
										$options_values_id = $options_values_result['options_values_id'];

										$option_value_check_query = go_db_query("select count(*) as total from " . DB_TBL_ITEMS_CHARACTERISTICS . " where options_values_id = '" . $options_values_id . "' AND items_id != '" . (int)$items_id . "'");
										$option_value_check = go_db_fetch_array($option_value_check_query);
										if ($option_value_check['total'] < '1') {
											go_db_query("delete from " . DB_TBL_ITEMS_OPTIONS_VALUES . " where items_options_values_id = '" . $options_values_id . "'");		
										}
										$option_value_to_option_check_query = go_db_query("select count(*) as total from " . DB_TBL_ITEMS_CHARACTERISTICS . " where options_id='" . $option_id . "' AND options_values_id = '" . $options_values_id . "' AND items_id != '" . (int)$items_id . "'");
										$option_value_to_option_check = go_db_fetch_array($option_value_to_option_check_query);
										if ($option_value_to_option_check['total'] < '1') {
											go_db_query("delete from " . DB_TBL_ITEMS_OPTIONS_VALUES_TO_ITEMS_OPTIONS . " where items_options_values_id = '" . $options_values_id . "' AND  items_options_id='" . $option_id . "'");	
										}		

									}
									go_db_query("delete from " . DB_TBL_ITEMS_CHARACTERISTICS . " where options_id = '" . $option_id . "' AND items_id = '" . (int)$items_id . "'");

									/////////////////////////////				

									foreach ($_POST['merkmalwert_pro_'.$p] as $key => $value) {

										$check_query = go_db_query("select count(*) as total from " . DB_TBL_ITEMS_OPTIONS_VALUES . " where items_options_values_name = '" . $_POST['merkmalwert_pro_'.$p][$key] . "' AND  language_id='" . $languages_id . "'");
										$check = go_db_fetch_array($check_query);
										if ($check['total'] > '0') {				
											$values_select_query = go_db_query("SELECT items_options_values_id FROM " . DB_TBL_ITEMS_OPTIONS_VALUES . " WHERE items_options_values_name='" . $_POST['merkmalwert_pro_'.$p][$key] . "' AND  language_id='" . $languages_id . "'");				
											$values_select_result=go_db_fetch_array($values_select_query);
											$values_id = $values_select_result['items_options_values_id'];

										}
										else{

											$query = go_db_query("SELECT items_options_values_id FROM " . DB_TBL_ITEMS_OPTIONS_VALUES . " WHERE language_id='" . $languages_id . "' ORDER BY `items_options_values_id` DESC");
											if($result=go_db_fetch_array($query)) {
												$values_id =$result['items_options_values_id']+1;
											}
											else{
												$values_id = "1";
											}

											$languages = go_get_languages();
											for ($m=0, $n=sizeof($languages); $m<$n; $m++) {
												$languages_opt_value_id=$languages[$m]['id'];
												go_db_query("insert into " . DB_TBL_ITEMS_OPTIONS_VALUES . " SET items_options_values_name='" . $_POST['merkmalwert_pro_'.$p][$key] . "', language_id='" . $languages_opt_value_id . "', items_options_values_id='" . $values_id . "'");
											}

										}

										$check_option_to_value_query = go_db_query("select count(*) as total from " . DB_TBL_ITEMS_OPTIONS_VALUES_TO_ITEMS_OPTIONS . " where items_options_id = '" . $option_id . "' AND  items_options_values_id='" . $values_id . "'");
										$check_option_to_value = go_db_fetch_array($check_option_to_value_query);
										if ($check_option_to_value['total'] < '1') {						
											go_db_query("insert into " . DB_TBL_ITEMS_OPTIONS_VALUES_TO_ITEMS_OPTIONS . " SET items_options_id='" . $option_id . "', items_options_values_id='" . $values_id . "'");
										}

										$_POST['attributs_sort_order_pro_'.$p][$key] = (is_numeric($_POST['attributs_sort_order_pro_'.$p][$key]) ? $_POST['attributs_sort_order_pro_'.$p][$key] : '0');
										if ($_POST['attributs_sort_order_pro_'.$p][$key] == ''){$_POST['attributs_sort_order_pro_'.$p][$key] = '0';}
										$_POST['anzahl_pro_'.$p][$key] = (is_numeric($_POST['anzahl_pro_'.$p][$key]) ? $_POST['anzahl_pro_'.$p][$key] : '');
										$_POST['preis_pro_'.$p][$key] = preg_replace('/,/i', '.', $_POST['preis_pro_'.$p][$key]);
										$_POST['preis_pro_'.$p][$key] = (is_numeric($_POST['preis_pro_'.$p][$key]) ? $_POST['preis_pro_'.$p][$key] : '');
										$vorzeichenzaeler = '0';
										if ($_POST['vorzeichen_pro_'.$p][$key] == '+'){$vorzeichenzaeler++;}
										if ($_POST['vorzeichen_pro_'.$p][$key] == '-'){$vorzeichenzaeler++;}
										if ($vorzeichenzaeler < '1'){$_POST['vorzeichen_pro_'.$p][$key] = '+';}
										if ($_POST['preis_pro_'.$p][$key] == ""){$_POST['vorzeichen_pro_'.$p][$key] = '';}
										go_db_query("insert into " . DB_TBL_ITEMS_CHARACTERISTICS . " SET items_id = '" . (int)$items_id . "', options_id='" . $option_id . "', options_values_id='" . $values_id . "', options_values_price='" . $_POST['preis_pro_'.$p][$key] . "', price_prefix='" . $_POST['vorzeichen_pro_'.$p][$key] . "', attributs_sort_order='" . $_POST['attributs_sort_order_pro_'.$p][$key] . "', qty='" . $_POST['anzahl_pro_'.$p][$key] . "'");

									}	

									/////////////////////////////
								}				

								elseif ($_POST['pro_opt_'.$p] != '' AND count ($_POST['merkmalwert_pro_'.$p]) < '1'){

									$option_id_query = go_db_query("SELECT items_options_id FROM " . DB_TBL_ITEMS_OPTIONS . " WHERE items_options_name='" . $_POST['pro_opt_'.$p] . "' AND  language_id='" . $languages_id . "'");
									$option_id_result=go_db_fetch_array($option_id_query);
									$option_id = $option_id_result['items_options_id'];



									$option_check_query = go_db_query("select count(*) as total from " . DB_TBL_ITEMS_CHARACTERISTICS . " where options_id = '" . $option_id . "' AND items_id != '" . (int)$items_id . "'");
									$option_check = go_db_fetch_array($option_check_query);
									if ($option_check['total'] < '1') {

										go_db_query("delete from " . DB_TBL_ITEMS_OPTIONS . " where items_options_id = '" . $option_id . "'");
									}

									$options_values_id_query = go_db_query("SELECT options_values_id FROM " . DB_TBL_ITEMS_CHARACTERISTICS . " WHERE options_id='" . $option_id . "' AND  items_id = '" . (int)$items_id . "'");
									while($options_values_result=go_db_fetch_array($options_values_id_query)){
										$options_values_id = $options_values_result['options_values_id'];

										$option_value_check_query = go_db_query("select count(*) as total from " . DB_TBL_ITEMS_CHARACTERISTICS . " where options_values_id = '" . $options_values_id . "' AND items_id != '" . (int)$items_id . "'");
										$option_value_check = go_db_fetch_array($option_value_check_query);
										if ($option_value_check['total'] < '1') {
											go_db_query("delete from " . DB_TBL_ITEMS_OPTIONS_VALUES . " where items_options_values_id = '" . $options_values_id . "'");		
										}
										$option_value_to_option_check_query = go_db_query("select count(*) as total from " . DB_TBL_ITEMS_CHARACTERISTICS . " where options_id='" . $option_id . "' AND options_values_id = '" . $options_values_id . "' AND items_id != '" . (int)$items_id . "'");
										$option_value_to_option_check = go_db_fetch_array($option_value_to_option_check_query);
										if ($option_value_to_option_check['total'] < '1') {
											go_db_query("delete from " . DB_TBL_ITEMS_OPTIONS_VALUES_TO_ITEMS_OPTIONS . " where items_options_values_id = '" . $options_values_id . "' AND  items_options_id='" . $option_id . "'");	
										}		

									}		            	

									go_db_query("delete from " . DB_TBL_ITEMS_CHARACTERISTICS . " where options_id = '" . $option_id . "' AND items_id = '" . (int)$items_id . "'");


								}				
							}
							if ($_POST['new_pro_opt_'.$p] != "" AND count ($_POST['merkmalwert_pro_'.$p]) > '0'){	

								$option_check_query = go_db_query("select count(*) as total from " . DB_TBL_ITEMS_OPTIONS . " where items_options_name = '" . $_POST['new_pro_opt_'.$p] . "' AND  language_id='" . $languages_id . "'");
								$option_check = go_db_fetch_array($option_check_query);
								if ($option_check['total'] > '0') {
									$option_id_query = go_db_query("SELECT items_options_id FROM " . DB_TBL_ITEMS_OPTIONS . " WHERE items_options_name='" . $_POST['new_pro_opt_'.$p] . "' AND  language_id='" . $languages_id . "'");
									$option_id_result=go_db_fetch_array($option_id_query);
									$option_id = $option_id_result['items_options_id'];
								}
								else{
									$option_query = go_db_query("SELECT items_options_id FROM " . DB_TBL_ITEMS_OPTIONS . " WHERE language_id='" . $languages_id . "' ORDER BY items_options_id DESC");
									if($option_result=go_db_fetch_array($option_query)) {
										$option_id =$option_result['items_options_id']+1;
									}
									else{
										$option_id = "1";
									}

									$languages = go_get_languages();
									for ($o=0, $u=sizeof($languages); $o<$u; $o++) {
										$languages_opt_id=$languages[$o]['id'];
										go_db_query("insert into " . DB_TBL_ITEMS_OPTIONS . " SET items_options_name='" . $_POST['new_pro_opt_'.$p] . "', language_id='" . $languages_opt_id . "', items_options_id='" . $option_id . "'");
									}		
								}
								if (count ($_POST['merkmalwert_pro_'.$p]) > '0'){
									foreach ($_POST['merkmalwert_pro_'.$p] as $key => $value) {

										$check_query = go_db_query("select count(*) as total from " . DB_TBL_ITEMS_OPTIONS_VALUES . " where items_options_values_name = '" . $_POST['merkmalwert_pro_'.$p][$key] . "' AND  language_id='" . $languages_id . "'");
										$check = go_db_fetch_array($check_query);
										if ($check['total'] > '0') {				
											$values_select_query = go_db_query("SELECT items_options_values_id FROM " . DB_TBL_ITEMS_OPTIONS_VALUES . " WHERE items_options_values_name='" . $_POST['merkmalwert_pro_'.$p][$key] . "' AND  language_id='" . $languages_id . "'");				
											$values_select_result=go_db_fetch_array($values_select_query);
											$values_id = $values_select_result['items_options_values_id'];

										}
										else{

											$query = go_db_query("SELECT items_options_values_id FROM " . DB_TBL_ITEMS_OPTIONS_VALUES . " WHERE language_id='" . $languages_id . "' ORDER BY `items_options_values_id` DESC");
											if($result=go_db_fetch_array($query)) {
												$values_id =$result['items_options_values_id']+1;
											}
											else{
												$values_id = "1";
											}

											$languages = go_get_languages();
											for ($m=0, $n=sizeof($languages); $m<$n; $m++) {
												$languages_opt_value_id=$languages[$m]['id'];
												go_db_query("insert into " . DB_TBL_ITEMS_OPTIONS_VALUES . " SET items_options_values_name='" . $_POST['merkmalwert_pro_'.$p][$key] . "', language_id='" . $languages_opt_value_id . "', items_options_values_id='" . $values_id . "'");
											}

										}

										$check_option_to_value_query = go_db_query("select count(*) as total from " . DB_TBL_ITEMS_OPTIONS_VALUES_TO_ITEMS_OPTIONS . " where items_options_id = '" . $option_id . "' AND  items_options_values_id='" . $values_id . "'");
										$check_option_to_value = go_db_fetch_array($check_option_to_value_query);
										if ($check_option_to_value['total'] < '1') {						
											go_db_query("insert into " . DB_TBL_ITEMS_OPTIONS_VALUES_TO_ITEMS_OPTIONS . " SET items_options_id='" . $option_id . "', items_options_values_id='" . $values_id . "'");
										}

										$_POST['attributs_sort_order_pro_'.$p][$key] = (is_numeric($_POST['attributs_sort_order_pro_'.$p][$key]) ? $_POST['attributs_sort_order_pro_'.$p][$key] : '0');
										if ($_POST['attributs_sort_order_pro_'.$p][$key] == ''){$_POST['attributs_sort_order_pro_'.$p][$key] = '0';}
										$_POST['anzahl_pro_'.$p][$key] = (is_numeric($_POST['anzahl_pro_'.$p][$key]) ? $_POST['anzahl_pro_'.$p][$key] : '');
										$_POST['preis_pro_'.$p][$key] = preg_replace('/,/i', '.', $_POST['preis_pro_'.$p][$key]);
										$_POST['preis_pro_'.$p][$key] = (is_numeric($_POST['preis_pro_'.$p][$key]) ? $_POST['preis_pro_'.$p][$key] : '');
										$vorzeichenzaeler = '0';
										if ($_POST['vorzeichen_pro_'.$p][$key] == '+'){$vorzeichenzaeler++;}
										if ($_POST['vorzeichen_pro_'.$p][$key] == '-'){$vorzeichenzaeler++;}
										if ($vorzeichenzaeler < '1'){$_POST['vorzeichen_pro_'.$p][$key] = '+';}
										if ($_POST['preis_pro_'.$p][$key] == ""){$_POST['vorzeichen_pro_'.$p][$key] = '';}
										go_db_query("insert into " . DB_TBL_ITEMS_CHARACTERISTICS . " SET items_id = '" . (int)$items_id . "', options_id='" . $option_id . "', options_values_id='" . $values_id . "', options_values_price='" . $_POST['preis_pro_'.$p][$key] . "', price_prefix='" . $_POST['vorzeichen_pro_'.$p][$key] . "', attributs_sort_order='" . $_POST['attributs_sort_order_pro_'.$p][$key] . "', qty='" . $_POST['anzahl_pro_'.$p][$key] . "'");

									}
								}		
							}	

						}	

					} 
					//////////////////   Produktmerkmale aktualisieren, wenn ein existierender Artikel bearbeitet wurde ende  ////////////////////////////          



				} // elseif ENDE = aktualisieren, wenn vorhanden

				if (file_exists(FOLDER_ABSOLUT_CATALOG . 'modules/bundle')) {
					require(FOLDER_ABSOLUT_CATALOG . 'modules/bundle/configmain/main_bigware_10_c.php');
				}    
				if (file_exists(FOLDER_ABSOLUT_CATALOG . 'modules/masseinheitenartikel')) {
					require(FOLDER_ABSOLUT_CATALOG . 'modules/masseinheitenartikel/configmain/main_bigware_10_c.php');
				}       
				if (file_exists(FOLDER_ABSOLUT_CATALOG . 'modules/download')) {
					require(FOLDER_ABSOLUT_CATALOG . 'modules/download/configmain/main_bigware_10_c.php');
				}       


				$attendees_group_query = go_db_query("select distinct attendees_group_id, attendees_group_name, attendees_group_discount from " . DB_TBL_ATTENDEES_GROUPS . " where attendees_group_id != '" . 0 . "' order by attendees_group_id"); 
				while ($attendees_group = go_db_fetch_array($attendees_group_query)) {
					$characteristics_query = go_db_query("select g.attendees_group_id, g.attendees_group_price, p.items_price from " . DB_TBL_ITEMS_GROUPS . " g," . DB_TBL_ITEMS . " p  where ((p.items_id = '" . $items_id . "') && (p.items_id =g.items_id) &&(g.attendees_group_id = " . $attendees_group['attendees_group_id'] . ")) order by g.attendees_group_id");
					$characteristics = go_db_fetch_array($characteristics_query);
					if (go_db_num_rows($characteristics_query) > 0) { 
						if ($_POST['option'][$attendees_group['attendees_group_id']]) {
							if (($_POST['price'][$attendees_group['attendees_group_id']] <> $characteristics['attendees_group_price']) && ($characteristics['attendees_group_id'] == $attendees_group['attendees_group_id']) ) {    
								go_db_query("update " . DB_TBL_ITEMS_GROUPS . " set attendees_group_price = '" . $_POST['price'][$attendees_group['attendees_group_id']] . "', items_price = '" . $_POST['items_price'] . "' where attendees_group_id = '" . $characteristics['attendees_group_id'] . "' and items_id = '" . $items_id . "'");
								$characteristics = go_db_fetch_array($characteristics_query);
							} elseif (($_POST['price'][$attendees_group['attendees_group_id']] == $characteristics['attendees_group_price'])) {
								$characteristics = go_db_fetch_array($characteristics_query);
							}
						} else {
							go_db_query("delete from " . DB_TBL_ITEMS_GROUPS . " where attendees_group_id = '" . $attendees_group['attendees_group_id'] . "' and items_id = '" . $items_id . "'");
							$characteristics = go_db_fetch_array($characteristics_query);
						}
					} elseif (($_POST['option'][$attendees_group['attendees_group_id']]) && ($_POST['price'][$attendees_group['attendees_group_id']] != '')) {
						go_db_query("insert into " . DB_TBL_ITEMS_GROUPS . " (items_id, items_price, attendees_group_id, attendees_group_price) values ('" . $items_id . "', '" . $_POST['items_price'] . "', '" . $attendees_group['attendees_group_id'] . "', '" . $_POST['price'][$attendees_group['attendees_group_id']] . "')");
						$characteristics = go_db_fetch_array($characteristics_query);
					}
				} 

				$languages = go_get_languages();
				for ($i=0, $n=sizeof($languages); $i<$n; $i++) {
					$language_id = $languages[$i]['id'];

					// creating_new_variable7
					$sql_data_array = array('items_name' => go_db_producing_input($_POST['items_name'][$language_id]),
							'items_name2' => go_db_producing_input($_POST['items_name2'][$language_id]),
							'bezeichnung1' => go_db_producing_input($_POST['bezeichnung1'][$language_id]),
							'inhalt1' => go_db_producing_input($_POST['inhalt1'][$language_id]),
							'bezeichnung2' => go_db_producing_input($_POST['bezeichnung2'][$language_id]),
							'inhalt2' => go_db_producing_input($_POST['inhalt2'][$language_id]),
							'bezeichnung3' => go_db_producing_input($_POST['bezeichnung3'][$language_id]),
							'inhalt3' => go_db_producing_input($_POST['inhalt3'][$language_id]),
							'bezeichnung4' => go_db_producing_input($_POST['bezeichnung4'][$language_id]),
							'inhalt4' => go_db_producing_input($_POST['inhalt4'][$language_id]),
							'bezeichnung5' => go_db_producing_input($_POST['bezeichnung5'][$language_id]),
							'inhalt5' => go_db_producing_input($_POST['inhalt5'][$language_id]),
							'bezeichnung6' => go_db_producing_input($_POST['bezeichnung6'][$language_id]),
							'inhalt6' => go_db_producing_input($_POST['inhalt6'][$language_id]),
							'items_description' => go_db_producing_input($_POST["items_description$language_id"]),
							'items_url' => go_db_producing_input($_POST['items_url'][$language_id]),
							'extra_item_costumer_input_text_preceded' => go_db_producing_input($_POST['extra_item_costumer_input_text_preceded'][$language_id]),
							'items_description_in_cat_list' => go_db_producing_input($_POST['items_description_in_cat_list'][$language_id]));
					if ($action == 'insert_item') {
						$insert_sql_data = array('items_id' => $items_id,
								'language_id' => $language_id);
						$sql_data_array = array_merge($sql_data_array, $insert_sql_data);
						go_db_carry(DB_TBL_ITEMS_DESCRIPTION, $sql_data_array);
					} elseif ($action == 'update_item') {
						go_db_carry(DB_TBL_ITEMS_DESCRIPTION, $sql_data_array, 'update', "items_id = '" . (int)$items_id . "' and language_id = '" . (int)$language_id . "'");
					}
				}
				if (USE_CACHE == 'true') {
					go_reset_cache_block('categories');
					go_reset_cache_block('also_purchased');
				}
				go_forward(go_href_link(NAME_OF_FILE_CATEGORIES, 'bigPfad=' . $bigPfad . '&bigID=' . $items_id. "&dd=1"));
			}
			break;
		case 'copy_to_confirm':
			if (isset($_POST['items_id']) && isset($_POST['categories_id'])) {
				$items_id = go_db_producing_input($_POST['items_id']);
				$categories_id = go_db_producing_input($_POST['categories_id']);
				if ($_POST['copy_as'] == 'link') {
					if ($categories_id != $current_category_id) {
						$check_query = go_db_query("select count(*) as total from " . DB_TBL_ITEMS_TO_CATEGORIES . " where items_id = '" . (int)$items_id . "' and categories_id = '" . (int)$categories_id . "'");
						$check = go_db_fetch_array($check_query);
						if ($check['total'] < '1') {
							go_db_query("insert into " . DB_TBL_ITEMS_TO_CATEGORIES . " (items_id, categories_id) values ('" . (int)$items_id . "', '" . (int)$categories_id . "')");
						}
					} else {
						$messageStack->add_session(ERROR_CANNOT_LINK_TO_SAME_CATEGORY, 'error');
					}
				} elseif ($_POST['copy_as'] == 'duplicate') {

					// Zeile aus items db rausholen und wieder speichern

					$item_query = go_db_query("select * from " . DB_TBL_ITEMS . " where items_id = '" . (int)$items_id . "'");
					$item = go_db_fetch_array($item_query);    

					$field_names_array = array_keys( $item );
					$field_names_how_many = count($field_names_array);
					$field_names = '';
					$field_values = '';
					$field_names_count = 1;
					while (list($key, $value) = each ($field_names_array)) {
						if ($field_names_count > '1'){
							if ($field_names_how_many == $field_names_count){
								if ($value == 'items_status'){
									$field_names .= $value;
									$field_values .= "'1'";
								}elseif ($value == 'items_date_added'){
									$field_names .= $value;
									$field_values .= "now()";
								}elseif ($value == 'items_date_available'){
									# nothing
								}elseif ($value == 'items_date_available_end'){
									# nothing
								}elseif ($value == 'items_last_modified'){
									# nothing
								}else{
									$field_names .= $value;
									$field_values .= "'" . go_db_input($item[$value]) . "'";
								}

							}else{
								if ($value == 'items_status'){
									$field_names .= $value . ', ';
									$field_values .= "'1', ";
								}elseif ($value == 'items_date_added'){
									$field_names .= $value . ', ';
									$field_values .= "now(), ";
								}elseif ($value == 'items_date_available'){
									# nothing
								}elseif ($value == 'items_date_available_end'){
									# nothing
								}elseif ($value == 'items_last_modified'){
									# nothing
								}else{
									$field_names .= $value . ', ';
									$field_values .= "'" . go_db_input($item[$value]) . "', ";
								}					  	
							}
						}
						$field_names_count++;
					}
					$insert_duplicate_query =  "insert into " . DB_TBL_ITEMS . " (" . $field_names . ") values (" . $field_values . ")";
					go_db_query($insert_duplicate_query);
					$dup_items_id = go_db_insert_id();

					// Zeilen aus items_description db rausholen und wieder speichern

					$description_query = go_db_query("select * from " . DB_TBL_ITEMS_DESCRIPTION . " where items_id = '" . (int)$items_id . "'");
					while ($description = go_db_fetch_array($description_query)) { 
						$field_desc_names_array = array_keys( $description );
						$field_desc_names_how_many = count($field_desc_names_array);
						$field_desc_names = '';
						$field_desc_values = '';
						$field_desc_names_count = 1;
						while (list($key, $value) = each ($field_desc_names_array)) {
							if ($field_desc_names_how_many == $field_desc_names_count){
								if ($value == 'items_id'){
									$field_desc_names .= $value;
									$field_desc_values .= "'" . (int)$dup_items_id . "'";
								}elseif ($value == 'language_id'){
									$field_desc_names .= $value;
									$field_desc_values .= "'" . (int)$description[$value] . "'";
								}elseif ($value == 'items_viewed'){

								}else{
									$field_desc_names .= $value;
									$field_desc_values .= "'" . go_db_input($description[$value]) . "'";
								}

							}else{
								if ($value == 'items_id'){
									$field_desc_names .= $value . ', ';
									$field_desc_values .= "'" . (int)$dup_items_id . "', ";
								}elseif ($value == 'language_id'){
									$field_desc_names .= $value . ', ';
									$field_desc_values .= "'" . (int)$description[$value] . "', ";
								}elseif ($value == 'items_viewed'){

								}else{
									$field_desc_names .= $value . ', ';
									$field_desc_values .= "'" . go_db_input($description[$value]) . "', ";
								}					  	
							}
							$field_desc_names_count++;
						}
						$insert_duplicate_desc_query =  "insert into " . DB_TBL_ITEMS_DESCRIPTION . " (" . $field_desc_names . ") values (" . $field_desc_values . ")";
						go_db_query($insert_duplicate_desc_query);
					}
					go_db_query("insert into " . DB_TBL_ITEMS_TO_CATEGORIES . " (items_id, categories_id) values ('" . (int)$dup_items_id . "', '" . (int)$categories_id . "')");
					$items_id = $dup_items_id;
				} elseif ($_POST['copy_as'] == 'duplicate_with_characteristics'){     	
					if (file_exists(FOLDER_ABSOLUT_CATALOG . 'modules/copy_characteristics')) {
						$this_one_copy_caracterristic = '2';
						require(FOLDER_ABSOLUT_CATALOG . 'modules/copy_characteristics/configmain/main_bigware_11.php');
					}
				} 
				if (USE_CACHE == 'true') {
					go_reset_cache_block('categories');
					go_reset_cache_block('also_purchased');
				}
			}
			go_forward(go_href_link(NAME_OF_FILE_CATEGORIES, 'bigPfad=' . $categories_id . '&bigID=' . $items_id));
			break;
		case 'new_item_preview':

			function split_picture($html){
				require_once('class_this/simple_html_dom.php');
				if ($post_html = str_get_html($html)) {
					$first_img = $post_html->find('img', 0);
					if($first_img !== null) {
						$pic_url = str_replace('\"','',$first_img->src);
						if (substr_count($pic_url, HTTP_SERVER . FOLDER_RELATIV_CATALOG . FOLDER_RELATIV_PICTURES) > 0){
							$src_1 = strstr($pic_url, FOLDER_RELATIV_PICTURES);
							$src = str_replace(FOLDER_RELATIV_PICTURES, '', $src_1);
						}
						elseif (substr_count($pic_url, FOLDER_RELATIV_CATALOG . FOLDER_RELATIV_PICTURES) > 0){
							$src_1 = strstr($pic_url, FOLDER_RELATIV_PICTURES);
							$src = str_replace(FOLDER_RELATIV_PICTURES, '', $src_1);				
						}
						else{
							$src = $pic_url;
						}
						return $src;
					}
				}
				return null;
			}

			//////////////////

			$_POST['items_bpicture'] = split_picture($_POST['items_bpicture']);				
			$_POST['items_picture']  = split_picture($_POST['items_picture']);				
			$_POST['items_3picture'] = split_picture($_POST['items_3picture']);				
			$_POST['items_4picture'] = split_picture($_POST['items_4picture']);				
			$_POST['items_5picture'] = split_picture($_POST['items_5picture']);

			//////////////////

			if (isset($_POST['items_picture']) && go_not_null($_POST['items_picture'])) {
				$items_picture_name = $_POST['items_picture'];
			} else {
				$items_picture_name = $_POST['items_picture']; 
			} 
			if (isset($_POST['items_bpicture']) && go_not_null($_POST['items_bpicture'])) {
				$items_bpicture_name = $_POST['items_bpicture'];

			} else {
				$items_bpicture_name = $_POST['items_bpicture']; 
			}
			if (isset($_POST['items_3picture']) && go_not_null($_POST['items_3picture'])) {
				$items_3picture_name = $_POST['items_3picture'];
			} else {
				$items_3picture_name = $_POST['items_3picture'];
			}
			if (isset($_POST['items_4picture']) && go_not_null($_POST['items_4picture'])) {
				$items_4picture_name = $_POST['items_4picture'];
			} else {
				$items_4picture_name = $_POST['items_4picture'];
			}
			if (isset($_POST['items_5picture']) && go_not_null($_POST['items_5picture'])) {
				$items_5picture_name = $_POST['items_5picture'];
			} else {
				$items_5picture_name = $_POST['items_5picture'];
			}
			break;
	}
}
if (is_dir(FOLDER_ABSOLUT_CATALOG_PICTURES)) {
	if (!is_writeable(FOLDER_ABSOLUT_CATALOG_PICTURES)) $messageStack->add(ERROR_CATALOG_PICTURE_DIRECTORY_NOT_WRITEABLE, 'error');
} else {
	$messageStack->add(ERROR_CATALOG_PICTURE_DIRECTORY_DOES_NOT_EXIST, 'error');
}

?>
<!doctype html public "-//W3C//DTD HTML 4.01 Transitional//EN">
<html <?php echo HTML_PARAMS; ?>>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=<?php echo CHARSET; ?>">
<title><?php echo TITLE; ?></title>
<link rel="stylesheet" type="text/css" href="load_this/style.css">
<script language="javascript" src="load_this/general.js"></script>
<script language="javascript" src="load_this/menu.js"></script>
<script language="javascript" src="tiny_mce/tiny_mce.js"></script>
<script language="javascript" src="tiny_mce/tiny_mce_init.js"></script>
<script language="JavaScript" type="text/JavaScript">
<!--
function ow(seite)
  {
	w1 = window.open(seite, 'LEAF', 'toolbar=no,status=no,width=700,height=300,directories=no,scrollbars=yes,location=no,resize=yes,menubar=no');
  	w1.focus();
}
//-->
</script>
</head>
<body marginwidth="0" marginheight="0" topmargin="0" bottommargin="0" leftmargin="0" rightmargin="0" bgcolor="#FFFFFF" onload="SetFocus();">

<?php
include('load_this/preloader_header.php');
?>
<div id="spiffycalendar" class="text"></div>
<!-- header //-->
<?php require(FOLDER_RELATIV_INCLUDES . 'load_bigware_9.php'); ?>
<!-- header_eof //-->
<!-- body //-->
<table border="0" width="100%" cellspacing="2" cellpadding="2" align="center">
  <tr>
    <!--td width="<?php echo FRAME_WIDTH; ?>" valign="top"></td-->
<!-- body_text //-->
    <td width="100%" valign="top">
<?php
if ($action == 'new_item') {
	
	require(getcwd().'/main_bigware_12.php');
	
} elseif ($action == 'new_item_preview') {

	require('main_bigware_13.php');


} else {
	
	require('main_bigware_13b.php');     

}
?>
    </td>
<!-- body_text_eof //-->
</tr>
</table>
<!-- body_eof //-->
<!-- footer //-->
<?php require(FOLDER_RELATIV_INCLUDES . 'load_bigware_7.php'); ?>
<!-- footer_eof //-->
<br>
<?php
include('load_this/preloader_footer.php');
?>
</body>
</html>
<?php require(FOLDER_RELATIV_INCLUDES . 'load_bigware_6.php'); ?>